/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X509AlgorithmIdentifier;
import java.util.ArrayList;

class X509PublicKeyInfo {
    private X509AlgorithmIdentifier _algorithm;
    private byte[] _publicKey;

    public static X509PublicKeyInfo fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509PublicKeyInfo info = new X509PublicKeyInfo();
        int num = 0;
        info.setAlgorithm(X509AlgorithmIdentifier.fromAsn1(sequence.getValues()[num++]));
        info.setPublicKey(((Asn1BitString)sequence.getValues()[num++]).getValueBytes());
        return info;
    }

    public X509AlgorithmIdentifier getAlgorithm() {
        return this._algorithm;
    }

    public byte[] getPublicKey() {
        return this._publicKey;
    }

    public void setAlgorithm(X509AlgorithmIdentifier value) {
        this._algorithm = value;
    }

    public void setPublicKey(byte[] value) {
        this._publicKey = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        list.add(this.getAlgorithm().toAsn1());
        list.add(new Asn1BitString(this.getPublicKey()));
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }
}

