/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1OctetString;
import fm.icelink.BitAssistant;
import fm.icelink.Global;

class X509ECPoint {
    private static byte[] __empty = new byte[]{BitAssistant.castByte(0)};
    private byte[] __value = null;

    public byte[] compress() {
        byte[] source = this.getValue();
        if (source == null || ArrayExtensions.getLength(source) == 0) {
            return __empty;
        }
        byte[] destination = new byte[ArrayExtensions.getLength(source) + 1];
        destination[0] = 4;
        BitAssistant.copy(source, 0, destination, 1, ArrayExtensions.getLength(source));
        return destination;
    }

    public static X509ECPoint decompress(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        X509ECPoint point = new X509ECPoint();
        if (!BitAssistant.sequencesAreEqual(bytes, __empty) && bytes[0] == 4) {
            point.setValue(BitAssistant.subArray(bytes, 1));
        }
        return point;
    }

    public static X509ECPoint fromAsn1(Asn1Any any) {
        Asn1OctetString str = Global.tryCast(any, Asn1OctetString.class);
        if (str == null) {
            return null;
        }
        return X509ECPoint.decompress(str.getValueBytes());
    }

    public byte[] getValue() {
        return this.__value;
    }

    public void setValue(byte[] value) {
        this.__value = value;
    }

    public Asn1OctetString toAsn1() {
        return new Asn1OctetString(this.compress());
    }

    public X509ECPoint() {
    }

    public X509ECPoint(byte[] value) {
        this.setValue(value);
    }
}

