/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1OctetString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import java.util.ArrayList;

class X509ECCurve {
    private byte[] _a;
    private byte[] _b;
    private byte[] _seed;

    public static X509ECCurve fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509ECCurve curve = new X509ECCurve();
        int num = 0;
        curve.setA(((Asn1OctetString)sequence.getValues()[num++]).getValueBytes());
        curve.setB(((Asn1OctetString)sequence.getValues()[num++]).getValueBytes());
        if (ArrayExtensions.getLength(sequence.getValues()) > 2) {
            curve.setSeed(((Asn1BitString)sequence.getValues()[num++]).getValueBytes());
        }
        return curve;
    }

    public byte[] getA() {
        return this._a;
    }

    public byte[] getB() {
        return this._b;
    }

    public byte[] getSeed() {
        return this._seed;
    }

    public void setA(byte[] value) {
        this._a = value;
    }

    public void setB(byte[] value) {
        this._b = value;
    }

    public void setSeed(byte[] value) {
        this._seed = value;
    }

    public Asn1Any toAsn1() {
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        list.add(new Asn1OctetString(this.getA()));
        list.add(new Asn1OctetString(this.getB()));
        if (this.getSeed() != null) {
            list.add(new Asn1BitString(this.getSeed()));
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }
}

