/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Sequence;
import fm.icelink.BitAssistant;
import fm.icelink.Global;
import java.util.ArrayList;

class X509DsaSignature {
    private byte[] _r;
    private byte[] _s;

    public static X509DsaSignature fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509DsaSignature signature = new X509DsaSignature();
        int num = 0;
        signature.setR(((Asn1Integer)sequence.getValues()[num++]).getValue());
        signature.setS(((Asn1Integer)sequence.getValues()[num++]).getValue());
        if (ArrayExtensions.getLength(signature.getR()) % 2 == 1) {
            signature.setR(BitAssistant.subArray(signature.getR(), 1));
        }
        if (ArrayExtensions.getLength(signature.getS()) % 2 == 1) {
            signature.setS(BitAssistant.subArray(signature.getS(), 1));
        }
        return signature;
    }

    public byte[] getR() {
        return this._r;
    }

    public byte[] getS() {
        return this._s;
    }

    public void setR(byte[] value) {
        this._r = value;
    }

    public void setS(byte[] value) {
        this._s = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Integer> list = new ArrayList<Asn1Integer>();
        list.add(new Asn1Integer(this.getR()));
        list.add(new Asn1Integer(this.getS()));
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }
}

