/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Base64;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.ByteExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Dns;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashContextBase;
import fm.icelink.HashMapExtensions;
import fm.icelink.HashType;
import fm.icelink.Holder;
import fm.icelink.HttpRequestCreatedArgs;
import fm.icelink.HttpResponseReceivedArgs;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IWebSocket;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.ParseAssistant;
import fm.icelink.Platform;
import fm.icelink.RandomExtensions;
import fm.icelink.Splitter;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.TcpSocket;
import fm.icelink.Unhandled;
import fm.icelink.UriExtensions;
import fm.icelink.Utf8;
import fm.icelink.WebSocketBase;
import fm.icelink.WebSocketCloseArgs;
import fm.icelink.WebSocketCloseCompleteArgs;
import fm.icelink.WebSocketFrameType;
import fm.icelink.WebSocketMockRequest;
import fm.icelink.WebSocketMockResponse;
import fm.icelink.WebSocketOpenArgs;
import fm.icelink.WebSocketSendArgs;
import fm.icelink.WebSocketSendState;
import fm.icelink.WebSocketStatusCode;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class WebSocket
extends WebSocketBase
implements IWebSocket {
    private boolean __isOpen;
    private boolean __secure;
    private boolean _closing = false;
    private Exception _exception;
    private ByteCollection _fragmentedMessageBytes;
    private WebSocketFrameType _fragmentedMessageType;
    private byte[] _handshakeEndOfResponse;
    private WebSocketOpenArgs _openArgs;
    private boolean _opening = false;
    private String _protocol;
    private ByteCollection _receiveBuffer;
    private URI _requestUri;
    private String _secWebSocketAccept;
    private String _secWebSocketKey;
    private boolean _sending = false;
    private Random _sendingRandomizer;
    private ArrayList<WebSocketSendState> _sendQueue;
    private TcpSocket _socket;
    private Object _stateLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(WebSocketCloseArgs closeArgs, boolean initiate) {
        Object obj2;
        if (initiate) {
            Object obj22;
            Object object = obj22 = this._stateLock;
            synchronized (object) {
                if (this.getIsOpen() && !this._opening && !this._closing) {
                    this._sendQueue.clear();
                    ByteCollection bytes = new ByteCollection();
                    byte[] buffer = Binary.toBytes16((short)closeArgs.getStatusCode().getAssignedValue(), false);
                    bytes.addRange(buffer);
                    if (closeArgs.getReason() != null) {
                        bytes.addRange(Utf8.encode(closeArgs.getReason()));
                    }
                    WebSocketSendArgs sendArgs = new WebSocketSendArgs();
                    sendArgs.setBinaryMessage(bytes.toArray());
                    this.send(sendArgs, WebSocketFrameType.Close);
                    this._closing = true;
                    this.close(closeArgs, false);
                }
            }
        }
        Object object = obj2 = this._stateLock;
        synchronized (object) {
            if (!this.getIsOpen()) {
                return;
            }
            this._socket.close();
            this._closing = false;
            this.__isOpen = false;
        }
        super.raiseCloseComplete(closeArgs, closeArgs.getStatusCode(), closeArgs.getReason());
    }

    @Override
    public void close(WebSocketCloseArgs closeArgs) {
        closeArgs.setStatusCode(WebSocketStatusCode.Normal);
        closeArgs.setReason(null);
        this.close(closeArgs, true);
    }

    @Override
    public void close() {
        try {
            this.close(new WebSocketCloseArgs());
        }
        catch (Exception exception) {
            Log.error("Could not close WebSocket.", exception);
        }
    }

    private void closeComplete(WebSocketCloseCompleteArgs e) {
        super.raiseStreamFailure(this._openArgs, e.getStatusCode(), this._exception);
    }

    private void closeWithException(Exception ex, WebSocketStatusCode statusCode, boolean initiateClose) {
        this._exception = ex;
        WebSocketCloseArgs closeArgs = new WebSocketCloseArgs();
        closeArgs.setStatusCode(statusCode);
        closeArgs.setReason(ex.getMessage());
        closeArgs.setOnComplete((IAction1<WebSocketCloseCompleteArgs>)new IActionDelegate1<WebSocketCloseCompleteArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.closeComplete";
            }

            @Override
            public void invoke(WebSocketCloseCompleteArgs e) {
                WebSocket.this.closeComplete(e);
            }
        });
        this.close(closeArgs, initiateClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectFailure(Exception exception, boolean timedOut) {
        Object object = this._stateLock;
        synchronized (object) {
            this._opening = false;
            super.raiseOpenFailure(this._openArgs, WebSocketStatusCode.NoStatus, exception);
        }
    }

    private void connectSuccess() {
        this.handshakeSend();
    }

    private void dnsResolveCallback(String[] ipAddresses, Object state) {
        WebSocketOpenArgs args = (WebSocketOpenArgs)state;
        if (ipAddresses == null) {
            ipAddresses = new String[]{"127.0.0.1"};
        }
        String str = ipAddresses[0];
        Log.info(StringExtensions.format("WebSocket address resolved to {0}.", str));
        this._socket = new TcpSocket(false, Global.equals((Object)LocalNetwork.getAddressType(str), (Object)AddressType.IPv6), this.getSecure());
        this._receiveBuffer = new ByteCollection();
        this._sendQueue = new ArrayList();
        this._openArgs = args;
        this._socket.connectAsync(UriExtensions.getDnsSafeHost(this._requestUri), str, this.getServerPort(), 0, new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.connectSuccess";
            }

            @Override
            public void invoke() {
                WebSocket.this.connectSuccess();
            }
        }, (IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.connectFailure";
            }

            @Override
            public void invoke(Exception exception, Boolean timedOut) {
                WebSocket.this.connectFailure(exception, timedOut);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferedAmount() {
        Object object = this._stateLock;
        synchronized (object) {
            int num = 0;
            for (WebSocketSendState state : this._sendQueue) {
                num += ArrayExtensions.getLength(state.getRequestBytes());
            }
            return num;
        }
    }

    public static boolean getExists() {
        return true;
    }

    private WebSocketFrameType getFrameType(byte opcode) {
        if (opcode == 0) {
            return WebSocketFrameType.Continuation;
        }
        if (opcode == 1) {
            return WebSocketFrameType.Text;
        }
        if (opcode == 2) {
            return WebSocketFrameType.Binary;
        }
        if (opcode == 8) {
            return WebSocketFrameType.Close;
        }
        if (opcode == 9) {
            return WebSocketFrameType.Ping;
        }
        if (opcode == 10) {
            return WebSocketFrameType.Pong;
        }
        return WebSocketFrameType.Unknown;
    }

    @Override
    public boolean getIsOpen() {
        return this.__isOpen;
    }

    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public boolean getSecure() {
        return this.__secure;
    }

    private int getServerPort() {
        int port = this._requestUri.getPort();
        if (port <= 0) {
            port = Global.equals(this._requestUri.getScheme(), "wss") ? 443 : 80;
        }
        return port;
    }

    private void handshakeReceive() {
        this._socket.setOnReceiveSuccess((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.handshakeReceiveSuccess";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                WebSocket.this.handshakeReceiveSuccess(buffer);
            }
        });
        this._socket.setOnReceiveFailure((IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.handshakeReceiveFailure";
            }

            @Override
            public void invoke(Exception exception, Boolean timedOut) {
                WebSocket.this.handshakeReceiveFailure(exception, timedOut);
            }
        });
        this._socket.receiveAsync(this._openArgs.getHandshakeTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeReceiveFailure(Exception exception, boolean timedOut) {
        try {
            Object object = this._stateLock;
            synchronized (object) {
                this._opening = false;
                super.raiseOpenFailure(this._openArgs, WebSocketStatusCode.NoStatus, new Exception(StringExtensions.format("Could not receive handshake response. {0}", exception.getMessage()), exception));
            }
        }
        catch (Exception exception2) {
            Unhandled.logException(exception2, "WebSocket -> HandshakeReceive -> OnFailure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeReceiveSuccess(DataBuffer buffer) {
        block22: {
            try {
                this._receiveBuffer.addRange(buffer.toArray());
                int index = this.indexOf(this._handshakeEndOfResponse, this._receiveBuffer.toArray());
                if (index > -1) {
                    Object obj2;
                    byte[] range = this._receiveBuffer.getRange(0, index + ArrayExtensions.getLength(this._handshakeEndOfResponse));
                    this._receiveBuffer.removeRange(0, index + ArrayExtensions.getLength(this._handshakeEndOfResponse));
                    String str = Utf8.decode(range, 0, ArrayExtensions.getLength(range));
                    Object[] strArray = Splitter.split(StringExtensions.trimEnd(str, new char[]{'\r', '\n'}), "\r\n");
                    HashMap<String, String> responseHeaders = new HashMap<String, String>();
                    String str2 = strArray[0];
                    if (ArrayExtensions.getLength(strArray) > 1) {
                        for (int i = 1; i < ArrayExtensions.getLength(strArray); ++i) {
                            Object[] strArray2 = StringExtensions.split((String)strArray[i], new char[]{':'});
                            if (ArrayExtensions.getLength(strArray2) != 2) continue;
                            HashMapExtensions.set(HashMapExtensions.getItem(responseHeaders), ((String)strArray2[0]).trim(), ((String)strArray2[1]).trim());
                        }
                    }
                    if (this._openArgs.getOnResponseReceived() != null) {
                        WebSocketMockResponse response = new WebSocketMockResponse();
                        response.setResponseUri(this._requestUri);
                        Object[] strArray3 = StringExtensions.split(str2, new char[]{' '});
                        if (ArrayExtensions.getLength(strArray3) > 1) {
                            int intResult = 0;
                            IntegerHolder _var0 = new IntegerHolder(intResult);
                            boolean _var1 = ParseAssistant.tryParseIntegerValue((String)strArray3[1], _var0);
                            intResult = _var0.getValue();
                            if (_var1) {
                                response.setStatusCode(intResult);
                            }
                        }
                        for (String str4 : HashMapExtensions.getAllKeys(responseHeaders)) {
                            if (Global.equals(StringExtensions.toLower(str4), "content-type")) {
                                response.setContentType(HashMapExtensions.getItem(responseHeaders).get(str4));
                                continue;
                            }
                            if (Global.equals(StringExtensions.toLower(str4), "content-length")) {
                                long longResult = 0L;
                                LongHolder _var2 = new LongHolder(longResult);
                                boolean _var3 = ParseAssistant.tryParseLongValue(HashMapExtensions.getItem(responseHeaders).get(str4), _var2);
                                longResult = _var2.getValue();
                                if (!_var3) continue;
                                response.setContentLength(longResult);
                                continue;
                            }
                            HashMapExtensions.set(HashMapExtensions.getItem(response.getHeaders()), str4, HashMapExtensions.getItem(responseHeaders).get(str4));
                        }
                        HttpResponseReceivedArgs p = new HttpResponseReceivedArgs();
                        p.setResponse(response);
                        p.setSender(this._openArgs.getSender());
                        this._openArgs.getOnResponseReceived().invoke(p);
                    }
                    if (!this.handshakeResponseIsValid(str2, responseHeaders)) {
                        Object obj22;
                        Object object = obj22 = this._stateLock;
                        synchronized (object) {
                            this._opening = false;
                            super.raiseOpenFailure(this._openArgs, WebSocketStatusCode.NoStatus, new Exception(StringExtensions.format("Invalid handshake response ({0}).", str)));
                            break block22;
                        }
                    }
                    Object object = obj2 = this._stateLock;
                    synchronized (object) {
                        this.__isOpen = true;
                        this._opening = false;
                        super.raiseOpenSuccess(this._openArgs);
                        if (ArrayListExtensions.getCount(this._sendQueue) > 0) {
                            WebSocketSendState state = ArrayListExtensions.getItem(this._sendQueue).get(0);
                            this.sendNow(state.getSendArgs(), state.getRequestBytes());
                        }
                    }
                    this._socket.setOnReceiveSuccess((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.WebSocket.listenSuccess";
                        }

                        @Override
                        public void invoke(DataBuffer buffer) {
                            WebSocket.this.listenSuccess(buffer);
                        }
                    });
                    this._socket.setOnReceiveFailure((IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.WebSocket.listenFailure";
                        }

                        @Override
                        public void invoke(Exception exception, Boolean timedOut) {
                            WebSocket.this.listenFailure(exception, timedOut);
                        }
                    });
                    this.listen();
                    break block22;
                }
                this.handshakeReceive();
            }
            catch (Exception exception) {
                Object obj2;
                Object object = obj2 = this._stateLock;
                synchronized (object) {
                    this._opening = false;
                    super.raiseOpenFailure(this._openArgs, WebSocketStatusCode.NoStatus, exception);
                }
            }
        }
    }

    private boolean handshakeResponseIsValid(String responseLine1, HashMap<String, String> responseHeaders) {
        if (!Global.equals(responseLine1, "HTTP/1.1 101 Switching Protocols")) {
            return false;
        }
        String str = HashMapExtensions.getItem(responseHeaders).get("Upgrade");
        String str2 = HashMapExtensions.getItem(responseHeaders).get("Connection");
        String str3 = HashMapExtensions.getItem(responseHeaders).get("Sec-WebSocket-Accept");
        String str4 = HashMapExtensions.getItem(responseHeaders).get("Sec-WebSocket-Protocol");
        if (str == null || str2 == null || str3 == null) {
            return false;
        }
        if (!(Global.equals(StringExtensions.toLower(str), "websocket") && Global.equals(StringExtensions.toLower(str2), "upgrade") && Global.equals(StringExtensions.toLower(str3), StringExtensions.toLower(this._secWebSocketAccept)))) {
            return false;
        }
        return str4 == null || this.getProtocol() == null || Global.equals(StringExtensions.toLower(str4), StringExtensions.toLower(this.getProtocol()));
    }

    private void handshakeSend() {
        String str = StringExtensions.concat(UriExtensions.getAbsolutePath(this._requestUri), UriExtensions.getQuery(this._requestUri));
        String dnsSafeHost = UriExtensions.getDnsSafeHost(this._requestUri);
        if (this.getServerPort() != 80) {
            dnsSafeHost = StringExtensions.concat(dnsSafeHost, ":", IntegerExtensions.toString(this.getServerPort()));
        }
        WebSocketMockRequest request = new WebSocketMockRequest();
        try {
            request.setRequestUri(new URI(this._requestUri.toString().replace("ws://", "http://").replace("wss://", "https://")));
        }
        catch (Exception exception) {
            super.raiseOpenFailure(this._openArgs, WebSocketStatusCode.NoStatus, new Exception(StringExtensions.format("Could not parse request URI. {0}", exception.getMessage()), exception));
            return;
        }
        request.setMethod("GET");
        if (this._openArgs.getHeaders() != null) {
            for (String string : HashMapExtensions.getAllKeys(this._openArgs.getHeaders())) {
                HashMapExtensions.set(HashMapExtensions.getItem(request.getHeaders()), string, HashMapExtensions.getItem(this._openArgs.getHeaders()).get(string));
            }
        }
        if (!StringExtensions.isNullOrEmpty(this.getProtocol())) {
            HashMapExtensions.set(HashMapExtensions.getItem(request.getHeaders()), "Sec-WebSocket-Protocol", this.getProtocol());
        }
        if (this._openArgs.getOnRequestCreated() != null) {
            HttpRequestCreatedArgs p = new HttpRequestCreatedArgs();
            p.setRequest(request);
            p.setSender(this._openArgs.getSender());
            this._openArgs.getOnRequestCreated().invoke(p);
        }
        StringBuilder builder = new StringBuilder();
        for (String str4 : HashMapExtensions.getAllKeys(request.getHeaders())) {
            StringBuilderExtensions.append(builder, StringExtensions.format("{0}: {1}\r\n", str4, HashMapExtensions.getItem(request.getHeaders()).get(str4)));
        }
        byte[] byArray = Utf8.encode(StringExtensions.concat(new String[]{"GET ", str, " HTTP/1.1\r\nHost: ", dnsSafeHost, "\r\nUpgrade: websocket\r\nConnection: Upgrade\r\nSec-WebSocket-Key: ", this._secWebSocketKey, "\r\nSec-WebSocket-Version: 13\r\n", builder.toString(), "\r\n"}));
        this._socket.sendAsync(DataBuffer.wrap(byArray), this._openArgs.getHandshakeTimeout(), new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.handshakeSendSuccess";
            }

            @Override
            public void invoke() {
                WebSocket.this.handshakeSendSuccess();
            }
        }, (IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.handshakeSendFailure";
            }

            @Override
            public void invoke(Exception exception, Boolean timedOut) {
                WebSocket.this.handshakeSendFailure(exception, timedOut);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeSendFailure(Exception exception, boolean timedOut) {
        Object object = this._stateLock;
        synchronized (object) {
            this._opening = false;
            super.raiseOpenFailure(this._openArgs, WebSocketStatusCode.NoStatus, new Exception(StringExtensions.format("Could not send handshake request. {0}", exception.getMessage()), exception));
        }
    }

    private void handshakeSendSuccess() {
        this.handshakeReceive();
    }

    private int indexOf(byte[] pattern, byte[] data) {
        int num = -1;
        int index = 0;
        int num3 = 0;
        for (index = 0; index < ArrayExtensions.getLength(data); ++index) {
            byte num4 = data[index];
            byte num5 = pattern[num3];
            if (num4 == num5) {
                if (num3 == 0) {
                    num = index;
                }
                if (num3 == ArrayExtensions.getLength(pattern) - 1) {
                    return num;
                }
                ++num3;
                continue;
            }
            num3 = 0;
        }
        return -1;
    }

    private void listen() {
        this._socket.receiveAsync(this._openArgs.getStreamTimeout());
    }

    private void listenFailure(Exception exception, boolean timedOut) {
        try {
            if (this.getIsOpen() && !this._opening && !this._closing) {
                this.closeWithException(exception, WebSocketStatusCode.GoingAway, true);
            }
        }
        catch (Exception exception2) {
            Unhandled.logException(exception2, "WebSocket -> Listen -> OnFailure");
        }
    }

    private void listenSuccess(DataBuffer buffer) {
        try {
            if (this.getIsOpen() && !this._opening && !this._closing) {
                this._receiveBuffer.addRange(buffer.toArray());
                WebSocketStatusCode normal = WebSocketStatusCode.Normal;
                Exception exception = null;
                boolean initiateClose = false;
                Holder<WebSocketStatusCode> _var0 = new Holder<WebSocketStatusCode>(normal);
                Holder<Object> _var1 = new Holder<Object>(exception);
                BooleanHolder _var2 = new BooleanHolder(initiateClose);
                boolean _var3 = this.processReceiveBuffer(_var0, _var1, _var2);
                normal = _var0.getValue();
                exception = _var1.getValue();
                initiateClose = _var2.getValue();
                if (_var3) {
                    this.listen();
                } else {
                    this.closeWithException(exception, normal, initiateClose);
                }
            }
        }
        catch (Exception exception2) {
            Unhandled.logException(exception2, "WebSocket -> Listen -> OnSuccess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(WebSocketOpenArgs openArgs) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getIsOpen()) {
                super.raiseOpenFailure(openArgs, WebSocketStatusCode.NoStatus, new Exception("Already open."));
                return;
            }
            if (this._opening) {
                super.raiseOpenFailure(openArgs, WebSocketStatusCode.NoStatus, new Exception("Already opening."));
                return;
            }
            this._opening = true;
        }
        this.__secure = Global.equals(this._requestUri.getScheme(), "wss");
        Dns.resolve(UriExtensions.getDnsSafeHost(this._requestUri), (IAction2<String[], Object>)new IActionDelegate2<String[], Object>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.dnsResolveCallback";
            }

            @Override
            public void invoke(String[] ipAddresses, Object state) {
                WebSocket.this.dnsResolveCallback(ipAddresses, state);
            }
        }, openArgs);
    }

    private boolean processReceiveBuffer(Holder<WebSocketStatusCode> statusCode, Holder<Exception> exception, BooleanHolder initiateClose) {
        WebSocketFrameType frameType;
        boolean finalFlag;
        byte[] range;
        boolean _var0;
        statusCode.setValue(WebSocketStatusCode.Normal);
        exception.setValue(null);
        initiateClose.setValue(true);
        do {
            if (this._receiveBuffer.getCount() < 2) {
                return true;
            }
            byte num = this._receiveBuffer.get(0);
            byte num2 = this._receiveBuffer.get(1);
            finalFlag = (num & 0x80) == 128;
            byte opcode = (byte)(num & 0xF);
            frameType = this.getFrameType(opcode);
            if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Unknown)) {
                statusCode.setValue(WebSocketStatusCode.InvalidType);
                exception.setValue(new Exception(StringExtensions.format("Invalid frame type received (opcode {0}).", ByteExtensions.toString(opcode))));
                return false;
            }
            if ((num2 & 0x80) == 128) {
                statusCode.setValue(WebSocketStatusCode.ProtocolError);
                exception.setValue(new Exception("Masked frame received from server."));
                return false;
            }
            long num4 = num2 & 0x7F;
            int index = 2;
            int count = 0;
            if (num4 == 126L) {
                count = 2;
            } else if (num4 == 127L) {
                count = 8;
            }
            if (this._receiveBuffer.getCount() < count + 2) {
                return true;
            }
            if (count > 0) {
                byte[] input = this._receiveBuffer.getRange(2, count);
                if (count == 2) {
                    num4 = Binary.fromBytes16(input, 0, false);
                } else if (count == 8) {
                    num4 = Binary.fromBytes64(input, 0, false);
                }
                index += count;
            }
            if (num4 > Integer.MAX_VALUE) {
                statusCode.setValue(WebSocketStatusCode.MessageTooLarge);
                exception.setValue(new Exception(StringExtensions.format("Maximum payload size of 2GB was exceeded (actual {0} bytes).", LongExtensions.toString(num4))));
                return false;
            }
            int num7 = (int)num4;
            if (this._receiveBuffer.getCount() < index + num7) {
                return true;
            }
            range = this._receiveBuffer.getRange(index, num7);
            this._receiveBuffer.removeRange(0, index + num7);
        } while (_var0 = this.processReceiveFrame(range, finalFlag, frameType, statusCode, exception, initiateClose));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processReceiveFrame(byte[] payloadData, boolean finalFlag, WebSocketFrameType frameType, Holder<WebSocketStatusCode> statusCode, Holder<Exception> exception, BooleanHolder initiateClose) {
        WebSocketFrameType fragmentedMessageType;
        byte[] buffer;
        statusCode.setValue(WebSocketStatusCode.Normal);
        exception.setValue(null);
        initiateClose.setValue(true);
        if (!finalFlag) {
            if (!Global.equals((Object)frameType, (Object)WebSocketFrameType.Continuation)) {
                this._fragmentedMessageBytes = new ByteCollection(payloadData);
                this._fragmentedMessageType = frameType;
            } else {
                this._fragmentedMessageBytes.addRange(payloadData);
            }
            return true;
        }
        if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Continuation)) {
            this._fragmentedMessageBytes.addRange(payloadData);
            buffer = this._fragmentedMessageBytes.toArray();
            fragmentedMessageType = this._fragmentedMessageType;
        } else {
            buffer = payloadData;
            fragmentedMessageType = frameType;
        }
        if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Close)) {
            Object object = this._stateLock;
            synchronized (object) {
                this._sendQueue.clear();
                if (!this._closing) {
                    try {
                        WebSocketSendArgs sendArgs = new WebSocketSendArgs();
                        sendArgs.setBinaryMessage(buffer);
                        this.send(sendArgs, WebSocketFrameType.Close);
                    }
                    catch (Exception sendArgs) {
                        // empty catch block
                    }
                }
                this._closing = true;
            }
            statusCode.setValue(WebSocketStatusCode.NoStatus);
            if (ArrayExtensions.getLength(buffer) >= 2) {
                int num = Binary.fromBytes16(buffer, 0, false);
                try {
                    statusCode.setValue(WebSocketStatusCode.getByAssignedValue(num));
                }
                catch (Exception exception2) {
                    statusCode.setValue(WebSocketStatusCode.NoStatus);
                }
            }
            String str = null;
            if (ArrayExtensions.getLength(buffer) > 2) {
                try {
                    str = Utf8.decode(buffer, 2, ArrayExtensions.getLength(buffer) - 2);
                }
                catch (Exception exception3) {
                    str = "Reason was given, but not in UTF-8 format.";
                }
            }
            exception.setValue(new Exception(StringExtensions.format("Connection closed ({0}).", str)));
            initiateClose.setValue(false);
            return false;
        }
        if (Global.equals((Object)fragmentedMessageType, (Object)WebSocketFrameType.Text)) {
            String str2;
            try {
                str2 = Utf8.decode(buffer, 0, ArrayExtensions.getLength(buffer));
            }
            catch (Exception exception4) {
                statusCode.setValue(WebSocketStatusCode.InvalidData);
                exception.setValue(new Exception("Message of type text was not in UTF-8 format."));
                return false;
            }
            super.raiseReceive(this._openArgs, str2, null);
        } else if (Global.equals((Object)fragmentedMessageType, (Object)WebSocketFrameType.Binary)) {
            super.raiseReceive(this._openArgs, null, buffer);
        } else if (Global.equals((Object)frameType, (Object)WebSocketFrameType.Ping)) {
            try {
                WebSocketSendArgs args2 = new WebSocketSendArgs();
                args2.setBinaryMessage(buffer);
                this.send(args2, WebSocketFrameType.Pong);
            }
            catch (Exception args2) {
                // empty catch block
            }
        }
        boolean _var0 = this.processReceiveBuffer(statusCode, exception, initiateClose);
        return _var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(WebSocketSendArgs sendArgs, WebSocketFrameType frameType) {
        if (this.getIsOpen()) {
            ByteCollection bytes = new ByteCollection();
            WebSocketFrameType _var0 = frameType;
            if (_var0 == WebSocketFrameType.Continuation) {
                bytes.add((byte)-128);
            } else if (_var0 == WebSocketFrameType.Text) {
                bytes.add((byte)-127);
            } else if (_var0 == WebSocketFrameType.Binary) {
                bytes.add((byte)-126);
            } else if (_var0 == WebSocketFrameType.Close) {
                bytes.add((byte)-120);
            } else if (_var0 == WebSocketFrameType.Ping) {
                bytes.add((byte)-119);
            } else if (_var0 == WebSocketFrameType.Pong) {
                bytes.add((byte)-118);
            }
            if (sendArgs.getBinaryMessage() == null) {
                bytes.add((byte)-128);
            } else if (ArrayExtensions.getLength(sendArgs.getBinaryMessage()) < 126) {
                byte length = (byte)ArrayExtensions.getLength(sendArgs.getBinaryMessage());
                bytes.add((byte)(0x80 | length));
            } else if (ArrayExtensions.getLength(sendArgs.getBinaryMessage()) <= 65535) {
                bytes.add((byte)-2);
                byte[] buffer = Binary.toBytes16(ArrayExtensions.getLength(sendArgs.getBinaryMessage()), false);
                bytes.addRange(buffer);
            } else {
                bytes.add((byte)-1);
                byte[] buffer = Binary.toBytes64(ArrayExtensions.getLength(sendArgs.getBinaryMessage()), false);
                bytes.addRange(buffer);
            }
            byte[] buffer2 = new byte[4];
            RandomExtensions.nextBytes(this._sendingRandomizer, buffer2);
            if (Platform.getInstance().getIsLittleEndian()) {
                BitAssistant.reverse(buffer2);
            }
            bytes.addRange(buffer2);
            if (sendArgs.getBinaryMessage() != null) {
                for (int i = 0; i < ArrayExtensions.getLength(sendArgs.getBinaryMessage()); ++i) {
                    int index = i % 4;
                    sendArgs.getBinaryMessage()[i] = (byte)(sendArgs.getBinaryMessage()[i] ^ buffer2[index]);
                }
                bytes.addRange(sendArgs.getBinaryMessage());
            }
            Object object = this._stateLock;
            synchronized (object) {
                if (!this.getIsOpen() || this._opening || this._closing) {
                    WebSocketSendState item = new WebSocketSendState();
                    item.setSendArgs(sendArgs);
                    item.setRequestBytes(bytes.toArray());
                    this._sendQueue.add(item);
                    return;
                }
                if (this._sending) {
                    WebSocketSendState state2 = new WebSocketSendState();
                    state2.setSendArgs(sendArgs);
                    state2.setRequestBytes(bytes.toArray());
                    this._sendQueue.add(state2);
                    return;
                }
                this._sending = true;
            }
            this.sendNow(sendArgs, bytes.toArray());
        }
    }

    @Override
    public void send(WebSocketSendArgs sendArgs) {
        if (sendArgs.getTextMessage() == null && sendArgs.getBinaryMessage() == null) {
            throw new RuntimeException(new Exception("textMessage and binaryMessage cannot both be null."));
        }
        if (sendArgs.getBinaryMessage() == null) {
            sendArgs.setBinaryMessage(Utf8.encode(sendArgs.getTextMessage()));
            this.send(sendArgs, WebSocketFrameType.Text);
        } else {
            this.send(sendArgs, WebSocketFrameType.Binary);
        }
    }

    private void sendNow(WebSocketSendArgs sendArgs, byte[] requestBytes) {
        this._socket.sendAsync(DataBuffer.wrap(requestBytes), sendArgs.getTimeout(), new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.sendNowSuccess";
            }

            @Override
            public void invoke() {
                WebSocket.this.sendNowSuccess();
            }
        }, (IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.WebSocket.sendNowFailure";
            }

            @Override
            public void invoke(Exception exception, Boolean timedOut) {
                WebSocket.this.sendNowFailure(exception, timedOut);
            }
        });
    }

    private void sendNowFailure(Exception exception, boolean timedOut) {
        this.closeWithException(exception, WebSocketStatusCode.GoingAway, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNowSuccess() {
        Object object = this._stateLock;
        synchronized (object) {
            if (ArrayListExtensions.getCount(this._sendQueue) > 0) {
                WebSocketSendState state = ArrayListExtensions.getItem(this._sendQueue).get(0);
                ArrayListExtensions.removeAt(this._sendQueue, 0);
                this.sendNow(state.getSendArgs(), state.getRequestBytes());
            } else {
                this._sending = false;
            }
        }
    }

    private void setProtocol(String value) {
        this._protocol = value;
    }

    public WebSocket(String requestUrl, String protocol) {
        this._handshakeEndOfResponse = Utf8.encode("\r\n\r\n");
        this._sendingRandomizer = new Random();
        try {
            this._requestUri = new URI(requestUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProtocol(protocol);
        this._secWebSocketKey = Base64.encode(Guid.newGuid().toByteArray());
        this._secWebSocketAccept = Base64.encodeBuffer(HashContextBase.compute(HashType.Sha1, StringExtensions.concat(this._secWebSocketKey, "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")));
    }

    public WebSocket(String requestUrl) {
        this(requestUrl, null);
    }
}

