/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaOutput;
import fm.icelink.IOutput;
import fm.icelink.IVideoElement;
import fm.icelink.IVideoInput;
import fm.icelink.IVideoInputCollection;
import fm.icelink.IVideoOutput;
import fm.icelink.MathAssistant;
import fm.icelink.MediaSource;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoBufferCollection;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;

public abstract class VideoSource
extends MediaSource<IVideoOutput, IVideoInput, IVideoInputCollection, VideoSource, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>
implements IVideoOutput,
IMediaOutput<IVideoOutput, IVideoInput, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IOutput<IVideoOutput, IVideoInput, VideoFrame, VideoBuffer, VideoBufferCollection, VideoFormat>,
IVideoElement,
IMediaElement,
IElement {
    private long __startTicks = -1L;
    private long _frameCount;

    @Override
    protected IVideoInputCollection createInputCollection(IVideoOutput output) {
        return new IVideoInputCollection(output);
    }

    public int getAverageFrameRate() {
        if (this.getFrameCount() == 0L) {
            return 0;
        }
        if (this.__startTicks == -1L) {
            return 0;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__startTicks;
        if (num < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(this.getFrameCount() * (long)Constants.getTicksPerSecond() / num);
    }

    public long getFrameCount() {
        return this._frameCount;
    }

    public int getFrameRateDistance(int frameRate1, int frameRate2) {
        if (frameRate2 > 0) {
            return MathAssistant.abs(frameRate2 - frameRate1);
        }
        return -1;
    }

    public int getSizeDistance(int width1, int height1, int width2, int height2) {
        if (width2 > 0 && height2 > 0) {
            return MathAssistant.abs(width2 - width1) + MathAssistant.abs(height2 - height1);
        }
        if (width2 <= 0) {
            return MathAssistant.abs(height2 - height1);
        }
        if (height2 <= 0) {
            return MathAssistant.abs(width2 - width1);
        }
        return -1;
    }

    @Override
    protected void raiseFrame(VideoFrame frame) {
        this.setFrameCount(this.getFrameCount() + 1L);
        if (this.__startTicks == -1L) {
            this.__startTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if (frame.getTimestamp() < 0L) {
            frame.setTimestamp((DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__startTicks) * (long)((VideoFormat)super.getOutputFormat()).getClockRate() / (long)Constants.getTicksPerSecond());
        }
        super.raiseFrame(frame);
    }

    private void setFrameCount(long value) {
        this._frameCount = value;
    }

    public VideoSource(VideoFormat outputFormat) {
        super(outputFormat);
    }
}

