/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.TimeoutTimer;
import fm.icelink.TransportAddress;
import fm.icelink.TurnChannelBinding;
import fm.icelink.TurnPermission;
import fm.icelink.stun.BadRequestError;
import fm.icelink.stun.Error;
import java.util.ArrayList;
import java.util.Date;

abstract class TurnAllocation {
    private ArrayList<TurnChannelBinding> __channelBindingsList;
    private Object __channelBindingsLock;
    private TurnChannelBinding[] __channels;
    private TimeoutTimer __expirationTimer;
    private long __lastLifetime;
    private IAction1<TransportAddress> __onExpires;
    private TurnPermission[] __permissions;
    private ArrayList<TurnPermission> __permissionsList;
    private Object __permissionsLock;
    private TransportAddress _clientAddress;
    private Date _expires = new Date();
    private String _realm;
    private DataBuffer _reservation;
    private DataBuffer _transactionId;
    private String _username;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error addChannelBinding(TransportAddress xorRemoteAddress, int channelNumber, TransportAddress remoteAddress) {
        Object object = this.__channelBindingsLock;
        synchronized (object) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__channelBindingsList); ++i) {
                TurnChannelBinding binding = ArrayListExtensions.getItem(this.__channelBindingsList).get(i);
                if (binding.getIsExpired()) {
                    ArrayListExtensions.removeAt(this.__channelBindingsList, i);
                    --i;
                    continue;
                }
                if (binding.getChannelNumber() == channelNumber && binding.getAddress().equals(xorRemoteAddress)) {
                    binding.extendTimeToExpiry();
                    if (Log.getIsDebugEnabled()) {
                        Log.debug(StringExtensions.format("Extending {0}:{1} allocation channel binding for {2}.", xorRemoteAddress.getIPAddress(), IntegerExtensions.toString(channelNumber), remoteAddress.toString()));
                    }
                    return null;
                }
                if (binding.getAddress().equals(xorRemoteAddress)) {
                    String str = StringExtensions.format("Could not process channel-bind request for {0} - address is bound to a different channel number.", remoteAddress.toString());
                    if (Log.getIsErrorEnabled()) {
                        Log.error(str);
                    }
                    return new BadRequestError(str);
                }
                if (binding.getChannelNumber() != channelNumber) continue;
                String str = StringExtensions.format("Could not process channel-bind request for {0} - channel number is already in use.", remoteAddress.toString());
                if (Log.getIsErrorEnabled()) {
                    Log.error(str);
                }
                return new BadRequestError(str);
            }
            this.__channelBindingsList.add(new TurnChannelBinding(xorRemoteAddress, channelNumber));
            this.__channels = this.__channelBindingsList.toArray(new TurnChannelBinding[0]);
            this.addPermission(xorRemoteAddress.getIPAddress());
        }
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("Adding {0}:{1} allocation channel binding for {2}.", xorRemoteAddress.getIPAddress(), IntegerExtensions.toString(channelNumber), remoteAddress.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPermission(String remoteIPAddress) {
        Object object = this.__permissionsLock;
        synchronized (object) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__permissionsList); ++i) {
                TurnPermission permission = ArrayListExtensions.getItem(this.__permissionsList).get(i);
                if (permission.getIsExpired()) {
                    ArrayListExtensions.removeAt(this.__permissionsList, i);
                    --i;
                    continue;
                }
                if (!Global.equals(permission.getAddress(), remoteIPAddress)) continue;
                permission.extendTimeToExpiry();
                return false;
            }
            this.__permissionsList.add(new TurnPermission(remoteIPAddress));
            this.__permissions = this.__permissionsList.toArray(new TurnPermission[0]);
        }
        return true;
    }

    public void close() {
        if (this.__expirationTimer != null) {
            this.__expirationTimer.stop();
            this.__expirationTimer = null;
        }
    }

    private void expiredCallback(Object state) {
        if (this.__onExpires != null) {
            this.__onExpires.invoke(this.getClientAddress());
        }
    }

    public TurnChannelBinding[] getChannelBindings() {
        return this.__channels;
    }

    public TransportAddress getClientAddress() {
        return this._clientAddress;
    }

    public boolean getIsExpired() {
        return DateExtensions.getTicks(DateExtensions.getUtcNow()) > DateExtensions.getTicks(this._expires);
    }

    public long getLastLifetime() {
        return this.__lastLifetime;
    }

    public abstract String getLocalIPAddress();

    public abstract int getLocalPort();

    public TurnPermission[] getPermissions() {
        return this.__permissions;
    }

    public abstract String getPublicIPAddress();

    public String getRealm() {
        return this._realm;
    }

    public DataBuffer getReservation() {
        return this._reservation;
    }

    public DataBuffer getTransactionId() {
        return this._transactionId;
    }

    public String getUsername() {
        return this._username;
    }

    public int hasChannelBindingAddress(TransportAddress remoteAddress) {
        for (TurnChannelBinding binding : this.__channels) {
            if (!binding.getAddress().equals(remoteAddress) || binding.getIsExpired()) continue;
            return binding.getChannelNumber();
        }
        return 0;
    }

    public TransportAddress hasChannelBindingNumber(int channelNumber) {
        for (TurnChannelBinding binding : this.__channels) {
            if (binding.getChannelNumber() != channelNumber || binding.getIsExpired()) continue;
            return binding.getAddress();
        }
        return null;
    }

    public boolean hasPermission(String remoteIPAddress) {
        for (TurnPermission permission : this.__permissions) {
            if (!Global.equals(permission.getAddress(), remoteIPAddress) || permission.getIsExpired()) continue;
            return true;
        }
        return false;
    }

    public boolean refresh(long lifetime) {
        return this.updateTimeToExpiry(lifetime);
    }

    private void setClientAddress(TransportAddress value) {
        this._clientAddress = value;
    }

    private void setRealm(String value) {
        this._realm = value;
    }

    private void setReservation(DataBuffer value) {
        this._reservation = value;
    }

    private void setTransactionId(DataBuffer value) {
        this._transactionId = value;
    }

    private void setUsername(String value) {
        this._username = value;
    }

    public TurnAllocation(DataBuffer transactionId, DataBuffer reservation, TransportAddress clientAddress, String username, String realm, long lifetime, IAction1<TransportAddress> onExpires) {
        this.__permissionsList = new ArrayList();
        this.__channelBindingsList = new ArrayList();
        this.__permissions = new TurnPermission[0];
        this.__channels = new TurnChannelBinding[0];
        this.__permissionsLock = new Object();
        this.__channelBindingsLock = new Object();
        if (transactionId == null) {
            throw new RuntimeException(new Exception("transactionId cannot be null"));
        }
        if (clientAddress == null) {
            throw new RuntimeException(new Exception("clientAddress cannot be null"));
        }
        if (username == null) {
            throw new RuntimeException(new Exception("username cannot be null"));
        }
        if (realm == null) {
            throw new RuntimeException(new Exception("realm cannot be null"));
        }
        this.setTransactionId(transactionId == null ? transactionId : DataBuffer.wrap(transactionId.toArray(), transactionId.getLittleEndian()));
        this.setReservation(reservation == null ? reservation : DataBuffer.wrap(reservation.toArray(), reservation.getLittleEndian()));
        this.setClientAddress(clientAddress);
        this.setUsername(username);
        this.setRealm(realm);
        this.__onExpires = onExpires;
        this.updateTimeToExpiry(lifetime);
    }

    private boolean updateTimeToExpiry(long lifetime) {
        if (this.__expirationTimer == null || this.__expirationTimer.stop()) {
            this.__lastLifetime = lifetime;
            this._expires = DateExtensions.addSeconds(DateExtensions.getUtcNow(), lifetime);
            this.__expirationTimer = new TimeoutTimer((IAction1<Object>)new IActionDelegate1<Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.TurnAllocation.expiredCallback";
                }

                @Override
                public void invoke(Object state) {
                    TurnAllocation.this.expiredCallback(state);
                }
            }, null);
            try {
                this.__expirationTimer.start((int)(lifetime * 1000L));
            }
            catch (Exception exception) {
                Log.error("Could not start TURN allocation expiration timer.", exception);
            }
            return true;
        }
        return false;
    }
}

