/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BooleanHolder;
import fm.icelink.CircularDataBuffer;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.DatagramSocket;
import fm.icelink.DatagramSocketCreateArgs;
import fm.icelink.Dynamic;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IFunction1;
import fm.icelink.IFunction2;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.IntegerHolder;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.ManagedSocket;
import fm.icelink.ManagedThread;
import fm.icelink.ServerAddress;
import fm.icelink.StreamSocket;
import fm.icelink.StreamSocketCreateArgs;
import fm.icelink.StringExtensions;
import fm.icelink.TcpSocket;
import fm.icelink.TlsCertificate;
import fm.icelink.TransportAddress;
import fm.icelink.TurnTcpConnection;
import fm.icelink.UdpSocket;
import fm.icelink.Utility;
import fm.icelink.stun.BindingRequest;
import fm.icelink.stun.BindingResponse;
import fm.icelink.stun.Error;
import fm.icelink.stun.ErrorCodeAttribute;
import fm.icelink.stun.MappedAddressAttribute;
import fm.icelink.stun.Message;
import fm.icelink.stun.MessageType;
import fm.icelink.stun.ServerError;
import fm.icelink.stun.XorMappedAddressAttribute;
import java.util.ArrayList;
import java.util.HashMap;

public class StunServer
extends Dynamic {
    private Object __startedLock = new Object();
    private int __streamSendTimeout = -1;
    private IFunction1<DatagramSocketCreateArgs, DatagramSocket> _createDatagramSocket;
    private IFunction1<StreamSocketCreateArgs, StreamSocket> _createStreamSocket;
    private boolean _disableTcp;
    private boolean _disableTls;
    private boolean _disableUdp;
    private volatile boolean _started = false;
    private HashMap<String, TurnTcpConnection> _tcpConnections = new HashMap();
    private Object _tcpConnectionsLock = new Object();
    private StreamSocket[] _tcpSockets = null;
    private StreamSocket[] _tlsSockets = null;
    private DatagramSocket[] _udpSockets = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTcpConnection(TurnTcpConnection connection) {
        Object object = this._tcpConnectionsLock;
        synchronized (object) {
            HashMapExtensions.add(this._tcpConnections, connection.getId(), connection);
        }
    }

    protected Message createErrorResponse(Message request, TransportAddress remoteAddress, String errorMessage) {
        ServerError error = new ServerError(errorMessage);
        return this.createExceptionResponse(request, remoteAddress, error);
    }

    protected Message createExceptionResponse(Message request, TransportAddress remoteAddress, Error error) {
        Message message = Message.createMessage(request.getMethod(), MessageType.ErrorResponse, request.getTransactionId());
        int stunErrorCode = error.getStunErrorCode();
        if (stunErrorCode == 0) {
            if (Log.getIsErrorEnabled()) {
                Log.error(StringExtensions.format("An exception occurred while processing request from {0}: {1}", remoteAddress.toString(), error.getMessage()));
            }
            stunErrorCode = 500;
        }
        message.setErrorCode(new ErrorCodeAttribute(stunErrorCode, this.getReason(stunErrorCode)));
        return message;
    }

    private <T> ArrayList<T> createServerSockets(boolean udp, ServerAddress[] addresses, boolean secure, IFunction2<ServerAddress, Boolean, T> createSocket) {
        String prefix = this.getPrefix(udp, secure);
        ArrayList<T> list = new ArrayList<T>();
        if (ArrayExtensions.getLength(addresses) == 0) {
            Log.debug(StringExtensions.format("{0}No server addresses.", prefix));
            return list;
        }
        for (ServerAddress address : addresses) {
            try {
                list.add(createSocket.invoke(address, secure));
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("{0}Could not create socket on {1}.", prefix, address.toString()), exception);
            }
        }
        if (ArrayListExtensions.getCount(list) == 0) {
            Log.fatal(StringExtensions.format("{0}Could not create any sockets.", prefix));
            return list;
        }
        return list;
    }

    private StreamSocket createTcpSocket(ServerAddress address, boolean secure) {
        boolean addressInUse = false;
        boolean server = true;
        boolean flag3 = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
        ManagedSocket socket = null;
        if (this.getCreateStreamSocket() != null) {
            socket = this.getCreateStreamSocket().invoke(new StreamSocketCreateArgs(server, flag3, secure));
        }
        if (socket == null) {
            socket = new TcpSocket(server, flag3, secure);
        }
        socket.setPublicIPAddress(address.getPublicIPAddress());
        BooleanHolder _var0 = new BooleanHolder(addressInUse);
        boolean _var1 = socket.bind(address.getIPAddress(), address.getPort(), _var0);
        addressInUse = _var0.getValue();
        if (_var1) {
            return socket;
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (addressInUse) {
            throw new RuntimeException(new Exception("TCP socket address is in use."));
        }
        throw new RuntimeException(new Exception("TCP socket bind failed."));
    }

    private DatagramSocket createUdpSocket(ServerAddress address, boolean secure) {
        boolean addressInUse = false;
        boolean flag2 = Global.equals((Object)LocalNetwork.getAddressType(address.getIPAddress()), (Object)AddressType.IPv6);
        ManagedSocket socket = null;
        if (this.getCreateDatagramSocket() != null) {
            socket = this.getCreateDatagramSocket().invoke(new DatagramSocketCreateArgs(flag2));
        }
        if (socket == null) {
            socket = new UdpSocket(flag2);
        }
        socket.setPublicIPAddress(address.getPublicIPAddress());
        BooleanHolder _var0 = new BooleanHolder(addressInUse);
        boolean _var1 = socket.bind(address.getIPAddress(), address.getPort(), _var0);
        addressInUse = _var0.getValue();
        if (_var1) {
            return socket;
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (addressInUse) {
            throw new RuntimeException(new Exception("UDP socket address is in use."));
        }
        throw new RuntimeException(new Exception("UDP socket bind failed."));
    }

    private void doTcpAccept(StreamSocket tcpSocket) {
        if (!tcpSocket.getIsClosed()) {
            this.tcpAccept(tcpSocket);
        }
    }

    private void doUdpReceive(DatagramSocket udpSocket) {
        if (udpSocket == null || !udpSocket.getIsClosed()) {
            this.udpReceive(udpSocket);
        }
    }

    public IFunction1<DatagramSocketCreateArgs, DatagramSocket> getCreateDatagramSocket() {
        return this._createDatagramSocket;
    }

    public IFunction1<StreamSocketCreateArgs, StreamSocket> getCreateStreamSocket() {
        return this._createStreamSocket;
    }

    private ServerAddress[] getDefaultAddresses(int port) {
        ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
        for (String str : LocalNetwork.getIPAddresses(new AddressType[]{AddressType.IPv4, AddressType.IPv6}, true)) {
            list.add(new ServerAddress(str, port));
        }
        return list.toArray(new ServerAddress[0]);
    }

    public boolean getDisableTcp() {
        return this._disableTcp;
    }

    public boolean getDisableTls() {
        return this._disableTls;
    }

    public boolean getDisableUdp() {
        return this._disableUdp;
    }

    protected String getLabel() {
        return "STUN";
    }

    public ServerAddress getLocalTcpAddress() {
        return Utility.firstOrDefault(this.getLocalTcpAddresses());
    }

    public ServerAddress[] getLocalTcpAddresses() {
        Object[] tcpSockets = this._tcpSockets;
        ServerAddress[] addressArray = new ServerAddress[ArrayExtensions.getLength(tcpSockets)];
        for (int i = 0; i < ArrayExtensions.getLength(tcpSockets); ++i) {
            addressArray[i] = new ServerAddress(((ManagedSocket)tcpSockets[i]).getLocalIPAddress(), ((ManagedSocket)tcpSockets[i]).getLocalPort(), ((ManagedSocket)tcpSockets[i]).getPublicIPAddress());
        }
        return addressArray;
    }

    public ServerAddress getLocalUdpAddress() {
        return Utility.firstOrDefault(this.getLocalUdpAddresses());
    }

    public ServerAddress[] getLocalUdpAddresses() {
        Object[] udpSockets = this._udpSockets;
        ServerAddress[] addressArray = new ServerAddress[ArrayExtensions.getLength(udpSockets)];
        for (int i = 0; i < ArrayExtensions.getLength(udpSockets); ++i) {
            addressArray[i] = new ServerAddress(((ManagedSocket)udpSockets[i]).getLocalIPAddress(), ((ManagedSocket)udpSockets[i]).getLocalPort(), ((ManagedSocket)udpSockets[i]).getPublicIPAddress());
        }
        return addressArray;
    }

    protected String getPrefix(boolean udp, boolean secure) {
        if (udp) {
            return "[UDP] ";
        }
        if (secure) {
            return "[TLS] ";
        }
        return "[TCP] ";
    }

    private String getReason(int errorCode) {
        int _var0 = errorCode;
        if (_var0 == 400) {
            return "Bad Request";
        }
        if (_var0 == 401) {
            return "Unauthorized";
        }
        if (_var0 == 403) {
            return "Forbidden";
        }
        if (_var0 == 404) {
            return "Not Found";
        }
        if (_var0 == 420) {
            return "Unknown Attribute";
        }
        if (_var0 == 300) {
            return "Try Alternate";
        }
        if (_var0 == 500) {
            return "Server Error";
        }
        if (_var0 == 508) {
            return "Insufficient Capacity";
        }
        if (_var0 == 437) {
            return "Allocation Mismatch";
        }
        if (_var0 == 438) {
            return "Stale Nonce";
        }
        if (_var0 == 441) {
            return "Wrong Credentials";
        }
        if (_var0 == 442) {
            return "Unsupported Transport Protocol";
        }
        if (_var0 == 446) {
            return "Connection Already Exists";
        }
        if (_var0 == 447) {
            return "Connection Timeout or Failure";
        }
        if (_var0 == 486) {
            return "Allocation Quote Reached";
        }
        if (_var0 == 487) {
            return "Role Conflict";
        }
        return null;
    }

    public int getStreamSendTimeout() {
        return this.__streamSendTimeout;
    }

    private void logSocket(boolean udp, boolean secure, ServerAddress address) {
        String prefix = this.getPrefix(udp, secure);
        if (Log.getIsInfoEnabled()) {
            if (TransportAddress.isPrivate(address.getIPAddress())) {
                if (StringExtensions.isNullOrEmpty(address.getPublicIPAddress())) {
                    Log.warn(StringExtensions.format("{0}{1} server listening on {2}.\nThis is a private IP address and no public IP address was specified. Server may not behave as expected.", prefix, this.getLabel(), address.toString()));
                } else {
                    Log.info(StringExtensions.format("{0}{1} server listening on {2}.\nPublic IP address is mapped to {3}. A 1:1 NAT is required.", new Object[]{prefix, this.getLabel(), address.toString(), address.getPublicIPAddress()}));
                }
            } else {
                Log.info(StringExtensions.format("{0}{1} server listening on {2}.", prefix, this.getLabel(), address.toString()));
            }
        }
    }

    protected Message process(Message request, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress) {
        Message message;
        block5: {
            boolean udp = tcpServerSocket == null;
            boolean secure = !udp && tcpServerSocket.getSecure();
            String prefix = this.getPrefix(udp, secure);
            String str2 = StringExtensions.empty;
            message = null;
            try {
                if (!(request instanceof BindingRequest)) {
                    return message;
                }
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processing UDP binding request from {1}{2}.", prefix, remoteAddress.toString(), str2));
                }
                message = this.processBindingRequest((BindingRequest)request, remoteAddress);
                if (Log.getIsDebugEnabled()) {
                    Log.debug(StringExtensions.format("{0}Processed UDP binding request from {1}{2}.", prefix, remoteAddress.toString(), str2));
                }
            }
            catch (Exception exception) {
                if (Global.equals((Object)request.getMessageType(), (Object)MessageType.Indication)) break block5;
                message = this.createErrorResponse(request, remoteAddress, exception.getMessage());
            }
        }
        return message;
    }

    private BindingResponse processBindingRequest(BindingRequest request, TransportAddress remoteAddress) {
        BindingResponse response = new BindingResponse(request.getTransactionId(), true);
        response.setXorMappedAddress(new XorMappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort(), request.getTransactionId()));
        response.setMappedAddress(new MappedAddressAttribute(remoteAddress.getIPAddress(), remoteAddress.getPort()));
        return response;
    }

    protected boolean processBuffer(DataBuffer buffer, DatagramSocket udpServerSocket, StreamSocket tcpServerSocket, ServerAddress localAddress, TransportAddress remoteAddress, IntegerHolder readLength) {
        int length = 0;
        IntegerHolder _var0 = new IntegerHolder(length);
        Message _var1 = Message.readFrom(buffer, 0, _var0);
        length = _var0.getValue();
        Message request = _var1;
        if (request != null) {
            readLength.setValue(length);
            Message message2 = this.process(request, udpServerSocket, tcpServerSocket, localAddress, remoteAddress);
            if (message2 != null) {
                DataBuffer buffer2 = DataBufferPool.getInstance().take(message2.getLength());
                message2.writeTo(buffer2, 0);
                if (udpServerSocket != null) {
                    udpServerSocket.send(buffer2, remoteAddress.getIPAddress(), remoteAddress.getPort());
                } else {
                    tcpServerSocket.sendAsync(buffer2, this.__streamSendTimeout, null, null);
                }
                buffer2.free();
            }
            return true;
        }
        readLength.setValue(0);
        return false;
    }

    private void processTcpConnectionReceive(TurnTcpConnection connection, CircularDataBuffer receiveBuffer) {
        do {
            int readLength = 0;
            IntegerHolder _var0 = new IntegerHolder(readLength);
            boolean _var1 = this.processBuffer(DataBuffer.wrap(receiveBuffer.toArray()), null, connection.getSocket(), connection.getServerAddress(), connection.getClientAddress(), _var0);
            readLength = _var0.getValue();
            if (!_var1) {
                return;
            }
            receiveBuffer.discard(readLength);
        } while (receiveBuffer.getLength() != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTcpConnection(TurnTcpConnection connection) {
        Object object = this._tcpConnectionsLock;
        synchronized (object) {
            HashMapExtensions.remove(this._tcpConnections, connection.getId());
            try {
                if (!connection.getIsClosed()) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTcpConnections() {
        Object object = this._tcpConnectionsLock;
        synchronized (object) {
            ArrayList<String> list = new ArrayList<String>();
            for (String str : HashMapExtensions.getKeys(this._tcpConnections)) {
                list.add(str);
            }
            for (String str : list) {
                this.removeTcpConnection(HashMapExtensions.getItem(this._tcpConnections).get(str));
            }
        }
    }

    public void setCreateDatagramSocket(IFunction1<DatagramSocketCreateArgs, DatagramSocket> value) {
        this._createDatagramSocket = value;
    }

    public void setCreateStreamSocket(IFunction1<StreamSocketCreateArgs, StreamSocket> value) {
        this._createStreamSocket = value;
    }

    public void setDisableTcp(boolean value) {
        this._disableTcp = value;
    }

    public void setDisableTls(boolean value) {
        this._disableTls = value;
    }

    public void setDisableUdp(boolean value) {
        this._disableUdp = value;
    }

    public void setStreamSendTimeout(int value) {
        if (value >= -1) {
            this.__streamSendTimeout = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(ServerAddress[] udpAddresses, ServerAddress[] tcpAddresses, ServerAddress[] tlsAddresses, TlsCertificate tlsCertificate) {
        if (this.getDisableUdp() && this.getDisableTcp() && this.getDisableTls()) {
            throw new RuntimeException(new Exception("Cannot start server. UDP, TCP, and TLS are all disabled."));
        }
        ManagedSocket[] managedSocketArray = this.__startedLock;
        synchronized (this.__startedLock) {
            if (this._started) {
                // ** MonitorExit[managedSocketArray] (shouldn't be in output)
                return false;
            }
            this._started = true;
            // ** MonitorExit[managedSocketArray] (shouldn't be in output)
            if (this.getDisableUdp()) {
                udpAddresses = new ServerAddress[]{};
            } else if (udpAddresses == null) {
                udpAddresses = this.getDefaultAddresses(3478);
            }
            if (this.getDisableTcp()) {
                tcpAddresses = new ServerAddress[]{};
            } else if (tcpAddresses == null) {
                tcpAddresses = this.getDefaultAddresses(3478);
            }
            if (this.getDisableTls()) {
                tlsAddresses = new ServerAddress[]{};
            } else if (tlsAddresses == null) {
                tlsAddresses = this.getDefaultAddresses(5349);
            }
            if (this.getDisableUdp()) {
                Log.info("UDP is disabled.");
                this._udpSockets = new DatagramSocket[0];
            } else {
                this._udpSockets = this.createServerSockets(true, udpAddresses, false, new IFunctionDelegate2<ServerAddress, Boolean, DatagramSocket>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.StunServer.createUdpSocket";
                    }

                    @Override
                    public DatagramSocket invoke(ServerAddress address, Boolean secure) {
                        return StunServer.this.createUdpSocket(address, secure);
                    }
                }).toArray(new DatagramSocket[0]);
            }
            if (this.getDisableTcp()) {
                Log.info("TCP is disabled.");
                this._tcpSockets = new StreamSocket[0];
            } else {
                this._tcpSockets = this.createServerSockets(false, tcpAddresses, false, new IFunctionDelegate2<ServerAddress, Boolean, StreamSocket>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.StunServer.createTcpSocket";
                    }

                    @Override
                    public StreamSocket invoke(ServerAddress address, Boolean secure) {
                        return StunServer.this.createTcpSocket(address, secure);
                    }
                }).toArray(new StreamSocket[0]);
            }
            if (this.getDisableTls()) {
                Log.info("TLS is disabled.");
                this._tlsSockets = new StreamSocket[0];
            } else {
                if (tlsCertificate == null) {
                    Log.info("Generating self-signed TLS certificate.");
                    tlsCertificate = TlsCertificate.generateCertificate();
                }
                this._tlsSockets = this.createServerSockets(false, tlsAddresses, true, new IFunctionDelegate2<ServerAddress, Boolean, StreamSocket>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.StunServer.createTcpSocket";
                    }

                    @Override
                    public StreamSocket invoke(ServerAddress address, Boolean secure) {
                        return StunServer.this.createTcpSocket(address, secure);
                    }
                }).toArray(new StreamSocket[0]);
            }
            for (DatagramSocket datagramSocket : this._udpSockets) {
                this.doUdpReceive(datagramSocket);
                this.logSocket(true, false, new ServerAddress(datagramSocket.getLocalIPAddress(), datagramSocket.getLocalPort(), datagramSocket.getPublicIPAddress()));
            }
            for (ManagedSocket managedSocket : this._tcpSockets) {
                this.doTcpAccept((StreamSocket)managedSocket);
                this.logSocket(false, false, new ServerAddress(managedSocket.getLocalIPAddress(), managedSocket.getLocalPort(), managedSocket.getPublicIPAddress()));
            }
            for (ManagedSocket managedSocket : this._tlsSockets) {
                this.doTcpAccept((StreamSocket)managedSocket);
                this.logSocket(false, true, new ServerAddress(managedSocket.getLocalIPAddress(), managedSocket.getLocalPort(), managedSocket.getPublicIPAddress()));
            }
            return true;
        }
    }

    public boolean start(ServerAddress[] udpAddresses, ServerAddress[] tcpAddresses, ServerAddress[] tlsAddresses) {
        return this.start(udpAddresses, tcpAddresses, tlsAddresses, null);
    }

    public boolean start(ServerAddress[] udpAddresses) {
        return this.start(udpAddresses, null);
    }

    public boolean start() {
        return this.start(null);
    }

    public boolean start(ServerAddress[] udpAddresses, ServerAddress[] tcpAddresses) {
        return this.start(udpAddresses, tcpAddresses, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        ManagedSocket[] managedSocketArray = this.__startedLock;
        synchronized (this.__startedLock) {
            if (!this._started) {
                // ** MonitorExit[managedSocketArray] (shouldn't be in output)
                return false;
            }
            this._started = false;
            // ** MonitorExit[managedSocketArray] (shouldn't be in output)
            for (DatagramSocket datagramSocket : this._udpSockets) {
                datagramSocket.close();
            }
            for (ManagedSocket managedSocket : this._tcpSockets) {
                managedSocket.close();
            }
            this.removeTcpConnections();
            return true;
        }
    }

    private void tcpAccept(final StreamSocket tcpSocket) {
        IAction0 onSuccess = null;
        IAction1<Exception> onFailure = null;
        IAction1<StreamSocket> onSocket = null;
        try {
            if (onSuccess == null) {
                onSuccess = new IAction0(){

                    @Override
                    public void invoke() {
                        if (StunServer.this._started) {
                            StunServer.this.doTcpAccept(tcpSocket);
                        }
                    }
                };
            }
            if (onFailure == null) {
                onFailure = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        IAction0 action = null;
                        if (StunServer.this._started) {
                            if (action == null) {
                                action = new IAction0(){

                                    @Override
                                    public void invoke() {
                                        StunServer.this.doTcpAccept(tcpSocket);
                                    }
                                };
                            }
                            ManagedThread.dispatch(action);
                        }
                    }
                };
            }
            if (onSocket == null) {
                onSocket = new IAction1<StreamSocket>(){

                    @Override
                    public void invoke(StreamSocket acceptedSocket) {
                        acceptedSocket.setPublicIPAddress(tcpSocket.getPublicIPAddress());
                        try {
                            TurnTcpConnection connection = new TurnTcpConnection(acceptedSocket, (IAction2<TurnTcpConnection, CircularDataBuffer>)new IActionDelegate2<TurnTcpConnection, CircularDataBuffer>(){

                                @Override
                                public String getId() {
                                    return "fm.icelink.StunServer.processTcpConnectionReceive";
                                }

                                @Override
                                public void invoke(TurnTcpConnection connection, CircularDataBuffer receiveBuffer) {
                                    StunServer.this.processTcpConnectionReceive(connection, receiveBuffer);
                                }
                            });
                            StunServer.this.addTcpConnection(connection);
                            connection.setOnClose((IAction1<TurnTcpConnection>)new IActionDelegate1<TurnTcpConnection>(){

                                @Override
                                public String getId() {
                                    return "fm.icelink.StunServer.removeTcpConnection";
                                }

                                @Override
                                public void invoke(TurnTcpConnection connection) {
                                    StunServer.this.removeTcpConnection(connection);
                                }
                            });
                            connection.startListening();
                        }
                        catch (Exception exception) {
                            Log.error("Could not accept TCP socket.", exception);
                        }
                    }
                };
            }
            tcpSocket.acceptAsync(onSuccess, onFailure, onSocket);
        }
        catch (Exception exception) {
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not accept on server TCP socket. {0}", exception.getMessage()));
            }
            try {
                tcpSocket.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void udpReceive(final DatagramSocket socket) {
        IAction3<DataBuffer, String, Integer> onSuccess = null;
        IAction1<Exception> onFailure = null;
        try {
            if (onSuccess == null) {
                onSuccess = new IAction3<DataBuffer, String, Integer>(){

                    @Override
                    public void invoke(DataBuffer data, String remoteIPAddress, Integer remotePort) {
                        try {
                            int readLength = 0;
                            IntegerHolder _var0 = new IntegerHolder(readLength);
                            boolean _var1 = StunServer.this.processBuffer(data, socket, null, new ServerAddress(socket.getLocalIPAddress(), socket.getLocalPort(), socket.getPublicIPAddress()), new TransportAddress(remoteIPAddress, remotePort), _var0);
                            readLength = _var0.getValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (StunServer.this._started) {
                            StunServer.this.doUdpReceive(socket);
                        }
                    }
                };
            }
            if (onFailure == null) {
                onFailure = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception exception) {
                        if (StunServer.this._started) {
                            StunServer.this.doUdpReceive(socket);
                        }
                    }
                };
            }
            socket.receiveAsync(onSuccess, onFailure);
        }
        catch (Exception exception) {
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not receive on server UDP socket. {0}", exception.getMessage()));
            }
            socket.close();
        }
    }
}

