/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Constants;
import fm.icelink.DateExtensions;
import fm.icelink.IAudioReframer;
import fm.icelink.Log;

class SoundTimestampContext
implements IAudioReframer {
    private int __timestampResetInterval = 1000;
    private int _clockRate;
    private boolean _disableTimestampReset;
    private boolean _forceTimestampReset;
    private int _frameDuration;
    private long _lastTimestamp = -1L;
    private long _nextTimestamp = 0L;
    private long _startTicks = -1L;

    @Override
    public int getClockRate() {
        return this._clockRate;
    }

    @Override
    public boolean getDisableTimestampReset() {
        return this._disableTimestampReset;
    }

    @Override
    public boolean getForceTimestampReset() {
        return this._forceTimestampReset;
    }

    @Override
    public int getFrameDuration() {
        return this._frameDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextTimestamp() {
        long num7;
        try {
            boolean forceTimestampReset = this.getForceTimestampReset();
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (this._startTicks == -1L) {
                this._startTicks = ticks;
            }
            long nextTimestamp = this._nextTimestamp;
            int num3 = this.getFrameDuration() * this.getClockRate() / Constants.getMillisecondsPerSecond();
            if (!this.getDisableTimestampReset()) {
                long num4 = ticks - this._startTicks;
                long num5 = nextTimestamp * (long)Constants.getTicksPerSecond() / (long)this.getClockRate();
                long num6 = num4 - num5;
                if (forceTimestampReset) {
                    if (Log.getIsInfoEnabled()) {
                        Log.info("Audio timestamp reset requested.");
                    }
                } else if (num6 > (long)(this.getTimestampResetInterval() * Constants.getTicksPerMillisecond())) {
                    forceTimestampReset = true;
                    if (Log.getIsInfoEnabled()) {
                        Log.info("Audio leap detected. Resetting timestamp using wall clock.");
                    }
                }
                if (forceTimestampReset) {
                    nextTimestamp = num4 * (long)this.getClockRate() / (long)Constants.getTicksPerSecond();
                    nextTimestamp -= nextTimestamp % (long)num3;
                    while (nextTimestamp <= this._lastTimestamp) {
                        nextTimestamp += (long)num3;
                    }
                }
            }
            this._nextTimestamp = nextTimestamp + (long)num3;
            this._lastTimestamp = nextTimestamp;
            while (nextTimestamp >= 0x100000000L) {
                nextTimestamp -= 0x100000000L;
            }
            num7 = nextTimestamp;
        }
        finally {
            this.setForceTimestampReset(false);
        }
        return num7;
    }

    @Override
    public int getTimestampResetInterval() {
        return this.__timestampResetInterval;
    }

    private void setClockRate(int value) {
        this._clockRate = value;
    }

    @Override
    public void setDisableTimestampReset(boolean value) {
        this._disableTimestampReset = value;
    }

    @Override
    public void setForceTimestampReset(boolean value) {
        this._forceTimestampReset = value;
    }

    private void setFrameDuration(int value) {
        this._frameDuration = value;
    }

    @Override
    public void setTimestampResetInterval(int value) {
        this.__timestampResetInterval = value;
    }

    public SoundTimestampContext(int frameDuration, int clockRate) {
        if (frameDuration <= 0) {
            frameDuration = 20;
        }
        this.setFrameDuration(frameDuration);
        this.setClockRate(clockRate);
    }
}

