/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.SoundTimestampContext;

class SoundReframerContext
extends SoundTimestampContext {
    private long __baseTimestamp = 0L;
    private int __currentFrameDataLength = 0;
    private DataBuffer __frameAccumulator = null;
    private int _channelCount;
    private IAction1<AudioFrame> _onFrame;

    private void cloneAndRaise(AudioFrame frame, AudioFormat format, int duration, DataBuffer chunkDataBuffer) {
        chunkDataBuffer.setLittleEndian(format.getLittleEndian());
        AudioFrame frame2 = frame.clone();
        frame2.setDuration(duration);
        frame2.setTimestamp(super.getNextTimestamp());
        frame2.removeBuffers();
        frame2.addBuffer(new AudioBuffer(chunkDataBuffer, format));
        this.raise(frame2);
    }

    public int getChannelCount() {
        return this._channelCount;
    }

    public IAction1<AudioFrame> getOnFrame() {
        return this._onFrame;
    }

    public void processFrame(AudioFrame frame, AudioBuffer buffer) {
        if (frame.getDuration() == super.getFrameDuration() && (this.__frameAccumulator == null || this.__frameAccumulator.getLength() == 0)) {
            frame.setTimestamp(super.getNextTimestamp());
            this.raise(frame);
        } else {
            int count = super.getClockRate() * this.getChannelCount() * 2 * super.getFrameDuration() / Constants.getMillisecondsPerSecond();
            if (this.__frameAccumulator == null) {
                this.__frameAccumulator = DataBuffer.allocate(count, ((AudioFormat)buffer.getFormat()).getLittleEndian());
                this.__frameAccumulator.resize(0);
                this.__currentFrameDataLength = count;
                this.__baseTimestamp = frame.getTimestamp();
            }
            if (count > this.__currentFrameDataLength) {
                int length = this.__frameAccumulator.getLength();
                this.__frameAccumulator.resize(count);
                this.__frameAccumulator.resize(length);
                this.__currentFrameDataLength = count;
            }
            if (count < this.__currentFrameDataLength) {
                int offset = 0;
                int num4 = this.__frameAccumulator.getLength() % count;
                for (int i = 0; i < num4; ++i) {
                    this.cloneAndRaise(frame, (AudioFormat)buffer.getFormat(), super.getFrameDuration(), this.__frameAccumulator.subset(offset, count));
                    offset += count;
                }
                if (offset > 0) {
                    int num6 = this.__frameAccumulator.getLength() - offset;
                    this.__frameAccumulator.write(this.__frameAccumulator.subset(offset, num6), 0);
                    this.__frameAccumulator.resize(num6);
                    this.__currentFrameDataLength = count;
                }
            }
            DataBuffer dataBuffer = buffer.getDataBuffer();
            if (this.__frameAccumulator.getLength() + dataBuffer.getLength() <= count) {
                this.__frameAccumulator.append(dataBuffer);
                if (this.__frameAccumulator.getLength() == count) {
                    this.cloneAndRaise(frame, (AudioFormat)buffer.getFormat(), super.getFrameDuration(), this.__frameAccumulator);
                    this.__frameAccumulator.resize(0);
                }
            } else {
                DataBuffer buffer3;
                if (this.__frameAccumulator.getLength() > 0) {
                    int num7 = count - this.__frameAccumulator.getLength();
                    this.__frameAccumulator.append(dataBuffer.subset(0, num7));
                    this.cloneAndRaise(frame, (AudioFormat)buffer.getFormat(), super.getFrameDuration(), this.__frameAccumulator);
                    this.__frameAccumulator.resize(0);
                    buffer3 = dataBuffer.subset(num7);
                } else {
                    buffer3 = dataBuffer;
                }
                while (buffer3.getLength() >= count) {
                    this.cloneAndRaise(frame, (AudioFormat)buffer.getFormat(), super.getFrameDuration(), buffer3.subset(0, count));
                    buffer3 = buffer3.subset(count);
                }
                if (buffer3.getLength() > 0) {
                    this.__frameAccumulator.append(buffer3);
                }
            }
        }
    }

    private void raise(AudioFrame frame) {
        IAction1<AudioFrame> onFrame = this.getOnFrame();
        if (onFrame != null) {
            onFrame.invoke(frame);
        }
    }

    private void setChannelCount(int value) {
        this._channelCount = value;
    }

    public void setOnFrame(IAction1<AudioFrame> value) {
        this._onFrame = value;
    }

    public SoundReframerContext(int frameDuration, int clockRate, int channelCount) {
        super(frameDuration, clockRate);
        this.setChannelCount(channelCount);
    }

    public SoundReframerContext(int frameDuration, AudioConfig config) {
        this(frameDuration, config.getClockRate(), config.getChannelCount());
    }
}

