/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.ByteCollection;
import fm.icelink.ByteExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ILog;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.NullableLong;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.SctpAbortChunk;
import fm.icelink.SctpChunk;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpCommonHeader;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpCookieAckChunk;
import fm.icelink.SctpCookieEchoChunk;
import fm.icelink.SctpDataChunk;
import fm.icelink.SctpErrorCause;
import fm.icelink.SctpErrorChunk;
import fm.icelink.SctpForwardTsnChunk;
import fm.icelink.SctpHeartbeatAckChunk;
import fm.icelink.SctpHeartbeatChunk;
import fm.icelink.SctpInitAckChunk;
import fm.icelink.SctpInitChunk;
import fm.icelink.SctpMessage;
import fm.icelink.SctpPacket;
import fm.icelink.SctpPartialReliabilitySupportParameters;
import fm.icelink.SctpReceiveDataQueue;
import fm.icelink.SctpResendArgs;
import fm.icelink.SctpSackChunk;
import fm.icelink.SctpSendControlChunkQueue;
import fm.icelink.SctpSendDataQueue;
import fm.icelink.SctpShutdownCompleteChunk;
import fm.icelink.SctpStaleCookieError;
import fm.icelink.SctpStateCookie;
import fm.icelink.SctpStateCookieChunkParameter;
import fm.icelink.SctpStream;
import fm.icelink.SctpStreamCollection;
import fm.icelink.SctpTcbState;
import fm.icelink.SctpTlvParameter;
import fm.icelink.SctpTransmissionControlBlock;
import fm.icelink.SctpTransportState;
import fm.icelink.SctpUnrecognizedChunkType;
import fm.icelink.SctpUnrecognizedParameterChunkParameter;
import fm.icelink.SctpUnrecognizedParameters;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import java.util.ArrayList;
import java.util.List;

class SctpTransport {
    private boolean __dataRetransmission;
    private SctpErrorChunk __errorToCombineWithCookieEcho;
    private ScheduledItem __initiationControlChunkScheduledItem = null;
    private Transport __innerTransport;
    private static ILog __log = Log.getLogger("FM.IceLink.Sctp.Transport");
    private SctpDataChunk __nextDataChunkToBeExaminedForSending;
    private int __numberOfPacketsSentSinceLastProcessorYield;
    private List<IAction1<SctpTransport>> __onStateChange = new ArrayList<IAction1<SctpTransport>>();
    private ScheduledItem __outgoingQueueScheduledItem = null;
    private SctpReceiveDataQueue __receiveDataQueue;
    private Scheduler __scheduler;
    private SctpSendControlChunkQueue __sendControlChunkQueue = new SctpSendControlChunkQueue();
    private SctpSendDataQueue __sendDataQueue;
    private Object __stateLock;
    private SctpTransmissionControlBlock __tcb;
    private Error _error;
    private String _id;
    private IAction1<SctpMessage> _onMessage;
    private IAction1<SctpTransport> _onStateChange = null;

    public void addOnStateChange(IAction1<SctpTransport> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<SctpTransport>(){

                    @Override
                    public void invoke(SctpTransport p0) {
                        for (IAction1 action : new ArrayList(SctpTransport.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    private void assembleMessage(Holder<byte[]> message, Holder<long[]> tsnArray, long currentTSN) {
        boolean flag = false;
        ArrayList<SctpDataChunk> list = new ArrayList<SctpDataChunk>();
        ArrayList<LongHolder> list2 = new ArrayList<LongHolder>();
        ByteCollection bytes = new ByteCollection();
        while (!flag) {
            list.add(this.__receiveDataQueue.getChunk(currentTSN));
            list2.add(new LongHolder(currentTSN));
            if (this.__receiveDataQueue.getChunk(currentTSN).getBeginning()) {
                flag = true;
                continue;
            }
            if (this.__receiveDataQueue.chunkExists(currentTSN = SctpDataChunk.decrementTSN(currentTSN))) continue;
            __log.error("SCTP: While assembling, did not encounter the beginning of the message in the receiving queue.");
            flag = true;
        }
        for (int i = ArrayListExtensions.getCount(list) - 1; i > -1; --i) {
            bytes.addRange(((SctpDataChunk)ArrayListExtensions.getItem(list).get(i)).getUserData());
        }
        message.setValue(bytes.toArray());
        tsnArray.setValue(new long[ArrayListExtensions.getCount(list2)]);
        for (int j = 0; j < ArrayExtensions.getLength(tsnArray.getValue()); ++j) {
            tsnArray.getValue()[j] = ((LongHolder)ArrayListExtensions.getItem(list2).get(j)).getValue();
        }
    }

    private boolean buildSctpPacket(Holder<SctpPacket> packet, boolean requestSACKImmediately) {
        boolean flag3;
        ScheduledItem resendScheduledItem = null;
        long peerVerificationTag = this.__tcb.getPeerVerificationTag();
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("Building outgoing SCTP packet. Peer verification tag is set to {0}.", LongExtensions.toString(peerVerificationTag)));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean flag = true;
        boolean flag2 = false;
        boolean bl = flag3 = !this.__tcb.getRemoteLikelyInConnectedState() && this.__sendDataQueue.getCount() > 0 && Global.equals((Object)this.getState(), (Object)SctpTransportState.Connected) && this.__tcb.getCookieAckSent();
        if (this.__sendControlChunkQueue.getCount() > 0 || flag3) {
            SctpControlChunk chunk = this.__sendControlChunkQueue.dequeue();
            if (chunk == null && flag3) {
                if (!this.__tcb.getRemoteLikelyInConnectedState() && this.__sendDataQueue.getCount() > 0 && Global.equals((Object)this.getState(), (Object)SctpTransportState.Connected)) {
                    chunk = new SctpCookieAckChunk();
                }
            } else if (chunk.getType() == SctpChunkType.getInitiationAck()) {
                peerVerificationTag = ((SctpInitAckChunk)chunk).getStateCookieChunk().getStateCookie().getPeerVerificationTag();
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("Updating peer verification tag to {0}.", LongExtensions.toString(peerVerificationTag)));
                }
            } else if (chunk.getType() == SctpChunkType.getCookieAck()) {
                this.__tcb.setCookieAckSent(true);
            }
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("Outgoing SCTP packet will contain control chunk of type {0}.", IntegerExtensions.toString(chunk.getType())));
            }
            flag &= chunk.getCanBundleWithDataAndSackChunks();
            list.add(chunk);
            if (resendScheduledItem == null) {
                resendScheduledItem = chunk.getResendScheduledItem();
            }
            if (chunk.getType() == SctpChunkType.getCookieEcho() && this.__errorToCombineWithCookieEcho != null && ArrayExtensions.getLength(chunk.getBytes()) + ArrayExtensions.getLength(this.__errorToCombineWithCookieEcho.getBytes()) <= 1050) {
                list.add(this.__errorToCombineWithCookieEcho);
                this.__errorToCombineWithCookieEcho = null;
            }
            if (this.__sendControlChunkQueue.getCount() > 0) {
                flag2 = true;
            }
        }
        int num2 = 0;
        if (this.__tcb.getEarliestAllowedSackSendTime() != (long)ScheduledItem.getUnset() && this.__tcb.getEarliestAllowedSackSendTime() < Scheduler.getCurrentTime() && this.__tcb.getSackCounter() > 0) {
            if (flag) {
                for (SctpChunk sctpChunk : list) {
                    num2 += ArrayExtensions.getLength(sctpChunk.getBytes());
                }
                SctpSackChunk sackChunk = this.__receiveDataQueue.getSackChunk();
                if (num2 + ArrayExtensions.getLength(sackChunk.getBytes(1050)) < 1050) {
                    this.__tcb.setSackCounter(0);
                    if (__log.getIsVerboseEnabled()) {
                        __log.verbose(StringExtensions.format("SCTP: Adding {0} to outgoing packet.", sackChunk.toString()));
                    }
                    list.add(sackChunk);
                    this.__tcb.setEarliestAllowedSackSendTime(ScheduledItem.getUnset());
                } else {
                    flag2 = true;
                }
            } else {
                flag2 = true;
            }
        }
        if (this.__sendDataQueue.getCount() > 0 && this.get_CanSendDataChunksInState()) {
            if (flag) {
                for (SctpChunk sctpChunk : list) {
                    num2 += ArrayExtensions.getLength(sctpChunk.getBytes());
                }
                boolean flag4 = false;
                while (!flag4 && this.__nextDataChunkToBeExaminedForSending != null) {
                    boolean bl2;
                    boolean bl3 = bl2 = !this.__nextDataChunkToBeExaminedForSending.getAcked() && this.__dataRetransmission && this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() > 0L;
                    if (!this.__nextDataChunkToBeExaminedForSending.getAcked() && this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() < 0L && this.__sendDataQueue.getCwnd() <= this.__tcb.getMaximumStaticCongestionWindow() || bl2) {
                        int num3 = num2 + ArrayExtensions.getLength(this.__nextDataChunkToBeExaminedForSending.getBytes());
                        if (num2 + ArrayExtensions.getLength(this.__nextDataChunkToBeExaminedForSending.getBytes()) < 1050) {
                            list.add(this.__nextDataChunkToBeExaminedForSending);
                            this.__sendDataQueue.markChunkTransmitted(this.__nextDataChunkToBeExaminedForSending);
                            if (requestSACKImmediately) {
                                this.__nextDataChunkToBeExaminedForSending.setSackImmediately(true);
                            } else if (!this.__nextDataChunkToBeExaminedForSending.getEnding()) {
                                this.__nextDataChunkToBeExaminedForSending.setSackImmediately(false);
                            }
                            num2 = num3;
                            this.__nextDataChunkToBeExaminedForSending = this.__sendDataQueue.getNextChunk(this.__nextDataChunkToBeExaminedForSending.getTsn());
                            continue;
                        }
                        flag4 = true;
                        continue;
                    }
                    if (this.__dataRetransmission) {
                        if (this.__nextDataChunkToBeExaminedForSending.getAcked()) {
                            this.__nextDataChunkToBeExaminedForSending = this.__sendDataQueue.getNextChunk(this.__nextDataChunkToBeExaminedForSending.getTsn());
                            continue;
                        }
                        flag4 = true;
                        continue;
                    }
                    flag4 = true;
                }
                if (this.__nextDataChunkToBeExaminedForSending != null) {
                    flag2 = !this.__nextDataChunkToBeExaminedForSending.getAcked() && (this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() < 0L && this.__sendDataQueue.getCwnd() <= this.__tcb.getMaximumStaticCongestionWindow() || this.__dataRetransmission && this.__nextDataChunkToBeExaminedForSending.getTransmissionTime() > 0L);
                }
            } else {
                flag2 = true;
            }
        }
        SctpCommonHeader header = new SctpCommonHeader(this.getLocalPort(), this.__tcb.getDestinationPort(), peerVerificationTag);
        if (ArrayListExtensions.getCount(list) > 0) {
            packet.setValue(new SctpPacket(header, list.toArray(new SctpChunk[0])));
            if (resendScheduledItem != null) {
                SctpResendArgs sctpResendArgs = (SctpResendArgs)resendScheduledItem.getState();
                sctpResendArgs.setPacketBytes(DataBuffer.wrap(packet.getValue().getBytes()));
                this.__scheduler.add(resendScheduledItem);
                resendScheduledItem = null;
            }
            return flag2;
        }
        packet.setValue(null);
        return flag2;
    }

    private boolean checkVerificationTag(SctpPacket packet) {
        if (ArrayExtensions.getLength(packet.getChunks()) > 0) {
            if (packet.getChunks()[0].getType() == SctpChunkType.getInitiation()) {
                return packet.getHeader().getVerificationTag() == 0L;
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getAbort()) {
                SctpAbortChunk chunk = (SctpAbortChunk)packet.getChunks()[0];
                if (chunk.getVerificationTagReflected()) {
                    return this.__tcb.getPeerVerificationTag() == packet.getHeader().getVerificationTag();
                }
                return this.__tcb.getMyVerificationTag() == packet.getHeader().getVerificationTag();
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getShutdownComplete()) {
                SctpShutdownCompleteChunk chunk2 = (SctpShutdownCompleteChunk)packet.getChunks()[0];
                if (chunk2.getVerificationTagReflected()) {
                    return this.__tcb.getPeerVerificationTag() == packet.getHeader().getVerificationTag();
                }
                return this.__tcb.getMyVerificationTag() == packet.getHeader().getVerificationTag();
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getCookieEcho()) {
                return true;
            }
            if (packet.getChunks()[0].getType() == SctpChunkType.getShutdownAck() && (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait))) {
                return false;
            }
        }
        return this.__tcb.getMyVerificationTag() == packet.getHeader().getVerificationTag();
    }

    private void closeOnFailure(Exception ex) {
        __log.debug("SCTP: Failure occurred. Proceeding to Close the SCTP Association.");
        this.setError(new Error(ErrorCode.SctpInternalError, ex));
        this.set_InnerState(SctpTcbState.Failing);
        this.stopAllDataChunkTransmission();
        this.stopAllControlChunkTransmission();
        this.set_InnerState(SctpTcbState.Failed);
        __log.debug("SCTP: Association shut down.");
        this.__innerTransport = null;
    }

    private void dispatch(DataBuffer buffer) {
        Transport transport = this.__innerTransport;
        if (transport != null && !transport.getIsClosed()) {
            try {
                transport.send(buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessIncomingSctpPacket(DataBuffer buffer) {
        Object[] chunkArray;
        Object object;
        Object obj2;
        SctpPacket packet;
        byte[] sctpBytes = buffer.toArray();
        int length = buffer.getLength();
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("SCTP Manager received an SCTP packet at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
        }
        if (!SctpPacket.verifyCRC32cChecksum(sctpBytes, 0, length)) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("Incoming packet dropped due to invalid CRC32c checksum at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
            }
            return false;
        }
        try {
            packet = SctpPacket.parseBytes(sctpBytes, 0, length);
        }
        catch (Exception exception1) {
            __log.error("Failed to parse SCTP packets.");
            return false;
        }
        if (packet == null) {
            __log.warn("Could not parse SCTP packets.");
            return false;
        }
        if (!this.checkVerificationTag(packet)) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP packet contains invalid verification tag. Dropping packet at {0}", LongExtensions.toString(Scheduler.getCurrentTime())));
            }
            return false;
        }
        boolean flag = true;
        if (packet.getChunks() == null) {
            flag = false;
        }
        int num3 = 0;
        int num4 = 0;
        boolean flag2 = false;
        long greatestCumulativeTsnReceived = this.__tcb.getGreatestCumulativeTsnReceived();
        boolean flag3 = false;
        ArrayList<SctpChunk> list = new ArrayList<SctpChunk>();
        for (int index = 0; index < ArrayExtensions.getLength(packet.getChunks()) && flag; ++index) {
            SctpDataChunk chunk2;
            Object chunk;
            if (__log.getIsVerboseEnabled()) {
                chunk = packet.getChunks()[index];
                if (((SctpChunk)chunk).getType() == SctpChunkType.getData()) {
                    chunk2 = (SctpDataChunk)chunk;
                    __log.verbose(StringExtensions.format("SCTP packet received by manager contains chunk of type {1} with TSN {2}, SSN {3} on the Sctp Stream {4} at {0}.", new Object[]{LongExtensions.toString(Scheduler.getCurrentTime()), IntegerExtensions.toString(chunk2.getType()), LongExtensions.toString(chunk2.getTsn()), IntegerExtensions.toString(chunk2.getStreamSequenceNumber()), IntegerExtensions.toString(chunk2.getStreamIdentifier())}));
                } else {
                    __log.verbose(StringExtensions.format("SCTP packet received by manager contains chunk of type {1}.", LongExtensions.toString(Scheduler.getCurrentTime()), IntegerExtensions.toString(((SctpChunk)chunk).getType())));
                }
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getInitiation()) {
                chunk = obj2 = this.__stateLock;
                synchronized (chunk) {
                    if ((Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) && index == 0) {
                        this.respondWithINIT_ACK((SctpInitChunk)packet.getChunks()[0]);
                    } else {
                        __log.debug("SCTP: Association not in CLOSED, COOKIE WAIT or COOKIE ECHOED state when INIT received or control chunk not the first in sequence. Stale packet?");
                    }
                }
                flag = false;
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getInitiationAck()) {
                chunk = obj2 = this.__stateLock;
                synchronized (chunk) {
                    if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait) && index == 0) {
                        this.respondWithCOOKIE_ECHO((SctpInitAckChunk)packet.getChunks()[0]);
                    } else {
                        __log.debug("SCTP: Association not in COOKIE_WAIT state when INIT_ACK received or control chunk not the first in sequence. Stale packet?");
                    }
                }
                flag = false;
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getCookieEcho()) {
                chunk = obj2 = this.__stateLock;
                synchronized (chunk) {
                    if ((Global.equals((Object)this.getState(), (Object)SctpTransportState.Connecting) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) && index == 0) {
                        boolean flag4 = this.respondWithCOOKIE_ACK((SctpCookieEchoChunk)packet.getChunks()[0], packet.getHeader());
                        greatestCumulativeTsnReceived = this.__tcb.getGreatestCumulativeTsnReceived();
                        if (!flag4) {
                            flag = false;
                        }
                    } else {
                        flag = false;
                        __log.debug("SCTP: Cookie received in state other than CLOSED or control chunk not the first in sequence. Stale packet?");
                    }
                    continue;
                }
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getCookieAck()) {
                chunk = obj2 = this.__stateLock;
                synchronized (chunk) {
                    if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed) && index == 0) {
                        this.set_InnerState(SctpTcbState.Established);
                        if (this.__errorToCombineWithCookieEcho != null) {
                            this.__sendControlChunkQueue.enqueue(this.__errorToCombineWithCookieEcho);
                            this.__errorToCombineWithCookieEcho = null;
                            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                        }
                    } else if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                        flag = true;
                        __log.debug("SCTP: Cookie_ACK received in state other than SCTPStates.COOKIE_ECHOED. Ignoring the Cookie_ACK chunk. If there are other chunks in the packet, they will be examined.");
                    } else {
                        flag = true;
                        __log.debug("SCTP: Cookie_ACK control chunk not the first in packet sequence. Droping packet.");
                    }
                    continue;
                }
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getForwardCumulativeTSN()) {
                if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) continue;
                SctpPartialReliabilitySupportParameters partialReliabilitySupport = this.__tcb.getPartialReliabilitySupport();
                if (partialReliabilitySupport != null && partialReliabilitySupport.getPartialReliabilityUsedInThisAssociation()) {
                    this.__tcb.setRemoteLikelyInConnectedState(true);
                    SctpForwardTsnChunk fwd = (SctpForwardTsnChunk)packet.getChunks()[index];
                    if (__log.getIsVerboseEnabled()) {
                        __log.verbose(StringExtensions.format("SCTP: Received Forward TSN chunk with the New Cumulative Tsn Ack {0} at {1}", LongExtensions.toString(fwd.getNewCumulativeTsnAck()), LongExtensions.toString(Scheduler.getCurrentTime())));
                    }
                    flag3 |= !this.__receiveDataQueue.processForwardTsnChunk(fwd);
                    continue;
                }
                __log.debug("SCTP: remote sent Forward Cumulative TSN chunk, but this party has not enabled support for partial reliability OR PR was not negotiated. Ignoring this chunk and reporting it as unrecognied to the other party.");
                list.add(packet.getChunks()[index]);
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getData()) {
                if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) continue;
                this.__tcb.setRemoteLikelyInConnectedState(true);
                ++num3;
                chunk2 = (SctpDataChunk)packet.getChunks()[index];
                flag3 |= chunk2.getSackImmediately();
                if (SctpDataChunk.compareTsns(chunk2.getTsn(), this.__tcb.getGreatestReceivedTsn()) == 1) {
                    this.__tcb.setGreatestReceivedTsn(chunk2.getTsn());
                    if (__log.getIsVerboseEnabled()) {
                        __log.verbose(StringExtensions.concat("Updating greatest received TSN to ", LongExtensions.toString(this.__tcb.getGreatestReceivedTsn())));
                    }
                }
                if (SctpDataChunk.compareTsns(chunk2.getTsn(), this.__receiveDataQueue.getCumulativeACK()) != 1 || this.__receiveDataQueue.chunkExists(chunk2.getTsn())) continue;
                ++num4;
                this.__receiveDataQueue.add(chunk2);
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getSack()) {
                if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                    this.__tcb.setRemoteLikelyInConnectedState(true);
                    if (this.__tcb.getFreshestReceivedSack() != null && SctpDataChunk.compareTsns(((SctpSackChunk)packet.getChunks()[index]).getCumulativeTsnAck(), this.__tcb.getFreshestReceivedSack().getCumulativeTsnAck()) >= 2) continue;
                    if (__log.getIsVerboseEnabled()) {
                        if (this.__tcb.getFreshestReceivedSack() != null) {
                            __log.verbose(StringExtensions.format("New SACK received with the cumulative TSN ACK of {1}, while association's cumulative ACK is {2} at {0}", LongExtensions.toString(Scheduler.getCurrentTime()), LongExtensions.toString(((SctpSackChunk)packet.getChunks()[index]).getCumulativeTsnAck()), LongExtensions.toString(this.__tcb.getFreshestReceivedSack().getCumulativeTsnAck())));
                        } else {
                            __log.debug(StringExtensions.format("New SACK received with the cumulative TSN ACK of {1} at {0}", LongExtensions.toString(Scheduler.getCurrentTime()), LongExtensions.toString(((SctpSackChunk)packet.getChunks()[index]).getCumulativeTsnAck())));
                        }
                    }
                    this.__tcb.setFreshestReceivedSack((SctpSackChunk)packet.getChunks()[index]);
                    flag2 = true;
                    continue;
                }
                if (!Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Closed)) continue;
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getHeartbeat()) {
                if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                    try {
                        SctpHeartbeatAckChunk controlChunk;
                        SctpHeartbeatChunk chunk4 = (SctpHeartbeatChunk)packet.getChunks()[index];
                        if (__log.getIsVerboseEnabled()) {
                            __log.verbose(StringExtensions.format("SCTP: Received a heartbeat. Sending HEARTBEAT_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                        }
                        if ((controlChunk = new SctpHeartbeatAckChunk(chunk4.getHeartbeatInfo())) == null) continue;
                        object = obj2 = this.__stateLock;
                        synchronized (object) {
                            this.__sendControlChunkQueue.enqueue(controlChunk);
                            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                        }
                    }
                    catch (Exception exception) {
                        __log.debug(StringExtensions.format("Failure to process incoming SCTP Heartbeats: {0}", exception.toString()));
                    }
                    continue;
                }
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("SCTP: Received a heartbeat; discarding it because the association is in state {1} at {0}.", LongExtensions.toString(Scheduler.getCurrentTime()), this.get_InnerState().toString()));
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getHeartbeatAck()) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("SCTP: Received a heartbeat ack at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                continue;
            }
            if (packet.getChunks()[index].getType() == SctpChunkType.getAbort()) {
                if (__log.getIsVerboseEnabled()) {
                    SctpAbortChunk chunk6 = (SctpAbortChunk)packet.getChunks()[index];
                    if (chunk6.getErrorCauses() != null) {
                        int num13 = ArrayExtensions.getLength(chunk6.getErrorCauses());
                        __log.verbose(StringExtensions.format("SCTP:  Received ABORT from another peer containing {1} error causes at {0}.", LongExtensions.toString(Scheduler.getCurrentTime()), IntegerExtensions.toString(num13)));
                        continue;
                    }
                    __log.verbose(StringExtensions.format("SCTP:  Received ABORT from another peer containing no error causes at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    continue;
                }
                __log.debug("SCTP: Received ABORT from another peer.");
                continue;
            }
            if (packet.getChunks()[index].getType() != SctpChunkType.getError()) continue;
            this.processError((SctpErrorChunk)packet.getChunks()[index]);
        }
        if (packet.getUnrecognizedChunksThatShouldBeReportedToSender() != null) {
            ArrayListExtensions.addRange(list, packet.getUnrecognizedChunksThatShouldBeReportedToSender());
        }
        if (ArrayListExtensions.getCount(list) > 0 && ArrayExtensions.getLength(chunkArray = list.toArray(new SctpChunk[0])) > 0) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP: Reporting unrecognised chunks to the other peer at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
            }
            SctpErrorCause[] errorCauses = new SctpUnrecognizedChunkType[ArrayExtensions.getLength(chunkArray)];
            for (int i = 0; i < ArrayExtensions.getLength(chunkArray); ++i) {
                errorCauses[i] = new SctpUnrecognizedChunkType((SctpChunk)chunkArray[i]);
            }
            SctpErrorChunk chunk7 = new SctpErrorChunk(errorCauses);
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.__sendControlChunkQueue.enqueue(chunk7);
                this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            }
        }
        if (num3 > 0 && this.__receiveDataQueue.getCount() > 0) {
            long earliestTSN = this.__receiveDataQueue.getEarliestTSN();
            if (SctpDataChunk.compareTsns(earliestTSN, SctpDataChunk.incrementTSN(greatestCumulativeTsnReceived)) == 1) {
                earliestTSN = SctpDataChunk.incrementTSN(greatestCumulativeTsnReceived);
            }
            boolean flag5 = false;
            boolean flag6 = true;
            boolean flag7 = false;
            SctpDataChunk nextChunk = this.__receiveDataQueue.getChunk(earliestTSN);
            if (nextChunk == null) {
                flag6 = false;
                nextChunk = this.__receiveDataQueue.getNextChunk(earliestTSN);
            }
            while (nextChunk != null) {
                long tsn;
                if (!nextChunk.getRaised() && (flag6 || !flag6 && nextChunk.getUnordered())) {
                    SctpStream stream = this.__tcb.getInboundStreams().getStream(nextChunk.getStreamIdentifier());
                    if (flag5) {
                        if (nextChunk.getBeginning()) {
                            if (!flag7) {
                                throw new RuntimeException(new Exception("SCTP: Encountered an unfinished message"));
                            }
                        } else if (nextChunk.getEnding() && !flag7) {
                            if (nextChunk.getUnordered()) {
                                this.raiseReceivedMessage(nextChunk.getTsn());
                            } else if (nextChunk.getStreamSequenceNumber() == stream.getNextSsn()) {
                                this.raiseReceivedMessage(nextChunk.getTsn());
                                stream.setNextSsn(SctpDataChunk.incrementSSN(stream.getNextSsn()));
                            }
                            flag5 = false;
                        }
                    } else if (nextChunk.getBeginning()) {
                        flag7 = false;
                        if (nextChunk.getEnding()) {
                            if (nextChunk.getUnordered()) {
                                this.raiseReceivedMessage(nextChunk.getTsn());
                            } else if (nextChunk.getStreamSequenceNumber() == stream.getNextSsn()) {
                                this.raiseReceivedMessage(nextChunk.getTsn());
                                stream.setNextSsn(SctpDataChunk.incrementSSN(stream.getNextSsn()));
                            }
                        } else {
                            flag5 = true;
                        }
                    }
                }
                if ((nextChunk = this.__receiveDataQueue.getChunk(SctpDataChunk.incrementTSN(tsn = nextChunk.getTsn()))) != null) continue;
                flag7 = true;
                flag6 = false;
                nextChunk = this.__receiveDataQueue.getNextChunk(tsn);
            }
            boolean flag8 = true;
            nextChunk = this.__receiveDataQueue.getChunk(this.__receiveDataQueue.getEarliestTSN());
            while (flag8 && nextChunk != null) {
                if (nextChunk.getRaised()) {
                    this.__receiveDataQueue.remove(nextChunk.getTsn());
                } else {
                    flag8 = false;
                }
                nextChunk = this.__receiveDataQueue.getNextChunk(nextChunk.getTsn());
            }
            this.__tcb.setGreatestCumulativeTsnReceived(this.__receiveDataQueue.getCumulativeACK());
        }
        if (flag2 || num3 > 0) {
            boolean flag9 = false;
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                int newDataPacketCountTrigger = this.getNewDataPacketCountTrigger();
                if (num3 > 0) {
                    int sackCounter = this.__tcb.getSackCounter();
                    this.__tcb.setSackCounter(sackCounter + 1);
                    if ((float)(num4 / num3) < 0.4f) {
                        this.__tcb.setEarliestAllowedSackSendTime(Scheduler.getCurrentTime());
                        flag9 = true;
                        if (__log.getIsVerboseEnabled()) {
                            __log.verbose("Latest SCTP Packet contained too many retransmitted chunks. Sending SACK immediately.");
                        }
                    }
                }
                if (flag2) {
                    flag9 = true;
                }
                if (flag3 || this.__tcb.getSackCounter() >= newDataPacketCountTrigger) {
                    if (__log.getIsVerboseEnabled()) {
                        if (flag3) {
                            __log.verbose("One of received DATA chunks contained SACK-Immediately bit set. Will transmit SACK immediately.");
                        } else {
                            __log.verbose("SACK counter exceeded. Will transmit SACK now.");
                        }
                    }
                    this.__tcb.setEarliestAllowedSackSendTime(Scheduler.getCurrentTime());
                    flag9 = true;
                } else if (this.__tcb.getSackCounter() < newDataPacketCountTrigger && num3 > 0) {
                    if (this.__tcb.getEarliestAllowedSackSendTime() == (long)ScheduledItem.getUnset()) {
                        this.__tcb.setEarliestAllowedSackSendTime(500L + Scheduler.getCurrentTime());
                        if (!this.__scheduler.itemIsScheduled(this.__outgoingQueueScheduledItem)) {
                            int num11 = 500;
                            if (__log.getIsVerboseEnabled()) {
                                __log.verbose(StringExtensions.format("Starting countdown to sending new data. Scheduling outgoing queue processing in {0}", IntegerExtensions.toString(num11)));
                            }
                            this.__outgoingQueueScheduledItem.setDelay(num11);
                            this.__scheduler.add(this.__outgoingQueueScheduledItem);
                        }
                    } else if (this.__tcb.getEarliestAllowedSackSendTime() < Scheduler.getCurrentTime()) {
                        flag9 = true;
                    }
                }
                if (flag9) {
                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                }
            }
        }
        return true;
    }

    private boolean get_Active() {
        return Global.equals((Object)this.getState(), (Object)SctpTransportState.Closing) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Connected) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Connecting);
    }

    private boolean get_CanSendDataChunksInState() {
        return Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closing) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpTcbState get_InnerState() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (this.__tcb != null) {
                return this.__tcb.getState();
            }
            return SctpTcbState.ClosedNeverOpened;
        }
    }

    public Error getError() {
        return this._error;
    }

    public String getId() {
        return this._id;
    }

    public boolean getIsClosed() {
        return Global.equals((Object)this.getState(), (Object)SctpTransportState.Closed) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Closing) || Global.equals((Object)this.getState(), (Object)SctpTransportState.Failed) || Global.equals((Object)this.getState(), (Object)SctpTransportState.New);
    }

    public int getLocalPort() {
        return this.__tcb == null ? SctpTransport.getUnset() : this.__tcb.getSourcePort();
    }

    public boolean getLocalSupportsPartialReliabilityExtension() {
        SctpTransmissionControlBlock block = this.__tcb;
        if (block == null) {
            throw new RuntimeException(new Exception("SCTP: TCB is not set, cannot get support for partial reliability extension."));
        }
        SctpPartialReliabilitySupportParameters partialReliabilitySupport = block.getPartialReliabilitySupport();
        return partialReliabilitySupport != null && partialReliabilitySupport.getPartialReliabilitySupportedByThisEndpoint();
    }

    private int getNewDataPacketCountTrigger() {
        return 4;
    }

    public IAction1<SctpMessage> getOnMessage() {
        return this._onMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpTransportState getState() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (this.__tcb != null) {
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.ClosedNeverOpened)) {
                    return SctpTransportState.New;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Failed)) {
                    return SctpTransportState.Failed;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Closed)) {
                    return SctpTransportState.Closed;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Closing)) {
                    return SctpTransportState.Closing;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Failing)) {
                    return SctpTransportState.Failing;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.CookieEchoed)) {
                    return SctpTransportState.Connecting;
                }
                if (Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.CookieWait)) {
                    return SctpTransportState.Connecting;
                }
                if (!Global.equals((Object)this.__tcb.getState(), (Object)SctpTcbState.Established)) {
                    throw new RuntimeException(new Exception(StringExtensions.format("SCTP: unknown TCB state {0}.", this.__tcb.getState().toString())));
                }
                return SctpTransportState.Connected;
            }
            return SctpTransportState.New;
        }
    }

    private int getT3TimerExtension() {
        return 1000;
    }

    public static int getUnset() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializationFailure(ScheduledItem item) {
        SctpResendArgs args = (SctpResendArgs)item.getState();
        SctpTcbState state = args.getState();
        Object object = this.__stateLock;
        synchronized (object) {
            if (Global.equals((Object)state, (Object)this.get_InnerState())) {
                String message = "";
                message = __log.getIsVerboseEnabled() ? StringExtensions.format("SCTP has not received valid response to a control chunk of type {0} within expected time period at {1}.", ByteExtensions.toString(args.getType()), LongExtensions.toString(Scheduler.getCurrentTime())) : StringExtensions.format("SCTP has not received valid response to a control chunk of type {0} within expected time period.", ByteExtensions.toString(args.getType()));
                __log.verbose(message);
                this.closeOnFailure(new Exception(message));
            }
        }
    }

    private void initiate() {
        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Closed) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Failed) || Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) {
            ScheduledItem item;
            this.__tcb.setMyVerificationTag(MathAssistant.max(1L, (long)(4.294967295E9 * LockedRandomizer.nextDouble())));
            this.__tcb.setNextTsnToSend(this.__tcb.getMyVerificationTag());
            SctpInitChunk controlChunk = new SctpInitChunk(this.__tcb.getMyVerificationTag(), this.__tcb.getAdvertisedReceiverWindowCredit(), this.__tcb.getOutboundStreams().getCount(), this.__tcb.getInboundStreams().getCount(), this.__tcb.getNextTsnToSend(), this.__tcb.getPartialReliabilitySupport(), this.__tcb.getAuthenticatedChunksSupport(), this.__tcb.getDynamicAddressReconfigurationSupport(), null, null);
            this.set_InnerState(SctpTcbState.CookieWait);
            SctpResendArgs args2 = new SctpResendArgs(SctpTcbState.CookieWait);
            args2.setType(SctpChunkType.getInitiation());
            SctpResendArgs args = args2;
            ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.resendPacket";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.resendPacket(item);
                }
            }, 200, 200, 10000, ScheduledItem.getUnset());
            item2.setState(args);
            item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.initializationFailure";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.initializationFailure(item);
                }
            });
            this.__initiationControlChunkScheduledItem = item = item2;
            controlChunk.setResendScheduledItem(item);
            this.__sendControlChunkQueue.enqueue(controlChunk);
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP: sending INIT at {0} and moving into the COOKIE_WAIT state. My verification tag = Next TSN to send: {1}.", LongExtensions.toString(Scheduler.getCurrentTime()), LongExtensions.toString(this.__tcb.getNextTsnToSend())));
            } else {
                __log.debug("SCTP: sending INIT and moving into the COOKIE_WAIT state.");
            }
            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
        }
    }

    private void processError(SctpErrorChunk chunk) {
        SctpErrorCause[] errorCauses;
        for (SctpErrorCause cause : errorCauses = chunk.getErrorCauses()) {
            SctpTlvParameter[] parameters;
            SctpPartialReliabilitySupportParameters partialReliabilitySupport;
            int _var0 = cause.getCauseCode();
            if (_var0 == 6) {
                SctpUnrecognizedChunkType type = (SctpUnrecognizedChunkType)cause;
                if (type.getUnrecognizedChunk().getType() != SctpChunkType.getForwardCumulativeTSN()) continue;
                partialReliabilitySupport = this.__tcb.getPartialReliabilitySupport();
                if (partialReliabilitySupport != null) {
                    partialReliabilitySupport = new SctpPartialReliabilitySupportParameters(true);
                }
                partialReliabilitySupport.setRemoteIndicatedLackOfPRSupport(true);
                __log.debug("SCTP: Remote party indicates that it does not recognise SCTP Forward Cumulative TSN Chunk. Partial Reliability extension will be disabled for data stream.");
                continue;
            }
            if (_var0 != 8) continue;
            SctpUnrecognizedParameters parameters2 = (SctpUnrecognizedParameters)cause;
            for (SctpTlvParameter parameter : parameters = parameters2.getParameters()) {
                if (parameter.getType() != 49152) continue;
                partialReliabilitySupport = this.__tcb.getPartialReliabilitySupport();
                if (partialReliabilitySupport != null) {
                    partialReliabilitySupport = new SctpPartialReliabilitySupportParameters(true);
                }
                partialReliabilitySupport.setRemoteIndicatedLackOfPRSupport(true);
                __log.debug("SCTP: Remote party indicates that it does not recognise SCTP Forward-TSN-Supported-Parameter. Partial Reliability extension will be disabled for data stream.");
            }
        }
    }

    public void processIncomingSctpPacket(DataBuffer buffer) {
        this.doProcessIncomingSctpPacket(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOutgoingQueueLoop(ScheduledItem item) {
        this.__scheduler.remove(item);
        ArrayList<SctpPacket> list = new ArrayList<SctpPacket>();
        SctpDataChunk[] chunkArray = null;
        try {
            Object obj2;
            SctpDataChunk[] sctpDataChunkArray = obj2 = this.__stateLock;
            synchronized (obj2) {
                boolean flag3;
                ScheduledItem item2;
                int flag;
                long currentTime = Scheduler.getCurrentTime();
                if (this.__tcb.getFreshestReceivedSack() != null) {
                    chunkArray = this.__sendDataQueue.processSackChunk(this.__tcb.getFreshestReceivedSack());
                }
                this.__dataRetransmission = this.__tcb.getEarliestAllowedRetransmissionTime() != -1L && this.__tcb.getEarliestAllowedRetransmissionTime() < currentTime;
                int n = flag = this.__sendDataQueue.getNonsentDataAvailable() && this.__sendDataQueue.getCwnd() <= this.__tcb.getMaximumStaticCongestionWindow() || !this.__sendDataQueue.getAllSentAcked() && this.__dataRetransmission && this.__sendDataQueue.getCount() > 0 ? 1 : 0;
                if (flag != 0) {
                    if (this.__tcb.getMostRecentOutgoingForwardTsnChunk() != null) {
                        if (this.__tcb.getNumberOfDuplicateForwardTsnRequests() == 0) {
                            this.__sendControlChunkQueue.enqueue(this.__tcb.getMostRecentOutgoingForwardTsnChunk());
                        } else {
                            item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                                @Override
                                public String getId() {
                                    return "fm.icelink.SctpTransport.putForwardTsnOntoControlChunkQueue";
                                }

                                @Override
                                public void invoke(ScheduledItem item) {
                                    SctpTransport.this.putForwardTsnOntoControlChunkQueue(item);
                                }
                            }, 500, ScheduledItem.getUnset(), ScheduledItem.getUnset(), ScheduledItem.getUnset());
                            this.__tcb.setSendForwardTsnScheduledItem(item2);
                            this.__scheduler.add(item2);
                        }
                    }
                } else if (this.__tcb.getMostRecentOutgoingForwardTsnChunk() != null) {
                    item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.SctpTransport.putForwardTsnOntoControlChunkQueue";
                        }

                        @Override
                        public void invoke(ScheduledItem item) {
                            SctpTransport.this.putForwardTsnOntoControlChunkQueue(item);
                        }
                    }, 500, ScheduledItem.getUnset(), ScheduledItem.getUnset(), ScheduledItem.getUnset());
                    this.__tcb.setSendForwardTsnScheduledItem(item2);
                    this.__scheduler.add(item2);
                }
                boolean requestSACKImmediately = (float)this.__sendDataQueue.getCwnd() >= (float)this.__tcb.getMaximumStaticCongestionWindow() * 0.9f;
                boolean bl = flag3 = this.__sendControlChunkQueue.getCount() > 0 || flag != 0 || this.__tcb.getEarliestAllowedSackSendTime() != (long)ScheduledItem.getUnset() && this.__tcb.getEarliestAllowedSackSendTime() < currentTime && this.__tcb.getSackCounter() > 0;
                if (flag != 0 && this.__tcb.getEarliestAllowedRetransmissionTime() < currentTime) {
                    this.__tcb.setEarliestAllowedRetransmissionTime(currentTime + (long)this.getT3TimerExtension());
                }
                if (this.__sendDataQueue.getCount() > 0) {
                    this.__nextDataChunkToBeExaminedForSending = this.__sendDataQueue.getFirstUnAcked();
                }
                SctpPacket packet = null;
                while (flag3) {
                    Holder<Object> _var0 = new Holder<Object>(packet);
                    boolean _var1 = this.buildSctpPacket(_var0, requestSACKImmediately);
                    packet = _var0.getValue();
                    flag3 = _var1;
                    if (packet == null) continue;
                    list.add(packet);
                }
                // ** MonitorExit[var7_5] (shouldn't be in output)
                for (SctpPacket packet2 : list) {
                    if (this.__numberOfPacketsSentSinceLastProcessorYield >= 0) {
                        ManagedThread.sleep(1);
                        this.__numberOfPacketsSentSinceLastProcessorYield = 0;
                    } else {
                        ++this.__numberOfPacketsSentSinceLastProcessorYield;
                    }
                    this.dispatch(DataBuffer.wrap(packet2.getBytes()));
                }
                if (chunkArray != null) {
                    for (SctpDataChunk chunk : chunkArray) {
                        SctpMessage message = chunk.getMessage();
                        if (message == null) continue;
                        message.raiseSuccess();
                    }
                }
                list.clear();
                sctpDataChunkArray = obj2 = this.__stateLock;
                synchronized (obj2) {
                    currentTime = Scheduler.getCurrentTime();
                    int unset = ScheduledItem.getUnset();
                    if (this.__sendDataQueue.getCount() > 0) {
                        unset = (int)MathAssistant.max(this.__tcb.getEarliestAllowedRetransmissionTime() - currentTime, 0L);
                    }
                    if (this.__tcb.getSackCounter() > 0 && this.__tcb.getEarliestAllowedSackSendTime() != (long)ScheduledItem.getUnset()) {
                        int num3 = (int)MathAssistant.max(this.__tcb.getEarliestAllowedSackSendTime() - currentTime, 0L);
                        unset = unset > ScheduledItem.getUnset() ? MathAssistant.min(unset, num3) : num3;
                    }
                    if (unset <= ScheduledItem.getUnset()) return;
                    this.__outgoingQueueScheduledItem.setDelay(unset);
                    this.__scheduler.add(this.__outgoingQueueScheduledItem);
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
            }
        }
        catch (Exception exception) {
            if (!this.get_Active() && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) return;
            __log.error("SCTP Transport: Could not process outgoing queue.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putForwardTsnOntoControlChunkQueue(ScheduledItem item) {
        Object object = this.__stateLock;
        synchronized (object) {
            this.__tcb.setSendForwardTsnScheduledItem(null);
            this.__tcb.setNumberOfDuplicateForwardTsnRequests(0);
            SctpForwardTsnChunk mostRecentOutgoingForwardTsnChunk = this.__tcb.getMostRecentOutgoingForwardTsnChunk();
            if (mostRecentOutgoingForwardTsnChunk != null) {
                this.__sendControlChunkQueue.enqueue(mostRecentOutgoingForwardTsnChunk);
                this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            }
        }
    }

    private void raiseReceivedMessage(long tsn) {
        long[] tsnArray = new long[]{};
        byte[] buffer = new byte[]{};
        Holder<byte[]> _var0 = new Holder<byte[]>(buffer);
        Holder<long[]> _var1 = new Holder<long[]>(tsnArray);
        this.assembleMessage(_var0, _var1, tsn);
        buffer = _var0.getValue();
        tsnArray = _var1.getValue();
        IAction1<SctpMessage> onMessage = this.getOnMessage();
        if (onMessage != null) {
            SctpMessage p = new SctpMessage(DataBuffer.wrap(buffer), this.__receiveDataQueue.getChunk(tsn).getStreamIdentifier());
            p.setPayloadType(this.__receiveDataQueue.getChunk(tsn).getPayloadProtocolIdentifier());
            p.setUnordered(this.__receiveDataQueue.getChunk(tsn).getUnordered());
            onMessage.invoke(p);
        }
        for (int i = 0; i < ArrayExtensions.getLength(tsnArray); ++i) {
            this.__receiveDataQueue.getChunk(tsnArray[i]).setRaised(true);
        }
    }

    public void removeOnStateChange(IAction1<SctpTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resendPacket(ScheduledItem item) {
        SctpResendArgs args = (SctpResendArgs)item.getState();
        SctpTcbState state = args.getState();
        DataBuffer packetBytes = args.getPacketBytes();
        Object object = this.__stateLock;
        synchronized (object) {
            if (Global.equals((Object)state, (Object)this.get_InnerState())) {
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("SCTP is retransmitting a control chunk {0} at {1}.", ByteExtensions.toString(args.getType()), LongExtensions.toString(Scheduler.getCurrentTime())));
                }
                this.dispatch(packetBytes);
            } else {
                this.__scheduler.remove(item);
            }
        }
    }

    private boolean respondWithCOOKIE_ACK(SctpCookieEchoChunk incomingCOOKIEECHOChunk, SctpCommonHeader header) {
        int offsetPlus = 0;
        if (this.__tcb.getSecretKeyForCookie() == null) {
            __log.error("SCTP: missing secret key to extract cookie.");
            return false;
        }
        IntegerHolder _var0 = new IntegerHolder(offsetPlus);
        SctpStateCookie _var1 = SctpStateCookie.parseBytes(incomingCOOKIEECHOChunk.getCookieBytes(), _var0, this.__tcb.getSecretKeyForCookie());
        offsetPlus = _var0.getValue();
        SctpStateCookie cookie = _var1;
        if (cookie == null) {
            __log.error("SCTP: Could not extract cookie.");
            return false;
        }
        SctpTransmissionControlBlock tcb = new SctpTransmissionControlBlock(cookie);
        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened)) {
            if (header.getVerificationTag() == tcb.getMyVerificationTag()) {
                if (cookie.getTimestamp() + 12000L >= Scheduler.getCurrentTime()) {
                    if (__log.getIsVerboseEnabled()) {
                        __log.verbose(StringExtensions.format("SCTP: Received a valid COOKIE_ECHO at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    } else {
                        __log.debug("SCTP: Received a valid COOKIE_ECHO.");
                    }
                    this.__tcb.importTcbParameters(tcb);
                    this.set_InnerState(SctpTcbState.Established);
                    if (__log.getIsVerboseEnabled()) {
                        __log.verbose(StringExtensions.format("SCTP: Sending COOKIE_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    } else {
                        __log.debug("SCTP: Sending COOKIE_ACK.");
                    }
                    SctpCookieAckChunk chunk = new SctpCookieAckChunk();
                    this.__sendControlChunkQueue.enqueue(chunk);
                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                    return true;
                }
                SctpStaleCookieError error = new SctpStaleCookieError(new NullableLong(cookie.getTimestamp() + 12000L - Scheduler.getCurrentTime()));
                SctpErrorChunk controlChunk = new SctpErrorChunk(new SctpErrorCause[]{error});
                this.__sendControlChunkQueue.enqueue(controlChunk);
                __log.debug("SCTP: Stale cookie at initiation stage.");
                this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            }
            return false;
        }
        if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed) && !Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established)) {
            return false;
        }
        if (cookie.getTimestamp() + 12000L < Scheduler.getCurrentTime()) {
            return false;
        }
        if (this.__tcb.getMyVerificationTag() != tcb.getMyVerificationTag()) {
            return false;
        }
        if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP: Received a valid COOKIE_ECHO in Cookie Echoed state at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
            } else {
                __log.debug("SCTP: Received a valid COOKIE_ECHO in Cookie Echoed state.");
            }
            this.__tcb.importTcbParameters(tcb);
            this.set_InnerState(SctpTcbState.Established);
        } else {
            if (this.__tcb.getPeerVerificationTag() != tcb.getPeerVerificationTag()) {
                this.__tcb.setPeerVerificationTag(tcb.getPeerVerificationTag());
                __log.debug("SCTP: Updating peer verification tag from incoming Cookie.");
            }
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP: Received a valid duplicate COOKIE_ECHO. Re-sending COOKIE_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
            } else {
                __log.debug("SCTP: Received a valid duplicate COOKIE_ECHO. Re-sending COOKIE_ACK.");
            }
        }
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("SCTP: sending COOKIE_ACK at {0}.", LongExtensions.toString(Scheduler.getCurrentTime())));
        } else {
            __log.debug("SCTP: sending COOKIE_ACK.");
        }
        SctpCookieAckChunk chunk = new SctpCookieAckChunk();
        this.__sendControlChunkQueue.enqueue(chunk);
        this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
        return true;
    }

    private void respondWithCOOKIE_ECHO(SctpInitAckChunk incomingINITACKChunk) {
        byte[] stateCookieBytes = incomingINITACKChunk.getStateCookieChunk().getStateCookieBytes();
        if (stateCookieBytes == null) {
            String str = "SCTP: init ack does not contain properly reflected cookie.";
            __log.error(str);
            Exception exception = new Exception(str);
            this.closeOnFailure(exception);
        } else {
            ScheduledItem item;
            SctpCookieEchoChunk controlChunk = new SctpCookieEchoChunk(stateCookieBytes);
            SctpResendArgs args2 = new SctpResendArgs(SctpTcbState.CookieEchoed);
            args2.setType(SctpChunkType.getCookieEcho());
            SctpResendArgs args = args2;
            ScheduledItem item2 = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.resendPacket";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.resendPacket(item);
                }
            }, 200, 200, 10000, ScheduledItem.getUnset());
            item2.setState(args);
            item2.setTimeoutCallback((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.SctpTransport.initializationFailure";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    SctpTransport.this.initializationFailure(item);
                }
            });
            this.__initiationControlChunkScheduledItem = item = item2;
            controlChunk.setResendScheduledItem(item);
            if (incomingINITACKChunk.getInitiateTag() == 0L) {
                String str = "SCTP: initiate tag is 0. Aborting association establishment.";
                __log.error(str);
                Exception exception = new Exception(str);
                this.closeOnFailure(exception);
            } else {
                this.__tcb.setPeerVerificationTag(incomingINITACKChunk.getInitiateTag());
                this.__tcb.setPeerReceiverWindowCredit(incomingINITACKChunk.getAdvertisedReceiverWindowCredit());
                int numberOfInboundStreams = incomingINITACKChunk.getNumberOfInboundStreams();
                if (numberOfInboundStreams < this.__tcb.getOutboundStreams().getCount()) {
                    this.__tcb.setOutboundStreams(new SctpStreamCollection(numberOfInboundStreams));
                }
                if (this.__tcb.getOutboundStreams().getCount() == 0) {
                    String str = "SCTP: The number of outbound streams must be a positive value.";
                    __log.error(str);
                    Exception exception = new Exception(str);
                    this.closeOnFailure(exception);
                } else {
                    boolean flag = false;
                    if (incomingINITACKChunk.getAuthenticatedChunksParameters() != null && incomingINITACKChunk.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint()) {
                        __log.debug("Remote party supports optional SCTP authenticated chunks feature, which is not yet supported by this party. Authenticated chunks feature will be disabled in this association");
                    }
                    if (incomingINITACKChunk.getPartialReliabilityParameters() != null && incomingINITACKChunk.getPartialReliabilityParameters().getPartialReliabilitySupportedByThisEndpoint()) {
                        if (this.getLocalSupportsPartialReliabilityExtension()) {
                            __log.debug("SCTP partial reliability has been negotiated for data stream.");
                            flag = true;
                        } else {
                            __log.debug("Remote party supports optional SCTP partial reliability feature, support for which is currently disabled for the local party. Partial reliability extension support is currently in beta and maybe enabled via DataStream.SupportsSctpPartialReliabilityExtension. Partial reliability feature will be disabled in this association");
                        }
                    }
                    if (incomingINITACKChunk.getDynamicAddressReconfigurationParameters() != null && incomingINITACKChunk.getDynamicAddressReconfigurationParameters().getDynamicAddressReconfigurationSupportedByThisEndpoint()) {
                        __log.debug("Remote party supports optional SCTP address reconfiguration feature, which is not yet supported by this party. Address reconfiguration feature will be disabled in this association");
                    }
                    if (incomingINITACKChunk.getUnrecognizedParameter() != null) {
                        SctpTlvParameter[] unrecognizedParameters;
                        for (SctpTlvParameter parameter2 : unrecognizedParameters = incomingINITACKChunk.getUnrecognizedParameter().getUnrecognizedParameters()) {
                            if (parameter2.getType() != 49152) continue;
                            SctpPartialReliabilitySupportParameters partialReliabilitySupport = this.__tcb.getPartialReliabilitySupport();
                            if (partialReliabilitySupport != null) {
                                partialReliabilitySupport = new SctpPartialReliabilitySupportParameters(true);
                            }
                            partialReliabilitySupport.setRemoteIndicatedLackOfPRSupport(true);
                            __log.debug("SCTP: Remote party indicates that it does not recognise SCTP Forward-TSN-Supported-Parameter. Partial Reliability extension will be disabled for data stream.");
                            flag = false;
                        }
                    }
                    this.__tcb.setGreatestReceivedTsn(SctpDataChunk.decrementTSN(incomingINITACKChunk.getInitialTsn()));
                    this.__tcb.setGreatestCumulativeTsnReceived(this.__tcb.getGreatestReceivedTsn());
                    this.__receiveDataQueue.setInitialTSN(incomingINITACKChunk.getInitialTsn());
                    this.__tcb.setState(SctpTcbState.CookieEchoed);
                    if (flag) {
                        this.__tcb.getPartialReliabilitySupport().setPartialReliabilityUsedInThisAssociation(true);
                    } else {
                        this.__tcb.getPartialReliabilitySupport().setPartialReliabilityUsedInThisAssociation(false);
                    }
                    if (__log.getIsVerboseEnabled()) {
                        __log.verbose(StringExtensions.format("SCTP: sending COOKIE_ECHO at {0} and moving into the COOKIE_ECHOED state.", LongExtensions.toString(Scheduler.getCurrentTime())));
                    } else {
                        __log.debug("SCTP: sending COOKIE_ECHO and moving into the COOKIE_ECHOED state.");
                    }
                    this.__sendControlChunkQueue.enqueue(controlChunk);
                    Object[] unrecognizedParametersThatNeedToBeReportedBackToSender = incomingINITACKChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender();
                    if (unrecognizedParametersThatNeedToBeReportedBackToSender != null && ArrayExtensions.getLength(unrecognizedParametersThatNeedToBeReportedBackToSender) > 0) {
                        SctpErrorChunk chunk2;
                        SctpUnrecognizedParameters parameters2 = new SctpUnrecognizedParameters((SctpTlvParameter[])unrecognizedParametersThatNeedToBeReportedBackToSender);
                        this.__errorToCombineWithCookieEcho = chunk2 = new SctpErrorChunk(new SctpErrorCause[]{parameters2});
                    }
                    this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
                }
            }
        }
    }

    private void respondWithINIT_ACK(SctpInitChunk incomingINITChunk) {
        int count;
        long myVerificationTag = 0L;
        myVerificationTag = Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.ClosedNeverOpened) ? MathAssistant.max(1L, (long)(4.294967295E9 * LockedRandomizer.nextDouble())) : this.__tcb.getMyVerificationTag();
        long initiateTag = incomingINITChunk.getInitiateTag();
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("Local inititate/verification tag is set to {0}; remote initiate/verification tag is set to {1}.", LongExtensions.toString(myVerificationTag), LongExtensions.toString(initiateTag)));
        }
        long advertisedReceiverWindowCredit = incomingINITChunk.getAdvertisedReceiverWindowCredit();
        int numberOfInboundStreams = incomingINITChunk.getNumberOfInboundStreams();
        if (numberOfInboundStreams < (count = this.__tcb.getOutboundStreams().getCount())) {
            count = numberOfInboundStreams;
        }
        if (count == 0) {
            String str = "SCTP: The number of outbound channels must be a positive value.";
            __log.error(str);
            this.closeOnFailure(new Exception("SCTP: The number of outbound channels must be a positive value."));
        } else {
            SctpStateCookie newCookie;
            long initialTsn = incomingINITChunk.getInitialTsn();
            boolean flag = false;
            if (incomingINITChunk.getAuthenticatedChunksParameters() != null && incomingINITChunk.getAuthenticatedChunksParameters().getAuthenticatedChunksSupportedByThisEndpoint()) {
                __log.debug("Remote party supports optional SCTP authenticated chunks feature, which is not yet supported by this party. Authenticated chunks feature will be disabled in this association");
            }
            if (incomingINITChunk.getPartialReliabilityParameters() != null && incomingINITChunk.getPartialReliabilityParameters().getPartialReliabilitySupportedByThisEndpoint()) {
                if (this.getLocalSupportsPartialReliabilityExtension()) {
                    __log.debug("SCTP partial reliability has been negotiated for data stream.");
                    flag = true;
                } else {
                    __log.debug("Remote party supports optional SCTP partial reliability feature, support for which is currently disabled for the local party. Partial reliability extension support is currently in beta and maybe enabled via DataStream.SupportsSctpPartialReliabilityExtension. Partial reliability feature will be disabled in this association");
                }
            }
            if (incomingINITChunk.getDynamicAddressReconfigurationParameters() != null && incomingINITChunk.getDynamicAddressReconfigurationParameters().getDynamicAddressReconfigurationSupportedByThisEndpoint()) {
                __log.debug("Remote party supports optional SCTP address reconfiguration feature, which is not yet supported by this party. Address reconfiguration feature will be disabled in this association");
            }
            SctpUnrecognizedParameterChunkParameter unrecognizedParameter = null;
            if (incomingINITChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender() != null && ArrayExtensions.getLength(incomingINITChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender()) > 0) {
                unrecognizedParameter = new SctpUnrecognizedParameterChunkParameter(incomingINITChunk.getUnrecognizedParametersThatNeedToBeReportedBackToSender());
            }
            SctpTransmissionControlBlock block = new SctpTransmissionControlBlock(myVerificationTag, initiateTag, advertisedReceiverWindowCredit, SctpDataChunk.decrementTSN(initialTsn), count, this.__tcb.getSecretKeyForCookie());
            block.setDestinationPort(this.__tcb.getDestinationPort());
            block.setSourcePort(this.__tcb.getSourcePort());
            if (flag) {
                SctpPartialReliabilitySupportParameters parameters = new SctpPartialReliabilitySupportParameters(true);
                parameters.setPartialReliabilityUsedInThisAssociation(true);
                block.setPartialReliabilitySupport(parameters);
            }
            if ((newCookie = block.getNewCookie()) == null) {
                String str = "SCTP: could not prepare cookie. Shutting down.";
                __log.error(str);
                this.closeOnFailure(new Exception(str));
            } else {
                SctpStateCookieChunkParameter stateCookie = new SctpStateCookieChunkParameter(newCookie);
                SctpInitAckChunk controlChunk = new SctpInitAckChunk(myVerificationTag, advertisedReceiverWindowCredit, count, this.__tcb.getInboundStreams().getCount(), myVerificationTag, stateCookie, null, unrecognizedParameter);
                controlChunk.setPartialReliabilityParameters(this.__tcb.getPartialReliabilitySupport());
                this.__sendControlChunkQueue.enqueue(controlChunk);
                String str2 = "CLOSED";
                if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieWait)) {
                    str2 = "COOKIE_WAIT";
                } else if (Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.CookieEchoed)) {
                    str2 = "COOKIE_ECHOED";
                }
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("SCTP: Responding with INIT_ACK at {0}. Remaining in {1} state.", LongExtensions.toString(Scheduler.getCurrentTime()), str2));
                } else {
                    __log.debug(StringExtensions.format("SCTP: Responding with INIT_ACK. Remaining in {0} state.", str2));
                }
                this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            }
        }
    }

    public SctpTransport(Object lockObject, Scheduler scheduler, Transport innerTransport, int requestedOutboundStreams, int maxIncomingStreams, long advertisedReceiverWindow, int sourcePort, int destinationPort) {
        int num2;
        int interval;
        this.__stateLock = lockObject;
        this.__sendDataQueue = new SctpSendDataQueue(this.__stateLock);
        this.__receiveDataQueue = new SctpReceiveDataQueue(this.__stateLock);
        this.__scheduler = scheduler;
        this.setId(Guid.newGuid().toString().replace("-", ""));
        if (innerTransport == null) {
            __log.error("Null inner transport argument.");
        }
        if ((interval = 500) > (num2 = this.getT3TimerExtension())) {
            interval = num2;
        }
        this.__outgoingQueueScheduledItem = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.SctpTransport.processOutgoingQueueLoop";
            }

            @Override
            public void invoke(ScheduledItem item) {
                SctpTransport.this.processOutgoingQueueLoop(item);
            }
        }, 0, interval, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        this.__innerTransport = innerTransport;
        if (maxIncomingStreams < 1) {
            throw new RuntimeException(new Exception("SCTP: Maximum supported number of inbound channels must be at least 1"));
        }
        if (requestedOutboundStreams < 1) {
            throw new RuntimeException(new Exception("SCTP: Desirable number of outbound channels must be at least 1"));
        }
        SctpTransmissionControlBlock block = new SctpTransmissionControlBlock(requestedOutboundStreams, maxIncomingStreams, advertisedReceiverWindow);
        block.setMaximumStaticCongestionWindow(500L);
        this.__tcb = block;
        this.__tcb.setSourcePort(sourcePort);
        this.__tcb.setDestinationPort(destinationPort);
        this.__sendControlChunkQueue = new SctpSendControlChunkQueue();
        this.__tcb.setPartialReliabilitySupport(new SctpPartialReliabilitySupportParameters(false));
    }

    public SctpTransport(Object lockObject, Scheduler scheduler, Transport innerTransport, int requestedOutboundStreams, int maxIncomingStreams, long advertisedReceiverWindow) {
        this(lockObject, scheduler, innerTransport, requestedOutboundStreams, maxIncomingStreams, advertisedReceiverWindow, 5000, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error sendData(SctpMessage message) {
        if (message == null || message.getPayload() == null || message.getPayload().getLength() == 0) {
            return new Error(ErrorCode.SctpNoPayloadData, new Exception("SCTP payload cannot be null or empty."));
        }
        byte[] buffer = message.getPayload().toArray();
        boolean unordered = message.getUnordered();
        int streamId = message.getStreamId();
        long payloadType = message.getPayloadType();
        Object object = this.__stateLock;
        synchronized (object) {
            SctpStream stream;
            if (streamId > this.__tcb.getOutboundStreams().getCount() - 1) {
                return new Error(ErrorCode.SctpUnsupportedStream, new Exception(StringExtensions.format("SCTP: Communication on an unsupported SCTP stream {0}.", IntegerExtensions.toString(streamId))));
            }
            if (!Global.equals((Object)this.get_InnerState(), (Object)SctpTcbState.Established)) {
                return new Error(ErrorCode.SctpInvalidState, new Exception(StringExtensions.format("SCTP: Communication is only allowed in the Established state. Sctp transport is in {0} state.", this.getState().toString())));
            }
            ByteCollection bytes = new ByteCollection(buffer);
            boolean beginning = true;
            boolean ending = false;
            int index = 0;
            int count = MathAssistant.min(bytes.getCount(), 950);
            while (!ending) {
                if (count == bytes.getCount() - index) {
                    ending = true;
                }
                if (__log.getIsVerboseEnabled()) {
                    __log.debug(StringExtensions.format("Adding a new DATA chunk with TSN {0} to the outgoing queue at {1}.", LongExtensions.toString(this.__tcb.getNextTsnToSend()), LongExtensions.toString(Scheduler.getCurrentTime())));
                }
                stream = this.__tcb.getOutboundStreams().getStream(streamId);
                SctpDataChunk dataChunk = new SctpDataChunk(unordered, beginning, ending, this.__tcb.getNextTsnToSend(), streamId, stream.getNextSsn(), payloadType, bytes.getRange(index, count), ending);
                dataChunk.setMessage(message);
                dataChunk.setAcked(false);
                beginning = false;
                this.__sendDataQueue.add(dataChunk);
                count = MathAssistant.min(bytes.getCount() - (index += count), 950);
                this.__tcb.setNextTsnToSend(SctpDataChunk.incrementTSN(this.__tcb.getNextTsnToSend()));
            }
            if (!unordered) {
                stream = this.__tcb.getOutboundStreams().getStream(streamId);
                stream.setNextSsn(SctpDataChunk.incrementSSN(stream.getNextSsn()));
            }
            this.__scheduler.trigger(this.__outgoingQueueScheduledItem);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_InnerState(SctpTcbState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (this.__tcb != null && !Global.equals((Object)value, (Object)this.__tcb.getState())) {
                this.__tcb.setState(value);
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("SCTP: Moving into the {0} state at {1}.", value.toString(), LongExtensions.toString(Scheduler.getCurrentTime())));
                } else {
                    __log.debug(StringExtensions.format("SCTP: Moving into the {0} state.", value.toString()));
                }
                IAction1<SctpTransport> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    private void setError(Error value) {
        this._error = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    public void setLocalSupportsPartialReliabilityExtension(boolean value) {
        SctpTransmissionControlBlock block = this.__tcb;
        if (block == null) {
            throw new RuntimeException(new Exception("SCTP: TCB is not set, cannot set support for partial reliability extension."));
        }
        SctpPartialReliabilitySupportParameters partialReliabilitySupport = block.getPartialReliabilitySupport();
        if (partialReliabilitySupport == null) {
            partialReliabilitySupport = new SctpPartialReliabilitySupportParameters(value);
        } else {
            partialReliabilitySupport.setPartialReliabilitySupportedByThisEndpoint(value);
        }
    }

    public void setOnMessage(IAction1<SctpMessage> value) {
        this._onMessage = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!this.get_Active()) {
                this.__scheduler.add(this.__outgoingQueueScheduledItem);
                this.__innerTransport.removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.SctpTransport.processIncomingSctpPacket";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        SctpTransport.this.processIncomingSctpPacket(buffer);
                    }
                });
                this.__innerTransport.addOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.SctpTransport.processIncomingSctpPacket";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        SctpTransport.this.processIncomingSctpPacket(buffer);
                    }
                });
                this.initiate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)SctpTransportState.Closed) && !Global.equals((Object)this.getState(), (Object)SctpTransportState.Closing)) {
                __log.debug("SCTP: Association shutdown");
                this.__innerTransport.removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.SctpTransport.processIncomingSctpPacket";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        SctpTransport.this.processIncomingSctpPacket(buffer);
                    }
                });
                this.set_InnerState(SctpTcbState.Closing);
                this.stopAllDataChunkTransmission();
                this.stopAllControlChunkTransmission();
                this.set_InnerState(SctpTcbState.Closed);
                this.__innerTransport = null;
            }
        }
    }

    private void stopAllControlChunkTransmission() {
        this.__sendControlChunkQueue.removeAll();
        if (this.__scheduler != null) {
            this.__scheduler.remove(this.__initiationControlChunkScheduledItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllDataChunkTransmission() {
        Object object = this.__stateLock;
        synchronized (object) {
            long[] tsns;
            for (long num : tsns = this.__sendDataQueue.getTsns()) {
                SctpMessage message;
                SctpDataChunk chunk = this.__sendDataQueue.getChunk(num);
                if (!chunk.getEnding() || (message = chunk.getMessage()) == null) continue;
                message.raiseFailure(new Exception("SCTP: message delivery not acknowledged before shutdown."));
            }
            this.__sendDataQueue.removeAll();
            if (this.__scheduler != null) {
                this.__scheduler.remove(this.__outgoingQueueScheduledItem);
            }
        }
        this.__tcb.resetAssociationState();
    }

    private long translateIndextoTSN(int index, boolean rollover, long start) {
        if (!rollover) {
            return start + (long)index;
        }
        if (start + (long)index <= 0xFFFFFFFFL) {
            return start + (long)index;
        }
        return (long)index + start - 0xFFFFFFFFL - 1L;
    }
}

