/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpTlvParameter;

class SctpSupportedAddressTypesChunkParameter
extends SctpTlvParameter {
    private int[] _addressTypes;

    public int[] getAddressTypes() {
        return this._addressTypes;
    }

    @Override
    public byte[] getBytes() {
        return SctpSupportedAddressTypesChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpSupportedAddressTypesChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(12, false));
        bytes.addRange(Binary.toBytes16(4 + 2 * ArrayExtensions.getLength(parameter.getAddressTypes()), false));
        for (int i = 0; i < ArrayExtensions.getLength(parameter.getAddressTypes()); ++i) {
            bytes.addRange(Binary.toBytes16(parameter.getAddressTypes()[i], false));
        }
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    public static SctpSupportedAddressTypesChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num = (Binary.fromBytes16(bytes, 2, false) - 4) / 2;
            int[] addressTypes = new int[num];
            for (int i = 0; i < num; ++i) {
                addressTypes[i] = Binary.fromBytes16(bytes, 4 + i * 2, false);
            }
            int len = Binary.fromBytes16(bytes, 2, false);
            offsetPlus.setValue(len + SctpChunk.calculatePaddingBytes(len));
            return new SctpSupportedAddressTypesChunkParameter(addressTypes);
        }
        catch (Exception exception1) {
            Log.debug("Could not read SupportedAddressTypesChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpSupportedAddressTypesChunkParameter(int[] addressTypes) {
        super.setType(12);
        this.setAddressTypes(addressTypes);
    }

    public void setAddressTypes(int[] value) {
        this._addressTypes = value;
    }
}

