/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.LongExtensions;
import fm.icelink.MathAssistant;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;
import fm.icelink.SctpGapAckBlock;
import fm.icelink.StringExtensions;

class SctpSackChunk
extends SctpControlChunk {
    private long _advertisedReceiverWindowCredit;
    private long _cumulativeTsnAck;
    private long[] _duplicateTsns;
    private SctpGapAckBlock[] _gapAckBlocks;
    public static int _unset = -1;

    public boolean equals(SctpSackChunk chunk) {
        if (this.getCumulativeTsnAck() != chunk.getCumulativeTsnAck()) {
            return false;
        }
        if (ArrayExtensions.getLength(this.getGapAckBlocks()) != ArrayExtensions.getLength(chunk.getGapAckBlocks())) {
            return false;
        }
        for (int i = 0; i < ArrayExtensions.getLength(this.getGapAckBlocks()); ++i) {
            long num5;
            long num3;
            long absoluteGapAckBlockStart = this.getGapAckBlocks()[i].getAbsoluteGapAckBlockStart();
            if (absoluteGapAckBlockStart != (num3 = chunk.getGapAckBlocks()[i].getAbsoluteGapAckBlockStart())) {
                return false;
            }
            long absoluteGapAckBlockEnd = this.getGapAckBlocks()[i].getAbsoluteGapAckBlockEnd();
            if (absoluteGapAckBlockEnd == (num5 = chunk.getGapAckBlocks()[i].getAbsoluteGapAckBlockEnd())) continue;
            return false;
        }
        return true;
    }

    public long getAdvertisedReceiverWindowCredit() {
        return this._advertisedReceiverWindowCredit;
    }

    public byte[] getBytes(int sizeLimit) {
        return SctpSackChunk.getBytes(this, sizeLimit);
    }

    @Override
    public byte[] getBytes() {
        return SctpSackChunk.getBytes(this, _unset);
    }

    public static byte[] getBytes(SctpSackChunk chunk, int sizeLimit) {
        int num4;
        int num = 16;
        if (sizeLimit != _unset && num > sizeLimit) {
            throw new RuntimeException(new Exception("SCTP chunk limit is set too low and prevents SCTP SACK chunk dispatching."));
        }
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        int num2 = sizeLimit != _unset ? MathAssistant.min(chunk.getNumberOfGapAckBlocks(), (int)MathAssistant.floor((sizeLimit - num) / 4)) : chunk.getNumberOfGapAckBlocks();
        int num3 = sizeLimit != _unset ? MathAssistant.min(chunk.getNumberOfDuplicateTsns(), (int)MathAssistant.floor((sizeLimit - (num += num2 * 4)) / 4)) : chunk.getNumberOfDuplicateTsns();
        bytes.addRange(Binary.toBytes16(num += num3 * 4, false));
        bytes.addRange(Binary.toBytes32(chunk.getCumulativeTsnAck(), false));
        bytes.addRange(Binary.toBytes32(chunk.getAdvertisedReceiverWindowCredit(), false));
        bytes.addRange(Binary.toBytes16(num2, false));
        bytes.addRange(Binary.toBytes16(num3, false));
        for (num4 = 0; num4 < num2; ++num4) {
            bytes.addRange(chunk.getGapAckBlocks()[num4].getBytes(chunk.getCumulativeTsnAck()));
        }
        for (num4 = 0; num4 < num3; ++num4) {
            bytes.addRange(Binary.toBytes32(chunk.getDuplicateTsns()[num4], false));
        }
        return bytes.toArray();
    }

    public long getCumulativeTsnAck() {
        return this._cumulativeTsnAck;
    }

    public long[] getDuplicateTsns() {
        return this._duplicateTsns;
    }

    public SctpGapAckBlock[] getGapAckBlocks() {
        return this._gapAckBlocks;
    }

    public int getNumberOfDuplicateTsns() {
        if (this.getDuplicateTsns() == null) {
            return 0;
        }
        return ArrayExtensions.getLength(this.getDuplicateTsns());
    }

    public int getNumberOfGapAckBlocks() {
        if (this.getGapAckBlocks() == null) {
            return 0;
        }
        return ArrayExtensions.getLength(this.getGapAckBlocks());
    }

    public static SctpSackChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int num6;
            long cumulativeTsnAck = Binary.fromBytes32(bytes, 4, false);
            long advertisedReceiverWindowCredit = Binary.fromBytes32(bytes, 8, false);
            int num3 = Binary.fromBytes16(bytes, 12, false);
            int num4 = Binary.fromBytes16(bytes, 14, false);
            SctpSackChunk chunk = new SctpSackChunk(cumulativeTsnAck, advertisedReceiverWindowCredit, null, null);
            int startIndex = 16;
            if (num3 > 0) {
                SctpGapAckBlock[] blockArray = new SctpGapAckBlock[num3];
                for (num6 = 0; num6 < num3; ++num6) {
                    SctpGapAckBlock _var0;
                    blockArray[num6] = _var0 = SctpGapAckBlock.parseBytes(bytes, startIndex, cumulativeTsnAck, offsetPlus);
                    startIndex += offsetPlus.getValue();
                }
                chunk.setGapAckBlocks(blockArray);
            }
            if (num4 > 0) {
                long[] numArray = new long[num4];
                for (num6 = 0; num6 < num4; ++num6) {
                    numArray[num6] = Binary.fromBytes32(bytes, startIndex, false);
                    startIndex += 4;
                }
                chunk.setDuplicateTsns(numArray);
            }
            offsetPlus.setValue(startIndex);
            return chunk;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpSackChunk(long cumulativeTsnAck, long advertisedReceiverWindowCredit, SctpGapAckBlock[] gapAckBlocks, long[] duplicateTsns) {
        super.setType(SctpChunkType.getSack());
        this.setCumulativeTsnAck(cumulativeTsnAck);
        this.setAdvertisedReceiverWindowCredit(advertisedReceiverWindowCredit);
        this.setGapAckBlocks(gapAckBlocks != null ? gapAckBlocks : new SctpGapAckBlock[]{});
        this.setDuplicateTsns(duplicateTsns);
        super.setCanBundleWithDataAndSackChunks(true);
        super.setUnrecognized(false);
    }

    public void setAdvertisedReceiverWindowCredit(long value) {
        this._advertisedReceiverWindowCredit = value;
    }

    public void setCumulativeTsnAck(long value) {
        this._cumulativeTsnAck = value;
    }

    public void setDuplicateTsns(long[] value) {
        this._duplicateTsns = value;
    }

    public void setGapAckBlocks(SctpGapAckBlock[] value) {
        this._gapAckBlocks = value;
    }

    public String toString() {
        int num;
        String str = StringExtensions.format("SCTP SACK. Cumulative: {0}. Number of blocks: {1}.", LongExtensions.toString(this.getCumulativeTsnAck()), IntegerExtensions.toString(this.getNumberOfGapAckBlocks()));
        if (this.getNumberOfGapAckBlocks() > 0) {
            SctpGapAckBlock block = null;
            for (num = 0; num < ArrayExtensions.getLength(this.getGapAckBlocks()); ++num) {
                str = StringExtensions.concat(str, " ");
                block = this.getGapAckBlocks()[num];
                str = StringExtensions.concat(str, StringExtensions.format("Block {0}: start {1}, end {2}.", IntegerExtensions.toString(num), LongExtensions.toString(block.getAbsoluteGapAckBlockStart()), LongExtensions.toString(block.getAbsoluteGapAckBlockEnd())));
            }
            str = StringExtensions.concat(str, ".");
        }
        str = StringExtensions.concat(str, StringExtensions.format(" Advertised receiver window credit: {0}. Number of duplicate TSNs: {1}.", LongExtensions.toString(this.getAdvertisedReceiverWindowCredit()), IntegerExtensions.toString(this.getNumberOfDuplicateTsns())));
        if (this.getNumberOfDuplicateTsns() <= 0) {
            return str;
        }
        str = StringExtensions.concat(str, "Duplicates: ");
        for (num = 0; num < ArrayExtensions.getLength(this.getDuplicateTsns()); ++num) {
            str = StringExtensions.concat(str, LongExtensions.toString(this.getDuplicateTsns()[num]), ", ");
        }
        return StringExtensions.substring(str, 0, StringExtensions.getLength(str) - 1);
    }
}

