/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.BooleanExtensions;
import fm.icelink.ILog;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.SctpDataChunk;
import fm.icelink.SctpDataQueue;
import fm.icelink.SctpForwardTsnChunk;
import fm.icelink.SctpGapAckBlock;
import fm.icelink.SctpSackChunk;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class SctpReceiveDataQueue
extends SctpDataQueue {
    private long __cumulativeACKPoint = -1L;
    private ArrayList<SctpGapAckBlock> __gapAckBlocks;
    private long __initialTSN = -1L;
    private static ILog __log = Log.getLogger("FM.IceLink.Sctp.ReceiveDataQueue");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SctpDataChunk dataChunk) {
        Object object = this.__lock;
        synchronized (object) {
            long tsn = dataChunk.getTsn();
            boolean flag = this.tryUpdateCumulativeACKPoint(tsn);
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP ReceiveDataQueue Add: Inserting into queue: newTSN: {0}. Cumulative: {1}.", LongExtensions.toString(tsn), LongExtensions.toString(this.__cumulativeACKPoint)));
                __log.verbose(StringExtensions.format("SCTP ReceiveDataQueue Add: Moved cumulative: {0}", BooleanExtensions.toString(flag)));
            }
            if (flag && ArrayListExtensions.getCount(this.__gapAckBlocks) > 0) {
                boolean flag2 = false;
                if (ArrayListExtensions.getItem(this.__gapAckBlocks).get(0).getAbsoluteGapAckBlockStart() == this.__cumulativeACKPoint + 1L) {
                    if (__log.getIsVerboseEnabled()) {
                        __log.debug("SCTP ReceiveDataQueue Add: Merged the first block in.");
                    }
                    this.__cumulativeACKPoint = ArrayListExtensions.getItem(this.__gapAckBlocks).get(0).getAbsoluteGapAckBlockEnd();
                    flag2 = true;
                }
                if (flag2) {
                    ArrayListExtensions.removeAt(this.__gapAckBlocks, 0);
                }
            } else if (!flag) {
                boolean flag3 = false;
                int index = 0;
                long tsnB = -1L;
                long absoluteGapAckBlockEnd = -1L;
                long tsnA = -1L;
                ArrayList<Object> list = new ArrayList<SctpGapAckBlock>();
                if (ArrayListExtensions.getCount(this.__gapAckBlocks) == 0) {
                    list.add(new SctpGapAckBlock(tsn, tsn));
                    if (__log.getIsVerboseEnabled()) {
                        __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Inserted a new block. Case 1", new Object[0]));
                    }
                    flag3 = true;
                }
                while (!flag3) {
                    tsnB = ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockStart();
                    absoluteGapAckBlockEnd = ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockEnd();
                    tsnA = index + 1 < ArrayListExtensions.getCount(this.__gapAckBlocks) ? ArrayListExtensions.getItem(this.__gapAckBlocks).get(index + 1).getAbsoluteGapAckBlockStart() : -1L;
                    if (__log.getIsVerboseEnabled()) {
                        __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: start {0} end {1} nextStart {2}", LongExtensions.toString(tsnB), LongExtensions.toString(absoluteGapAckBlockEnd), LongExtensions.toString(tsnA)));
                    }
                    if (SctpDataChunk.compareTsns(SctpDataChunk.incrementTSN(tsn), tsnB) == 2) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Inserted a new block. Case 2", new Object[0]));
                        }
                        list = this.__gapAckBlocks;
                        ArrayListExtensions.insert(list, index, new SctpGapAckBlock(tsn, tsn));
                        flag3 = true;
                    } else if (SctpDataChunk.compareTsns(SctpDataChunk.incrementTSN(tsn), tsnB) == 0) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Expanded the beginning of this block. Case 3", new Object[0]));
                        }
                        long num6 = SctpDataChunk.decrementTSN(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockStart());
                        if (index > 0) {
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, 0, index));
                            if (SctpDataChunk.compareTsns(SctpDataChunk.incrementTSN(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index - 1).getAbsoluteGapAckBlockEnd() + 1L), num6) != 2) {
                                if (__log.getIsVerboseEnabled()) {
                                    __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Merged with the previous. Subcase 3", new Object[0]));
                                }
                                list.add(new SctpGapAckBlock(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index - 1).getAbsoluteGapAckBlockStart(), ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockEnd()));
                            } else {
                                list.add(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index - 1));
                                list.add(new SctpGapAckBlock(num6, ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockEnd()));
                            }
                        } else {
                            list.add(new SctpGapAckBlock(num6, ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockEnd()));
                        }
                        ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, index + 1, ArrayListExtensions.getCount(this.__gapAckBlocks) - index - 1));
                        flag3 = true;
                    } else if (SctpDataChunk.compareTsns(tsn, tsnB) < 2 && SctpDataChunk.compareTsns(tsn, absoluteGapAckBlockEnd) != 1) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Already have this chunk. Case 4", new Object[0]));
                        }
                        flag3 = true;
                    } else if (SctpDataChunk.compareTsns(SctpDataChunk.incrementTSN(absoluteGapAckBlockEnd), tsn) == 0) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Expanded the end of this block. Case 5", new Object[0]));
                        }
                        long end = tsn;
                        ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, 0, index));
                        if (tsnA != -1L) {
                            if (SctpDataChunk.compareTsns(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index + 1).getAbsoluteGapAckBlockStart(), SctpDataChunk.incrementTSN(tsn)) != 1) {
                                if (__log.getIsVerboseEnabled()) {
                                    __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Merged with the next. Subcase 5", new Object[0]));
                                }
                                list.add(new SctpGapAckBlock(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockStart(), ArrayListExtensions.getItem(this.__gapAckBlocks).get(index + 1).getAbsoluteGapAckBlockEnd()));
                                ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, index + 2, ArrayListExtensions.getCount(this.__gapAckBlocks) - index - 2));
                            } else {
                                list.add(new SctpGapAckBlock(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockStart(), end));
                                ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, index + 1, ArrayListExtensions.getCount(this.__gapAckBlocks) - index - 1));
                            }
                        } else {
                            list.add(new SctpGapAckBlock(ArrayListExtensions.getItem(this.__gapAckBlocks).get(index).getAbsoluteGapAckBlockStart(), end));
                        }
                        flag3 = true;
                    } else if (tsnA == -1L) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Inserted new block. Case 6.", new Object[0]));
                        }
                        ArrayListExtensions.addRange(list, this.__gapAckBlocks);
                        list.add(new SctpGapAckBlock(tsn, tsn));
                        flag3 = true;
                    } else if (SctpDataChunk.compareTsns(tsnA, SctpDataChunk.incrementTSN(tsn)) == 1) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Inserted new block. Case 7", new Object[0]));
                        }
                        ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, 0, index + 1));
                        list.add(new SctpGapAckBlock(tsn, tsn));
                        ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, index + 1, ArrayListExtensions.getCount(this.__gapAckBlocks) - index - 1));
                        flag3 = true;
                    } else if (SctpDataChunk.compareTsns(tsnA, SctpDataChunk.incrementTSN(tsn)) == 0) {
                        if (__log.getIsVerboseEnabled()) {
                            __log.debug(StringExtensions.format("SCTP ReceiveDataQueue Add: Expanded beginning of the next block. Case 8", new Object[0]));
                        }
                        list = this.__gapAckBlocks;
                        ((SctpGapAckBlock)ArrayListExtensions.getItem(list).get(index + 1)).setAbsoluteGapAckBlockStart(SctpDataChunk.decrementTSN(((SctpGapAckBlock)ArrayListExtensions.getItem(list).get(index + 1)).getAbsoluteGapAckBlockStart()));
                        flag3 = true;
                    }
                    ++index;
                }
                this.__gapAckBlocks = list;
            }
            super.add(dataChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCumulativeACK() {
        Object object = this.__lock;
        synchronized (object) {
            return this.__cumulativeACKPoint;
        }
    }

    long getInitialTSN() {
        return this.__initialTSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpSackChunk getSackChunk() {
        SctpSackChunk chunk = null;
        Object object = this.__lock;
        synchronized (object) {
            if (this.getCumulativeACK() != -1L) {
                SctpGapAckBlock[] gapAckBlocks = this.__gapAckBlocks.toArray(new SctpGapAckBlock[0]);
                chunk = new SctpSackChunk(this.getCumulativeACK(), 0xFFFFFFFFL, gapAckBlocks, null);
            }
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processForwardTsnChunk(SctpForwardTsnChunk fwd) {
        long newCumulativeTsnAck = fwd.getNewCumulativeTsnAck();
        Object object = this.__lock;
        synchronized (object) {
            if (SctpDataChunk.compareTsns(this.__cumulativeACKPoint, newCumulativeTsnAck) == 2) {
                this.purge(newCumulativeTsnAck);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            super.purge(tsn);
            if (SctpDataChunk.compareTsns(tsn, this.__cumulativeACKPoint) == 1) {
                this.__cumulativeACKPoint = tsn;
                boolean flag = false;
                ArrayList list = new ArrayList();
                for (int i = 0; i < ArrayListExtensions.getCount(this.__gapAckBlocks) && !flag; ++i) {
                    SctpGapAckBlock block = ArrayListExtensions.getItem(this.__gapAckBlocks).get(i);
                    if (SctpDataChunk.compareTsns(block.getAbsoluteGapAckBlockEnd(), this.__cumulativeACKPoint) != 2 && SctpDataChunk.compareTsns(block.getAbsoluteGapAckBlockStart(), SctpDataChunk.incrementTSN(this.__cumulativeACKPoint)) != 1) {
                        this.__cumulativeACKPoint = block.getAbsoluteGapAckBlockEnd();
                        continue;
                    }
                    if (SctpDataChunk.compareTsns(block.getAbsoluteGapAckBlockEnd(), this.__cumulativeACKPoint) != 1) continue;
                    ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, i, ArrayListExtensions.getCount(this.__gapAckBlocks) - i));
                    flag = true;
                }
                this.__gapAckBlocks = list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            boolean flag = super.remove(tsn);
            if (flag) {
                boolean flag2 = false;
                int count = 0;
                SctpGapAckBlock item = null;
                ArrayList<SctpGapAckBlock> list = null;
                while (!flag2) {
                    if (count >= ArrayListExtensions.getCount(this.__gapAckBlocks)) {
                        flag2 = true;
                    } else {
                        item = ArrayListExtensions.getItem(this.__gapAckBlocks).get(count);
                        if (item.getAbsoluteGapAckBlockStart() == tsn) {
                            list = new ArrayList<SctpGapAckBlock>();
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, 0, count));
                            if (item.getAbsoluteGapAckBlockStart() != item.getAbsoluteGapAckBlockEnd()) {
                                item.setAbsoluteGapAckBlockStart(SctpDataChunk.incrementTSN(item.getAbsoluteGapAckBlockStart()));
                                list.add(item);
                            }
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, count + 1, ArrayListExtensions.getCount(this.__gapAckBlocks) - count - 1));
                            flag2 = true;
                        } else if (item.getAbsoluteGapAckBlockEnd() == tsn) {
                            list = new ArrayList();
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, 0, count));
                            item.setAbsoluteGapAckBlockEnd(SctpDataChunk.decrementTSN(item.getAbsoluteGapAckBlockEnd()));
                            list.add(item);
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, count + 1, ArrayListExtensions.getCount(this.__gapAckBlocks) - count - 1));
                            flag2 = true;
                        } else if (SctpDataChunk.compareTsns(item.getAbsoluteGapAckBlockStart(), tsn) == 2 && SctpDataChunk.compareTsns(item.getAbsoluteGapAckBlockEnd(), tsn) == 1) {
                            list = new ArrayList();
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, 0, count));
                            long absoluteGapAckBlockEnd = item.getAbsoluteGapAckBlockEnd();
                            item.setAbsoluteGapAckBlockEnd(SctpDataChunk.decrementTSN(tsn));
                            list.add(item);
                            list.add(new SctpGapAckBlock(SctpDataChunk.incrementTSN(tsn), absoluteGapAckBlockEnd));
                            ArrayListExtensions.addRange(list, ArrayListExtensions.getRange(this.__gapAckBlocks, count + 1, ArrayListExtensions.getCount(this.__gapAckBlocks) - count - 1));
                            flag2 = true;
                        }
                    }
                    ++count;
                }
                if (list != null) {
                    this.__gapAckBlocks = list;
                }
            }
            return flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.__lock;
        synchronized (object) {
            super.removeAll();
        }
    }

    public SctpReceiveDataQueue(Object lockObject) {
        this.__lock = lockObject;
        this.__gapAckBlocks = new ArrayList();
    }

    void setInitialTSN(long value) {
        this.__initialTSN = value;
        this.__cumulativeACKPoint = SctpDataChunk.decrementTSN(value);
    }

    private boolean tryUpdateCumulativeACKPoint(long tsn) {
        if (this.__cumulativeACKPoint == -1L) {
            throw new RuntimeException(new Exception("Initial TSN was not set for SCTP Receive DATA Queue."));
        }
        if (SctpDataChunk.compareTsns(SctpDataChunk.incrementTSN(this.__cumulativeACKPoint), tsn) == 0) {
            this.__cumulativeACKPoint = tsn;
            return true;
        }
        return false;
    }
}

