/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.SctpChunk;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpMessage;

class SctpDataChunk
extends SctpChunk {
    private boolean _abandoned;
    private boolean _acked;
    private boolean _beginning;
    private boolean _ending;
    private SctpMessage _message;
    private long _payloadProtocolIdentifier;
    private boolean _raised;
    private boolean _sackImmediately;
    private int _streamIdentifier;
    private int _streamSequenceNumber;
    private long _transmissionTime;
    private long _tsn;
    private boolean _unordered;
    private byte[] _userData;

    public static long addTSN(long tsnA, long tsnB) {
        long num = tsnA + tsnB;
        if (tsnA + tsnB > 0xFFFFFFFFL) {
            num = num - 0xFFFFFFFFL - 1L;
        }
        return num;
    }

    public static int compareSsns(long ssnA, long ssnB) {
        if (ssnA == ssnB) {
            return 0;
        }
        if (ssnA >= 0L) {
            if (ssnB < 0L) {
                return 1;
            }
            if ((double)ssnA > 52428.0 && (double)ssnB < 13107.0) {
                return 2;
            }
            if ((double)ssnB > 52428.0 && (double)ssnA < 13107.0) {
                return 1;
            }
            if (ssnA > ssnB) {
                return 1;
            }
        }
        return 2;
    }

    public static int compareTsns(long tsnA, long tsnB) {
        if (tsnA == tsnB) {
            return 0;
        }
        if (tsnA >= 0L) {
            if (tsnB < 0L) {
                return 1;
            }
            if ((double)tsnA > 3.435973836E9 && (double)tsnB < 8.58993459E8) {
                return 2;
            }
            if ((double)tsnB > 3.435973836E9 && (double)tsnA < 8.58993459E8) {
                return 1;
            }
            if (tsnA > tsnB) {
                return 1;
            }
        }
        return 2;
    }

    public static long decrementTSN(long tsn) {
        if (tsn <= 1L) {
            return 0xFFFFFFFFL;
        }
        return --tsn;
    }

    public boolean equals(Object other) {
        try {
            return this.getTsn() == ((SctpDataChunk)other).getTsn();
        }
        catch (Exception exception1) {
            return false;
        }
    }

    public boolean getAbandoned() {
        return this._abandoned;
    }

    public boolean getAcked() {
        return this._acked;
    }

    public boolean getBeginning() {
        return this._beginning;
    }

    public static byte[] getBytes(SctpDataChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        byte b = (byte)((chunk.getSackImmediately() ? 8 : 0) | (chunk.getEnding() ? 1 : 0) | (chunk.getBeginning() ? 2 : 0) | (chunk.getUnordered() ? 4 : 0));
        bytes.add(b);
        bytes.addRange(Binary.toBytes32(chunk.getTsn(), false));
        bytes.addRange(Binary.toBytes16(chunk.getStreamIdentifier(), false));
        bytes.addRange(Binary.toBytes16(chunk.getStreamSequenceNumber(), false));
        bytes.addRange(Binary.toBytes32(chunk.getPayloadProtocolIdentifier(), false));
        bytes.addRange(chunk.getUserData());
        bytes.insertRange(2, Binary.toBytes16(bytes.getCount() + 2, false));
        SctpChunk.addPadding(bytes);
        return bytes.toArray();
    }

    @Override
    public byte[] getBytes() {
        return SctpDataChunk.getBytes(this);
    }

    public boolean getEnding() {
        return this._ending;
    }

    SctpMessage getMessage() {
        return this._message;
    }

    public long getPayloadProtocolIdentifier() {
        return this._payloadProtocolIdentifier;
    }

    public boolean getRaised() {
        return this._raised;
    }

    public boolean getSackImmediately() {
        return this._sackImmediately;
    }

    public int getStreamIdentifier() {
        return this._streamIdentifier;
    }

    public int getStreamSequenceNumber() {
        return this._streamSequenceNumber;
    }

    public long getTransmissionTime() {
        return this._transmissionTime;
    }

    public long getTsn() {
        return this._tsn;
    }

    public boolean getUnordered() {
        return this._unordered;
    }

    public byte[] getUserData() {
        return this._userData;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static int incrementSSN(int ssn) {
        if (ssn > 65534) {
            return 0;
        }
        return ++ssn;
    }

    public static long incrementTSN(long tsn) {
        if (tsn > 0xFFFFFFFEL) {
            return 0L;
        }
        return ++tsn;
    }

    public static long maxTsns(long tsnA, long tsnB) {
        if (SctpDataChunk.compareTsns(tsnA, tsnB) == 1) {
            return tsnA;
        }
        return tsnB;
    }

    public static long minTsns(long tsnA, long tsnB) {
        if (SctpDataChunk.compareTsns(tsnA, tsnB) == 1) {
            return tsnB;
        }
        return tsnA;
    }

    public static SctpDataChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            boolean ending = (bytes[1] & 1) == 1;
            boolean beginning = (bytes[1] & 2) == 2;
            boolean unordered = (bytes[1] & 4) == 4;
            boolean sackImmediately = (bytes[1] & 8) == 8;
            int len = Binary.fromBytes16(bytes, 2, false);
            long tsn = Binary.fromBytes32(bytes, 4, false);
            int streamId = Binary.fromBytes16(bytes, 8, false);
            int ssn = Binary.fromBytes16(bytes, 10, false);
            long ppi = Binary.fromBytes32(bytes, 12, false);
            byte[] destination = new byte[len - 16];
            BitAssistant.copy(bytes, 16, destination, 0, len - 16);
            offsetPlus.setValue(len + SctpChunk.calculatePaddingBytes(len));
            return new SctpDataChunk(unordered, beginning, ending, tsn, streamId, ssn, ppi, destination, sackImmediately);
        }
        catch (Exception exception1) {
            Log.warn("Could not parse SCTP Data chunk");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpDataChunk(boolean unordered, boolean beginning, boolean ending, long tsn, int streamId, int ssn, long ppi, byte[] userData, boolean sackImmediately) {
        super.setType(SctpChunkType.getData());
        this.setEnding(ending);
        this.setUnordered(unordered);
        this.setBeginning(beginning);
        this.setTsn(tsn);
        this.setStreamIdentifier(streamId);
        this.setStreamSequenceNumber(ssn);
        this.setPayloadProtocolIdentifier(ppi);
        this.setUserData(userData);
        this.setSackImmediately(sackImmediately);
        this.setRaised(false);
        this.setTransmissionTime(-1L);
        super.setUnrecognized(false);
    }

    public void setAbandoned(boolean value) {
        this._abandoned = value;
    }

    public void setAcked(boolean value) {
        this._acked = value;
    }

    public void setBeginning(boolean value) {
        this._beginning = value;
    }

    public void setEnding(boolean value) {
        this._ending = value;
    }

    void setMessage(SctpMessage value) {
        this._message = value;
    }

    public void setPayloadProtocolIdentifier(long value) {
        this._payloadProtocolIdentifier = value;
    }

    public void setRaised(boolean value) {
        this._raised = value;
    }

    public void setSackImmediately(boolean value) {
        this._sackImmediately = value;
    }

    public void setStreamIdentifier(int value) {
        this._streamIdentifier = value;
    }

    public void setStreamSequenceNumber(int value) {
        this._streamSequenceNumber = value;
    }

    public void setTransmissionTime(long value) {
        this._transmissionTime = value;
    }

    public void setTsn(long value) {
        this._tsn = value;
    }

    public void setUnordered(boolean value) {
        this._unordered = value;
    }

    public void setUserData(byte[] value) {
        this._userData = value;
    }

    public static long subtractTSN(long tsnA, long tsnB) {
        if (tsnA < 0L || tsnB < 0L) {
            return 0L;
        }
        if ((double)tsnB > 3.435973836E9 && (double)tsnA < 8.58993459E8) {
            return 0xFFFFFFFFL - tsnB + 1L + tsnA;
        }
        return tsnA - tsnB;
    }

    public String toString() {
        return LongExtensions.toString(this.getTsn());
    }
}

