/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AfbControlFrame;
import fm.icelink.AppControlFrame;
import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AtomicLong;
import fm.icelink.AudioFormat;
import fm.icelink.Binary;
import fm.icelink.ByeControlFrame;
import fm.icelink.CodecStats;
import fm.icelink.CodecType;
import fm.icelink.Constants;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.DateExtensions;
import fm.icelink.FecContext;
import fm.icelink.FecProducer;
import fm.icelink.FecReceiver;
import fm.icelink.FecRedPacket;
import fm.icelink.FeedbackControlFrame;
import fm.icelink.FirControlFrame;
import fm.icelink.FirEntry;
import fm.icelink.GenericNack;
import fm.icelink.GenericNackControlFrame;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.ILog;
import fm.icelink.IceTransport;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterBuffer;
import fm.icelink.JitterConfig;
import fm.icelink.LinkedList;
import fm.icelink.LinkedListEnumerator;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaReceiverStats;
import fm.icelink.MediaSenderStats;
import fm.icelink.MediaTransport;
import fm.icelink.NackBuffer;
import fm.icelink.NackConfig;
import fm.icelink.NetworkTimeProtocol;
import fm.icelink.PliControlFrame;
import fm.icelink.RRControlFrame;
import fm.icelink.RedFecConfig;
import fm.icelink.RembControlFrame;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import fm.icelink.RpsiControlFrame;
import fm.icelink.RtpBandwidthEstimator;
import fm.icelink.RtpHeaderAbsSendTime;
import fm.icelink.RtpHeaderExtension;
import fm.icelink.RtpHeaderExtensionElement;
import fm.icelink.RtpHeaderExtensionForm;
import fm.icelink.RtpHeaderExtensionRegistry;
import fm.icelink.RtpHeaderExtensionType;
import fm.icelink.RtpPacket;
import fm.icelink.RtpPacketHeader;
import fm.icelink.RtpPacketPair;
import fm.icelink.RtpSendBuffer;
import fm.icelink.SRControlFrame;
import fm.icelink.ScheduledItem;
import fm.icelink.SdesChunk;
import fm.icelink.SdesControlFrame;
import fm.icelink.SdesItem;
import fm.icelink.SdesItemType;
import fm.icelink.SliControlFrame;
import fm.icelink.SrtpTransport;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.UnixTimestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

abstract class RtpTransport<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> {
    private StreamDirection __absoluteSenderTimeDirection;
    private RtpBandwidthEstimator __bandwidthEstimator;
    private long __baseFrameTimestamp = -1L;
    private int __currentFecSequenceNumber;
    private long __currentLocalSynchronizationSource = 0L;
    private int __currentMediaSequenceNumber = 0;
    private int __currentReceivePayloadType = -1;
    private long __currentRemoteSynchronizationSource = 0L;
    private int __currentRtpSequenceNumber;
    private int __currentSendPayloadType = -1;
    private int __delayToStartCollectingBWData = 3000;
    private StreamDirection __direction;
    private int __durationOfBWDataCollection = 10000;
    private LinkedList<DataBuffer> __fecBuffer;
    private long __firstSendRtpTimestamp = -1L;
    private long __firstSendTicks = -1L;
    private long __frameCount = 0L;
    private boolean __ignoreStats = true;
    private long __lastExpectedPacketCount = 0L;
    private int __lastFirReceiveSequenceNumber = -1;
    private long __lastFirReceiveTimestamp = 0L;
    private int __lastFirSendSequenceNumber = -1;
    private long __lastFirSendTimestamp = 0L;
    private long __lastNackNetworkConditionReportTicks = -1L;
    private long __lastNackReportTicks = -1L;
    private long __lastPliReceiveTimestamp = 0L;
    private long __lastPliSendTimestamp = 0L;
    private long __lastReceivedPacketCount = 0L;
    private long __lastReceiveTransit = 0L;
    private long __lastReportSent = -1L;
    private long __lastSenderReportNtpTimestamp = 0L;
    private long __lastSenderReportTicks = 0L;
    private static ILog __log = Log.getLogger("FM.IceLink.Rtp.Transport");
    private long __maxReceivedPacketIndex = -1L;
    private long __minReceivedPacketIndex = -1L;
    private long __minReceivedRtpTimestamp = -1L;
    private long __minReceivedTicks = -1L;
    private int __nackNetworkConditionReportingInterval = 10000;
    private int __nackReportingInterval = 1000;
    private int __nacksReceivedDuringInterval = 0;
    private int __nacksReceivedDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksReceivedDuringIntervalPoorNetworkWarning = 200;
    private int __nacksReceivedDuringNetworkConditionInterval = 0;
    private int __nacksSentDuringInterval = 0;
    private int __nacksSentDuringIntervalCriticalNetworkWarning = 1500;
    private int __nacksSentDuringIntervalPoorNetworkWarning = 200;
    private int __nacksSentDuringNetworkConditionInterval = 0;
    private int __nextNackBufferRtpSequenceNumber = -1;
    private long __nextNackBufferSequenceNumber = -1L;
    private List<IAction1<MediaControlFrame[]>> __onSendControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private Object __receiveCountsLock;
    private double __receiveJitter = 0.0;
    private double __receiveRtpCyclesPerTick = -1.0;
    private int __reportIntervalInTicks;
    private int __reportsReceived = 0;
    private static double __roundTripTimeAlpha = 0.75;
    private int __roundTripTimeCriticalWarning = 750;
    private int __roundTripTimePoorWarning = 300;
    private int __roundTripTimeRR = -1;
    private double __sendRtpCyclesPerTick = -1.0;
    private Object __sentCountsLock;
    private long __startTicks = -1L;
    private int __startTimeOffset;
    private boolean _disableAutomaticReports;
    ScheduledItem _dispatchRembSI;
    private FecProducer _fecProducer;
    private FecReceiver _fecReceiver;
    private AtomicLong _firsReceived;
    private AtomicLong _firsSent;
    private int _inboundPacketsLostRtp;
    private JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _jitterBuffer;
    private JitterConfig _jitterConfig;
    private NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _nackBuffer;
    private NackConfig _nackConfig;
    private AtomicLong _nacksReceived;
    private AtomicLong _nacksSent;
    private AtomicLong _octetsReceivedRtcp;
    private AtomicLong _octetsReceivedRtp;
    private AtomicLong _octetsSentRtcp;
    private AtomicLong _octetsSentRtp;
    private IAction1<MediaControlFrame[]> _onSendControlFrames = null;
    private int _outboundPacketsLostRtp;
    private AtomicLong _packetsDiscarded;
    private AtomicLong _packetsReceivedRtcp;
    private AtomicLong _packetsReceivedRtp;
    private AtomicLong _packetsSentRtcp;
    private AtomicLong _packetsSentRtp;
    private AtomicLong _plisReceived;
    private AtomicLong _plisSent;
    ScheduledItem _processBandwidthStatsSI;
    private boolean _redFecActivated;
    private RedFecConfig _redFecConfig;
    private RtpHeaderExtensionRegistry _rtpHeaderExtensionRegistry;
    private RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> _sendBuffer;
    private SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> _srtpTransport;
    ScheduledItem _startCollectingBWStatsSI;
    private StreamType _type;

    public void addOnSendControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onSendControlFrames == null) {
                this._onSendControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(RtpTransport.this.__onSendControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onSendControlFrames.add(value);
        }
    }

    private void attachTransportEvents() {
        this.getSrtpTransport().addOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().addOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    public abstract TFrame[] createFormatArray(int var1);

    private void detachTransportEvents() {
        this.getSrtpTransport().removeOnReceiveFrame(new IActionDelegate1<TFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveFrame";
            }

            @Override
            public void invoke(TFrame frame) {
                RtpTransport.this.receiveFrame(frame);
            }
        });
        this.getSrtpTransport().removeOnReceiveControlFrames((IAction1<MediaControlFrame[]>)new IActionDelegate1<MediaControlFrame[]>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.receiveControlFrames";
            }

            @Override
            public void invoke(MediaControlFrame[] controlFrames) {
                RtpTransport.this.receiveControlFrames(controlFrames);
            }
        });
    }

    @Override
    public void doReceiveControlFrames(MediaControlFrame[] controlFrames) {
        this.updateRtcpReceiverStatistics(controlFrames);
        boolean filterPli = false;
        boolean filterFir = false;
        for (MediaControlFrame frame : controlFrames) {
            if (frame instanceof ByeControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Received RTCP goodbye (BYE) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SRControlFrame) {
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("Received RTCP sender report (SR) for {0} stream.", this.getType().toString()));
                }
                SRControlFrame frame2 = (SRControlFrame)frame;
                this.__lastSenderReportNtpTimestamp = frame2.getNtpTimestamp();
                this.__lastSenderReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                ReportBlock reportBlock = frame2.getReportBlock();
                if (reportBlock == null) continue;
                this.processReportBlock(reportBlock);
                continue;
            }
            if (frame instanceof RRControlFrame) {
                RRControlFrame frame3;
                ReportBlock block;
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("Received RTCP receiver report (RR) for {0} stream.", this.getType().toString()));
                }
                if ((block = (frame3 = (RRControlFrame)frame).getReportBlock()) == null) continue;
                this.processReportBlock(block);
                continue;
            }
            if (frame instanceof AppControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Received RTCP application-specific message for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof SdesControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Received RTCP source description (SDES) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof AfbControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Received RTCP application feedback (AFB) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof PliControlFrame) {
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("Received RTCP picture loss indication (PLI) for {0} stream.", this.getType().toString()));
                }
                this.getPlisReceived().increment();
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (this.__lastPliReceiveTimestamp == -1L || ticks - this.__lastPliReceiveTimestamp > (long)this.getKeyFrameDelayTicks()) {
                    this.__lastPliReceiveTimestamp = ticks;
                    continue;
                }
                filterPli = true;
                continue;
            }
            if (frame instanceof FirControlFrame) {
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("Received RTCP full intra request (FIR) for {0} stream.", this.getType().toString()));
                }
                this.getFirsReceived().increment();
                FirControlFrame frame4 = (FirControlFrame)frame;
                int sequenceNumber = frame4.getEntry().getSequenceNumber();
                int firSequenceNumberDelta = 1;
                if (this.__lastFirReceiveSequenceNumber != -1) {
                    firSequenceNumberDelta = this.getFirSequenceNumberDelta(sequenceNumber, this.__lastFirReceiveSequenceNumber);
                }
                long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (firSequenceNumberDelta > 0 || firSequenceNumberDelta == 0 && ticks - this.__lastFirReceiveTimestamp > (long)this.getKeyFrameDelayTicks()) {
                    this.__lastFirReceiveTimestamp = ticks;
                    this.__lastFirReceiveSequenceNumber = sequenceNumber;
                    frame4.getEntry().setLastSequenceNumber(sequenceNumber);
                    continue;
                }
                filterFir = true;
                continue;
            }
            if (frame instanceof SliControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Received RTCP slice loss indication (SLI) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof RpsiControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Received RTCP reference picture selection indication (RPSI) for {0} stream.", this.getType().toString()));
                continue;
            }
            if (frame instanceof GenericNackControlFrame) {
                this.processGenericNack((GenericNackControlFrame)frame);
                if (__log.getIsVerboseEnabled()) {
                    __log.verbose(StringExtensions.format("Received RTCP generic NACK for {0} stream.", this.getType().toString()));
                }
                this.updateNackReceiverStatistics();
                continue;
            }
            if (!(frame instanceof RembControlFrame)) continue;
            this.processRembControlFrame((RembControlFrame)frame);
        }
        controlFrames = this.filterInboundControlFrames(controlFrames, filterPli, filterFir);
        this.raiseReceiveControlFrames(controlFrames);
    }

    @Override
    public void doReceiveFrame(TFrame frame) {
        RtpPacketHeader rtpHeader = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpHeader();
        this.updateRtpReceiverStatistics(rtpHeader, ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber(), ((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getClockRate(), rtpHeader.calculateHeaderLength() + ((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer().getLength());
        if (this.getNackEnabled()) {
            if (this.__nextNackBufferSequenceNumber == -1L) {
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
                this.__nextNackBufferRtpSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber();
            }
            if (((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() - this.__nextNackBufferSequenceNumber > (long)this.getNackBuffer().getLength()) {
                long sequenceNumber = this.__nextNackBufferSequenceNumber;
                int rtpSequenceNumber = this.__nextNackBufferRtpSequenceNumber;
                while (rtpSequenceNumber < ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber()) {
                    this.getNackBuffer().read(sequenceNumber, rtpSequenceNumber, -1L, new IActionDelegate1<TFrame>(){

                        @Override
                        public String getId() {
                            return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveFec";
                        }

                        @Override
                        public void invoke(TFrame frame) {
                            RtpTransport.this.processReceiveFec(frame);
                        }
                    }, null);
                    ++rtpSequenceNumber;
                    ++sequenceNumber;
                }
                this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber();
            }
            if (!this.getNackBuffer().write(frame)) {
                this.getPacketsDiscarded().increment();
                if (__log.getIsDebugEnabled()) {
                    __log.debug("NACK buffer is discarding stale/duplicate packet for video stream.");
                }
            }
            while (this.getNackBuffer().read(this.__nextNackBufferSequenceNumber, this.__nextNackBufferRtpSequenceNumber, ((MediaFrame)frame).getTimestamp(), new IActionDelegate1<TFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.nackBufferReadFrameCallback";
                }

                @Override
                public void invoke(TFrame frame) {
                    RtpTransport.this.nackBufferReadFrameCallback(frame);
                }
            }, (IAction1<GenericNackControlFrame>)new IActionDelegate1<GenericNackControlFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.nackBufferReadNackCallback";
                }

                @Override
                public void invoke(GenericNackControlFrame nack) {
                    RtpTransport.this.nackBufferReadNackCallback(nack);
                }
            })) {
            }
            return;
        }
        this.processReceiveFec(frame);
    }

    @Override
    public boolean doResendPacket(RtpPacketPair packet) {
        SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport = this.getSrtpTransport();
        if (srtpTransport != null) {
            this.preparePacketForResend(packet);
            srtpTransport.resendPacket(packet);
        }
        return true;
    }

    @Override
    public void doSendControlFrames(MediaControlFrame[] controlFrames) {
        SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport;
        long[] localSynchronizationSources;
        if (this.__currentLocalSynchronizationSource == 0L && (localSynchronizationSources = super.getLocalSynchronizationSources()) != null && ArrayExtensions.getLength(localSynchronizationSources) > 0) {
            this.__currentLocalSynchronizationSource = localSynchronizationSources[0];
        }
        if (ArrayExtensions.getLength(controlFrames) > 0) {
            MediaControlFrame[] sdes;
            int n;
            ArrayList<MediaControlFrame> list;
            ReportControlFrame report;
            for (MediaControlFrame frame : controlFrames) {
                long ticks;
                if (frame instanceof PliControlFrame) {
                    ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                    if (this.__lastPliSendTimestamp != -1L && ticks - this.__lastPliSendTimestamp <= (long)this.getKeyFrameDelayTicks()) {
                        return;
                    }
                    this.__lastPliSendTimestamp = ticks;
                    this.getPlisSent().increment();
                    if (!__log.getIsDebugEnabled()) continue;
                    __log.debug(StringExtensions.format("Sending RTCP picture loss indication (PLI) for {0} stream (RTT={1}).", this.getType().toString(), IntegerExtensions.toString(this.getRoundTripTime())));
                    continue;
                }
                if (!(frame instanceof FirControlFrame)) continue;
                int sequenceNumber = ((FirControlFrame)frame).getEntry().getSequenceNumber();
                int firSequenceNumberDelta = 1;
                if (this.__lastFirSendSequenceNumber != -1) {
                    firSequenceNumberDelta = this.getFirSequenceNumberDelta(sequenceNumber, this.__lastFirSendSequenceNumber);
                }
                ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
                if (firSequenceNumberDelta <= 0 && (firSequenceNumberDelta != 0 || ticks - this.__lastFirSendTimestamp <= (long)this.getKeyFrameDelayTicks())) {
                    return;
                }
                this.__lastFirSendTimestamp = ticks;
                this.__lastFirSendSequenceNumber = sequenceNumber;
                this.getFirsSent().increment();
                if (!__log.getIsDebugEnabled()) continue;
                __log.debug(StringExtensions.format("Sending RTCP full intra request (FIR) for {0} stream (RTT={1}, SN={2}).", this.getType().toString(), IntegerExtensions.toString(this.getRoundTripTime()), IntegerExtensions.toString(sequenceNumber)));
            }
            if ((ArrayExtensions.getLength(controlFrames) < 1 || !(controlFrames[0] instanceof SRControlFrame) && !(controlFrames[0] instanceof RRControlFrame)) && (report = this.getReport()) != null) {
                list = new ArrayList<MediaControlFrame>();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 0, report);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            if (!(ArrayExtensions.getLength(controlFrames) >= 2 && controlFrames[1] instanceof SdesControlFrame || (sdes = this.getSdes()) == null)) {
                list = new ArrayList();
                MediaControlFrame[] mediaControlFrameArray = controlFrames;
                n = mediaControlFrameArray.length;
                for (int frame = 0; frame < n; ++frame) {
                    MediaControlFrame frame3 = mediaControlFrameArray[frame];
                    list.add(frame3);
                }
                ArrayListExtensions.insert(list, 1, sdes);
                controlFrames = list.toArray(new MediaControlFrame[0]);
            }
            for (MediaControlFrame frame3 : controlFrames) {
                if (frame3 instanceof SRControlFrame) {
                    this.validateSRControlFrame((SRControlFrame)frame3);
                } else if (frame3 instanceof RRControlFrame) {
                    this.validateRRControlFrame((RRControlFrame)frame3);
                } else if (frame3 instanceof SdesControlFrame) {
                    this.validateSdesControlFrame((SdesControlFrame)frame3);
                } else if (frame3 instanceof FeedbackControlFrame) {
                    this.validateFeedbackControlFrame((FeedbackControlFrame)frame3);
                } else if (frame3 instanceof ByeControlFrame) {
                    this.validateByeControlFrame((ByeControlFrame)frame3);
                } else if (frame3 instanceof AppControlFrame) {
                    this.validateAppControlFrame((AppControlFrame)frame3);
                }
                this.updateRtcpSenderStatistics(frame3);
            }
        }
        if ((srtpTransport = this.getSrtpTransport()) != null) {
            IAction1<MediaControlFrame[]> onSendControlFrames = this._onSendControlFrames;
            if (onSendControlFrames != null) {
                onSendControlFrames.invoke(controlFrames);
            }
            srtpTransport.sendControlFrames(controlFrames);
        }
    }

    @Override
    public boolean doSendFrame(TFrame frame) {
        if (ArrayExtensions.getLength(frame.getBuffers()) == 0) {
            __log.error("Frame has no buffers to send!");
            return false;
        }
        Object buffer = ((MediaFrame)frame).getBuffer(true);
        if (buffer == null) {
            __log.error("Frame has no packetized buffers to send. Are you missing a packetizer?");
            return false;
        }
        if (this.prepareBufferForSend(buffer, frame)) {
            if (this.getNackEnabled()) {
                this.getSendBuffer().write(frame);
            }
            this.processSendFec(frame);
        }
        return true;
    }

    @Override
    public boolean doStart() {
        if (super.getParameters() == null) {
            __log.error("Cannot start RTP transport. Rtp.Parameters must be set.");
            return false;
        }
        if (this.getSrtpTransport() == null) {
            __log.error("Cannot start RTP transport. Srtp.Transport must be set.");
            return false;
        }
        this.attachTransportEvents();
        return true;
    }

    @Override
    public boolean doStop() {
        this.detachTransportEvents();
        return true;
    }

    private MediaControlFrame[] filterInboundControlFrames(MediaControlFrame[] controlFrames, boolean filterPli, boolean filterFir) {
        ArrayList<MediaControlFrame> list = new ArrayList<MediaControlFrame>();
        for (MediaControlFrame frame : controlFrames) {
            if (filterPli && frame instanceof PliControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Discarding inbound PLI control frame (too frequent, RTT={0}).", IntegerExtensions.toString(this.getRoundTripTime())));
                continue;
            }
            if (filterFir && frame instanceof FirControlFrame) {
                if (!__log.getIsVerboseEnabled()) continue;
                __log.verbose(StringExtensions.format("Discarding inbound FIR control frame (too frequent, RTT={0}).", IntegerExtensions.toString(this.getRoundTripTime())));
                continue;
            }
            list.add(frame);
        }
        return list.toArray(new MediaControlFrame[0]);
    }

    StreamDirection getAbsoluteSenderTimeDirection() {
        return this.__absoluteSenderTimeDirection;
    }

    public int getAverageFrameRate() {
        if (this.__frameCount == 0L) {
            return -1;
        }
        long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) - this.__startTicks;
        if (num < (long)Constants.getTicksPerSecond()) {
            return -1;
        }
        return (int)(this.__frameCount * (long)Constants.getTicksPerSecond() / num);
    }

    private CodecStats getCodecStats(boolean receiver) {
        AudioFormat format;
        int payloadType;
        int n = payloadType = receiver ? this.__currentReceivePayloadType : this.__currentSendPayloadType;
        if (payloadType == -1) {
            return null;
        }
        Object negotiatedFormat = super.getNegotiatedFormat(payloadType);
        if (negotiatedFormat == null) {
            return null;
        }
        CodecStats stats2 = new CodecStats();
        stats2.setId(super.getId());
        stats2.setTimestamp(DateExtensions.getUtcNow());
        stats2.setName(((MediaFormat)negotiatedFormat).getName());
        stats2.setClockRate(((MediaFormat)negotiatedFormat).getClockRate());
        stats2.setParameters(((MediaFormat)negotiatedFormat).getParameters());
        stats2.setPayloadType(payloadType);
        CodecStats stats = stats2;
        if (receiver) {
            stats.setCodecType(CodecType.Decode);
        } else {
            stats.setCodecType(CodecType.Encode);
        }
        if (Global.equals((Object)this.getType(), (Object)StreamType.Audio) && (format = Global.tryCast(negotiatedFormat, AudioFormat.class)) != null) {
            stats.setChannelCount(format.getChannelCount());
        }
        return stats;
    }

    public StreamDirection getDirection() {
        return this.__direction;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    long getEstimatedUpstreamBitrate() {
        return this.__bandwidthEstimator.getEstimatedUpstreamBitrate();
    }

    public boolean getFecEnabled() {
        RedFecConfig redFecConfig = this.getRedFecConfig();
        return redFecConfig != null && !redFecConfig.getDisabled();
    }

    private int getFirSequenceNumberDelta(int sequenceNumber, int lastSequenceNumber) {
        int num = sequenceNumber - lastSequenceNumber;
        if (num < -128) {
            return num + 256;
        }
        if (num > 128) {
            num -= 256;
        }
        return num;
    }

    public AtomicLong getFirsReceived() {
        return this._firsReceived;
    }

    public AtomicLong getFirsSent() {
        return this._firsSent;
    }

    public int getInboundPacketsLostRtp() {
        return this._inboundPacketsLostRtp;
    }

    public JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getJitterBuffer() {
        return this._jitterBuffer;
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public int getKeyFrameDelayTicks() {
        if (this.getRoundTripTime() > 0) {
            return 2 * this.getRoundTripTime() * Constants.getTicksPerMillisecond();
        }
        return 1000 * Constants.getTicksPerMillisecond();
    }

    public NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getNackBuffer() {
        return this._nackBuffer;
    }

    public NackConfig getNackConfig() {
        return this._nackConfig;
    }

    public boolean getNackEnabled() {
        NackConfig nackConfig = this.getNackConfig();
        return nackConfig != null && !nackConfig.getDisableBuffering();
    }

    public AtomicLong getNacksReceived() {
        return this._nacksReceived;
    }

    public AtomicLong getNacksSent() {
        return this._nacksSent;
    }

    private int getNextRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        int _var0 = this.incrementRtpSequenceNumber(nextMediaSequenceNumber);
        return _var0;
    }

    public AtomicLong getOctetsReceivedRtcp() {
        return this._octetsReceivedRtcp;
    }

    public AtomicLong getOctetsReceivedRtp() {
        return this._octetsReceivedRtp;
    }

    public AtomicLong getOctetsSentRtcp() {
        return this._octetsSentRtcp;
    }

    public AtomicLong getOctetsSentRtp() {
        return this._octetsSentRtp;
    }

    public int getOutboundPacketsLostRtp() {
        return this._outboundPacketsLostRtp;
    }

    public AtomicLong getPacketsDiscarded() {
        return this._packetsDiscarded;
    }

    public AtomicLong getPacketsReceivedRtcp() {
        return this._packetsReceivedRtcp;
    }

    public AtomicLong getPacketsReceivedRtp() {
        return this._packetsReceivedRtp;
    }

    public AtomicLong getPacketsSentRtcp() {
        return this._packetsSentRtcp;
    }

    public AtomicLong getPacketsSentRtp() {
        return this._packetsSentRtp;
    }

    public AtomicLong getPlisReceived() {
        return this._plisReceived;
    }

    public AtomicLong getPlisSent() {
        return this._plisSent;
    }

    public MediaReceiverStats getReceiverStats() {
        MediaReceiverStats stats = new MediaReceiverStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
        stats.setCodec(this.getCodecStats(true));
        stats.setNackCount(this.getNacksReceived().getValue());
        stats.setPliCount(this.getPlisReceived().getValue());
        stats.setFirCount(this.getFirsReceived().getValue());
        stats.setBytesReceived(this.getOctetsReceivedRtp().getValue());
        stats.setPacketsReceived(this.getPacketsReceivedRtp().getValue());
        stats.setPacketsLost(this.getInboundPacketsLostRtp());
        stats.setPacketsDiscarded(this.getPacketsDiscarded().getValue());
        stats.setJitter((int)this.__receiveJitter);
        return stats;
    }

    public boolean getRedFecActivated() {
        return this._redFecActivated;
    }

    public RedFecConfig getRedFecConfig() {
        return this._redFecConfig;
    }

    private ReportControlFrame getReport() {
        ReportControlFrame frame = null;
        ReportBlock reportBlock = null;
        if (this.__maxReceivedPacketIndex > -1L) {
            reportBlock = new ReportBlock();
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose("Generating RTCP receiver report.");
            }
            if (reportBlock != null) {
                return new RRControlFrame(this.__currentRemoteSynchronizationSource, reportBlock);
            }
            return new RRControlFrame();
        }
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.Inactive)) {
            return frame;
        }
        if (__log.getIsVerboseEnabled()) {
            __log.verbose("Generating RTCP sender report.");
        }
        if (reportBlock != null) {
            return new SRControlFrame(this.__currentLocalSynchronizationSource, 0L, 0L, 0L, 0L, reportBlock);
        }
        return new SRControlFrame();
    }

    public int getRoundTripTime() {
        int smoothedRoundTripTime;
        IceTransport rtpTransport;
        if (this.getSrtpTransport() != null && (rtpTransport = Global.tryCast(this.getSrtpTransport().getRtpTransport(), IceTransport.class)) != null && (smoothedRoundTripTime = rtpTransport.getSmoothedRoundTripTime()) > -1) {
            return smoothedRoundTripTime;
        }
        return this.__roundTripTimeRR;
    }

    RtpHeaderExtensionRegistry getRtpHeaderExtensionRegistry() {
        return this._rtpHeaderExtensionRegistry;
    }

    private SdesControlFrame getSdes() {
        return new SdesControlFrame(new SdesChunk(this.__currentLocalSynchronizationSource, new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName())));
    }

    public RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> getSendBuffer() {
        return this._sendBuffer;
    }

    public MediaSenderStats getSenderStats() {
        MediaSenderStats stats = new MediaSenderStats();
        stats.setId(super.getId());
        stats.setTimestamp(DateExtensions.getUtcNow());
        stats.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        stats.setCodec(this.getCodecStats(false));
        stats.setNackCount(this.getNacksSent().getValue());
        stats.setPliCount(this.getPlisSent().getValue());
        stats.setFirCount(this.getFirsSent().getValue());
        stats.setBytesSent(this.getOctetsSentRtp().getValue());
        stats.setPacketsSent(this.getPacketsSentRtp().getValue());
        stats.setRoundTripTime(this.getRoundTripTime());
        return stats;
    }

    public SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getSrtpTransport() {
        return this._srtpTransport;
    }

    private long getTimestamp(long frameTimestamp) {
        if (this.__baseFrameTimestamp == -1L) {
            this.__baseFrameTimestamp = frameTimestamp;
        }
        return (frameTimestamp - this.__baseFrameTimestamp + (long)this.__startTimeOffset) % 0x100000000L;
    }

    public StreamType getType() {
        return this._type;
    }

    private int incrementFecSequenceNumber() {
        int num = this.__currentFecSequenceNumber++;
        if (this.__currentFecSequenceNumber == 65536) {
            this.__currentFecSequenceNumber = 0;
        }
        return num;
    }

    private int incrementRtpSequenceNumber(LongHolder nextMediaSequenceNumber) {
        nextMediaSequenceNumber.setValue(this.__currentMediaSequenceNumber++);
        int num = this.__currentRtpSequenceNumber++;
        if (this.__currentRtpSequenceNumber == 65536) {
            this.__currentRtpSequenceNumber = 0;
        }
        return num;
    }

    private void nackBufferReadFrameCallback(TFrame frame) {
        this.__nextNackBufferSequenceNumber = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getSequenceNumber() + 1L;
        this.__nextNackBufferRtpSequenceNumber = (((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpSequenceNumber() + 1) % 65536;
        this.processReceiveFec(frame);
    }

    private void nackBufferReadNackCallback(GenericNackControlFrame nack) {
        super.sendControlFrames(new MediaControlFrame[]{nack});
        if (__log.getIsDebugEnabled()) {
            this.updateNackSenderStatistics();
        }
    }

    private boolean prepareBufferForSend(TBuffer buffer, TFrame frame) {
        int num;
        if (((MediaFrame)frame).getSynchronizationSource() == -1L) {
            __log.error("RTP Transport cannot process frame. SynchronizationSource not set.");
            return false;
        }
        ((MediaBuffer)buffer).setSequenceNumbers(new long[ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers())]);
        if (!((MediaBuffer)buffer).getIsPacketized()) {
            ((MediaBuffer)buffer).setRtpHeaders(new RtpPacketHeader[ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers())]);
            for (num = 0; num < ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers()); ++num) {
                RtpPacket packet = RtpPacket.wrap(((MediaBuffer)buffer).getDataBuffers()[num]);
                ((MediaBuffer)buffer).getRtpHeaders()[num] = RtpPacketHeader.readFrom(packet.getHeader());
                ((MediaBuffer)buffer).getDataBuffers()[num] = packet.getPayload();
            }
        }
        if (ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers()) != ArrayExtensions.getLength(((MediaBuffer)buffer).getRtpHeaders())) {
            __log.error("RTP Transport cannot process frame. Missing rtp headers.");
            return false;
        }
        for (num = 0; num < ArrayExtensions.getLength(((MediaBuffer)buffer).getDataBuffers()); ++num) {
            if (((MediaBuffer)buffer).getRtpHeaders()[num] == null) {
                ((MediaBuffer)buffer).getRtpHeaders()[num] = new RtpPacketHeader();
            }
            RtpPacketHeader rtpHeader = ((MediaBuffer)buffer).getRtpHeaders()[num];
            if (Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendReceive)) {
                int num2 = this.getRtpHeaderExtensionRegistry().registeredIdForRtpHeaderExtensionType(RtpHeaderExtensionType.AbsSendTime);
                RtpHeaderAbsSendTime time2 = new RtpHeaderAbsSendTime(UnixTimestamp.getUtcNow());
                time2.setId(num2);
                RtpHeaderAbsSendTime time = time2;
                rtpHeader.setHeaderExtension(new RtpHeaderExtension(RtpHeaderExtensionForm.OneByte, new RtpHeaderExtensionElement[]{time}));
            }
            if (this.__currentLocalSynchronizationSource == 0L) {
                this.__currentLocalSynchronizationSource = ((MediaFrame)frame).getSynchronizationSource();
            }
            if (((MediaFrame)frame).getRtpSequenceNumber() == -1) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                rtpHeader.setSequenceNumber(_var1);
                ((MediaBuffer)buffer).getSequenceNumbers()[num] = nextMediaSequenceNumber;
            }
            if (((MediaFrame)frame).getRtpTimestamp() == -1L) {
                rtpHeader.setTimestamp(this.getTimestamp(((MediaFrame)frame).getTimestamp()));
            }
            rtpHeader.setSynchronizationSource(this.__currentLocalSynchronizationSource);
            rtpHeader.setContributingSources(((MediaFrame)frame).getContributingSources());
            int negotiatedPayloadType = super.getNegotiatedPayloadType(((MediaBuffer)buffer).getFormat());
            if (negotiatedPayloadType == -1) {
                __log.error("RTP Transport cannot process frame. No matching payload types found.");
                return false;
            }
            rtpHeader.setPayloadType(negotiatedPayloadType);
            this.updateRtpSenderStatistics(rtpHeader, ((MediaBuffer)buffer).getDataBuffers()[num].getLength());
        }
        return true;
    }

    private boolean preparePacketForResend(RtpPacketPair packet) {
        if (Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendReceive)) {
            int num = this.getRtpHeaderExtensionRegistry().registeredIdForRtpHeaderExtensionType(RtpHeaderExtensionType.AbsSendTime);
            RtpHeaderAbsSendTime time2 = new RtpHeaderAbsSendTime(UnixTimestamp.getUtcNow());
            time2.setId(num);
            RtpHeaderAbsSendTime time = time2;
            packet.getHeader().setHeaderExtension(new RtpHeaderExtension(RtpHeaderExtensionForm.OneByte, new RtpHeaderExtensionElement[]{time}));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBandwidthStats(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            this._processBandwidthStatsSI.setSuspended(true);
            this.__ignoreStats = true;
            this.__bandwidthEstimator.processBandwidthStats(this.getOctetsSentRtp(), this.getOctetsReceivedRtp());
            this._startCollectingBWStatsSI.setSuspended(false);
        }
    }

    private void processGenericNack(GenericNackControlFrame genericNack) {
        for (GenericNack nack : genericNack.getGenericNacks()) {
            if (this.resendRtpPacket(nack.getPacketId())) {
                // empty if block
            }
            int packetId = nack.getPacketId();
            for (int i = 1; i <= nack.getLostPacketIdPlusLength(); ++i) {
                if (nack.getLostPacketIdPlus(i) && !this.resendRtpPacket((packetId + i) % 65536)) continue;
            }
        }
    }

    private void processJitterBuffer(TFrame frame) {
        if (this.getJitterConfig().getDisableBuffering()) {
            this.raiseReceiveFrame(frame);
        } else {
            if (this.getJitterBuffer() == null) {
                this.setJitterBuffer(new JitterBuffer(this.getType().toString(), ((MediaFormat)super.getNegotiatedFormat(((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpHeader().getPayloadType())).getClockRate(), this.getJitterConfig().getBufferLength()));
            }
            if (!this.getJitterBuffer().push(frame)) {
                this.getPacketsDiscarded().increment();
                if (__log.getIsDebugEnabled()) {
                    __log.debug("Jitter buffer is discarding late packet for stream.");
                }
            }
            this.getJitterBuffer().pull(new IActionDelegate1<TFrame>(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.raiseReceiveFrame";
                }

                @Override
                public void invoke(TFrame frame) {
                    RtpTransport.this.raiseReceiveFrame(frame);
                }
            });
        }
    }

    private void processReceiveFec(TFrame frame) {
        if (!this.getFecEnabled()) {
            this.processJitterBuffer(frame);
        } else if (StringExtensions.isEqual(((MediaFormat)((MediaBuffer)((MediaFrame)frame).getBuffer()).getFormat()).getName(), MediaFormat.getRedName(), StringComparison.OrdinalIgnoreCase)) {
            if (this._fecReceiver == null) {
                this._fecReceiver = new FecReceiver();
            }
            RtpPacketHeader rtpHeader = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getRtpHeader();
            int offset = rtpHeader.calculateHeaderLength();
            DataBuffer dataBuffer = ((MediaBuffer)((MediaFrame)frame).getBuffer()).getDataBuffer();
            DataBuffer buffer = DataBufferPool.getInstance().take(offset + dataBuffer.getLength());
            rtpHeader.writeTo(buffer, 0);
            buffer.write(dataBuffer, offset);
            if (this._fecReceiver.addReceivedRedPacket(offset, rtpHeader.getSequenceNumber(), buffer, buffer.getLength(), super.getNegotiatedPayloadTypeByFullName(MediaFormat.getUlpFecName()))) {
                this.__fecBuffer.clear();
                if (!this._fecReceiver.processReceivedFec(this.__fecBuffer)) {
                    // empty if block
                }
                LinkedListEnumerator<DataBuffer> enumerator = this.__fecBuffer.getEnumerator();
                while (enumerator.moveNext()) {
                    DataBuffer current = enumerator.getCurrent();
                    RtpPacketHeader header = RtpPacketHeader.readFrom(current);
                    Object negotiatedFormat = super.getNegotiatedFormat(header.getPayloadType());
                    if (negotiatedFormat == null) {
                        __log.warn(StringExtensions.format("Unknown packet type of {0} received from Fec.", IntegerExtensions.toString(header.getPayloadType())));
                    } else {
                        TFrame local2 = this.getSrtpTransport().generateFrame(header, current.subset(header.calculateHeaderLength()), negotiatedFormat);
                        if (local2 != null) {
                            this.processJitterBuffer(local2);
                        }
                    }
                    if (!current.getIsPooled()) continue;
                    current.free();
                }
            }
        } else {
            this.processJitterBuffer(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRembControlFrame(RembControlFrame frame) {
        if (__log.getIsVerboseEnabled()) {
            __log.verbose(StringExtensions.format("RTP Transport: Received {0}", frame.toString()));
        }
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__ignoreStats) {
                this.__bandwidthEstimator.processUplinkBandwidthFromRemoteRemb(frame.getBitrate());
            }
        }
    }

    private void processReportBlock(ReportBlock block) {
        ++this.__reportsReceived;
        if (block.getLastSenderReportTimestamp() > 0L) {
            long ticks;
            long num7;
            long num = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(block.getLastSenderReportTimestamp())) / (long)Constants.getTicksPerMillisecond();
            long num2 = block.getDelaySinceLastSenderReport() * 1000L / 65536L;
            long num3 = DateExtensions.getTicks(NetworkTimeProtocol.compactNtpToDateTime(NetworkTimeProtocol.dateTimeToCompactNtp(DateExtensions.getUtcNow()))) / (long)Constants.getTicksPerMillisecond();
            long num4 = num3 - num - num2;
            this.__roundTripTimeRR = this.__roundTripTimeRR == -1 ? (int)num4 : (int)(__roundTripTimeAlpha * (double)this.__roundTripTimeRR + (1.0 - __roundTripTimeAlpha) * (double)num4);
            if (!this.__ignoreStats) {
                double percentLost = block.getPercentLost();
                this.__bandwidthEstimator.updateLossBasedEstimatedAvailableBandwidth(percentLost, true);
            }
            if (this.getNackEnabled()) {
                this.getNackBuffer().setRetransmissionTimeout(this.getRoundTripTime());
            }
            if ((num7 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
                if (this.getRoundTripTime() > this.__roundTripTimeCriticalWarning) {
                    __log.warn(StringExtensions.format("Critical network condition detected! Round trip time exceeding {0}ms.", IntegerExtensions.toString(this.getRoundTripTime())));
                } else if (this.getRoundTripTime() > this.__roundTripTimePoorWarning) {
                    __log.warn(StringExtensions.format("Poor network condition detected! Round trip time exceeding {0}ms.", IntegerExtensions.toString(this.getRoundTripTime())));
                }
                this.__lastNackNetworkConditionReportTicks = ticks;
            }
        }
        if (this.__reportsReceived > this.getRedFecConfig().getMinimumReportsBeforeFec() && this.getFecEnabled()) {
            if (!this.getRedFecActivated() && block.getPercentLost() * 100.0 >= (double)this.getRedFecConfig().getActivationThreshold()) {
                __log.info(StringExtensions.format("Activating FEC for RTP Transport '{0}'.", super.getId()));
                this.setRedFecActivated(true);
            }
            if (this.getRedFecActivated() && block.getPercentLost() * 100.0 < (double)this.getRedFecConfig().getActivationThreshold()) {
                __log.info(StringExtensions.format("Deactivating FEC for RTP Transport '{0}'.", super.getId()));
                this.setRedFecActivated(false);
            }
        }
        this.setOutboundPacketsLostRtp(block.getCumulativeNumberOfPacketsLost());
    }

    private void processSendFec(TFrame frame) {
        SrtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> srtpTransport = this.getSrtpTransport();
        if (srtpTransport != null) {
            FecRedPacket packet;
            ArrayList<FecRedPacket> list = null;
            if (this.getRedFecActivated()) {
                if (this._fecProducer == null) {
                    this._fecProducer = new FecProducer(new FecContext());
                }
                list = new ArrayList<FecRedPacket>();
                Object lastBuffer = ((MediaFrame)frame).getLastBuffer();
                Object local2 = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)local2).setDataBuffers(new DataBuffer[ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers())]);
                for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)lastBuffer).getDataBuffers()); ++i) {
                    DataBuffer payload = ((MediaBuffer)lastBuffer).getDataBuffers()[i];
                    RtpPacketHeader header = ((MediaBuffer)lastBuffer).getRtpHeaders()[i];
                    packet = this._fecProducer.buildRedPacket(header, payload, super.getNegotiatedPayloadTypeByFullName(MediaFormat.getRedName()));
                    ((MediaBuffer)local2).getRtpHeaders()[i] = packet.getHeader();
                    ((MediaBuffer)local2).getDataBuffers()[i] = packet.getPayload();
                    list.add(packet);
                    if (this._fecProducer.addRtpPacketAndGenerateFec(new RtpPacketPair(header, payload))) continue;
                    __log.warn("Could not add RTP packet to outbound FEC context.");
                    return;
                }
                ((MediaBuffer)local2).setFormat(super.getNegotiatedFormatByFullName(MediaFormat.getRedName()));
                ((MediaFrame)frame).addBuffer((Object)local2);
            }
            srtpTransport.sendFrame(frame);
            if (this.getRedFecActivated() && list != null) {
                for (FecRedPacket packet2 : list) {
                    packet2.getPayload().free();
                }
            }
            while (this.getRedFecActivated() && this._fecProducer != null && this._fecProducer.getFecAvailable()) {
                long nextMediaSequenceNumber = 0L;
                LongHolder _var0 = new LongHolder(nextMediaSequenceNumber);
                int _var1 = this.getNextRtpSequenceNumber(_var0);
                nextMediaSequenceNumber = _var0.getValue();
                packet = this._fecProducer.getFecPacket(super.getNegotiatedPayloadTypeByFullName(MediaFormat.getRedName()), super.getNegotiatedPayloadTypeByFullName(MediaFormat.getUlpFecName()), _var1);
                Object local3 = ((MediaFrame)frame).clone();
                ((MediaFrame)local3).removeBuffers();
                Object buffer = ((MediaBuffer)((MediaFrame)frame).getLastBuffer()).clone();
                ((MediaBuffer)buffer).setFormat(super.getNegotiatedFormatByFullName(MediaFormat.getRedName()));
                ((MediaBuffer)buffer).setDataBuffer(packet.getPayload().subset(0, packet.getLength()));
                ((MediaBuffer)buffer).setSequenceNumber(nextMediaSequenceNumber);
                ((MediaFrame)local3).addBuffer(buffer);
                srtpTransport.sendFrame(local3);
                ((MediaBuffer)buffer).getDataBuffer().free();
            }
        }
    }

    public void removeOnSendControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSendControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSendControlFrames.remove(value);
        if (this.__onSendControlFrames.size() == 0) {
            this._onSendControlFrames = null;
        }
    }

    public boolean resendRtpPacket(int sequenceNumber) {
        RtpPacketPair packet;
        if (this.getNackEnabled() && (packet = this.getSendBuffer().read(sequenceNumber)) != null) {
            RtpPacketHeader header = packet.getHeader();
            if (Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.SendReceive)) {
                int num = this.getRtpHeaderExtensionRegistry().registeredIdForRtpHeaderExtensionType(RtpHeaderExtensionType.AbsSendTime);
                RtpHeaderAbsSendTime time2 = new RtpHeaderAbsSendTime(UnixTimestamp.getUtcNow());
                time2.setId(num);
                RtpHeaderAbsSendTime time = time2;
                header.setHeaderExtension(new RtpHeaderExtension(RtpHeaderExtensionForm.OneByte, new RtpHeaderExtensionElement[]{time}));
            }
            this.getSrtpTransport().resendPacket(packet);
            return true;
        }
        return false;
    }

    public RtpTransport(Object lockObject, StreamType streamType, NackConfig nackConfig, RedFecConfig redFecConfig, JitterConfig jitterConfig, boolean disableAutomaticReports) {
        super(lockObject);
        this.__absoluteSenderTimeDirection = StreamDirection.Unset;
        this.__direction = StreamDirection.Inactive;
        this.__reportIntervalInTicks = Constants.getTicksPerSecond();
        this.__sentCountsLock = new Object();
        this.__receiveCountsLock = new Object();
        this.__startTimeOffset = LockedRandomizer.next(65535, Integer.MAX_VALUE);
        this.__currentRtpSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__currentFecSequenceNumber = LockedRandomizer.next(64512) + 512;
        this.__fecBuffer = new LinkedList();
        this.__bandwidthEstimator = new RtpBandwidthEstimator();
        this.setType(streamType);
        this.setNackConfig(nackConfig);
        this.setRedFecConfig(redFecConfig);
        this.setJitterConfig(jitterConfig);
        this.setOctetsSentRtp(new AtomicLong());
        this.setPacketsSentRtp(new AtomicLong());
        this.setOctetsSentRtcp(new AtomicLong());
        this.setPacketsSentRtcp(new AtomicLong());
        this.setOctetsReceivedRtp(new AtomicLong());
        this.setPacketsReceivedRtp(new AtomicLong());
        this.setOctetsReceivedRtcp(new AtomicLong());
        this.setPacketsReceivedRtcp(new AtomicLong());
        this.setNacksSent(new AtomicLong());
        this.setNacksReceived(new AtomicLong());
        this.setPlisSent(new AtomicLong());
        this.setPlisReceived(new AtomicLong());
        this.setFirsSent(new AtomicLong());
        this.setFirsReceived(new AtomicLong());
        this.setPacketsDiscarded(new AtomicLong());
        if (!nackConfig.getDisableBuffering()) {
            this.setSendBuffer(new RtpSendBuffer(this.getType().toString(), this.getNackConfig().getSendBufferLength()));
            this.setNackBuffer(new NackBuffer(this.getType().toString(), this.getNackConfig().getReceiveBufferLength(), (IFunction1<Integer, TFrame[]>)new IFunctionDelegate1<Integer, TFrame[]>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.createFormatArray";
                }

                @Override
                public TFrame[] invoke(Integer size) {
                    return RtpTransport.this.createFormatArray(size);
                }
            }));
        }
        if (Global.equals((Object)streamType, (Object)StreamType.Video)) {
            this._dispatchRembSI = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

                @Override
                public String getId() {
                    return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.sendRemb";
                }

                @Override
                public void invoke(ScheduledItem item) {
                    RtpTransport.this.sendRemb(item);
                }
            }, 1000, 1000, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        }
        this._startCollectingBWStatsSI = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.startCollectingBWStats";
            }

            @Override
            public void invoke(ScheduledItem item) {
                RtpTransport.this.startCollectingBWStats(item);
            }
        }, this.__delayToStartCollectingBWData, this.__delayToStartCollectingBWData, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        ScheduledItem item = new ScheduledItem((IAction1<ScheduledItem>)new IActionDelegate1<ScheduledItem>(){

            @Override
            public String getId() {
                return "fm.icelink.RtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processBandwidthStats";
            }

            @Override
            public void invoke(ScheduledItem item) {
                RtpTransport.this.processBandwidthStats(item);
            }
        }, this.__durationOfBWDataCollection, this.__durationOfBWDataCollection, ScheduledItem.getUnset(), ScheduledItem.getUnset());
        item.setSuspended(true);
        this._processBandwidthStatsSI = item;
    }

    private void sendBye(String reason) {
        super.sendControlFrames(new MediaControlFrame[]{this.getReport(), new ByeControlFrame(this.__currentLocalSynchronizationSource, reason)});
    }

    private void sendRemb(ScheduledItem item) {
        long[] remoteSynchronizationSources = super.getRemoteSynchronizationSources();
        long bitrate = -1L;
        bitrate = super.getMaxInputBitrate() > -1 && this.__bandwidthEstimator.getEstimatedDownstreamBitrate() > -1L ? MathAssistant.min(this.__bandwidthEstimator.getEstimatedDownstreamBitrate(), (long)super.getMaxInputBitrate()) : (super.getMaxInputBitrate() > -1 ? (long)super.getMaxInputBitrate() : this.__bandwidthEstimator.getEstimatedDownstreamBitrate());
        if (bitrate > 0L) {
            RembControlFrame frame = new RembControlFrame(bitrate, remoteSynchronizationSources);
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("RTP Transport: Dispatching {0}", frame.toString()));
            }
            super.sendControlFrames(new MediaControlFrame[]{frame});
        }
    }

    private void sendReport() {
        try {
            if (!this.getDisableAutomaticReports()) {
                super.sendControlFrames(new MediaControlFrame[]{this.getReport()});
            }
        }
        catch (Exception exception) {
            __log.debug("Could not send RTCP report.", exception);
        }
    }

    private void sendReportIfNeeded() {
        if (this.__lastReportSent == -1L) {
            this.__lastReportSent = DateExtensions.getTicks(DateExtensions.getUtcNow());
        } else {
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (ticks - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
                boolean flag = false;
                if (ticks - this.__lastReportSent > (long)this.__reportIntervalInTicks) {
                    flag = true;
                    this.__lastReportSent = ticks;
                }
                if (flag) {
                    this.sendReport();
                }
            }
        }
    }

    void setAbsoluteSenderTimeDirection(StreamDirection value) {
        this.__absoluteSenderTimeDirection = value;
    }

    public void setDirection(StreamDirection value) {
        this.__direction = value;
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    private void setFirsReceived(AtomicLong value) {
        this._firsReceived = value;
    }

    private void setFirsSent(AtomicLong value) {
        this._firsSent = value;
    }

    private void setInboundPacketsLostRtp(int value) {
        this._inboundPacketsLostRtp = value;
    }

    private void setJitterBuffer(JitterBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._jitterBuffer = value;
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    private void setNackBuffer(NackBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._nackBuffer = value;
    }

    private void setNackConfig(NackConfig value) {
        this._nackConfig = value;
    }

    private void setNacksReceived(AtomicLong value) {
        this._nacksReceived = value;
    }

    private void setNacksSent(AtomicLong value) {
        this._nacksSent = value;
    }

    private void setOctetsReceivedRtcp(AtomicLong value) {
        this._octetsReceivedRtcp = value;
    }

    private void setOctetsReceivedRtp(AtomicLong value) {
        this._octetsReceivedRtp = value;
    }

    private void setOctetsSentRtcp(AtomicLong value) {
        this._octetsSentRtcp = value;
    }

    private void setOctetsSentRtp(AtomicLong value) {
        this._octetsSentRtp = value;
    }

    private void setOutboundPacketsLostRtp(int value) {
        this._outboundPacketsLostRtp = value;
    }

    private void setPacketsDiscarded(AtomicLong value) {
        this._packetsDiscarded = value;
    }

    private void setPacketsReceivedRtcp(AtomicLong value) {
        this._packetsReceivedRtcp = value;
    }

    private void setPacketsReceivedRtp(AtomicLong value) {
        this._packetsReceivedRtp = value;
    }

    private void setPacketsSentRtcp(AtomicLong value) {
        this._packetsSentRtcp = value;
    }

    private void setPacketsSentRtp(AtomicLong value) {
        this._packetsSentRtp = value;
    }

    private void setPlisReceived(AtomicLong value) {
        this._plisReceived = value;
    }

    private void setPlisSent(AtomicLong value) {
        this._plisSent = value;
    }

    private void setRedFecActivated(boolean value) {
        this._redFecActivated = value;
    }

    private void setRedFecConfig(RedFecConfig value) {
        this._redFecConfig = value;
    }

    void setRtpHeaderExtensionRegistry(RtpHeaderExtensionRegistry value) {
        this._rtpHeaderExtensionRegistry = value;
    }

    private void setSendBuffer(RtpSendBuffer<TFrame, TBuffer, TBufferCollection, TFormat> value) {
        this._sendBuffer = value;
    }

    public void setSrtpTransport(SrtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        this._srtpTransport = value;
    }

    private void setType(StreamType value) {
        this._type = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCollectingBWStats(ScheduledItem item) {
        Object object = this.__lock;
        synchronized (object) {
            this._startCollectingBWStatsSI.setSuspended(true);
            this.__bandwidthEstimator.startCollectingBWStats(this.getOctetsSentRtp(), this.getOctetsReceivedRtp());
            this._processBandwidthStatsSI.setSuspended(false);
            this.__ignoreStats = false;
        }
    }

    private void updateNackReceiverStatistics() {
        long num3;
        long ticks;
        long num2;
        ++this.__nacksReceivedDuringInterval;
        ++this.__nacksReceivedDuringNetworkConditionInterval;
        this.getNacksReceived().increment();
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if ((num2 = ((ticks = DateExtensions.getTicks(DateExtensions.getUtcNow())) - this.__lastNackReportTicks) / (long)Constants.getTicksPerSecond()) > (long)this.__nackReportingInterval) {
            __log.debug(StringExtensions.format("Received {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksReceivedDuringInterval), LongExtensions.toString(num2)));
            this.__nacksReceivedDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if ((num3 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond()) > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalCriticalNetworkWarning) {
                __log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}:{1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksReceivedDuringNetworkConditionInterval > this.__nacksReceivedDuringIntervalPoorNetworkWarning) {
                __log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}:{1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksReceivedDuringIntervalCriticalNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateNackSenderStatistics() {
        ++this.__nacksSentDuringInterval;
        ++this.__nacksSentDuringNetworkConditionInterval;
        this.getNacksSent().increment();
        if (this.__lastNackReportTicks == -1L) {
            this.__lastNackReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        if (this.__lastNackNetworkConditionReportTicks == -1L) {
            this.__lastNackNetworkConditionReportTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        }
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        long num2 = (ticks - this.__lastNackReportTicks) / (long)Constants.getTicksPerMillisecond();
        long num3 = (ticks - this.__lastNackNetworkConditionReportTicks) / (long)Constants.getTicksPerMillisecond();
        if (num2 > (long)this.__nackReportingInterval) {
            __log.debug(StringExtensions.format("Sent {0} generic NACKs in the last {1}ms.", IntegerExtensions.toString(this.__nacksSentDuringInterval), LongExtensions.toString(num2)));
            this.__nacksSentDuringInterval = 0;
            this.__lastNackReportTicks = ticks;
        }
        if (num3 > (long)this.__nackNetworkConditionReportingInterval) {
            if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalCriticalNetworkWarning) {
                __log.warn(StringExtensions.format("Critical network condition detected! NACKs sent exceeding critical threshold ({0}ms {1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksSentDuringIntervalCriticalNetworkWarning)));
            } else if (this.__nacksSentDuringNetworkConditionInterval > this.__nacksSentDuringIntervalPoorNetworkWarning) {
                __log.warn(StringExtensions.format("Poor network condition detected! Large numbers of NACKs being sent ({0}ms {1}).", LongExtensions.toString(num3), IntegerExtensions.toString(this.__nacksSentDuringIntervalPoorNetworkWarning)));
            }
            this.__nacksSentDuringNetworkConditionInterval = 0;
            this.__lastNackNetworkConditionReportTicks = ticks;
        }
    }

    private void updateRtcpReceiverStatistics(MediaControlFrame[] frames) {
        if (frames != null) {
            int num = 0;
            for (MediaControlFrame frame : frames) {
                num += frame.getDataBuffer().getLength();
            }
            this.getOctetsReceivedRtcp().add(num);
            this.getPacketsReceivedRtcp().increment();
        }
    }

    private void updateRtcpSenderStatistics(MediaControlFrame frame) {
        this.getOctetsSentRtcp().add(frame.getDataBuffer().getLength());
        this.getPacketsSentRtcp().increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRtpReceiverStatistics(RtpPacketHeader header, long sequenceNumber, int clockRate, int receivedPacketSize) {
        Object object = this.__receiveCountsLock;
        synchronized (object) {
            long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            if (this.__currentRemoteSynchronizationSource == 0L) {
                this.__currentRemoteSynchronizationSource = header.getSynchronizationSource();
                this.__minReceivedRtpTimestamp = header.getTimestamp();
                this.__minReceivedTicks = ticks;
                this.__minReceivedPacketIndex = sequenceNumber;
                this.__maxReceivedPacketIndex = sequenceNumber;
                this.__receiveRtpCyclesPerTick = clockRate / Constants.getTicksPerSecond();
            }
            this.__currentReceivePayloadType = header.getPayloadType();
            this.__minReceivedRtpTimestamp = MathAssistant.min(header.getTimestamp(), this.__minReceivedRtpTimestamp);
            this.__minReceivedTicks = MathAssistant.min(ticks, this.__minReceivedTicks);
            this.__minReceivedPacketIndex = MathAssistant.min(sequenceNumber, this.__minReceivedPacketIndex);
            this.__maxReceivedPacketIndex = MathAssistant.max(sequenceNumber, this.__maxReceivedPacketIndex);
            this.getOctetsReceivedRtp().add(receivedPacketSize);
            this.getPacketsReceivedRtp().increment();
            long num2 = (long)((double)(ticks - this.__minReceivedTicks) * this.__receiveRtpCyclesPerTick) + this.__minReceivedRtpTimestamp;
            long num3 = num2 - header.getTimestamp();
            long num4 = num3 - this.__lastReceiveTransit;
            this.__lastReceiveTransit = num3;
            if (num4 < 0L) {
                num4 = -num4;
            }
            this.__receiveJitter += ((double)num4 - this.__receiveJitter) / 16.0;
        }
        this.sendReportIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRtpSenderStatistics(RtpPacketHeader rtpHeader, int payloadLength) {
        if (rtpHeader == null) {
            __log.error("Transport cannot process RTP. Malformed RTP packet in frame.");
            return false;
        }
        if (this.__firstSendRtpTimestamp == -1L) {
            Object negotiatedFormat = super.getNegotiatedFormat(rtpHeader.getPayloadType());
            this.__firstSendRtpTimestamp = rtpHeader.getTimestamp();
            this.__firstSendTicks = DateExtensions.getTicks(DateExtensions.getUtcNow());
            this.__sendRtpCyclesPerTick = (double)((MediaFormat)negotiatedFormat).getClockRate() / 1.0E7;
        }
        this.__currentSendPayloadType = rtpHeader.getPayloadType();
        int num = payloadLength;
        Object object = this.__sentCountsLock;
        synchronized (object) {
            this.getPacketsSentRtp().increment();
            this.getOctetsSentRtp().add(num);
        }
        this.sendReportIfNeeded();
        return true;
    }

    private void validateAppControlFrame(AppControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
    }

    private void validateByeControlFrame(ByeControlFrame frame) {
        if (frame.getSourceCount() == 0) {
            frame = new ByeControlFrame(this.__currentLocalSynchronizationSource);
        }
    }

    private void validateFeedbackControlFrame(FeedbackControlFrame frame) {
        frame.setPacketSenderSynchronizationSource(this.__currentLocalSynchronizationSource);
        frame.setMediaSourceSynchronizationSource(this.__currentRemoteSynchronizationSource);
        if (frame instanceof FirControlFrame) {
            FirControlFrame frame2 = (FirControlFrame)frame;
            for (FirEntry entry : frame2.getEntries()) {
                entry.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateReportControlFrame(ReportControlFrame frame) {
        if (ArrayExtensions.getLength(frame.getReportBlocks()) > 0) {
            if (this.__maxReceivedPacketIndex == -1L) {
                frame.setReportBlock(null);
            } else {
                for (ReportBlock block : frame.getReportBlocks()) {
                    long num9;
                    long num8;
                    long num7;
                    long num6;
                    long num5;
                    long num3;
                    block.setSynchronizationSource(this.__currentRemoteSynchronizationSource);
                    long num = 0L;
                    long num2 = 0L;
                    Object object = this.__receiveCountsLock;
                    synchronized (object) {
                        num = this.__lastSenderReportNtpTimestamp;
                        num2 = this.__lastSenderReportTicks;
                        num3 = this.__maxReceivedPacketIndex;
                        long num4 = this.__minReceivedPacketIndex;
                        num5 = num3 - num4 + 1L;
                        num6 = this.getPacketsReceivedRtp().getValue();
                        num7 = num5 - this.__lastExpectedPacketCount;
                        this.__lastExpectedPacketCount = num5;
                        num8 = num6 - this.__lastReceivedPacketCount;
                        this.__lastReceivedPacketCount = num6;
                        num9 = (long)this.__receiveJitter;
                    }
                    int num10 = (int)(num5 - num6);
                    int num11 = (int)(num7 - num8);
                    short num12 = 0;
                    if (num7 != 0L && num11 > 0) {
                        num12 = (short)((long)(num11 << 8) / num7);
                    }
                    long num13 = Binary.fromBytes32(Binary.toBytes64(num, false), 2, false);
                    long num14 = 0L;
                    if (num2 > 0L) {
                        num14 = (long)((double)(DateExtensions.getTicks(DateExtensions.getUtcNow()) - num2) * (65536.0 / (double)Constants.getTicksPerSecond()));
                    }
                    if (block.getFractionLost() == 0) {
                        block.setFractionLost(num12);
                    }
                    if (block.getCumulativeNumberOfPacketsLost() == 0) {
                        block.setCumulativeNumberOfPacketsLost(num10);
                        this.setInboundPacketsLostRtp(num10);
                    }
                    if (block.getExtendedHighestSequenceNumberReceived() == 0L) {
                        block.setExtendedHighestSequenceNumberReceived(num3);
                    }
                    if (block.getInterarrivalJitter() == 0L) {
                        block.setInterarrivalJitter(num9);
                    }
                    if (block.getLastSenderReportTimestamp() == 0L) {
                        block.setLastSenderReportTimestamp(num13);
                    }
                    if (block.getDelaySinceLastSenderReport() == 0L) {
                        block.setDelaySinceLastSenderReport(num14);
                    }
                    if (this.__ignoreStats) continue;
                    this.__bandwidthEstimator.updateLossBasedEstimatedAvailableBandwidth(block.getPercentLost(), false);
                }
            }
        }
    }

    private void validateRRControlFrame(RRControlFrame frame) {
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        this.validateReportControlFrame(frame);
    }

    private void validateSdesControlFrame(SdesControlFrame frame) {
        if (frame.getChunks() != null) {
            for (SdesChunk chunk : frame.getChunks()) {
                chunk.setSynchronizationSource(this.__currentLocalSynchronizationSource);
                if (chunk.getSourceDescriptionItems() == null) continue;
                for (int i = 0; i < ArrayExtensions.getLength(chunk.getSourceDescriptionItems()); ++i) {
                    SdesItem item = chunk.getSourceDescriptionItems()[i];
                    if (item.getType() != SdesItemType.getCanonicalName() || Global.equals(item.getText(), super.getParameters().getCanonicalName())) continue;
                    item = new SdesItem(SdesItemType.getCanonicalName(), super.getParameters().getCanonicalName());
                }
            }
        }
    }

    private void validateSRControlFrame(SRControlFrame frame) {
        Date utcNow = DateExtensions.getUtcNow();
        long num = this.getPacketsSentRtp().getValue();
        long num2 = this.getOctetsSentRtp().getValue();
        frame.setSynchronizationSource(this.__currentLocalSynchronizationSource);
        if (frame.getNtpTimestamp() == 0L) {
            frame.setNtpTimestamp(NetworkTimeProtocol.dateTimeToNtp(utcNow));
        }
        if (frame.getRtpTimestamp() == 0L) {
            frame.setRtpTimestamp(num == 0L ? 0L : (long)((double)(DateExtensions.getTicks(utcNow) - this.__firstSendTicks) * this.__sendRtpCyclesPerTick) + (long)this.__startTimeOffset);
        }
        if (frame.getPacketCount() == 0L) {
            frame.setPacketCount(num);
        }
        if (frame.getOctetCount() == 0L) {
            frame.setOctetCount(num2);
        }
        this.validateReportControlFrame(frame);
    }
}

