/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.RtpPacketPair;

class RtpSendBuffer<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>> {
    private Object __ioLock = new Object();
    private RtpPacketPair[] __rtpPacketCache;
    private String _name;

    public int getLength() {
        return ArrayExtensions.getLength(this.__rtpPacketCache);
    }

    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtpPacketPair read(int rtpSequenceNumber) {
        RtpPacketPair pair = null;
        Object object = this.__ioLock;
        synchronized (object) {
            pair = this.__rtpPacketCache[rtpSequenceNumber % this.getLength()];
        }
        if (pair != null && pair.getHeader().getSequenceNumber() != rtpSequenceNumber) {
            return null;
        }
        return pair;
    }

    public RtpSendBuffer(String name, int size) {
        this.setName(name);
        this.__rtpPacketCache = new RtpPacketPair[size];
    }

    private void setName(String value) {
        this._name = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(TFrame frame) {
        boolean flag = false;
        Object object = this.__ioLock;
        synchronized (object) {
            DataBuffer[] dataBuffers = null;
            RtpPacketPair pair = null;
            for (int index = ArrayExtensions.getLength(frame.getBuffers()) - 1; dataBuffers == null && index >= 0; --index) {
                MediaBuffer local = frame.getBuffers()[index];
                if (!((MediaFormat)local.getFormat()).getIsPacketized()) continue;
                dataBuffers = local.getDataBuffers();
            }
            if (dataBuffers != null) {
                for (int i = 0; i < ArrayExtensions.getLength(dataBuffers); ++i) {
                    dataBuffers[i].keep();
                    pair = new RtpPacketPair(((MediaBuffer)((MediaFrame)frame).getLastBuffer()).getRtpHeaders()[i], dataBuffers[i]);
                    int sequenceNumber = pair.getHeader().getSequenceNumber();
                    RtpPacketPair pair2 = this.__rtpPacketCache[sequenceNumber % this.getLength()];
                    if (pair2 != null) {
                        pair2.getPayload().free();
                    }
                    this.__rtpPacketCache[sequenceNumber % this.getLength()] = pair;
                    flag = true;
                }
                return flag;
            }
            return false;
        }
    }
}

