/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IRtpHeaderExtension;
import fm.icelink.RtpRawHeaderExtension;

public class RtpPacketHeader {
    private int _contributingSourceCount;
    private long[] _contributingSources;
    private boolean _extension;
    private IRtpHeaderExtension _headerExtension;
    private boolean _marker;
    private boolean _padding;
    private int _paddingLength;
    private int _payloadType;
    private int _sequenceNumber;
    private long _synchronizationSource;
    private long _timestamp;
    private int _version;

    public int calculateHeaderLength() {
        int num = RtpPacketHeader.getFixedHeaderLength() + this.getContributingSourceCount() * 4;
        if (this.getExtension()) {
            num += this.getHeaderExtension().getLength() * 4 + 4;
        }
        return num;
    }

    public RtpPacketHeader clone() {
        RtpPacketHeader header = new RtpPacketHeader();
        header.setVersion(this.getVersion());
        header.setMarker(this.getMarker());
        header.setPadding(this.getPadding());
        header.setExtension(this.getExtension());
        header.setContributingSourceCount(this.getContributingSourceCount());
        header.setPayloadType(this.getPayloadType());
        header.setSequenceNumber(this.getSequenceNumber());
        header.setTimestamp(this.getTimestamp());
        header.setSynchronizationSource(this.getSynchronizationSource());
        header.setContributingSources(this.getContributingSources());
        return header;
    }

    public int getContributingSourceCount() {
        return this._contributingSourceCount;
    }

    public long[] getContributingSources() {
        return this._contributingSources;
    }

    public boolean getExtension() {
        return this._extension;
    }

    public static int getFixedHeaderLength() {
        return 12;
    }

    public IRtpHeaderExtension getHeaderExtension() {
        return this._headerExtension;
    }

    public boolean getMarker() {
        return this._marker;
    }

    public boolean getPadding() {
        return this._padding;
    }

    public int getPaddingLength() {
        return this._paddingLength;
    }

    public int getPayloadType() {
        return this._payloadType;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public int getVersion() {
        return this._version;
    }

    public static RtpPacketHeader readFrom(DataBuffer buffer) {
        RtpPacketHeader header = new RtpPacketHeader();
        header.setVersion(buffer.read2(0, 0));
        header.setPadding(buffer.read1(0, 2));
        header.setExtension(buffer.read1(0, 3));
        header.setContributingSourceCount(buffer.read4(0, 4));
        header.setMarker(buffer.read1(1, 0));
        header.setPayloadType(buffer.read7(1, 1));
        header.setSequenceNumber(buffer.read16(2));
        header.setTimestamp(buffer.read32(4));
        header.setSynchronizationSource(buffer.read32(8));
        if (header.getContributingSourceCount() > 0) {
            header.setContributingSources(new long[header.getContributingSourceCount()]);
            for (int i = 0; i < header.getContributingSourceCount(); ++i) {
                header.getContributingSources()[i] = buffer.read32(12 + i * 4);
            }
        }
        if (header.getPadding()) {
            header.setPaddingLength(buffer.read8(buffer.getLength() - 1));
        }
        if (header.getExtension()) {
            int num2 = RtpPacketHeader.getFixedHeaderLength() + header.getContributingSourceCount() * 4;
            int num3 = buffer.read16(num2 + 2);
            header.setHeaderExtension(new RtpRawHeaderExtension(new byte[]{buffer.getData()[buffer.getIndex() + num2], buffer.getData()[buffer.getIndex() + num2 + 1]}, buffer.subset(num2 + 4, num3 * 4)));
        }
        return header;
    }

    public RtpPacketHeader() {
        this.setVersion(2);
    }

    public void setContributingSourceCount(int value) {
        this._contributingSourceCount = value;
    }

    public void setContributingSources(long[] value) {
        this._contributingSources = value;
    }

    private void setExtension(boolean value) {
        this._extension = value;
    }

    public void setHeaderExtension(IRtpHeaderExtension value) {
        this._headerExtension = value;
    }

    public void setMarker(boolean value) {
        this._marker = value;
    }

    public void setPadding(boolean value) {
        this._padding = value;
    }

    private void setPaddingLength(int value) {
        this._paddingLength = value;
    }

    public void setPayloadType(int value) {
        this._payloadType = value;
    }

    public void setSequenceNumber(int value) {
        this._sequenceNumber = value;
    }

    public void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    public void setTimestamp(long value) {
        this._timestamp = value;
    }

    public void setVersion(int value) {
        this._version = value;
    }

    public void writeTo(DataBuffer buffer, int offset) {
        buffer.write2(this.getVersion(), offset, 0);
        buffer.write1(this.getPadding(), offset, 2);
        buffer.write1(this.getExtension(), offset, 3);
        buffer.write4(this.getContributingSourceCount(), offset, 4);
        buffer.write1(this.getMarker(), offset + 1, 0);
        buffer.write7(this.getPayloadType(), offset + 1, 1);
        buffer.write16(this.getSequenceNumber(), offset + 2);
        buffer.write32(this.getTimestamp(), offset + 4);
        buffer.write32(this.getSynchronizationSource(), offset + 8);
        if (this.getContributingSourceCount() > 0) {
            if (this.getContributingSources() == null || this.getContributingSourceCount() != ArrayExtensions.getLength(this.getContributingSources())) {
                throw new RuntimeException(new Exception("Contributing sources count has a non-zero value but the contributing sources array is null or contains an invalid count."));
            }
            for (int i = 0; i < this.getContributingSourceCount(); ++i) {
                buffer.write32(this.getContributingSources()[i], offset + 12 + i * 4);
            }
        }
        if (this.getExtension()) {
            int num2 = RtpPacketHeader.getFixedHeaderLength() + this.getContributingSourceCount() * 4;
            buffer.getData()[buffer.getIndex() + num2] = this.getHeaderExtension().getId()[0];
            buffer.getData()[buffer.getIndex() + num2 + 1] = this.getHeaderExtension().getId()[1];
            buffer.write16(this.getHeaderExtension().getLength(), offset + num2 + 2);
            this.getHeaderExtension().fillBuffer(buffer, offset + num2 + 4);
        }
    }
}

