/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.Log;
import fm.icelink.RsaKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class RsaCrypto {
    private static int _defaultKeySize = 2048;

    public static int getDefaultKeySize() {
        return _defaultKeySize;
    }

    public static void setDefaultKeySize(int defaultKeySize) {
        _defaultKeySize = defaultKeySize;
    }

    public static RsaKey createKey() {
        return RsaCrypto.createKey(_defaultKeySize);
    }

    public static RsaKey createKey(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(keySize);
            KeyPair key = kpg.genKeyPair();
            PrivateKey privateKey = key.getPrivate();
            PublicKey publicKey = key.getPublic();
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec publicSpec = kf.getKeySpec(publicKey, RSAPublicKeySpec.class);
            RSAPrivateCrtKeySpec privateSpec = kf.getKeySpec(privateKey, RSAPrivateCrtKeySpec.class);
            RsaKey RsaKey2 = new RsaKey();
            RsaKey2.setModulus(RsaCrypto.removePositive(publicSpec.getModulus().toByteArray()));
            RsaKey2.setPublicExponent(RsaCrypto.removePositive(publicSpec.getPublicExponent().toByteArray()));
            RsaKey2.setPrivateExponent(RsaCrypto.removePositive(privateSpec.getPrivateExponent().toByteArray()));
            RsaKey2.setPrime1(RsaCrypto.removePositive(privateSpec.getPrimeP().toByteArray()));
            RsaKey2.setPrime2(RsaCrypto.removePositive(privateSpec.getPrimeQ().toByteArray()));
            RsaKey2.setExponent1(RsaCrypto.removePositive(privateSpec.getPrimeExponentP().toByteArray()));
            RsaKey2.setExponent2(RsaCrypto.removePositive(privateSpec.getPrimeExponentQ().toByteArray()));
            RsaKey2.setCoefficient(RsaCrypto.removePositive(privateSpec.getCrtCoefficient().toByteArray()));
            return RsaKey2;
        }
        catch (Exception ex) {
            Log.error("Could not generate RSA key.", ex);
            return null;
        }
    }

    public static PrivateKey getPrivateKey(RsaKey key) throws Exception {
        RSAPrivateCrtKeySpec privateSpec = new RSAPrivateCrtKeySpec(new BigInteger(RsaCrypto.addPositive(key.getModulus())), new BigInteger(RsaCrypto.addPositive(key.getPublicExponent())), new BigInteger(RsaCrypto.addPositive(key.getPrivateExponent())), new BigInteger(RsaCrypto.addPositive(key.getPrime1())), new BigInteger(RsaCrypto.addPositive(key.getPrime2())), new BigInteger(RsaCrypto.addPositive(key.getExponent1())), new BigInteger(RsaCrypto.addPositive(key.getExponent2())), new BigInteger(RsaCrypto.addPositive(key.getCoefficient())));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(privateSpec);
    }

    public static PublicKey getPublicKey(RsaKey key) throws Exception {
        RSAPublicKeySpec publicSpec = new RSAPublicKeySpec(new BigInteger(RsaCrypto.addPositive(key.getModulus())), new BigInteger(RsaCrypto.addPositive(key.getPublicExponent())));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(publicSpec);
    }

    private static byte[] padHash(byte[] hash, int paddedLength) {
        int hashLength = hash.length;
        byte[] paddedHash = new byte[paddedLength];
        Binary.toBytes8(0, paddedHash, 0);
        Binary.toBytes8(1, paddedHash, 1);
        for (int i = 2; i < paddedHash.length - hashLength - 1; ++i) {
            Binary.toBytes8(255, paddedHash, i);
        }
        Binary.toBytes8(0, paddedHash, paddedHash.length - hashLength - 1);
        BitAssistant.copy(hash, 0, paddedHash, paddedHash.length - hashLength, hashLength);
        return paddedHash;
    }

    private static boolean verifyPaddedHash(byte[] paddedHash, int hashLength, int paddedLength) {
        int offset = 0;
        if (paddedHash.length == paddedLength ? (Binary.fromBytes8(paddedHash, offset++) & 0xFF) != 0 : paddedHash.length != paddedLength - 1) {
            return false;
        }
        if ((Binary.fromBytes8(paddedHash, offset++) & 0xFF) != 1) {
            return false;
        }
        for (int i = offset; i < paddedHash.length - hashLength - 1; ++i) {
            if ((Binary.fromBytes8(paddedHash, i) & 0xFF) == 255) continue;
            return false;
        }
        return (Binary.fromBytes8(paddedHash, paddedHash.length - hashLength - 1) & 0xFF) == 0;
    }

    private static byte[] addPositive(byte[] value) {
        if (value.length > 0 && (value[0] & 0x80) == 0) {
            return value;
        }
        byte[] pos = new byte[value.length + 1];
        pos[0] = 0;
        BitAssistant.copy(value, 0, pos, 1, value.length);
        return pos;
    }

    private static byte[] removePositive(byte[] value) {
        if (value.length % 2 == 1 && value[0] == 0) {
            return BitAssistant.subArray(value, 1);
        }
        return value;
    }

    public static byte[] signMd5Sha1(byte[] md5sha1, RsaKey privateKey) {
        byte[] md5sha1Padded = RsaCrypto.padHash(md5sha1, privateKey.getModulus().length);
        BigInteger input = new BigInteger(RsaCrypto.addPositive(md5sha1Padded));
        BigInteger output = input.modPow(new BigInteger(RsaCrypto.addPositive(privateKey.getPrivateExponent())), new BigInteger(RsaCrypto.addPositive(privateKey.getModulus())));
        return RsaCrypto.removePositive(output.toByteArray());
    }

    public static boolean verifyMd5Sha1(byte[] md5sha1, byte[] signature, RsaKey publicKey) {
        BigInteger input = new BigInteger(RsaCrypto.addPositive(signature));
        BigInteger output = input.modPow(new BigInteger(RsaCrypto.addPositive(publicKey.getPublicExponent())), new BigInteger(RsaCrypto.addPositive(publicKey.getModulus())));
        byte[] md5sha1Padded = RsaCrypto.removePositive(output.toByteArray());
        if (!BitAssistant.sequencesAreEqual(md5sha1, 0, md5sha1Padded, md5sha1Padded.length - md5sha1.length, md5sha1.length)) {
            return false;
        }
        return RsaCrypto.verifyPaddedHash(md5sha1Padded, md5sha1.length, publicKey.getModulus().length);
    }

    public static byte[] signSha1(byte[] sha1, RsaKey privateKey) {
        try {
            PrivateKey pk = RsaCrypto.getPrivateKey(privateKey);
            Signature s = Signature.getInstance("SHA1withRSA");
            s.initSign(pk);
            s.update(sha1);
            return s.sign();
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }

    public static boolean verifySha1(byte[] sha1, byte[] signature, RsaKey publicKey) {
        try {
            PublicKey pk = RsaCrypto.getPublicKey(publicKey);
            Signature s = Signature.getInstance("SHA1withRSA");
            s.initVerify(pk);
            s.update(sha1);
            return s.verify(signature);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static byte[] signSha256(byte[] sha256, RsaKey privateKey) {
        try {
            PrivateKey pk = RsaCrypto.getPrivateKey(privateKey);
            Signature s = Signature.getInstance("SHA256withRSA");
            s.initSign(pk);
            s.update(sha256);
            return s.sign();
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }

    public static boolean verifySha256(byte[] sha256, byte[] signature, RsaKey publicKey) {
        try {
            PublicKey pk = RsaCrypto.getPublicKey(publicKey);
            Signature s = Signature.getInstance("SHA256withRSA");
            s.initVerify(pk);
            s.update(sha256);
            return s.verify(signature);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static byte[] encrypt(byte[] b, RsaKey publicKey) {
        try {
            PublicKey pk = RsaCrypto.getPublicKey(publicKey);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, pk);
            return cipher.doFinal(b);
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }

    public static byte[] decrypt(byte[] b, RsaKey privateKey) {
        try {
            PrivateKey pk = RsaCrypto.getPrivateKey(privateKey);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, pk);
            return cipher.doFinal(b);
        }
        catch (Exception ex) {
            return new byte[0];
        }
    }
}

