/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.ReliableChannelState;
import fm.icelink.ReliableChannelType;
import fm.icelink.ReliableRtcDcepDataChannelAck;
import fm.icelink.ReliableRtcDcepDataChannelOpen;
import fm.icelink.ReliableRtcDcepMessage;
import fm.icelink.ReliableSctpPayloadProtocolIdentifier;
import fm.icelink.SctpMessage;
import fm.icelink.SctpTransport;
import fm.icelink.StringExtensions;
import fm.icelink.Utf8;
import java.util.ArrayList;
import java.util.List;

class ReliableChannel {
    private AtomicLong __bytesReceived;
    private AtomicLong __bytesSent;
    private AtomicLong __messagesReceived;
    private AtomicLong __messagesSent;
    private List<IAction1<Exception>> __onError = new ArrayList<IAction1<Exception>>();
    private List<IAction1<DataBuffer>> __onReceiveBinary = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<String>> __onReceiveString = new ArrayList<IAction1<String>>();
    private List<IAction1<ReliableChannel>> __onStateChange = new ArrayList<IAction1<ReliableChannel>>();
    private ArrayList<SctpMessage> __outgoingBuffer;
    private ReliableChannelState __state;
    private Object __stateLock = new Object();
    private Error _error;
    private SctpTransport _innerTransport;
    private int _innerTransportStreamId;
    private String _label;
    private IAction1<Exception> _onError = null;
    private IAction1<DataBuffer> _onReceiveBinary = null;
    private IAction1<String> _onReceiveString = null;
    private IAction1<ReliableChannel> _onStateChange = null;
    private boolean _ordered;
    private String _subProtocol;
    public static int _unset = -1;

    public void addOnError(IAction1<Exception> value) {
        if (value != null) {
            if (this._onError == null) {
                this._onError = new IAction1<Exception>(){

                    @Override
                    public void invoke(Exception p0) {
                        for (IAction1 action : new ArrayList(ReliableChannel.this.__onError)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onError.add(value);
        }
    }

    public void addOnReceiveBinary(IAction1<DataBuffer> value) {
        if (value != null) {
            if (this._onReceiveBinary == null) {
                this._onReceiveBinary = new IAction1<DataBuffer>(){

                    @Override
                    public void invoke(DataBuffer p0) {
                        for (IAction1 action : new ArrayList(ReliableChannel.this.__onReceiveBinary)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceiveBinary.add(value);
        }
    }

    public void addOnReceiveString(IAction1<String> value) {
        if (value != null) {
            if (this._onReceiveString == null) {
                this._onReceiveString = new IAction1<String>(){

                    @Override
                    public void invoke(String p0) {
                        for (IAction1 action : new ArrayList(ReliableChannel.this.__onReceiveString)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceiveString.add(value);
        }
    }

    public void addOnStateChange(IAction1<ReliableChannel> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<ReliableChannel>(){

                    @Override
                    public void invoke(ReliableChannel p0) {
                        for (IAction1 action : new ArrayList(ReliableChannel.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.__stateLock;
        synchronized (object) {
            this.setState(ReliableChannelState.Closing);
            this.setState(ReliableChannelState.Closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Error dispatch(DataBuffer buffer, long ppi, IAction0 onSuccess, IAction1<Exception> onFailure) {
        SctpMessage message2 = new SctpMessage(buffer, this.getInnerTransportStreamId());
        message2.setUnordered(!this.getOrdered());
        message2.setOnSuccess(onSuccess);
        message2.setOnFailure(onFailure);
        message2.setPayloadType(ppi);
        SctpMessage item = message2;
        Object object = this.__stateLock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)ReliableChannelState.New)) {
                this.__outgoingBuffer.add(item);
                item.setUnordered(false);
                return null;
            }
            if (Global.equals((Object)this.getState(), (Object)ReliableChannelState.Opening)) {
                item.setUnordered(false);
            } else if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.Open)) {
                String str = StringExtensions.format("Reliable Data: Attempting to send data on a channel in state {0}.", this.getState().toString());
                Log.error(StringExtensions.format(str, new Object[0]));
                return new Error(ErrorCode.ReliableDataChannelSendError, new Exception(str));
            }
        }
        try {
            Error error;
            SctpTransport innerTransport = this.getInnerTransport();
            if (innerTransport != null && (error = innerTransport.sendData(item)) != null) {
                return error;
            }
            return null;
        }
        catch (Exception exception) {
            String str = StringExtensions.format("Reliable Data: could not send data: {0}", exception.getMessage());
            Log.error(StringExtensions.format(str, new Object[0]));
            this.setError(new Error(ErrorCode.ReliableDataChannelSendError, new Exception(str)));
            return this.getError();
        }
    }

    public long getBytesReceived() {
        return this.__bytesReceived.getValue();
    }

    public long getBytesSent() {
        return this.__bytesSent.getValue();
    }

    public Error getError() {
        return this._error;
    }

    public SctpTransport getInnerTransport() {
        return this._innerTransport;
    }

    public int getInnerTransportStreamId() {
        return this._innerTransportStreamId;
    }

    public String getLabel() {
        return this._label;
    }

    static long getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier ppi) {
        if (Global.equals((Object)ppi, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcBinary)) {
            return 53L;
        }
        if (Global.equals((Object)ppi, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcDcep)) {
            return 50L;
        }
        if (Global.equals((Object)ppi, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyBinary)) {
            return 57L;
        }
        if (Global.equals((Object)ppi, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyString)) {
            return 56L;
        }
        if (!Global.equals((Object)ppi, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcString)) {
            throw new RuntimeException(new Exception("Reliable Data: Unknown SCTP WebRTC ppi"));
        }
        return 51L;
    }

    public long getMessagesReceived() {
        return this.__messagesReceived.getValue();
    }

    public long getMessagesSent() {
        return this.__messagesSent.getValue();
    }

    public boolean getOrdered() {
        return this._ordered;
    }

    static ReliableSctpPayloadProtocolIdentifier getPpiFromLong(long num) {
        if (num == 53L) {
            return ReliableSctpPayloadProtocolIdentifier.WebRtcBinary;
        }
        if (num == 50L) {
            return ReliableSctpPayloadProtocolIdentifier.WebRtcDcep;
        }
        if (num == 57L) {
            return ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyBinary;
        }
        if (num == 56L) {
            return ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyString;
        }
        if (num != 51L) {
            throw new RuntimeException(new Exception("Reliable Data: Unknown SCTP WebRTC ppi"));
        }
        return ReliableSctpPayloadProtocolIdentifier.WebRtcString;
    }

    public ReliableChannelState getState() {
        return this.__state;
    }

    public String getSubProtocol() {
        return this._subProtocol;
    }

    ReliableChannelType getType() {
        if (this.getOrdered()) {
            return ReliableChannelType.Reliable;
        }
        return ReliableChannelType.ReliableUnordered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Log.debug(StringExtensions.format("Reliable Data: requesting to open channel {0}.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.New)) {
                String str = "Reliable Data: Attempting to open a channel that is not new.";
                Log.error(str);
            } else {
                this.setState(ReliableChannelState.Opening);
                SctpTransport innerTransport = this.getInnerTransport();
                ReliableRtcDcepDataChannelOpen open = new ReliableRtcDcepDataChannelOpen(this.getOrdered() ? ReliableChannelType.Reliable : ReliableChannelType.ReliableUnordered, this.getLabel(), this.getSubProtocol());
                if (innerTransport != null && !innerTransport.getIsClosed()) {
                    SctpMessage message3 = new SctpMessage(DataBuffer.wrap(open.getBytes()), this.getInnerTransportStreamId());
                    message3.setUnordered(false);
                    message3.setPayloadType(ReliableChannel.getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier.WebRtcDcep));
                    SctpMessage message = message3;
                    try {
                        Error error = innerTransport.sendData(message);
                        for (SctpMessage message2 : this.__outgoingBuffer) {
                            message2.setStreamId(this.getInnerTransportStreamId());
                            error = innerTransport.sendData(message2);
                        }
                        this.__outgoingBuffer.clear();
                        if (error != null) {
                            this.setError(error);
                            this.setState(ReliableChannelState.Failed);
                        }
                    }
                    catch (Exception exception) {
                        this.setError(new Error(ErrorCode.ReliableDataChannelOpenError, exception));
                        this.setState(ReliableChannelState.Failed);
                    }
                } else {
                    Log.error("Reliable Data: Inner Sctp transport is either not initialized or is closed.");
                    this.setState(ReliableChannelState.Failed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChannelOpenAck(ReliableRtcDcepDataChannelAck ack) {
        SctpTransport innerTransport = null;
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.Opening)) {
                Log.error(StringExtensions.format("Reliable Data: Received channel open acknowledgement on channel {0}, but this channel is not in the channel requested state.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
            } else {
                innerTransport = this.getInnerTransport();
                if (innerTransport == null || innerTransport.getIsClosed()) {
                    Log.error(StringExtensions.format("Reliable Data: Inner Sctp transport is either not initialized or closed. Cannot process Channel Open Ack message on channel {0}.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
                    this.setState(ReliableChannelState.Failed);
                } else {
                    this.__outgoingBuffer.clear();
                    this.setState(ReliableChannelState.Open);
                    Log.debug(StringExtensions.format("Reliable Data: remote party confirmed opening channel {0}.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
                }
            }
        }
    }

    private void raiseError(Exception exception) {
        IAction1<Exception> onError = this._onError;
        if (onError != null) {
            onError.invoke(exception);
        }
    }

    private void raiseReceiveBinary(DataBuffer buffer) {
        IAction1<DataBuffer> onReceiveBinary = this._onReceiveBinary;
        if (onReceiveBinary != null) {
            onReceiveBinary.invoke(buffer);
        }
    }

    private void raiseReceiveString(String msg) {
        IAction1<String> onReceiveString = this._onReceiveString;
        if (onReceiveString != null) {
            onReceiveString.invoke(msg);
        }
    }

    private void raiseStateChange() {
        IAction1<ReliableChannel> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this);
        }
    }

    public void receiveSctpMessage(SctpMessage msg) {
        ReliableSctpPayloadProtocolIdentifier ppiFromLong = ReliableChannel.getPpiFromLong(msg.getPayloadType());
        try {
            if (Global.equals((Object)this.getState(), (Object)ReliableChannelState.Open) || !Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcDcep)) {
                String str = null;
                DataBuffer payload = null;
                if (Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyString)) {
                    str = StringExtensions.empty;
                    this.__bytesReceived.add(1L);
                } else if (Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcString)) {
                    str = msg.getPayload().readUtf8String(0);
                    this.__bytesReceived.add(msg.getPayload().getLength());
                } else if (Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyBinary)) {
                    payload = DataBuffer.wrap(new byte[0]);
                    this.__bytesReceived.add(1L);
                } else if (Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcBinary)) {
                    payload = msg.getPayload();
                    this.__bytesReceived.add(msg.getPayload().getLength());
                } else {
                    if (Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcDcep)) {
                        throw new RuntimeException(new Exception("Reliable Data: received a webrtc dcep message on an open channel. This scenario is not supported."));
                    }
                    throw new RuntimeException(new Exception("Reliable Data: received a reliable data message of an unknown type."));
                }
                this.__messagesReceived.increment();
                if (str != null) {
                    this.raiseReceiveString(str);
                } else {
                    this.raiseReceiveBinary(payload);
                }
            } else if (Global.equals((Object)ppiFromLong, (Object)ReliableSctpPayloadProtocolIdentifier.WebRtcDcep)) {
                ReliableRtcDcepMessage message = ReliableRtcDcepMessage.parseBytes(msg.getPayload());
                if (message == null) {
                    throw new RuntimeException(new Exception("Reliable Data: received an invalid webrtc message"));
                }
                if (message.getMessageType() == 3) {
                    try {
                        this.respondToOpenRequest((ReliableRtcDcepDataChannelOpen)message);
                    }
                    catch (Exception exception1) {
                        Exception exception = exception1;
                        Log.error(StringExtensions.format("Reliable Data: could not process incoming channel open request: {0}", exception.getMessage()));
                    }
                } else {
                    if (message.getMessageType() != 2) {
                        throw new RuntimeException(new Exception("Reliable Data: received an invalid webrtc message."));
                    }
                    try {
                        this.processChannelOpenAck((ReliableRtcDcepDataChannelAck)message);
                    }
                    catch (Exception exception2) {
                        Exception exception = exception2;
                        Log.error(StringExtensions.format("Reliable Data: could not process incoming channel open acknowledgement: {0}", exception.getMessage()));
                    }
                }
            }
        }
        catch (Exception exception3) {
            Exception exception = exception3;
            Log.error("Reliable Data: Could not process new data.", exception);
        }
    }

    public ReliableChannel(String label, boolean ordered) {
        this(label, ordered, StringExtensions.empty);
    }

    public ReliableChannel(String label, boolean ordered, String subprotocol) {
        this.__bytesSent = new AtomicLong();
        this.__messagesSent = new AtomicLong();
        this.__bytesReceived = new AtomicLong();
        this.__messagesReceived = new AtomicLong();
        this.__outgoingBuffer = new ArrayList();
        this.setLabel(label);
        this.setOrdered(ordered);
        this.setSubProtocol(subprotocol);
        this.setInnerTransportStreamId(_unset);
        this.setState(ReliableChannelState.New);
    }

    public ReliableChannel(String label) {
        this(label, true);
    }

    public ReliableChannel() {
        this(StringExtensions.empty);
    }

    public void removeOnError(IAction1<Exception> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onError, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onError.remove(value);
        if (this.__onError.size() == 0) {
            this._onError = null;
        }
    }

    public void removeOnReceiveBinary(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveBinary, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveBinary.remove(value);
        if (this.__onReceiveBinary.size() == 0) {
            this._onReceiveBinary = null;
        }
    }

    public void removeOnReceiveString(IAction1<String> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveString, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveString.remove(value);
        if (this.__onReceiveString.size() == 0) {
            this._onReceiveString = null;
        }
    }

    public void removeOnStateChange(IAction1<ReliableChannel> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean respondToOpenRequest(ReliableRtcDcepDataChannelOpen channelOpenRequest) {
        var2_2 = this.__stateLock;
        synchronized (var2_2) {
            if (!Global.equals((Object)this.getState(), (Object)ReliableChannelState.New)) {
                Log.error(StringExtensions.format("Reliable Data: Received channel open request on channel {0}, which is not in the New state. Check channel ownership convention.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
                this.setState(ReliableChannelState.Failed);
                return false;
            }
            channelType = channelOpenRequest.getChannelType();
            if (Global.equals((Object)channelType, (Object)ReliableChannelType.Reliable) || Global.equals((Object)channelType, (Object)ReliableChannelType.PartialReliableREXMIT) || Global.equals((Object)channelType, (Object)ReliableChannelType.PartialReliableTimed)) {
                this.setOrdered(true);
            } else {
                if (!(Global.equals((Object)channelType, (Object)ReliableChannelType.ReliableUnordered) || Global.equals((Object)channelType, (Object)ReliableChannelType.PartialReliableREXMITUnordered) || Global.equals((Object)channelType, (Object)ReliableChannelType.PartialReliableTimedUnordered))) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Reliable Data: received open request for a channel of an unknown type {0}", channelType.toString())));
                }
                this.setOrdered(false);
            }
            this.setSubProtocol(channelOpenRequest.getSubProtocol());
            this.setLabel(channelOpenRequest.getLabel());
            Log.debug(StringExtensions.format("Reliable Data: opening channel {0} on request.", IntegerExtensions.toString(this.getInnerTransportStreamId())));
            innerTransport = this.getInnerTransport();
            ack = new ReliableRtcDcepDataChannelAck();
            if (innerTransport != null) {
                message2 = new SctpMessage(DataBuffer.wrap(ack.getBytes()), this.getInnerTransportStreamId());
                message2.setUnordered(false);
                message2.setPayloadType(ReliableChannel.getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier.WebRtcDcep));
                message = message2;
                try {
                    error = innerTransport.sendData(message);
                    if (error == null) ** GOTO lbl41
                    this.setError(error);
                    this.setState(ReliableChannelState.Failed);
                }
                catch (Exception exception1) {
                    exception = exception1;
                    this.setError(new Error(ErrorCode.ReliableDataChannelOpenError, exception));
                    this.setState(ReliableChannelState.Failed);
                    return false;
                }
            } else {
                str = "Reliable Data: Inner Sctp transport is not initialized.";
                Log.error(str);
                this.setError(new Error(ErrorCode.ReliableDataChannelOpenError, new Exception(str)));
                this.setState(ReliableChannelState.Failed);
                return false;
            }
lbl41:
            // 3 sources

            for (SctpMessage message3 : this.__outgoingBuffer) {
                try {
                    message3.setStreamId(this.getInnerTransportStreamId());
                    error = innerTransport.sendData(message3);
                    if (error == null) continue;
                    this.setError(error);
                    this.setState(ReliableChannelState.Failed);
                    return false;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    this.setError(new Error(ErrorCode.ReliableDataChannelOpenError, exception));
                    this.setState(ReliableChannelState.Failed);
                    return false;
                }
            }
            this.__outgoingBuffer.clear();
            this.setState(ReliableChannelState.Opening);
            this.setState(ReliableChannelState.Open);
        }
        return true;
    }

    public void sendBytes(DataBuffer buffer, IAction0 onSuccess, IAction1<Exception> onFailure) {
        long longFromSctpPPI;
        if (buffer == null | buffer.getLength() == 0) {
            longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyBinary);
            buffer = DataBuffer.wrap(new byte[1]);
        } else {
            longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier.WebRtcBinary);
        }
        Error error = this.dispatch(buffer, longFromSctpPPI, onSuccess, onFailure);
        if (error == null) {
            this.__bytesSent.add(buffer.getLength());
            this.__messagesSent.increment();
        } else {
            IAction1<Exception> action = onFailure;
            if (action != null) {
                action.invoke(error.getException());
            }
            this.setError(error);
            this.setState(ReliableChannelState.Failed);
        }
    }

    public void sendBytes(DataBuffer buffer) {
        this.sendBytes(buffer, null, null);
    }

    public void sendString(String message, IAction0 onSuccess, IAction1<Exception> onFailure) {
        long longFromSctpPPI;
        DataBuffer buffer;
        if (message == null | StringExtensions.getLength(message) == 0) {
            buffer = DataBuffer.wrap(new byte[1]);
            longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier.WebRtcEmptyString);
        } else {
            buffer = DataBuffer.wrap(Utf8.encode(message));
            longFromSctpPPI = ReliableChannel.getLongFromSctpPPI(ReliableSctpPayloadProtocolIdentifier.WebRtcString);
        }
        Error error = this.dispatch(buffer, longFromSctpPPI, onSuccess, onFailure);
        if (error == null) {
            this.__bytesSent.add(buffer.getLength());
            this.__messagesSent.increment();
        } else {
            IAction1<Exception> action = onFailure;
            if (action != null) {
                action.invoke(error.getException());
            }
            this.setError(error);
            this.setState(ReliableChannelState.Failed);
        }
    }

    public void sendString(String message) {
        this.sendString(message, null, null);
    }

    private void setError(Error value) {
        this._error = value;
    }

    public void setInnerTransport(SctpTransport value) {
        this._innerTransport = value;
    }

    void setInnerTransportStreamId(int value) {
        this._innerTransportStreamId = value;
    }

    private void setLabel(String value) {
        this._label = value;
    }

    private void setOrdered(boolean value) {
        this._ordered = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ReliableChannelState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)value, (Object)this.getState())) {
                this.__state = value;
                this.raiseStateChange();
            }
        }
    }

    private void setSubProtocol(String value) {
        this._subProtocol = value;
    }
}

