/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicInteger;
import fm.icelink.Holder;
import fm.icelink.IFunction0;
import fm.icelink.ManagedConcurrentStack;

public class Pool<T> {
    private IFunction0<T> __createObject;
    private AtomicInteger __createObjectCounter;
    private ManagedConcurrentStack<T> __stack;
    private int _maxSize;
    private int _minSize;

    public T get() {
        T result = null;
        Holder<Object> _var0 = new Holder<Object>(result);
        boolean _var1 = this.__stack.tryPop(_var0);
        result = _var0.getValue();
        if (_var1) {
            return result;
        }
        if (this.__createObjectCounter.increment() > this.getMaxSize()) {
            this.__createObjectCounter.decrement();
            throw new RuntimeException(new Exception("Could not create pooled object. Maximum size reached."));
        }
        return this.__createObject.invoke();
    }

    public int getAvailable() {
        return this.__stack.getCount();
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getSize() {
        return this.__createObjectCounter.getValue();
    }

    public Pool(IFunction0<T> createObject, int minSize) {
        this(createObject, minSize, Integer.MAX_VALUE);
    }

    public Pool(IFunction0<T> createObject, int minSize, int maxSize) {
        if (createObject == null) {
            throw new RuntimeException(new Exception("Cannot initialize pool without a function to create objects."));
        }
        if (minSize < 0) {
            throw new RuntimeException(new Exception("Minimum pool size cannot be less than zero."));
        }
        if (maxSize < 0) {
            throw new RuntimeException(new Exception("Maximum pool size cannot be less than zero."));
        }
        if (minSize > maxSize) {
            throw new RuntimeException(new Exception("Minimum pool size cannot be greater than maximum pool size."));
        }
        this.__createObject = createObject;
        this.setMinSize(minSize);
        this.setMaxSize(maxSize);
        this.__stack = new ManagedConcurrentStack();
        this.__createObjectCounter = new AtomicInteger();
        for (int i = 0; i < this.getMinSize(); ++i) {
            this.__createObjectCounter.increment();
            this.__stack.push(this.__createObject.invoke());
        }
    }

    public Pool(IFunction0<T> createObject) {
        this(createObject, 0);
    }

    public void put(T item) {
        if (item != null) {
            this.__stack.push(item);
        }
    }

    private void setMaxSize(int value) {
        this._maxSize = value;
    }

    private void setMinSize(int value) {
        this._minSize = value;
    }
}

