/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioTrack;
import fm.icelink.BandwidthAdaptationPolicy;
import fm.icelink.Collection;
import fm.icelink.CoreTransport;
import fm.icelink.DateExtensions;
import fm.icelink.DispatchQueue;
import fm.icelink.EncryptionMode;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.FirControlFrame;
import fm.icelink.FirEntry;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.ILog;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaInputCollection;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaOutputCollection;
import fm.icelink.IMediaTransport;
import fm.icelink.IOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.JitterConfig;
import fm.icelink.JsonSerializer;
import fm.icelink.LocalMedia;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaHeaderExtensionPolicy;
import fm.icelink.MediaStreamBase;
import fm.icelink.MediaStreamStats;
import fm.icelink.MediaTrackStats;
import fm.icelink.MediaTransportState;
import fm.icelink.NackConfig;
import fm.icelink.NackPolicy;
import fm.icelink.PliControlFrame;
import fm.icelink.ProcessFramePolicy;
import fm.icelink.Promise;
import fm.icelink.RedFecConfig;
import fm.icelink.RedFecPolicy;
import fm.icelink.RembPolicy;
import fm.icelink.RemoteMedia;
import fm.icelink.ReportBlock;
import fm.icelink.ReportControlFrame;
import fm.icelink.RtpHeaderExtensionRegistry;
import fm.icelink.RtpHeaderExtensionRegistryElement;
import fm.icelink.RtpHeaderExtensionType;
import fm.icelink.RtpParameters;
import fm.icelink.RtpTransport;
import fm.icelink.Scheduler;
import fm.icelink.Stream;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;
import fm.icelink.VideoTrack;
import fm.icelink.sdp.Bandwidth;
import fm.icelink.sdp.DirectionAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.rtcp.Attribute;
import fm.icelink.sdp.rtcp.FeedbackAttribute;
import fm.icelink.sdp.rtcp.FeedbackAttributeType;
import fm.icelink.sdp.rtcp.MuxAttribute;
import fm.icelink.sdp.rtp.ExtMapAttribute;
import fm.icelink.sdp.rtp.MapAttribute;
import fm.icelink.sdp.rtp.Media;
import fm.icelink.sdp.rtp.SsrcAttribute;
import fm.icelink.sdp.rtp.SsrcAttributeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class MediaStream<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIOutputCollection extends IMediaOutputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIOutputCollection>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInputCollection extends IMediaInputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIInputCollection>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaStreamBase
implements IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private StreamDirection __absoluteSenderTimeLocalDirection;
    private StreamDirection __absoluteSenderTimeRemoteDirection;
    private BandwidthAdaptationPolicy __bandwidthAdaptationPolicy;
    private ArrayList<TFormat> __disabledInputFormats;
    private DispatchQueue<TFrame> __dispatchQueue;
    private int __firSequenceNumber = 0;
    private ArrayList<TFormat> __inputFormats;
    private Object __inputFormatsLock;
    private TIOutputCollection __inputs;
    private long __lastBitrateChange;
    private int __lastBitrateSet = -1;
    private TFormatCollection __localFormatRegistry;
    private static ILog __log = Log.getLogger("FM.IceLink.MediaStream");
    private NackConfig __nackConfig;
    private NackPolicy __nackPolicy;
    private List<IAction1<Stream>> __onBandwidthAdaptationPolicyStateChange = new ArrayList<IAction1<Stream>>();
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private TIInputCollection __outputs;
    private ArrayList<TFormat> __payloadTypeRegistry = new ArrayList();
    private ArrayList<String> __payloadTypesRegisteredByOtherStreams;
    private ProcessFramePolicy __processPolicy;
    private RedFecConfig __redFecConfig;
    private RedFecPolicy __redFecPolicy;
    private RembPolicy __rembPolicy;
    private TFormatCollection __remoteFormatRegistry;
    private HashMap<Integer, Integer> __remoteSupportedRembPayloadTypes;
    private boolean __remoteSupportsFec = false;
    private boolean __remoteSupportsFir = false;
    private boolean __remoteSupportsPli = false;
    private boolean __remoteSupportsRtcpFeedback = true;
    private RtpHeaderExtensionRegistry __rtpHeaderExtensionRegistry;
    private int __rtpPayloadTypeDynamicOffset = 96;
    private int __rtpPayloadTypeMaxOffset = 127;
    private RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> __rtpTransport;
    private boolean __startedOriginalNegotiation = false;
    private HashMap<String, TFormat> __wellKnownPayloadTypes;
    private MediaHeaderExtensionPolicy _absoluteSenderTimePolicy;
    private boolean _disableAutomaticReports;
    private TFormat _inputFormat;
    private JitterConfig _jitterConfig;
    private LocalMedia _localMedia;
    private boolean _multiplexingSupported;
    private IAction1<Stream> _onBandwidthAdaptationPolicyStateChange = null;
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = null;
    private IAction1<TFrame> _onProcessFrame = null;
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = null;
    private IAction1<TFrame> _onRaiseFrame = null;
    private TFormat _outputFormat;
    private volatile boolean _processingFrame = false;
    private RemoteMedia _remoteMedia;
    private RtpParameters<TFormat, TFormatCollection> _rtpParameters;

    @Override
    public void addInput(TIOutput input) {
        if (input == null) {
            throw new RuntimeException(new Exception("Received null input in the media stream."));
        }
        ((Collection)this.__inputs).add(input);
    }

    @Override
    public void addInputs(TIOutput[] inputs) {
        if (inputs == null) {
            throw new RuntimeException(new Exception("Received null inputs in the media stream."));
        }
        ((Collection)this.__inputs).addMany(inputs);
    }

    private void addLocalFormat(TFormat format) {
        TFormat equivalent;
        int registeredPayloadType = ((MediaFormat)format).getRegisteredPayloadType();
        if (((Collection)this.__remoteFormatRegistry).getCount() > 0 && (equivalent = ((MediaFormatCollection)this.__remoteFormatRegistry).getEquivalent(format)) != null) {
            ((MediaFormat)format).setRegisteredPayloadType(((MediaFormat)equivalent).getRegisteredPayloadType());
            registeredPayloadType = ((MediaFormat)equivalent).getRegisteredPayloadType();
        }
        if (((MediaFormat)format).getRegisteredPayloadType() >= 0) {
            ((Collection)this.__localFormatRegistry).add(format);
            if (!this.payloadTypeIsRegistered(registeredPayloadType) && ((MediaFormat)format).getRegisteredPayloadType() >= 0) {
                this.__payloadTypeRegistry.add(format);
            }
        }
    }

    void addOnBandwidthAdaptationPolicyStateChange(IAction1<Stream> value) {
        if (value != null) {
            if (this._onBandwidthAdaptationPolicyStateChange == null) {
                this._onBandwidthAdaptationPolicyStateChange = new IAction1<Stream>(){

                    @Override
                    public void invoke(Stream p0) {
                        for (IAction1 action : new ArrayList(MediaStream.this.__onBandwidthAdaptationPolicyStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onBandwidthAdaptationPolicyStateChange.add(value);
        }
    }

    @Override
    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onProcessControlFrames == null) {
                this._onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(MediaStream.this.__onProcessControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onProcessControlFrames.add(value);
        }
    }

    @Override
    public void addOnProcessFrame(IAction1<TFrame> value) {
        if (value != null) {
            if (this._onProcessFrame == null) {
                this._onProcessFrame = new IAction1<TFrame>(){

                    @Override
                    public void invoke(TFrame p0) {
                        for (IAction1 action : new ArrayList(MediaStream.this.__onProcessFrame)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onProcessFrame.add(value);
        }
    }

    @Override
    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onRaiseControlFrames == null) {
                this._onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(MediaStream.this.__onRaiseControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onRaiseControlFrames.add(value);
        }
    }

    @Override
    public void addOnRaiseFrame(IAction1<TFrame> value) {
        if (value != null) {
            if (this._onRaiseFrame == null) {
                this._onRaiseFrame = new IAction1<TFrame>(){

                    @Override
                    public void invoke(TFrame p0) {
                        for (IAction1 action : new ArrayList(MediaStream.this.__onRaiseFrame)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onRaiseFrame.add(value);
        }
    }

    @Override
    public void addOutput(TIInput output) {
        if (output == null) {
            throw new RuntimeException(new Exception("Received null output in the media stream."));
        }
        ((Collection)this.__outputs).add(output);
    }

    @Override
    public void addOutputs(TIInput[] outputs) {
        if (outputs == null) {
            throw new RuntimeException(new Exception("Received null outputs in the media stream."));
        }
        ((Collection)this.__outputs).addMany(outputs);
    }

    public Future<Object> changeInputFormat(TFormat inputFormat) {
        Promise<Object> promise = new Promise<Object>();
        this.doChangeInputFormat(inputFormat, promise);
        return promise;
    }

    private StreamDirection convertToHeaderExtensionDirection(boolean send, boolean receive) {
        if (send && receive) {
            return StreamDirection.SendReceive;
        }
        if (send) {
            return StreamDirection.SendOnly;
        }
        if (receive) {
            return StreamDirection.ReceiveOnly;
        }
        return StreamDirection.Inactive;
    }

    protected abstract TFormat createFormat(String var1, int var2, String var3, int var4);

    protected abstract TFormat createFormat(MapAttribute var1);

    protected abstract TIInputCollection createInputCollection(TIOutput var1);

    protected abstract TFormatCollection createMediaFormatCollection();

    protected abstract TIOutputCollection createOutputCollection(TIInput var1);

    private RtpHeaderExtensionRegistry createRtpHeaderRegistry() {
        StreamDirection direction;
        RtpHeaderExtensionRegistry registry = new RtpHeaderExtensionRegistry();
        boolean send = false;
        boolean receive = false;
        if (Global.equals((Object)this.getAbsoluteSenderTimePolicy(), (Object)MediaHeaderExtensionPolicy.Negotiated)) {
            boolean flag3 = Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.ReceiveOnly) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset);
            send = (Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset)) && !Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.ReceiveOnly);
            boolean bl = receive = flag3 && !Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.SendOnly);
        }
        if (!Global.equals((Object)(direction = this.convertToHeaderExtensionDirection(send, receive)), (Object)StreamDirection.Inactive)) {
            registry.register(RtpHeaderExtensionType.AbsSendTime, direction, "http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time");
        }
        return registry;
    }

    @Override
    public MediaDescription createSdpMediaDescription(Message sdpMessage, boolean supportSdes, boolean isOffer, boolean renegotiation) {
        fm.icelink.sdp.Attribute[] attributeArray;
        StreamDirection localDirection;
        this.getRtpParameters().setCanonicalName(super.getCanonicalName());
        MediaDescription description = super.createSdpMediaDescription(sdpMessage, supportSdes, isOffer, renegotiation);
        if (this.getMultiplexingSupported()) {
            description.addMediaAttribute(new MuxAttribute());
        }
        if (!Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.Inactive)) {
            CoreTransport coreTransport;
            String connectionAddress = "0.0.0.0";
            int port = 9;
            CoreTransport coreTransport2 = coreTransport = super.getCoreTransportRtcp() == null ? super.getCoreTransportRtp() : super.getCoreTransportRtcp();
            if (coreTransport != null) {
                MediaDescription[] address = super.obtainLikelyTransportAddress(coreTransport);
                connectionAddress = address.getIPAddress();
                port = address.getPort();
            } else {
                port = 0;
            }
            description.addMediaAttribute(new Attribute(super.getDisabled() ? 0 : port, connectionAddress));
        }
        StreamDirection streamDirection = localDirection = isOffer && super.getRenegotiationPending() ? super.getPendingLocalDirection() : this.getDirection();
        if (!renegotiation) {
            if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.Unset)) {
                this.setLocalDirection(this.getDirectionCapabilities());
            } else if (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.ReceiveOnly)) {
                if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.SendOnly)) {
                    this.setLocalDirection(StreamDirection.Inactive);
                }
            } else if (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.SendOnly)) {
                if (Global.equals((Object)this.getLocalDirection(), (Object)StreamDirection.ReceiveOnly)) {
                    this.setLocalDirection(StreamDirection.Inactive);
                }
            } else if (Global.equals((Object)this.getDirectionCapabilities(), (Object)StreamDirection.Inactive)) {
                this.setLocalDirection(StreamDirection.Inactive);
            }
            localDirection = isOffer ? this.getLocalDirection() : this.getDirection();
        }
        StreamDirection direction2 = localDirection;
        DirectionAttribute attribute = DirectionAttribute.generateDirectionAttribute(direction2);
        description.addMediaAttribute(attribute);
        for (MediaDescription mediaDescription : sdpMessage.getMediaDescriptions()) {
            fm.icelink.sdp.Attribute[] rtpMapAttributes;
            for (fm.icelink.sdp.Attribute attribute2 : rtpMapAttributes = mediaDescription.getRtpMapAttributes()) {
                MapAttribute attribute3 = (MapAttribute)attribute2;
                this.__payloadTypesRegisteredByOtherStreams.add(IntegerExtensions.toString(attribute3.getPayloadType()));
            }
        }
        this.registerPayloadTypes();
        description.getMedia().setMediaType(MediaType.fromStreamType(super.getType()));
        description.getMedia().setTransportProtocol(Media.generateRtpProfile(super.getType(), this.__remoteSupportsRtcpFeedback, super.getUseDtls(), !Global.equals((Object)super.getEncryptionMode(), (Object)EncryptionMode.Null)));
        description.getMedia().setFormatDescription(this.obtainFormatDescriptions());
        MapAttribute attribute4 = null;
        boolean flag = Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated);
        boolean flag2 = Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Negotiated);
        for (MediaFormat local : (MediaFormat[])((Collection)this.__localFormatRegistry).getValues()) {
            FeedbackAttribute attribute5;
            if (!this.payloadTypeIsRegistered(local.getRegisteredPayloadType())) continue;
            boolean flag3 = this.formatIsFec(local.getName());
            if (!flag3 || flag3 && flag) {
                attribute4 = new MapAttribute(local.getRegisteredPayloadType(), local.getName(), local.getClockRate(), local.getParameters());
                description.addMediaAttribute(attribute4);
                if (flag2 && !flag3) {
                    attribute5 = new FeedbackAttribute(local.getRegisteredPayloadType(), FeedbackAttributeType.getNack());
                    attribute4.addRelatedRtcpFeedbackAttribute(attribute5);
                }
            }
            if (Global.equals((Object)this.getRembPolicy(), (Object)RembPolicy.Disabled)) continue;
            attribute5 = new FeedbackAttribute(local.getRegisteredPayloadType(), FeedbackAttributeType.getRemb());
            attribute4.addRelatedRtcpFeedbackAttribute(attribute5);
        }
        for (Bandwidth bandwidth : description.getBandwidths()) {
            description.removeBandwidth(bandwidth);
        }
        if (super.getLocalBandwidth() > 0) {
            description.addBandwidth(new Bandwidth("TIAS", super.getLocalBandwidth() * 1024));
            description.addBandwidth(new Bandwidth("AS", super.getLocalBandwidth()));
        }
        for (fm.icelink.sdp.Attribute attribute2 : attributeArray = this.obtainRtpExtMapAttributes(isOffer, renegotiation)) {
            description.addMediaAttribute(attribute2);
        }
        return description;
    }

    @Override
    public boolean destroy() {
        super.removeOnDirectionChange(new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.MediaStream<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.setRtpTransportDirection";
            }

            @Override
            public void invoke() {
                MediaStream.this.setRtpTransportDirection();
            }
        });
        if (this.__rtpTransport != null) {
            this.__rtpTransport.removeOnSendControlFrames(this._onProcessControlFrames);
        }
        ((IMediaInputCollection)this.__outputs).destroy();
        ((IMediaOutputCollection)this.__inputs).destroy();
        return true;
    }

    public Future<Object> disableInputFormat(TFormat inputFormat) {
        Promise<Object> promise = new Promise<Object>();
        this.doDisableInputFormat(inputFormat, promise);
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeInputFormat(TFormat inputFormat) {
        Object object = this.__inputFormatsLock;
        synchronized (object) {
            if (this.getInputFormat() != inputFormat) {
                if (inputFormat != null && !this.__inputFormats.contains(inputFormat)) {
                    throw new RuntimeException(new Exception("Unrecognized input format."));
                }
                this.setInputFormat(null);
                while (this._processingFrame) {
                    ManagedThread.sleep(1);
                }
                this.setInputFormat(inputFormat);
            }
        }
    }

    private void doChangeInputFormat(TFormat inputFormat, Promise<Object> promise) {
        ManagedThread.dispatch(new IAction0((MediaFormat)inputFormat, promise){
            final /* synthetic */ MediaFormat val$inputFormat;
            final /* synthetic */ Promise val$promise;
            {
                this.val$inputFormat = mediaFormat;
                this.val$promise = promise;
            }

            @Override
            public void invoke() {
                try {
                    MediaStream.this.doChangeInputFormat(this.val$inputFormat);
                    this.val$promise.resolve(null);
                }
                catch (Exception exception) {
                    this.val$promise.reject(exception);
                }
            }
        });
    }

    private void doDisableInputFormat(TFormat inputFormat, Promise<Object> promise) {
        ManagedThread.dispatch(new IAction0((MediaFormat)inputFormat, promise){
            final /* synthetic */ MediaFormat val$inputFormat;
            final /* synthetic */ Promise val$promise;
            {
                this.val$inputFormat = mediaFormat;
                this.val$promise = promise;
            }

            @Override
            public void invoke() {
                try {
                    MediaStream.this.doDisableInputFormat(this.val$inputFormat);
                    this.val$promise.resolve(null);
                }
                catch (Exception exception) {
                    this.val$promise.reject(exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisableInputFormat(TFormat inputFormat) {
        Object object = this.__inputFormatsLock;
        synchronized (object) {
            if (!this.__disabledInputFormats.contains(inputFormat)) {
                if (!this.__inputFormats.contains(inputFormat)) {
                    throw new RuntimeException(new Exception("Unrecognized input format."));
                }
                this.__inputFormats.remove(inputFormat);
                this.__disabledInputFormats.add(inputFormat);
                this.doChangeInputFormat(ArrayListExtensions.getCount(this.__inputFormats) > 0 ? (MediaFormat)ArrayListExtensions.getItem(this.__inputFormats).get(0) : null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnableInputFormat(TFormat inputFormat) {
        Object object = this.__inputFormatsLock;
        synchronized (object) {
            if (!this.__inputFormats.contains(inputFormat)) {
                if (!this.__disabledInputFormats.contains(inputFormat)) {
                    throw new RuntimeException(new Exception("Unrecognized input format."));
                }
                this.__disabledInputFormats.remove(inputFormat);
                this.__inputFormats.add(inputFormat);
            }
        }
    }

    private void doEnableInputFormat(TFormat inputFormat, Promise<Object> promise) {
        ManagedThread.dispatch(new IAction0((MediaFormat)inputFormat, promise){
            final /* synthetic */ MediaFormat val$inputFormat;
            final /* synthetic */ Promise val$promise;
            {
                this.val$inputFormat = mediaFormat;
                this.val$promise = promise;
            }

            @Override
            public void invoke() {
                try {
                    MediaStream.this.doEnableInputFormat(this.val$inputFormat);
                    this.val$promise.resolve(null);
                }
                catch (Exception exception) {
                    this.val$promise.reject(exception);
                }
            }
        });
    }

    public Future<Object> enableInputFormat(TFormat inputFormat) {
        Promise<Object> promise = new Promise<Object>();
        this.doEnableInputFormat(inputFormat, promise);
        return promise;
    }

    private MediaControlFrame[] filterOutboundControlFrames(MediaControlFrame[] controlFrames) {
        ArrayList<MediaControlFrame> list = new ArrayList<MediaControlFrame>();
        for (MediaControlFrame frame : controlFrames) {
            if (!this.__remoteSupportsPli && frame instanceof PliControlFrame) {
                if (this.__remoteSupportsFir) {
                    list.add(new FirControlFrame(new FirEntry(this.getFirSequenceNumber())));
                    continue;
                }
                __log.debug("Discarding outbound PLI control frame (no support on remote).");
                continue;
            }
            if (!this.__remoteSupportsFir && frame instanceof FirControlFrame) {
                if (this.__remoteSupportsPli) {
                    list.add(new PliControlFrame());
                    continue;
                }
                __log.debug("Discarding outbound FIR control frame (no support on remote).");
                continue;
            }
            list.add(frame);
        }
        return list.toArray(new MediaControlFrame[0]);
    }

    protected abstract TFormat[] formatArrayFromList(ArrayList<TFormat> var1);

    private boolean formatIsFec(String formatName) {
        return Global.equals(formatName, MediaFormat.getRedName()) || Global.equals(formatName, MediaFormat.getUlpFecName());
    }

    public StreamDirection getAbsoluteSenderTimeDirection() {
        if (!Global.equals((Object)this.getAbsoluteSenderTimePolicy(), (Object)MediaHeaderExtensionPolicy.Disabled)) {
            if (Global.equals((Object)this.getAbsoluteSenderTimeRemoteDirection(), (Object)StreamDirection.Unset)) {
                return this.getAbsoluteSenderTimeLocalDirection();
            }
            if (Global.equals((Object)this.getAbsoluteSenderTimeRemoteDirection(), (Object)StreamDirection.Inactive)) {
                return StreamDirection.Inactive;
            }
            if (Global.equals((Object)this.getAbsoluteSenderTimeRemoteDirection(), (Object)StreamDirection.SendReceive)) {
                return Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset) ? StreamDirection.SendReceive : this.getAbsoluteSenderTimeLocalDirection();
            }
            if (Global.equals((Object)this.getAbsoluteSenderTimeRemoteDirection(), (Object)StreamDirection.SendOnly)) {
                if (Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.ReceiveOnly) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendReceive)) {
                    return StreamDirection.ReceiveOnly;
                }
                return StreamDirection.Inactive;
            }
            if (!Global.equals((Object)this.getAbsoluteSenderTimeRemoteDirection(), (Object)StreamDirection.ReceiveOnly)) {
                throw new RuntimeException(new Exception("Invalid case encountered while trying to identify AbsoluteSenderTimeDirection."));
            }
            if (Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendReceive)) {
                return StreamDirection.SendOnly;
            }
        }
        return StreamDirection.Inactive;
    }

    public StreamDirection getAbsoluteSenderTimeLocalDirection() {
        return this.__absoluteSenderTimeLocalDirection;
    }

    MediaHeaderExtensionPolicy getAbsoluteSenderTimePolicy() {
        return this._absoluteSenderTimePolicy;
    }

    public StreamDirection getAbsoluteSenderTimeRemoteDirection() {
        return this.__absoluteSenderTimeRemoteDirection;
    }

    public BandwidthAdaptationPolicy getBandwidthAdaptationPolicy() {
        return this.__bandwidthAdaptationPolicy;
    }

    @Override
    StreamDirection getDirectionCapabilities() {
        boolean flag2;
        boolean flag = ArrayExtensions.getLength(this.getInputs()) > 0;
        boolean bl = flag2 = ArrayExtensions.getLength(this.getOutputs()) > 0;
        if (flag && flag2) {
            return StreamDirection.SendReceive;
        }
        if (flag) {
            return StreamDirection.SendOnly;
        }
        if (flag2) {
            return StreamDirection.ReceiveOnly;
        }
        return StreamDirection.Inactive;
    }

    public boolean getDisableAutomaticReports() {
        return this._disableAutomaticReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat[] getDisabledInputFormats() {
        Object object = this.__inputFormatsLock;
        synchronized (object) {
            return this.formatArrayFromList(this.__disabledInputFormats);
        }
    }

    @Override
    public int getFirSequenceNumber() {
        return this.__firSequenceNumber;
    }

    @Override
    public TIOutput getInput() {
        return (TIOutput)((IMediaOutput)((Collection)this.__inputs).getValue());
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFormat[] getInputFormats() {
        Object object = this.__inputFormatsLock;
        synchronized (object) {
            return this.formatArrayFromList(this.__inputFormats);
        }
    }

    @Override
    public TIOutput[] getInputs() {
        return (IMediaOutput[])((Collection)this.__inputs).getValues();
    }

    public JitterConfig getJitterConfig() {
        return this._jitterConfig;
    }

    public LocalMedia getLocalMedia() {
        return this._localMedia;
    }

    @Override
    public int getMaxInputBitrate() {
        long currentTime = Scheduler.getCurrentTime();
        if (this.__lastBitrateSet < 0 || currentTime - 1000L > this.__lastBitrateChange) {
            int num2;
            this.__lastBitrateChange = currentTime;
            int n = num2 = this.getRtpTransport() == null ? -1 : (int)(this.getRtpTransport().getEstimatedUpstreamBitrate() / 1024L);
            this.__lastBitrateSet = num2 < 0 ? super.getRemoteBandwidth() : (super.getRemoteBandwidth() < 0 ? num2 : MathAssistant.min(num2, super.getRemoteBandwidth()));
        }
        return this.__lastBitrateSet;
    }

    @Override
    public int getMaxOutputBitrate() {
        int maxInputBitrate = -1;
        for (IMediaInput local : this.getOutputs()) {
            if (maxInputBitrate < 0) {
                maxInputBitrate = local.getMaxInputBitrate();
                continue;
            }
            if (local.getMaxInputBitrate() < 0) continue;
            maxInputBitrate = MathAssistant.min(local.getMaxInputBitrate(), maxInputBitrate);
        }
        return maxInputBitrate;
    }

    public boolean getMultiplexed() {
        return super.getCoreTransportRtcp() == null;
    }

    public boolean getMultiplexingSupported() {
        return this._multiplexingSupported;
    }

    @Override
    public boolean getMuted() {
        return this.processGetMuteFromStream();
    }

    public NackConfig getNackConfig() {
        if (this.__nackConfig == null) {
            boolean flag = false;
            if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                flag = true;
            } else if (!this.__startedOriginalNegotiation) {
                flag = Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Disabled);
            }
            NackConfig config = new NackConfig();
            config.setDisableBuffering(flag);
            this.__nackConfig = config;
            if (flag) {
                this.__nackConfig.setReceiveBufferLength(0);
                this.__nackConfig.setSendBufferLength(0);
            }
        }
        return this.__nackConfig;
    }

    public boolean getNackEnabled() {
        return !this.getNackConfig().getDisableBuffering();
    }

    public NackPolicy getNackPolicy() {
        return this.__nackPolicy;
    }

    @Override
    public TIInput getOutput() {
        return (TIInput)((IMediaInput)((Collection)this.__outputs).getValue());
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public TIInput[] getOutputs() {
        return (IMediaInput[])((Collection)this.__outputs).getValues();
    }

    @Override
    public boolean getPersistent() {
        return false;
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput(), ", ", this.getPipelineJsonOutput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", super.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromInput() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), " }"});
    }

    @Override
    public String getPipelineJsonFromOutput() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"inputFormat\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    private String getPipelineJsonInputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaOutput local : this.getInputs()) {
            list.add(local.getPipelineJsonFromOutput());
        }
        return StringExtensions.concat("\"inputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"outputFormat\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    private String getPipelineJsonOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaInput local : this.getOutputs()) {
            list.add(local.getPipelineJsonFromInput());
        }
        return StringExtensions.concat("\"outputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    TFormat getPreferredFormat() {
        MediaFormat[] values;
        for (MediaFormat local : values = (MediaFormat[])((Collection)this.getRtpParameters().getNegotiatedFormats()).getValues()) {
            if (local.getIsInjected()) continue;
            return (TFormat)local;
        }
        return null;
    }

    @Override
    public ProcessFramePolicy getProcessFramePolicy() {
        return this.__processPolicy;
    }

    public RedFecConfig getRedFecConfig() {
        if (this.__redFecConfig == null) {
            boolean flag = false;
            if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                flag = true;
            } else if (!this.__startedOriginalNegotiation) {
                flag = Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Disabled);
            }
            RedFecConfig config = new RedFecConfig();
            config.setDisabled(flag);
            this.__redFecConfig = config;
        }
        return this.__redFecConfig;
    }

    public boolean getRedFecEnabled() {
        return !this.getRedFecConfig().getDisabled();
    }

    public RedFecPolicy getRedFecPolicy() {
        return this.__redFecPolicy;
    }

    private TFormat getRegisteredFormat(int payloadType) {
        for (MediaFormat local : this.__payloadTypeRegistry) {
            if (local.getRegisteredPayloadType() != payloadType) continue;
            return (TFormat)local;
        }
        return null;
    }

    public boolean getRembEnabled() {
        return Global.equals((Object)this.__rembPolicy, (Object)RembPolicy.Negotiated) && HashMapExtensions.getCount(this.__remoteSupportedRembPayloadTypes) > 0;
    }

    public RembPolicy getRembPolicy() {
        return this.__rembPolicy;
    }

    public RemoteMedia getRemoteMedia() {
        return this._remoteMedia;
    }

    RtpHeaderExtensionRegistry getRtpHeaderExtensionRegistry() {
        if (this.__rtpHeaderExtensionRegistry == null) {
            this.__rtpHeaderExtensionRegistry = this.createRtpHeaderRegistry();
        }
        return this.__rtpHeaderExtensionRegistry;
    }

    RtpParameters<TFormat, TFormatCollection> getRtpParameters() {
        return this._rtpParameters;
    }

    RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> getRtpTransport() {
        return this.__rtpTransport;
    }

    MediaStreamStats getStats() {
        CoreTransport coreTransportRtp;
        MediaStreamStats stats5 = new MediaStreamStats();
        stats5.setId(super.getId());
        stats5.setTimestamp(DateExtensions.getUtcNow());
        stats5.setDirection(this.getDirection());
        stats5.setType(super.getType());
        MediaStreamStats stats = stats5;
        RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport = this.getRtpTransport();
        if (rtpTransport != null) {
            MediaTrackStats stats2;
            if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendOnly)) {
                stats.setSender(rtpTransport.getSenderStats());
                IOutput input = this.getInput();
                if (input != null) {
                    MediaTrackStats stats3 = new MediaTrackStats();
                    stats3.setId(input.getId());
                    stats3.setTimestamp(DateExtensions.getUtcNow());
                    stats3.setSynchronizationSources(rtpTransport.getLocalSynchronizationSources());
                    stats2 = stats3;
                    input.processStatsFromOutput(stats2);
                    stats.getSender().setTrack(stats2);
                }
            }
            if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
                stats.setReceiver(rtpTransport.getReceiverStats());
                IInput output = this.getOutput();
                if (output != null) {
                    MediaTrackStats stats4 = new MediaTrackStats();
                    stats4.setId(output.getId());
                    stats4.setTimestamp(DateExtensions.getUtcNow());
                    stats4.setSynchronizationSources(rtpTransport.getRemoteSynchronizationSources());
                    stats4.setDetached(false);
                    stats4.setStopped(false);
                    stats4.setFrameWidth(0);
                    stats4.setFrameHeight(0);
                    stats4.setFrameRate(0);
                    stats4.setFramesSent(0L);
                    stats4.setFramesReceived(0L);
                    stats4.setFramesDropped(0L);
                    stats4.setFramesCorrupted(0L);
                    stats4.setFramesDecoded(0L);
                    stats2 = stats4;
                    output.processStatsFromInput(stats2);
                    stats.getReceiver().setTrack(stats2);
                }
            }
        }
        if ((coreTransportRtp = super.getCoreTransportRtp()) != null) {
            stats.setTransport(coreTransportRtp.getStats());
            CoreTransport coreTransportRtcp = super.getCoreTransportRtcp();
            if (coreTransportRtcp != null && !Global.equals(coreTransportRtcp, coreTransportRtp)) {
                stats.getTransport().setRtcpTransport(coreTransportRtcp.getStats());
            }
        }
        return stats;
    }

    @Override
    public void incrementFirSequenceNumber() {
        this.__firSequenceNumber = (this.__firSequenceNumber + 1) % 256;
    }

    public MediaStream(StreamType type, JitterConfig jitterConfig) {
        super(type);
        this.__inputFormats = new ArrayList();
        this.__disabledInputFormats = new ArrayList();
        this.__inputFormatsLock = new Object();
        this.__redFecPolicy = RedFecPolicy.Negotiated;
        this.__nackPolicy = NackPolicy.Negotiated;
        this.__rembPolicy = RembPolicy.Disabled;
        this.__payloadTypesRegisteredByOtherStreams = new ArrayList();
        this.__remoteSupportedRembPayloadTypes = new HashMap();
        this.__absoluteSenderTimeLocalDirection = StreamDirection.Unset;
        this.__absoluteSenderTimeRemoteDirection = StreamDirection.Unset;
        this.__processPolicy = ProcessFramePolicy.Synchronous;
        this.setBandwidthAdaptationPolicy(BandwidthAdaptationPolicy.Disabled);
        this.setMultiplexingSupported(true);
        this.setJitterConfig(jitterConfig);
        this.setRtpParameters(new RtpParameters(this.createMediaFormatCollection()));
        this.__outputs = this.createInputCollection(this);
        this.__inputs = this.createOutputCollection(this);
        this.__localFormatRegistry = this.createMediaFormatCollection();
        this.__remoteFormatRegistry = this.createMediaFormatCollection();
        HashMap dictionary = new HashMap();
        HashMapExtensions.add(dictionary, "0", this.createFormat("PCMU", 8000, null, 0));
        HashMapExtensions.add(dictionary, "3", this.createFormat("GSM", 8000, null, 3));
        HashMapExtensions.add(dictionary, "4", this.createFormat("G723", 8000, null, 4));
        HashMapExtensions.add(dictionary, "5", this.createFormat("DVI4", 8000, null, 5));
        HashMapExtensions.add(dictionary, "6", this.createFormat("DVI4", 16000, null, 6));
        HashMapExtensions.add(dictionary, "7", this.createFormat("LPC", 8000, null, 7));
        HashMapExtensions.add(dictionary, "8", this.createFormat("PCMA", 8000, null, 8));
        HashMapExtensions.add(dictionary, "9", this.createFormat("G722", 8000, null, 9));
        HashMapExtensions.add(dictionary, "10", this.createFormat("L16", 44100, null, 10));
        HashMapExtensions.add(dictionary, "11", this.createFormat("L16", 44100, null, 11));
        HashMapExtensions.add(dictionary, "12", this.createFormat("QCELP", 8000, null, 12));
        HashMapExtensions.add(dictionary, "13", this.createFormat("CN", 8000, null, 13));
        HashMapExtensions.add(dictionary, "14", this.createFormat("MPA", 90000, null, 14));
        HashMapExtensions.add(dictionary, "15", this.createFormat("G728", 8000, null, 15));
        HashMapExtensions.add(dictionary, "16", this.createFormat("DVI4", 11025, null, 16));
        HashMapExtensions.add(dictionary, "17", this.createFormat("DVI4", 22050, null, 17));
        HashMapExtensions.add(dictionary, "18", this.createFormat("G729", 8000, null, 18));
        HashMapExtensions.add(dictionary, "25", this.createFormat("CelB", 90000, null, 25));
        HashMapExtensions.add(dictionary, "26", this.createFormat("JPEG", 90000, null, 26));
        HashMapExtensions.add(dictionary, "28", this.createFormat("nv", 90000, null, 28));
        HashMapExtensions.add(dictionary, "31", this.createFormat("H261", 90000, null, 31));
        HashMapExtensions.add(dictionary, "32", this.createFormat("MPV", 90000, null, 32));
        HashMapExtensions.add(dictionary, "33", this.createFormat("MP2T", 90000, null, 33));
        HashMapExtensions.add(dictionary, "34", this.createFormat("H263", 90000, null, 34));
        this.__wellKnownPayloadTypes = dictionary;
    }

    private String obtainFormatDescriptions() {
        StringBuilder builder = new StringBuilder();
        for (MediaFormat local : this.__payloadTypeRegistry) {
            if (local.getRegisteredPayloadType() < 0) continue;
            StringBuilderExtensions.append(builder, IntegerExtensions.toString(local.getRegisteredPayloadType()));
            StringBuilderExtensions.append(builder, " ");
        }
        return builder.toString();
    }

    private TFormatCollection obtainInputFormats() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaOutput local2 : this.getInputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(local2.getOutputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)local2.getOutputFormat()).clone());
        }
        return local;
    }

    private TFormatCollection obtainInputOutputFormatsUnion() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaOutput iMediaOutput : this.getInputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(iMediaOutput.getOutputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)iMediaOutput.getOutputFormat()).clone());
        }
        for (IMediaElement iMediaElement : this.getOutputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(iMediaElement.getInputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)iMediaElement.getInputFormat()).clone());
        }
        return local;
    }

    private TFormatCollection obtainLocalRemoteFormatsUnion() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (MediaFormat local2 : (MediaFormat[])((Collection)this.__remoteFormatRegistry).getValues()) {
            if (!((MediaFormatCollection)this.__localFormatRegistry).hasEquivalent((MediaFormat)local2)) continue;
            ((Collection)local).add((MediaFormat)local2);
        }
        return local;
    }

    private TFormatCollection obtainOutputFormats() {
        TFormatCollection local = this.createMediaFormatCollection();
        for (IMediaInput local2 : this.getOutputs()) {
            if (((MediaFormatCollection)local).hasEquivalent(local2.getInputFormat())) continue;
            ((Collection)local).add((Object)((MediaFormat)local2.getInputFormat()).clone());
        }
        return local;
    }

    private fm.icelink.sdp.Attribute[] obtainRtpExtMapAttributes(boolean isOffer, boolean isRenegotiation) {
        RtpHeaderExtensionRegistryElement[] elementArray = this.getRtpHeaderExtensionRegistry().obtainRegisteredEntries();
        ArrayList<ExtMapAttribute> list = new ArrayList<ExtMapAttribute>();
        for (RtpHeaderExtensionRegistryElement element : elementArray) {
            ExtMapAttribute item = null;
            StreamDirection pendingLocalDirection = isOffer ? this.getLocalDirection() : this.getDirection();
            StreamDirection unset = element.getDirection();
            if (isOffer && isRenegotiation) {
                pendingLocalDirection = super.getPendingLocalDirection();
            }
            if (Global.equals((Object)pendingLocalDirection, (Object)unset)) {
                item = new ExtMapAttribute(element.getId(), element.getUri());
            } else {
                if (Global.equals((Object)pendingLocalDirection, (Object)StreamDirection.ReceiveOnly)) {
                    if (Global.equals((Object)unset, (Object)StreamDirection.SendReceive)) {
                        unset = pendingLocalDirection;
                    } else if (Global.equals((Object)unset, (Object)StreamDirection.SendOnly)) {
                        unset = StreamDirection.Unset;
                    }
                } else if (Global.equals((Object)pendingLocalDirection, (Object)StreamDirection.SendOnly)) {
                    if (Global.equals((Object)unset, (Object)StreamDirection.SendReceive)) {
                        unset = pendingLocalDirection;
                    } else if (Global.equals((Object)unset, (Object)StreamDirection.ReceiveOnly)) {
                        unset = StreamDirection.Unset;
                    }
                }
                if (!Global.equals((Object)unset, (Object)StreamDirection.Unset)) {
                    item = new ExtMapAttribute(element.getId(), element.getUri(), unset);
                }
            }
            if (item == null) continue;
            list.add(item);
        }
        return list.toArray(new fm.icelink.sdp.Attribute[0]);
    }

    private boolean payloadTypeIsRegistered(int payloadType) {
        return this.getRegisteredFormat(payloadType) != null;
    }

    protected void processBandwidthAdapatationPolicyChange(BandwidthAdaptationPolicy policy) {
        this.raiseBandwidthAdaptationPolicyChange();
    }

    @Override
    protected void processCachedSettings() {
        super.processCachedSettings();
        if (super.getRenegotiationPending()) {
            this.setLocalDirection(super.getPendingLocalDirection());
        }
    }

    @Override
    public void processControlFrames(MediaControlFrame[] controlFrames) {
        RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport;
        if (!this.__remoteSupportsPli || !this.__remoteSupportsFir) {
            controlFrames = this.filterOutboundControlFrames(controlFrames);
        }
        if (ArrayExtensions.getLength(controlFrames) > 0 && (rtpTransport = this.getRtpTransport()) != null && Global.equals((Object)rtpTransport.getState(), (Object)MediaTransportState.Started)) {
            rtpTransport.sendControlFrames(controlFrames);
        }
    }

    @Override
    public boolean processFrame(TFrame frame) {
        if (Global.equals((Object)this.getProcessFramePolicy(), (Object)ProcessFramePolicy.Synchronous)) {
            return this.processFrameSync(frame);
        }
        if (Global.equals((Object)this.getProcessFramePolicy(), (Object)ProcessFramePolicy.Asynchronous)) {
            for (MediaBuffer local : frame.getBuffers()) {
                local.keep();
            }
            this.__dispatchQueue.enqueue(frame);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFrameSync(TFrame frame) {
        boolean flag;
        try {
            RtpTransport<Object, TBuffer, TBufferCollection, TFormat, TFormatCollection> rtpTransport;
            this._processingFrame = true;
            IAction1<TFrame> onProcessFrame = this._onProcessFrame;
            if (onProcessFrame != null) {
                onProcessFrame.invoke(frame);
            }
            if ((rtpTransport = this.getRtpTransport()) != null && Global.equals((Object)rtpTransport.getState(), (Object)MediaTransportState.Started)) {
                Object local = ((MediaFrame)frame).clone();
                ((MediaFrame)local).setTimestamp(((MediaFrame)frame).getTimestamp());
                ((MediaFrame)local).removeBuffers();
                for (int i = ArrayExtensions.getLength(frame.getBuffers()) - 1; i >= 0; --i) {
                    MediaBuffer buffer = frame.getBuffers()[i];
                    if (!((MediaFormat)buffer.getFormat()).getIsPacketized()) continue;
                    ((MediaFrame)local).addBuffer(buffer);
                    break;
                }
                if (ArrayExtensions.getLength(local.getBuffers()) == 0) {
                    __log.error("No packetized formats in frame for stream to send.");
                }
                rtpTransport.sendFrame(local);
                boolean bl = true;
                return bl;
            }
            flag = false;
        }
        finally {
            this._processingFrame = false;
        }
        return flag;
    }

    @Override
    public boolean processGetMuteFromStream() {
        for (IMediaOutput local : this.getInputs()) {
            if (!local.processGetMuteFromStream()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        Error error = super.processSdpMediaDescription(sdpMessage, sdpMediaDescription, isLocalDescription, isOffer, isRenegotiation);
        if (error == null) {
            StreamDirection direction2;
            void var16_58;
            fm.icelink.sdp.Attribute[] attributeArray;
            Object[] ssrcAttributes;
            MediaFormat local3;
            fm.icelink.sdp.Attribute[] attributeArray2;
            StreamDirection streamDirection = sdpMediaDescription.getStreamDirection();
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = sdpMessage.getSessionLevelDirection();
            }
            if (Global.equals((Object)streamDirection, (Object)StreamDirection.Unset)) {
                streamDirection = StreamDirection.SendReceive;
            }
            this.updateRtpHeaderExtensionRegistry(sdpMessage, sdpMediaDescription, isLocalDescription, isOffer, isRenegotiation, streamDirection);
            boolean supportsRtcpMultiplexing = sdpMediaDescription.getSupportsRtcpMultiplexing();
            if (!supportsRtcpMultiplexing) {
                supportsRtcpMultiplexing = sdpMessage.getSessionLevelRtcpMultiplexingSupport();
            }
            this.setMultiplexingSupported(this.getMultiplexingSupported() & supportsRtcpMultiplexing);
            if (isLocalDescription) {
                if (!Global.equals((Object)streamDirection, (Object)this.getDirection())) {
                    if (!isOffer) {
                        __log.debug("Local Stream direction was modified in outgoing SDP Answer message. This action may cause unintended consequences. Consider using Stream.ChangeDirection() interface instead.");
                    }
                    this.setLocalDirection(streamDirection);
                }
                for (IMediaOutput iMediaOutput : this.getInputs()) {
                    iMediaOutput.processSdpMediaDescriptionFromOutput(sdpMediaDescription, isOffer, isLocalDescription);
                }
                for (IMediaInput iMediaInput : this.getOutputs()) {
                    iMediaInput.processSdpMediaDescriptionFromInput(sdpMediaDescription, isOffer, isLocalDescription);
                }
                if (!isRenegotiation) {
                    for (fm.icelink.sdp.Attribute attribute : attributeArray2 = sdpMediaDescription.getRtpMapAttributes()) {
                        local3 = (MediaFormat)this.createFormat((MapAttribute)attribute);
                        if (this.validateMapAttribute(local3, isLocalDescription)) continue;
                        String str = StringExtensions.format("Invalid local map attribute {0}.", attribute.toString());
                        return new Error(ErrorCode.LocalDescriptionError, new Exception(str));
                    }
                }
                for (Object object : ssrcAttributes = sdpMediaDescription.getSsrcAttributes()) {
                    this.validateSsrcAttribute((SsrcAttribute)object, isLocalDescription);
                }
                String string = "TWVkaWFTdHJlYW0";
                if (this.getLocalMedia() != null) {
                    String string2 = this.getLocalMedia().getId();
                }
                String str322 = "-";
                if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                    AudioTrack audioTrack;
                    str322 = "QXVkaW9UcmFjaw";
                    if (this.getLocalMedia() != null && (audioTrack = (AudioTrack)this.getLocalMedia().getAudioTrack()) != null) {
                        str322 = audioTrack.getId();
                    }
                } else {
                    VideoTrack videoTrack2;
                    str322 = "VmlkZW9UcmFjaw";
                    if (this.getLocalMedia() != null && (videoTrack2 = (VideoTrack)this.getLocalMedia().getVideoTrack()) != null) {
                        str322 = videoTrack2.getId();
                    }
                }
                Object[] videoTrack2 = ssrcAttributes;
                int n = videoTrack2.length;
                for (int i = 0; i < n; ++i) {
                    void var13_16;
                    Object object = videoTrack2[i];
                    if (!Global.equals(((SsrcAttribute)object).getName(), SsrcAttributeName.getCName())) continue;
                    sdpMediaDescription.addMediaAttribute(new SsrcAttribute(((SsrcAttribute)object).getSynchronizationSource(), SsrcAttributeName.getMediaStreamId(), StringExtensions.format("{0} {1}", var13_16, str322)));
                    sdpMediaDescription.addMediaAttribute(new SsrcAttribute(((SsrcAttribute)object).getSynchronizationSource(), SsrcAttributeName.getMediaStreamLabel(), (String)var13_16));
                    sdpMediaDescription.addMediaAttribute(new SsrcAttribute(((SsrcAttribute)object).getSynchronizationSource(), SsrcAttributeName.getLabel(), str322));
                }
            } else {
                int videoTrack2;
                this.setRemoteDirection(streamDirection);
                this.__remoteSupportsRtcpFeedback = Media.supportsRtcpBasedFeedback(sdpMediaDescription.getMedia().getTransportProtocol());
                if (!isRenegotiation) {
                    ((Collection)this.__remoteFormatRegistry).removeAll();
                    fm.icelink.sdp.Attribute[] attributeArray3 = attributeArray2 = sdpMediaDescription.getRtpMapAttributes();
                    int str322 = attributeArray3.length;
                    for (videoTrack2 = 0; videoTrack2 < str322; ++videoTrack2) {
                        fm.icelink.sdp.Attribute attribute = attributeArray3[videoTrack2];
                        local3 = (MediaFormat)this.createFormat((MapAttribute)attribute);
                        if (!this.validateMapAttribute(local3, isLocalDescription)) continue;
                        ((Collection)this.__remoteFormatRegistry).add(local3);
                    }
                    int[] nArray = Media.getPayloadTypes(sdpMediaDescription.getMedia().getFormatDescription());
                    if (nArray != null) {
                        void var16_52;
                        local3 = null;
                        int[] str322 = nArray;
                        videoTrack2 = str322.length;
                        boolean bl = false;
                        while (var16_52 < videoTrack2) {
                            int num = str322[var16_52];
                            Holder<Object> holder = new Holder<Object>(local3);
                            boolean _var1 = HashMapExtensions.tryGetValue(this.__wellKnownPayloadTypes, IntegerExtensions.toString(num), holder);
                            local3 = holder.getValue();
                            if (_var1 && ((MediaFormatCollection)this.__remoteFormatRegistry).getEquivalent((MediaFormat)local3) == null && this.validateMapAttribute(local3, isLocalDescription)) {
                                ((Collection)this.__remoteFormatRegistry).add((MediaFormat)local3);
                            }
                            ++var16_52;
                        }
                    }
                }
                if (ArrayExtensions.getLength(ssrcAttributes = sdpMediaDescription.getSsrcAttributes()) > 0) {
                    Object[] objectArray = ssrcAttributes;
                    int str322 = objectArray.length;
                    for (videoTrack2 = 0; videoTrack2 < str322; ++videoTrack2) {
                        Object object = objectArray[videoTrack2];
                        if (this.validateSsrcAttribute((SsrcAttribute)object, isLocalDescription)) continue;
                        String str = StringExtensions.format("Remote description contains an invalid SSRC: {0}.", ((fm.icelink.sdp.Attribute)object).toString());
                        return new Error(ErrorCode.RemoteDescriptionError, new Exception(str));
                    }
                } else {
                    this.getRtpTransport().getSrtpTransport().getListener().setBypassSsrcCheck(true);
                }
                super.setRemoteBandwidth(-1);
                for (Bandwidth bandwidth : sdpMediaDescription.getBandwidths()) {
                    if (!Global.equals(StringExtensions.toUpper(bandwidth.getBandwidthType()), "TIAS") || bandwidth.getValue() <= 0L) continue;
                    super.setRemoteBandwidth((int)(bandwidth.getValue() / 1024L));
                    break;
                }
                for (IMediaOutput iMediaOutput : this.getInputs()) {
                    iMediaOutput.processSdpMediaDescriptionFromOutput(sdpMediaDescription, isOffer, isLocalDescription);
                }
                for (IMediaInput iMediaInput : this.getOutputs()) {
                    iMediaInput.processSdpMediaDescriptionFromInput(sdpMediaDescription, isOffer, isLocalDescription);
                }
            }
            fm.icelink.sdp.Attribute[] str322 = attributeArray = sdpMediaDescription.getRtpMapAttributes();
            int videoTrack2 = str322.length;
            boolean bl = false;
            while (var16_58 < videoTrack2) {
                fm.icelink.sdp.Attribute attribute = str322[var16_58];
                MapAttribute mapAttribute = (MapAttribute)attribute;
                if (isLocalDescription) {
                    FeedbackAttribute relatedNackPliFeedbackAttribute;
                    if (!isOffer) {
                        FeedbackAttribute relatedRembFeedbackAttribute;
                        FeedbackAttribute relatedCcmFirFeedbackAttribute;
                        if (!(this.__remoteSupportsPli && this.getNackEnabled() || (relatedNackPliFeedbackAttribute = mapAttribute.getRelatedNackPliFeedbackAttribute()) == null)) {
                            mapAttribute.removeRelatedRtcpFeedbackAttribute(relatedNackPliFeedbackAttribute);
                        }
                        if (!this.__remoteSupportsFir && (relatedCcmFirFeedbackAttribute = mapAttribute.getRelatedCcmFirFeedbackAttribute()) != null) {
                            mapAttribute.removeRelatedRtcpFeedbackAttribute(relatedCcmFirFeedbackAttribute);
                        }
                        if (!(this.__remoteSupportsFec && this.getRedFecEnabled() || !this.formatIsFec(mapAttribute.getFormatName()))) {
                            sdpMediaDescription.removeMediaAttribute(mapAttribute);
                        }
                        if (!(this.__remoteSupportedRembPayloadTypes.containsKey(mapAttribute.getPayloadType()) && this.getRembEnabled() || (relatedRembFeedbackAttribute = mapAttribute.getRelatedRembFeedbackAttribute()) == null)) {
                            mapAttribute.removeRelatedRtcpFeedbackAttribute(relatedRembFeedbackAttribute);
                        }
                    } else {
                        if (!this.getNackEnabled() && (relatedNackPliFeedbackAttribute = mapAttribute.getRelatedNackPliFeedbackAttribute()) != null) {
                            mapAttribute.removeRelatedRtcpFeedbackAttribute(relatedNackPliFeedbackAttribute);
                        }
                        if (!this.getRedFecEnabled() && this.formatIsFec(mapAttribute.getFormatName())) {
                            sdpMediaDescription.removeMediaAttribute(mapAttribute);
                        }
                    }
                } else {
                    if (mapAttribute.getRelatedNackPliFeedbackAttribute() != null) {
                        this.__remoteSupportsPli = true;
                    }
                    if (mapAttribute.getRelatedCcmFirFeedbackAttribute() != null) {
                        this.__remoteSupportsFir = true;
                    }
                    if (this.formatIsFec(mapAttribute.getFormatName())) {
                        this.__remoteSupportsFec = true;
                    }
                    if (!this.__remoteSupportedRembPayloadTypes.containsKey(mapAttribute.getPayloadType()) && mapAttribute.getRelatedRembFeedbackAttribute() != null) {
                        HashMapExtensions.add(this.__remoteSupportedRembPayloadTypes, mapAttribute.getPayloadType(), 0);
                    }
                }
                ++var16_58;
            }
            if (Global.equals((Object)super.getType(), (Object)StreamType.Audio)) {
                this.setNackEnabled(false);
                this.setRedFecEnabled(false);
            } else if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                if (isLocalDescription && isOffer) {
                    this.setNackEnabled(Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Negotiated));
                    this.setRedFecEnabled(Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated));
                } else {
                    if (this.__remoteSupportsPli && Global.equals((Object)this.getNackPolicy(), (Object)NackPolicy.Negotiated)) {
                        this.setNackEnabled(true);
                    } else {
                        this.setNackEnabled(false);
                    }
                    if (this.__remoteSupportsFec && Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated)) {
                        this.setRedFecEnabled(true);
                    } else {
                        this.setRedFecEnabled(false);
                    }
                }
            }
            if (!isRenegotiation) {
                SsrcAttribute[] attributeArray4;
                for (SsrcAttribute ssrcAttribute : attributeArray4 = sdpMediaDescription.getSsrcAttributes()) {
                    if (isLocalDescription) {
                        this.getRtpParameters().addLocalSynchronizationSource(ssrcAttribute.getSynchronizationSource());
                    } else {
                        this.getRtpParameters().addRemoteSynchronizationSource(ssrcAttribute.getSynchronizationSource());
                    }
                    StreamDirection _var2 = streamDirection;
                    if (_var2 != StreamDirection.ReceiveOnly && _var2 != StreamDirection.ReceiveOnly) continue;
                    sdpMediaDescription.removeMediaAttribute(ssrcAttribute);
                }
            }
            StreamDirection streamDirection2 = direction2 = isOffer && isLocalDescription ? this.getLocalDirection() : this.getDirection();
            if (!isRenegotiation) {
                this.setNegotiatedFormats(sdpMediaDescription);
                ArrayList<TFormat> videoTrack2 = this.__inputFormats;
                synchronized (videoTrack2) {
                    ArrayListExtensions.addRange(this.__inputFormats, ((Collection)this.getRtpParameters().getNegotiatedFormats()).getValues());
                }
            }
            if (Global.equals((Object)direction2, (Object)StreamDirection.ReceiveOnly)) {
                this.setInputFormat(null);
                this.setOutputFormat(this.getPreferredFormat());
            } else {
                if (Global.equals((Object)direction2, (Object)StreamDirection.SendOnly)) {
                    this.setInputFormat(this.getPreferredFormat());
                    this.setOutputFormat(null);
                    return error;
                }
                if (Global.equals((Object)direction2, (Object)StreamDirection.SendReceive)) {
                    this.setInputFormat(this.getPreferredFormat());
                    this.setOutputFormat(this.getPreferredFormat());
                    return error;
                }
                if (Global.equals((Object)direction2, (Object)StreamDirection.Inactive)) {
                    TFormat local5 = null;
                    this.setInputFormat(local5);
                    this.setOutputFormat(null);
                } else {
                    this.setInputFormat(this.getPreferredFormat());
                    this.setOutputFormat(null);
                }
            }
        }
        return error;
    }

    @Override
    public Error processSdpMediaDescriptionFromInput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    @Override
    public Error processSdpMediaDescriptionFromOutput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    @Override
    public void processSetMuteFromStream(boolean mute) {
        for (IMediaOutput local : this.getInputs()) {
            local.processSetMuteFromStream(mute);
        }
    }

    @Override
    public void processStatsFromInput(MediaTrackStats stats) {
    }

    @Override
    public void processStatsFromOutput(MediaTrackStats stats) {
    }

    private void raiseBandwidthAdaptationPolicyChange() {
        IAction1<Stream> onBandwidthAdaptationPolicyStateChange = this._onBandwidthAdaptationPolicyStateChange;
        if (onBandwidthAdaptationPolicyStateChange != null) {
            onBandwidthAdaptationPolicyStateChange.invoke(this);
        }
    }

    protected void raiseControlFrames(MediaControlFrame[] controlFrames) {
        for (MediaControlFrame frame : controlFrames) {
            frame.setStreamId(super.getId());
        }
        IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
        if (onRaiseControlFrames != null) {
            onRaiseControlFrames.invoke(controlFrames);
        }
        for (IMediaOutput local : this.getInputs()) {
            if (local.getDisabled()) continue;
            if (__log.getIsDebugEnabled()) {
                for (MediaControlFrame frame : controlFrames) {
                    if (!(frame instanceof ReportControlFrame)) continue;
                    ReportControlFrame frame2 = (ReportControlFrame)frame;
                    for (ReportBlock block : frame2.getReportBlocks()) {
                        if (!__log.getIsVerboseEnabled()) continue;
                        __log.verbose(StringExtensions.concat(new String[]{"Feedback report (", ((MediaFormat)local.getOutputFormat()).getFullName(), "): ", Utility.formatDoubleAsPercent(block.getPercentLost(), 2), " packet loss (", IntegerExtensions.toString(block.getCumulativeNumberOfPacketsLost()), " cumulative packets lost)"}));
                    }
                }
            }
            local.processControlFrames(controlFrames);
        }
    }

    protected void raiseFrame(TFrame frame) {
        IAction1<TFrame> onRaiseFrame = this._onRaiseFrame;
        if (onRaiseFrame != null) {
            onRaiseFrame.invoke(frame);
        }
        boolean flag = false;
        for (IMediaInput local : this.getOutputs()) {
            if (local.getDisabled() || !((MediaFrame)frame).hasBuffer(local.getInputFormat()) || !local.processFrame(frame)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            __log.debug("Stream could not raise frame to any outputs.");
        }
    }

    void receiveControlFrames(MediaControlFrame[] controlFrames) {
        this.raiseControlFrames(controlFrames);
    }

    void receiveFrame(TFrame frame) {
        this.raiseFrame(frame);
    }

    private void registerPayloadTypes() {
        int staticPayloadType;
        if (((Collection)this.__remoteFormatRegistry).getCount() == 0) {
            this.__payloadTypeRegistry.clear();
        }
        ((Collection)this.__localFormatRegistry).removeAll();
        int clockRate = 0;
        StreamDirection directionCapabilities = this.getDirectionCapabilities();
        TFormatCollection local = Global.equals((Object)directionCapabilities, (Object)StreamDirection.SendOnly) ? this.obtainInputFormats() : (Global.equals((Object)directionCapabilities, (Object)StreamDirection.ReceiveOnly) ? this.obtainOutputFormats() : this.obtainInputOutputFormatsUnion());
        for (int i = 0; i < ((Collection)local).getCount(); ++i) {
            staticPayloadType = -1;
            MediaFormat format = ((MediaFormat[])((Collection)local).getValues())[i];
            if (((Collection)this.__remoteFormatRegistry).getCount() == 0) {
                if (format.getStaticPayloadType() >= 0) {
                    String item = IntegerExtensions.toString(format.getStaticPayloadType());
                    if (this.__payloadTypesRegisteredByOtherStreams.contains(item)) {
                        __log.error(StringExtensions.format("Payload type {0} for {1} is already registered by another stream.", item, format.getFullName()));
                    } else {
                        staticPayloadType = format.getStaticPayloadType();
                    }
                } else {
                    staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                    while (this.__payloadTypesRegisteredByOtherStreams.contains(IntegerExtensions.toString(staticPayloadType))) {
                        ++this.__rtpPayloadTypeDynamicOffset;
                    }
                    if (staticPayloadType > this.__rtpPayloadTypeMaxOffset) {
                        __log.error(StringExtensions.format("Cannot add format {0}. Maximum dynamic payload types exceeded.", format.toString()));
                        staticPayloadType = -1;
                    }
                }
            }
            format.setRegisteredPayloadType(staticPayloadType);
            this.addLocalFormat(format);
            if (format.getRegisteredPayloadType() < 0 || clockRate != 0) continue;
            clockRate = format.getClockRate();
        }
        if (Global.equals((Object)this.getRedFecPolicy(), (Object)RedFecPolicy.Negotiated) && clockRate > 0) {
            if (Global.equals((Object)super.getType(), (Object)StreamType.Video)) {
                staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                this.addLocalFormat(this.createFormat(MediaFormat.getRedName(), clockRate, null, staticPayloadType));
                staticPayloadType = this.__rtpPayloadTypeDynamicOffset++;
                this.addLocalFormat(this.createFormat(MediaFormat.getUlpFecName(), clockRate, null, staticPayloadType));
            } else {
                __log.debug("FEC is only supported for video streams.");
            }
        }
    }

    @Override
    public boolean removeInput(TIOutput input) {
        return ((Collection)this.__inputs).remove(input);
    }

    @Override
    public void removeInputs() {
        ((Collection)this.__inputs).removeAll();
    }

    @Override
    public boolean removeInputs(TIOutput[] inputs) {
        return ((Collection)this.__inputs).removeMany(inputs);
    }

    void removeOnBandwidthAdaptationPolicyStateChange(IAction1<Stream> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onBandwidthAdaptationPolicyStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onBandwidthAdaptationPolicyStateChange.remove(value);
        if (this.__onBandwidthAdaptationPolicyStateChange.size() == 0) {
            this._onBandwidthAdaptationPolicyStateChange = null;
        }
    }

    @Override
    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
        if (this.__onProcessControlFrames.size() == 0) {
            this._onProcessControlFrames = null;
        }
    }

    @Override
    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
        if (this.__onProcessFrame.size() == 0) {
            this._onProcessFrame = null;
        }
    }

    @Override
    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
        if (this.__onRaiseControlFrames.size() == 0) {
            this._onRaiseControlFrames = null;
        }
    }

    @Override
    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
        if (this.__onRaiseFrame.size() == 0) {
            this._onRaiseFrame = null;
        }
    }

    @Override
    public boolean removeOutput(TIInput output) {
        return ((Collection)this.__outputs).remove(output);
    }

    @Override
    public void removeOutputs() {
        ((Collection)this.__outputs).removeAll();
    }

    @Override
    public boolean removeOutputs(TIInput[] outputs) {
        return ((Collection)this.__outputs).removeMany(outputs);
    }

    @Override
    void reset() {
        super.reset();
        this.setRtpTransport(null);
    }

    void setAbsoluteSenderTimeLocalDirection(StreamDirection value) {
        this.__absoluteSenderTimeLocalDirection = value;
    }

    void setAbsoluteSenderTimePolicy(MediaHeaderExtensionPolicy value) {
        this._absoluteSenderTimePolicy = value;
    }

    void setAbsoluteSenderTimeRemoteDirection(StreamDirection value) {
        this.__absoluteSenderTimeRemoteDirection = value;
    }

    public void setBandwidthAdaptationPolicy(BandwidthAdaptationPolicy value) {
        this.processBandwidthAdapatationPolicyChange(value);
        this.__bandwidthAdaptationPolicy = value;
    }

    public void setDisableAutomaticReports(boolean value) {
        this._disableAutomaticReports = value;
    }

    private void setInputFormat() {
        if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.ReceiveOnly)) {
            this.setInputFormat(null);
        } else if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendOnly)) {
            this.setInputFormat(this.getPreferredFormat());
        } else if (Global.equals((Object)this.getDirection(), (Object)StreamDirection.SendReceive)) {
            this.setInputFormat(this.getPreferredFormat());
        } else {
            this.setInputFormat(null);
        }
    }

    private void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    private void setJitterConfig(JitterConfig value) {
        this._jitterConfig = value;
    }

    protected void setLocalMedia(LocalMedia value) {
        this._localMedia = value;
    }

    void setMultiplexingSupported(boolean value) {
        this._multiplexingSupported = value;
    }

    @Override
    public void setMuted(boolean value) {
        this.processSetMuteFromStream(value);
    }

    private void setNackConfig(NackConfig value) {
        this.__nackConfig = value;
    }

    private void setNackEnabled(boolean value) {
        if (Global.equals((Object)super.getType(), (Object)StreamType.Audio) && value) {
            throw new RuntimeException(new Exception("Nack is not supported for Audio streams."));
        }
        this.getNackConfig().setDisableBuffering(!value);
    }

    public void setNackPolicy(NackPolicy value) {
        if (Global.equals((Object)this.__nackPolicy, (Object)NackPolicy.Disabled) && Global.equals((Object)value, (Object)NackPolicy.Negotiated)) {
            if (this.__startedOriginalNegotiation) {
                throw new RuntimeException(new Exception("Cannot set NACK policy to Negotiated after the original session description negotiation has commenced."));
            }
            this.__nackPolicy = NackPolicy.Negotiated;
        } else if (Global.equals((Object)this.__nackPolicy, (Object)NackPolicy.Negotiated) && Global.equals((Object)value, (Object)NackPolicy.Disabled)) {
            this.__nackPolicy = NackPolicy.Disabled;
            this.setNackEnabled(false);
        }
    }

    private void setNegotiatedFormats(MediaDescription mediaDescription) {
        int[] payloadTypes;
        String formatDescription = mediaDescription.getMedia().getFormatDescription();
        if (!StringExtensions.isNullOrEmpty(formatDescription) && (payloadTypes = Media.getPayloadTypes(formatDescription)) != null) {
            TFormatCollection local = this.obtainLocalRemoteFormatsUnion();
            for (int num : payloadTypes) {
                TFormat equivalent;
                TFormat registeredFormat = this.getRegisteredFormat(num);
                if (registeredFormat == null || (equivalent = ((MediaFormatCollection)local).getEquivalent(registeredFormat)) == null) continue;
                if (!this.getRtpParameters().getPayloadTypeRegistry().containsKey(num)) {
                    HashMapExtensions.add(this.getRtpParameters().getPayloadTypeRegistry(), num, equivalent);
                }
                ((Collection)this.getRtpParameters().getNegotiatedFormats()).add(equivalent);
            }
        }
    }

    protected void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    @Override
    public void setProcessFramePolicy(ProcessFramePolicy value) {
        IAction1 action = null;
        if (Global.equals((Object)value, (Object)ProcessFramePolicy.Asynchronous) && this.__dispatchQueue == null) {
            if (action == null) {
                action = new IAction1<TFrame>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void invoke(TFrame frame) {
                        try {
                            MediaStream.this.processFrameSync(frame);
                        }
                        finally {
                            MediaBuffer[] buffers;
                            for (MediaBuffer local : buffers = frame.getBuffers()) {
                                local.free();
                            }
                        }
                    }
                };
            }
            this.__dispatchQueue = new DispatchQueue(action);
        }
        this.__processPolicy = value;
    }

    private void setRedFecConfig(RedFecConfig value) {
        this.__redFecConfig = value;
    }

    private void setRedFecEnabled(boolean value) {
        if (Global.equals((Object)super.getType(), (Object)StreamType.Audio) && value) {
            throw new RuntimeException(new Exception("RED FEC is not supported for Audio streams."));
        }
        this.getRedFecConfig().setDisabled(!value);
    }

    public void setRedFecPolicy(RedFecPolicy value) {
        if (Global.equals((Object)value, (Object)RedFecPolicy.Negotiated)) {
            __log.error("Red FEC Negotiated policy is currently not supported. Defaulting to Red FEC Disabled.");
        }
        this.__redFecPolicy = RedFecPolicy.Disabled;
        this.setRedFecEnabled(false);
    }

    void setRembPolicy(RembPolicy value) {
        if (Global.equals((Object)this.__rembPolicy, (Object)RembPolicy.Disabled) && !Global.equals((Object)value, (Object)RembPolicy.Disabled) && this.__startedOriginalNegotiation) {
            throw new RuntimeException(new Exception("Cannot set Remb policy to Negotiated after the original session description negotiation has commenced."));
        }
        this.__rembPolicy = value;
    }

    protected void setRemoteMedia(RemoteMedia value) {
        this._remoteMedia = value;
    }

    private void setRtpParameters(RtpParameters<TFormat, TFormatCollection> value) {
        this._rtpParameters = value;
    }

    void setRtpTransport(RtpTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> value) {
        IAction1<IMediaTransport> action = null;
        this.__rtpTransport = value;
        if (this.__rtpTransport != null) {
            this.setRtpTransportDirection();
            super.removeOnDirectionChange(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaStream<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.setRtpTransportDirection";
                }

                @Override
                public void invoke() {
                    MediaStream.this.setRtpTransportDirection();
                }
            });
            super.addOnDirectionChange(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaStream<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.setRtpTransportDirection";
                }

                @Override
                public void invoke() {
                    MediaStream.this.setRtpTransportDirection();
                }
            });
            this.__rtpTransport.removeOnSendControlFrames(this._onProcessControlFrames);
            this.__rtpTransport.addOnSendControlFrames(this._onProcessControlFrames);
            if (action == null) {
                action = new IAction1<IMediaTransport>(){

                    @Override
                    public void invoke(IMediaTransport transport) {
                        if (Global.equals((Object)transport.getState(), (Object)MediaTransportState.Started)) {
                            if (Global.equals((Object)MediaStream.this.getType(), (Object)StreamType.Video)) {
                                MediaStream.this.raiseControlFrames(new FirControlFrame[]{new FirControlFrame(new FirEntry(0))});
                            }
                            MediaStream.this.raiseDisabledChange();
                            MediaStream.this.setInputFormat();
                        }
                    }
                };
            }
            this.__rtpTransport.addOnStateChange(action);
        }
    }

    private void setRtpTransportDirection() {
        if (this.__rtpTransport != null) {
            this.__rtpTransport.setDirection(this.getDirection());
        }
    }

    private boolean updateRtpHeaderExtensionRegistry(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation, StreamDirection streamDirection) {
        Object[] sessionLevelRtpExtMapAttributes;
        if (isRenegotiation && isOffer && isLocalDescription) {
            boolean receive;
            boolean flag = Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendOnly) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset);
            boolean flag2 = Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.ReceiveOnly) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.SendReceive) || Global.equals((Object)this.getAbsoluteSenderTimeLocalDirection(), (Object)StreamDirection.Unset);
            boolean send = Global.equals((Object)this.getAbsoluteSenderTimePolicy(), (Object)MediaHeaderExtensionPolicy.Negotiated) && flag && !Global.equals((Object)super.getPendingLocalDirection(), (Object)StreamDirection.ReceiveOnly);
            StreamDirection direction = this.convertToHeaderExtensionDirection(send, receive = Global.equals((Object)this.getAbsoluteSenderTimePolicy(), (Object)MediaHeaderExtensionPolicy.Negotiated) && flag2 && !Global.equals((Object)super.getPendingLocalDirection(), (Object)StreamDirection.SendOnly));
            if (!Global.equals((Object)direction, (Object)StreamDirection.Unset)) {
                this.getRtpHeaderExtensionRegistry().update(RtpHeaderExtensionType.AbsSendTime, direction, "http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time");
            }
        }
        if ((sessionLevelRtpExtMapAttributes = sdpMessage.getSessionLevelRtpExtMapAttributes()) == null || ArrayExtensions.getLength(sessionLevelRtpExtMapAttributes) == 0) {
            sessionLevelRtpExtMapAttributes = sdpMediaDescription.getRtpExtMapAttributes();
        }
        if (sessionLevelRtpExtMapAttributes == null || ArrayExtensions.getLength(sessionLevelRtpExtMapAttributes) == 0) {
            if (this.getRtpHeaderExtensionRegistry() != null) {
                this.getRtpHeaderExtensionRegistry().clear();
            }
            if (isLocalDescription) {
                this.setAbsoluteSenderTimeLocalDirection(StreamDirection.Inactive);
            } else {
                this.setAbsoluteSenderTimeRemoteDirection(StreamDirection.Inactive);
            }
            return false;
        }
        ArrayList<RtpHeaderExtensionRegistryElement> list = new ArrayList<RtpHeaderExtensionRegistryElement>();
        boolean flag5 = false;
        for (Object attribute : sessionLevelRtpExtMapAttributes) {
            RtpHeaderExtensionRegistryElement elementFromAttribute = RtpHeaderExtensionRegistryElement.getElementFromAttribute((ExtMapAttribute)attribute);
            if (!isLocalDescription && elementFromAttribute != null && Global.equals((Object)elementFromAttribute.getDirection(), (Object)StreamDirection.Unset)) {
                elementFromAttribute.setDirection(streamDirection);
            }
            if (isLocalDescription && elementFromAttribute != null) {
                list.add(elementFromAttribute);
                continue;
            }
            if (elementFromAttribute == null || !Global.equals((Object)elementFromAttribute.getType(), (Object)RtpHeaderExtensionType.AbsSendTime)) continue;
            flag5 = true;
            if (isLocalDescription) {
                this.setAbsoluteSenderTimeLocalDirection(elementFromAttribute.getDirection());
            } else {
                this.setAbsoluteSenderTimeRemoteDirection(elementFromAttribute.getDirection());
            }
            if (Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.Inactive) || Global.equals((Object)this.getAbsoluteSenderTimeDirection(), (Object)StreamDirection.Unset)) continue;
            elementFromAttribute.setDirection(this.getAbsoluteSenderTimeDirection());
            list.add(elementFromAttribute);
        }
        if (!isLocalDescription && !flag5) {
            this.setAbsoluteSenderTimeRemoteDirection(StreamDirection.Inactive);
        }
        this.getRtpHeaderExtensionRegistry().populate(list.toArray(new RtpHeaderExtensionRegistryElement[0]));
        return true;
    }

    private boolean validateMapAttribute(TFormat mapAttributeFormat, boolean isLocalDescription) {
        if (mapAttributeFormat != null) {
            int registeredPayloadType = ((MediaFormat)mapAttributeFormat).getRegisteredPayloadType();
            TFormat registeredFormat = this.getRegisteredFormat(registeredPayloadType);
            if (registeredFormat == null || !((MediaFormat)registeredFormat).isEquivalent(mapAttributeFormat) || ((MediaFormat)registeredFormat).getRegisteredPayloadType() != registeredPayloadType) {
                if (((Collection)this.__localFormatRegistry).getCount() <= 0) {
                    return true;
                }
                registeredFormat = ((MediaFormatCollection)this.__localFormatRegistry).getEquivalent(mapAttributeFormat);
                if (registeredFormat == null) {
                    return false;
                }
                if (isLocalDescription) {
                    ((MediaFormat)registeredFormat).setRegisteredPayloadType(((MediaFormat)mapAttributeFormat).getRegisteredPayloadType());
                } else {
                    ((Collection)this.__remoteFormatRegistry).add(registeredFormat);
                }
            }
            return true;
        }
        return false;
    }

    private boolean validateSsrcAttribute(SsrcAttribute attribute, boolean isLocalDescription) {
        if (isLocalDescription) {
            if (Global.equals(attribute.getName(), SsrcAttributeName.getCName())) {
                if (attribute.getValue() == null) {
                    attribute.setValue(this.getRtpParameters().getCanonicalName());
                } else if (!Global.equals(attribute.getValue(), this.getRtpParameters().getCanonicalName())) {
                    __log.error("Canonical name of a stream must match RTP parameters.");
                    return false;
                }
            }
            this.getRtpParameters().addLocalSynchronizationSource(attribute.getSynchronizationSource());
        } else if (Global.equals(attribute.getName(), SsrcAttributeName.getCName())) {
            this.getRtpParameters().addRemoteSynchronizationSource(attribute.getSynchronizationSource());
        }
        return true;
    }
}

