/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Collection;
import fm.icelink.DispatchQueue;
import fm.icelink.Error;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaOutputCollection;
import fm.icelink.JsonSerializer;
import fm.icelink.License;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaSinkBase;
import fm.icelink.MediaSinkState;
import fm.icelink.MediaTrackStats;
import fm.icelink.ProcessFramePolicy;
import fm.icelink.Promise;
import fm.icelink.SinkOutput;
import fm.icelink.Stream;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.MediaDescription;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaSink<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIOutputCollection extends IMediaOutputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIOutputCollection>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TSink extends MediaSink<TIOutput, TIOutputCollection, TIInput, TSink, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends MediaSinkBase
implements IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private boolean __disabled;
    private DispatchQueue<TFrame> __dispatchQueue;
    private TIOutputCollection __inputs;
    private List<IAction0> __onDisabledChange = new ArrayList<IAction0>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction2<TFrame, Exception>> __onProcessFrameException = new ArrayList<IAction2<TFrame, Exception>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TSink>> __onStateChange = new ArrayList<IAction1<TSink>>();
    private SinkOutput __output = null;
    private volatile boolean __processingFrame = false;
    private ProcessFramePolicy __processPolicy;
    private volatile boolean __raisingControlFrames = false;
    private MediaSinkState __state = MediaSinkState.Initialized;
    private Object __stateLock = new Object();
    private TFormat _inputFormat;
    private boolean _muted;
    private IAction0 _onDisabledChange = null;
    private IAction1<TFrame> _onProcessFrame = null;
    private IAction2<TFrame, Exception> _onProcessFrameException = null;
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = null;
    private IAction1<TSink> _onStateChange = null;
    private boolean _persistent;

    @Override
    public void addInput(TIOutput input) {
        if (input == null) {
            throw new RuntimeException(new Exception("Received null input in the media sink."));
        }
        if (input != null) {
            this.validateInput(input);
            ((Collection)this.__inputs).add(input);
        }
    }

    @Override
    public void addInputs(TIOutput[] inputs) {
        if (inputs == null) {
            throw new RuntimeException(new Exception("Received null inputs in the media sink."));
        }
        for (TIOutput local : inputs) {
            this.validateInput(local);
        }
        ((Collection)this.__inputs).addMany(inputs);
    }

    @Override
    public void addOnDisabledChange(IAction0 value) {
        if (value != null) {
            if (this._onDisabledChange == null) {
                this._onDisabledChange = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(MediaSink.this.__onDisabledChange)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onDisabledChange.add(value);
        }
    }

    @Override
    public void addOnProcessFrame(IAction1<TFrame> value) {
        if (value != null) {
            if (this._onProcessFrame == null) {
                this._onProcessFrame = new IAction1<TFrame>(){

                    @Override
                    public void invoke(TFrame p0) {
                        for (IAction1 action : new ArrayList(MediaSink.this.__onProcessFrame)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onProcessFrame.add(value);
        }
    }

    public void addOnProcessFrameException(IAction2<TFrame, Exception> value) {
        if (value != null) {
            if (this._onProcessFrameException == null) {
                this._onProcessFrameException = new IAction2<TFrame, Exception>(){

                    @Override
                    public void invoke(TFrame p0, Exception p1) {
                        for (IAction2 action : new ArrayList(MediaSink.this.__onProcessFrameException)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onProcessFrameException.add(value);
        }
    }

    @Override
    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onRaiseControlFrames == null) {
                this._onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(MediaSink.this.__onRaiseControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onRaiseControlFrames.add(value);
        }
    }

    public void addOnStateChange(IAction1<TSink> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<TSink>(){

                    @Override
                    public void invoke(TSink p0) {
                        for (IAction1 action : new ArrayList(MediaSink.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    public Future<Object> changeOutput(SinkOutput output) {
        return this.doChangeOutput(new Promise<Object>(), output);
    }

    protected abstract TIOutputCollection createOutputCollection(TIInput var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        MediaSinkState state;
        Object obj2;
        Object object = obj2 = this.__stateLock;
        synchronized (object) {
            MediaSinkState _var0 = this.getState();
            if (_var0 == MediaSinkState.Destroying) {
                throw new RuntimeException(new Exception("A media sink cannot be destroyed while it is being destroyed on a different thread."));
            }
            if (_var0 == MediaSinkState.Destroyed) {
                return true;
            }
            state = this.getState();
            this.setState(MediaSinkState.Destroying);
        }
        Log.debug(StringExtensions.format("Media sink ({0}) is being destroyed.", this.getLabel()));
        while (this.__processingFrame || this.__raisingControlFrames) {
            ManagedThread.sleep(10);
        }
        try {
            this.doDestroy();
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.setState(MediaSinkState.Destroyed);
            }
            ((IMediaOutputCollection)this.__inputs).destroy();
            return true;
        }
        catch (Exception obj1) {
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                this.setState(state);
            }
            return false;
        }
    }

    private Future<Object> doChangeOutput(final Promise<Object> promise, final SinkOutput output) {
        IAction0 action = null;
        IAction0 action2 = null;
        if (Global.equals(output, this.__output)) {
            if (action == null) {
                action = new IAction0(){

                    @Override
                    public void invoke() {
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action);
        } else {
            if (action2 == null) {
                action2 = new IAction0(){

                    @Override
                    public void invoke() {
                        MediaSink.this.__output = output;
                        promise.resolve(null);
                    }
                };
            }
            ManagedThread.dispatch(action2);
        }
        return promise;
    }

    protected abstract void doDestroy();

    protected abstract void doProcessFrame(TFrame var1, TBuffer var2);

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    protected void doProcessStatsFromInput(MediaTrackStats stats) {
    }

    @Override
    public boolean getDisabled() {
        return this.__disabled;
    }

    @Override
    public TIOutput getInput() {
        return (TIOutput)((IMediaOutput)((Collection)this.__inputs).getValue());
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    @Override
    public TIOutput[] getInputs() {
        return (IMediaOutput[])((Collection)this.__inputs).getValues();
    }

    @Override
    public abstract String getLabel();

    @Override
    public int getMaxInputBitrate() {
        return -1;
    }

    @Override
    public boolean getMuted() {
        return this._muted;
    }

    public SinkOutput getOutput() {
        return this.__output;
    }

    public Future<SinkOutput[]> getOutputs() {
        Promise<SinkOutput[]> promise = new Promise<SinkOutput[]>();
        promise.resolve(new SinkOutput[0]);
        return promise;
    }

    @Override
    public boolean getPersistent() {
        return this._persistent;
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), " }"});
    }

    private String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", this.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromInput() {
        return StringExtensions.concat("{ ", this.getPipelineJsonBase(), " }");
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(super.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"inputFormat\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    private String getPipelineJsonInputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaOutput local : this.getInputs()) {
            list.add(local.getPipelineJsonFromOutput());
        }
        return StringExtensions.concat("\"inputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(super.getTag()));
    }

    @Override
    public ProcessFramePolicy getProcessFramePolicy() {
        return this.__processPolicy;
    }

    public MediaSinkState getState() {
        return this.__state;
    }

    public boolean hasInput(TIOutput input) {
        for (IMediaOutput local : this.getInputs()) {
            if (local != input) continue;
            return true;
        }
        return false;
    }

    public MediaSink(TFormat inputFormat) {
        License.checkKey();
        this.__processPolicy = ProcessFramePolicy.Synchronous;
        this.setInputFormat(inputFormat);
        this.__inputs = this.createOutputCollection(this);
    }

    public MediaSink() {
        this(null);
    }

    @Override
    public boolean processFrame(TFrame frame) {
        if (Global.equals((Object)this.getProcessFramePolicy(), (Object)ProcessFramePolicy.Synchronous)) {
            return this.processFrameSync(frame);
        }
        if (Global.equals((Object)this.getProcessFramePolicy(), (Object)ProcessFramePolicy.Asynchronous)) {
            for (MediaBuffer local : frame.getBuffers()) {
                local.keep();
            }
            this.__dispatchQueue.enqueue(frame);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFrameSync(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized)) {
            this.__processingFrame = true;
            try {
                Object buffer22;
                if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized) && (buffer22 = ((MediaFrame)frame).getBuffer(this.getInputFormat())) != null) {
                    IAction1<TFrame> onProcessFrame;
                    if (StringExtensions.isNullOrEmpty(((MediaBuffer)buffer22).getSourceId())) {
                        ((MediaBuffer)buffer22).setSourceId(super.getId());
                    }
                    if (this.getMuted()) {
                        ((MediaBuffer)buffer22).mute();
                    }
                    if ((onProcessFrame = this._onProcessFrame) != null) {
                        onProcessFrame.invoke(frame);
                    }
                    this.doProcessFrame(frame, buffer22);
                }
                boolean buffer22 = true;
                return buffer22;
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media sink ({0}) could not process frame.", this.getLabel()), exception);
                IAction2<TFrame, Exception> onProcessFrameException = this._onProcessFrameException;
                if (onProcessFrameException != null) {
                    onProcessFrameException.invoke(frame, exception);
                }
            }
            finally {
                this.__processingFrame = false;
            }
        }
        return false;
    }

    @Override
    public Error processSdpMediaDescriptionFromInput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
    }

    @Override
    public void processStatsFromInput(MediaTrackStats stats) {
        this.doProcessStatsFromInput(stats);
    }

    protected void raiseControlFrame(MediaControlFrame controlFrame) {
        this.raiseControlFrames(new MediaControlFrame[]{controlFrame});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized)) {
            this.__raisingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaSinkState.Initialized)) {
                    IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
                    if (onRaiseControlFrames != null) {
                        onRaiseControlFrames.invoke(controlFrames);
                    }
                    for (IMediaOutput local : this.getInputs()) {
                        if (local.getDisabled()) continue;
                        local.processControlFrames(controlFrames);
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media sink ({0}) could not raise control frames.", this.getLabel()), exception);
            }
            finally {
                this.__raisingControlFrames = false;
            }
        }
    }

    @Override
    public boolean removeInput(TIOutput input) {
        return ((Collection)this.__inputs).remove(input);
    }

    @Override
    public boolean removeInputs(TIOutput[] inputs) {
        return ((Collection)this.__inputs).removeMany(inputs);
    }

    @Override
    public void removeInputs() {
        ((Collection)this.__inputs).removeAll();
    }

    @Override
    public void removeOnDisabledChange(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onDisabledChange, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onDisabledChange.remove(value);
        if (this.__onDisabledChange.size() == 0) {
            this._onDisabledChange = null;
        }
    }

    @Override
    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
        if (this.__onProcessFrame.size() == 0) {
            this._onProcessFrame = null;
        }
    }

    public void removeOnProcessFrameException(IAction2<TFrame, Exception> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onProcessFrameException, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrameException.remove(value);
        if (this.__onProcessFrameException.size() == 0) {
            this._onProcessFrameException = null;
        }
    }

    @Override
    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
        if (this.__onRaiseControlFrames.size() == 0) {
            this._onRaiseControlFrames = null;
        }
    }

    public void removeOnStateChange(IAction1<TSink> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    public void setDisabled(boolean value) {
        if (!Global.equals(this.__disabled, value)) {
            this.__disabled = value;
            IAction0 onDisabledChange = this._onDisabledChange;
            if (onDisabledChange != null) {
                onDisabledChange.invoke();
            }
        }
    }

    public void setInput(TIOutput value) {
        this.removeInputs();
        this.addInput(value);
    }

    private void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    public void setInputs(TIOutput[] value) {
        this.removeInputs();
        this.addInputs((IMediaOutput[])value);
    }

    @Override
    public void setMuted(boolean value) {
        this._muted = value;
    }

    public void setOutput(SinkOutput value) {
        this.__output = value;
    }

    public void setPersistent(boolean value) {
        this._persistent = value;
    }

    @Override
    public void setProcessFramePolicy(ProcessFramePolicy value) {
        IAction1 action = null;
        if (Global.equals((Object)value, (Object)ProcessFramePolicy.Asynchronous) && this.__dispatchQueue == null) {
            if (action == null) {
                action = new IAction1<TFrame>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void invoke(TFrame frame) {
                        try {
                            MediaSink.this.processFrameSync(frame);
                        }
                        finally {
                            for (MediaBuffer local : frame.getBuffers()) {
                                local.free();
                            }
                        }
                    }
                };
            }
            this.__dispatchQueue = new DispatchQueue(action);
        }
        this.__processPolicy = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MediaSinkState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TSink> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    public String toString() {
        return StringExtensions.format("{0} ({1})", this.getLabel(), ((MediaFormat)this.getInputFormat()).getName());
    }

    private void validateInput(TIOutput input) {
        if (!(input instanceof Stream)) {
            if (this.getInputFormat() == null) {
                this.setInputFormat(((MediaFormat)input.getOutputFormat()).clone());
            }
            if (!((MediaFormat)input.getOutputFormat()).isEquivalent(this.getInputFormat())) {
                throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Output format [", ((MediaFormat)input.getOutputFormat()).toString(), "] of input (", input.getLabel(), ") does not match input format [", ((MediaFormat)this.getInputFormat()).toString(), "] of self (", this.getLabel(), ")."})));
            }
        }
    }
}

