/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Collection;
import fm.icelink.DispatchQueue;
import fm.icelink.Dynamic;
import fm.icelink.Error;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate0;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaInputCollection;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaOutputCollection;
import fm.icelink.IOutput;
import fm.icelink.JsonSerializer;
import fm.icelink.License;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaPipeState;
import fm.icelink.MediaTrackStats;
import fm.icelink.ProcessFramePolicy;
import fm.icelink.Stream;
import fm.icelink.StringExtensions;
import fm.icelink.diagnostics.DurationTimer;
import fm.icelink.diagnostics.Timers;
import fm.icelink.sdp.MediaDescription;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaPipe<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIOutputCollection extends IMediaOutputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIOutputCollection>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInputCollection extends IMediaInputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIInputCollection>, TPipe extends MediaPipe<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TPipe, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends Dynamic
implements IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>,
IMediaElement,
IElement {
    private DurationTimer __diagnosticTimer;
    private boolean __disabled = true;
    private DispatchQueue<TFrame> __dispatchQueue;
    private TIOutputCollection __inputs;
    private List<IAction0> __onDisabledChange = new ArrayList<IAction0>();
    private List<IAction1<MediaControlFrame[]>> __onProcessControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onProcessFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction2<TFrame, Exception>> __onProcessFrameException = new ArrayList<IAction2<TFrame, Exception>>();
    private List<IAction1<MediaControlFrame[]>> __onRaiseControlFrames = new ArrayList<IAction1<MediaControlFrame[]>>();
    private List<IAction1<TFrame>> __onRaiseFrame = new ArrayList<IAction1<TFrame>>();
    private List<IAction1<TPipe>> __onStateChange = new ArrayList<IAction1<TPipe>>();
    private TIInputCollection __outputs;
    private volatile boolean __processingControlFrames = false;
    private volatile boolean __processingFrame = false;
    private ProcessFramePolicy __processPolicy;
    private volatile boolean __raisingControlFrames = false;
    private volatile boolean __raisingFrame = false;
    private MediaPipeState __state = MediaPipeState.Initialized;
    private Object __stateLock = new Object();
    private String _id;
    private TFormat _inputFormat;
    private boolean _muted;
    private IAction0 _onDisabledChange = null;
    private IAction1<MediaControlFrame[]> _onProcessControlFrames = null;
    private IAction1<TFrame> _onProcessFrame = null;
    private IAction2<TFrame, Exception> _onProcessFrameException = null;
    private IAction1<MediaControlFrame[]> _onRaiseControlFrames = null;
    private IAction1<TFrame> _onRaiseFrame = null;
    private IAction1<TPipe> _onStateChange = null;
    private TFormat _outputFormat;
    private boolean _persistent;
    private String _tag;

    @Override
    public void addInput(TIOutput input) {
        if (input == null) {
            throw new RuntimeException(new Exception("Received null input in the media pipe."));
        }
        if (input != null) {
            this.validateInput(input);
            ((Collection)this.__inputs).add(input);
        }
    }

    @Override
    public void addInputs(TIOutput[] inputs) {
        if (inputs == null) {
            throw new RuntimeException(new Exception("Received null inputs in the media pipe."));
        }
        for (TIOutput local : inputs) {
            this.validateInput(local);
        }
        ((Collection)this.__inputs).addMany(inputs);
    }

    @Override
    public void addOnDisabledChange(IAction0 value) {
        if (value != null) {
            if (this._onDisabledChange == null) {
                this._onDisabledChange = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(MediaPipe.this.__onDisabledChange)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onDisabledChange.add(value);
        }
    }

    @Override
    public void addOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onProcessControlFrames == null) {
                this._onProcessControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(MediaPipe.this.__onProcessControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onProcessControlFrames.add(value);
        }
    }

    @Override
    public void addOnProcessFrame(IAction1<TFrame> value) {
        if (value != null) {
            if (this._onProcessFrame == null) {
                this._onProcessFrame = new IAction1<TFrame>(){

                    @Override
                    public void invoke(TFrame p0) {
                        for (IAction1 action : new ArrayList(MediaPipe.this.__onProcessFrame)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onProcessFrame.add(value);
        }
    }

    public void addOnProcessFrameException(IAction2<TFrame, Exception> value) {
        if (value != null) {
            if (this._onProcessFrameException == null) {
                this._onProcessFrameException = new IAction2<TFrame, Exception>(){

                    @Override
                    public void invoke(TFrame p0, Exception p1) {
                        for (IAction2 action : new ArrayList(MediaPipe.this.__onProcessFrameException)) {
                            action.invoke(p0, p1);
                        }
                    }
                };
            }
            this.__onProcessFrameException.add(value);
        }
    }

    @Override
    public void addOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        if (value != null) {
            if (this._onRaiseControlFrames == null) {
                this._onRaiseControlFrames = new IAction1<MediaControlFrame[]>(){

                    @Override
                    public void invoke(MediaControlFrame[] p0) {
                        for (IAction1 action : new ArrayList(MediaPipe.this.__onRaiseControlFrames)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onRaiseControlFrames.add(value);
        }
    }

    @Override
    public void addOnRaiseFrame(IAction1<TFrame> value) {
        if (value != null) {
            if (this._onRaiseFrame == null) {
                this._onRaiseFrame = new IAction1<TFrame>(){

                    @Override
                    public void invoke(TFrame p0) {
                        for (IAction1 action : new ArrayList(MediaPipe.this.__onRaiseFrame)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onRaiseFrame.add(value);
        }
    }

    public void addOnStateChange(IAction1<TPipe> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<TPipe>(){

                    @Override
                    public void invoke(TPipe p0) {
                        for (IAction1 action : new ArrayList(MediaPipe.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    @Override
    public void addOutput(TIInput output) {
        if (output == null) {
            throw new RuntimeException(new Exception("Received null output in the media pipe."));
        }
        this.validateOutput(output);
        output.addOnDisabledChange(new IActionDelegate0(){

            @Override
            public String getId() {
                return "fm.icelink.MediaPipe<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TPipe,TFrame,TBuffer,TBufferCollection,TFormat>.outputDisabledChanged";
            }

            @Override
            public void invoke() {
                MediaPipe.this.outputDisabledChanged();
            }
        });
        ((Collection)this.__outputs).add(output);
        this.updateDisabled();
    }

    @Override
    public void addOutputs(TIInput[] outputs) {
        if (outputs == null) {
            throw new RuntimeException(new Exception("Received null outputs in the media pipe."));
        }
        for (TIInput local : outputs) {
            this.validateOutput(local);
            local.addOnDisabledChange(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaPipe<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TPipe,TFrame,TBuffer,TBufferCollection,TFormat>.outputDisabledChanged";
                }

                @Override
                public void invoke() {
                    MediaPipe.this.outputDisabledChanged();
                }
            });
        }
        ((Collection)this.__outputs).addMany(outputs);
        this.updateDisabled();
    }

    protected abstract TIInputCollection createInputCollection(TIOutput var1);

    protected abstract TIOutputCollection createOutputCollection(TIInput var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        MediaPipeState state;
        Object obj2;
        Object object = obj2 = this.__stateLock;
        synchronized (object) {
            MediaPipeState _var0 = this.getState();
            if (_var0 == MediaPipeState.Destroying) {
                throw new RuntimeException(new Exception("A media pipe cannot be destroyed while it is being destroyed on a different thread."));
            }
            if (_var0 == MediaPipeState.Destroyed) {
                return true;
            }
            state = this.getState();
            this.setState(MediaPipeState.Destroying);
        }
        Log.debug(StringExtensions.format("Media pipe ({0}) is being destroyed.", this.getLabel()));
        while (this.__processingFrame || this.__processingControlFrames || this.__raisingFrame || this.__raisingControlFrames) {
            ManagedThread.sleep(10);
        }
        try {
            this.doDestroy();
            if (this.__diagnosticTimer != null) {
                this.__diagnosticTimer.destroy();
                this.__diagnosticTimer = null;
            }
            object = obj2 = this.__stateLock;
            synchronized (object) {
                this.setState(MediaPipeState.Destroyed);
            }
            ((IMediaOutputCollection)this.__inputs).destroy();
            ((IMediaInputCollection)this.__outputs).destroy();
            return true;
        }
        catch (Exception obj1) {
            Object object2 = obj2 = this.__stateLock;
            synchronized (object2) {
                this.setState(state);
            }
            return false;
        }
    }

    protected abstract void doDestroy();

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        this.raiseControlFrames(controlFrames);
    }

    protected abstract void doProcessFrame(TFrame var1, TBuffer var2);

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        return null;
    }

    protected void doProcessStatsFromInput(MediaTrackStats stats) {
    }

    protected void doProcessStatsFromOutput(MediaTrackStats stats) {
    }

    protected boolean getAllowDiagnosticTimer() {
        return true;
    }

    @Override
    public boolean getDisabled() {
        return this.updateDisabled();
    }

    @Override
    public int getFirSequenceNumber() {
        IOutput input = this.getInput();
        if (input != null) {
            return input.getFirSequenceNumber();
        }
        return 0;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public TIOutput getInput() {
        return (TIOutput)((IMediaOutput)((Collection)this.__inputs).getValue());
    }

    @Override
    public TFormat getInputFormat() {
        return this._inputFormat;
    }

    @Override
    public TIOutput[] getInputs() {
        return (IMediaOutput[])((Collection)this.__inputs).getValues();
    }

    @Override
    public abstract String getLabel();

    @Override
    public int getMaxInputBitrate() {
        return this.getMaxOutputBitrate();
    }

    @Override
    public int getMaxOutputBitrate() {
        int maxInputBitrate = -1;
        for (IMediaInput local : this.getOutputs()) {
            if (maxInputBitrate < 0) {
                maxInputBitrate = local.getMaxInputBitrate();
                continue;
            }
            if (local.getMaxInputBitrate() < 0) continue;
            maxInputBitrate = MathAssistant.min(local.getMaxInputBitrate(), maxInputBitrate);
        }
        return maxInputBitrate;
    }

    @Override
    public boolean getMuted() {
        return this._muted;
    }

    @Override
    public TIInput getOutput() {
        return (TIInput)((IMediaInput)((Collection)this.__outputs).getValue());
    }

    @Override
    public TFormat getOutputFormat() {
        return this._outputFormat;
    }

    @Override
    public TIInput[] getOutputs() {
        return (IMediaInput[])((Collection)this.__outputs).getValues();
    }

    @Override
    public boolean getPersistent() {
        return this._persistent;
    }

    @Override
    public String getPipelineJson() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    protected String getPipelineJsonBase() {
        return StringExtensions.concat(new String[]{this.getPipelineJsonId(), ", ", this.getPipelineJsonLabel(), ", ", this.getPipelineJsonTag(), ", ", this.getPipelineJsonDisabled(), ", ", this.getPipelineJsonInput(), ", ", this.getPipelineJsonOutput()});
    }

    private String getPipelineJsonDisabled() {
        return StringExtensions.concat("\"disabled\": ", this.getDisabled() ? "true" : "false");
    }

    @Override
    public String getPipelineJsonFromInput() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonOutputs(), " }"});
    }

    @Override
    public String getPipelineJsonFromOutput() {
        return StringExtensions.concat(new String[]{"{ ", this.getPipelineJsonBase(), ", ", this.getPipelineJsonInputs(), " }"});
    }

    private String getPipelineJsonId() {
        return StringExtensions.concat("\"id\": ", JsonSerializer.serializeString(this.getId()));
    }

    private String getPipelineJsonInput() {
        return StringExtensions.concat("\"inputFormat\": ", this.getInputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getInputFormat()).toString()));
    }

    protected String getPipelineJsonInputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaOutput local : this.getInputs()) {
            list.add(local.getPipelineJsonFromOutput());
        }
        return StringExtensions.concat("\"inputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonLabel() {
        return StringExtensions.concat("\"label\": ", JsonSerializer.serializeString(this.getLabel()));
    }

    private String getPipelineJsonOutput() {
        return StringExtensions.concat("\"outputFormat\": ", this.getOutputFormat() == null ? "null" : JsonSerializer.serializeString(((MediaFormat)this.getOutputFormat()).toString()));
    }

    protected String getPipelineJsonOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (IMediaInput local : this.getOutputs()) {
            list.add(local.getPipelineJsonFromInput());
        }
        return StringExtensions.concat("\"outputs\": [", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    private String getPipelineJsonTag() {
        return StringExtensions.concat("\"tag\": ", JsonSerializer.serializeString(this.getTag()));
    }

    @Override
    public ProcessFramePolicy getProcessFramePolicy() {
        return this.__processPolicy;
    }

    public MediaPipeState getState() {
        return this.__state;
    }

    public String getTag() {
        return this._tag;
    }

    public boolean hasInput(TIOutput input) {
        for (IMediaOutput local : this.getInputs()) {
            if (local != input) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutput(TIInput output) {
        for (IMediaInput local : this.getOutputs()) {
            if (local != output) continue;
            return true;
        }
        return false;
    }

    @Override
    public void incrementFirSequenceNumber() {
        IOutput input = this.getInput();
        if (input != null) {
            input.incrementFirSequenceNumber();
        }
    }

    public MediaPipe(TFormat outputFormat) {
        this(null, outputFormat);
    }

    public MediaPipe(TFormat inputFormat, TFormat outputFormat) {
        License.checkKey();
        this.__processPolicy = ProcessFramePolicy.Synchronous;
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setInputFormat(inputFormat);
        this.setOutputFormat(outputFormat);
        this.__outputs = this.createInputCollection(this);
        this.__inputs = this.createOutputCollection(this);
        if (this.getAllowDiagnosticTimer()) {
            this.__diagnosticTimer = Timers.getDurationTimer(StringExtensions.format("{0} ({1}, {2})", this.getLabel(), this.getInputFormat() != null ? ((MediaFormat)this.getInputFormat()).getName() : "null", this.getOutputFormat() != null ? ((MediaFormat)this.getOutputFormat()).getName() : "null"));
        }
    }

    private void outputDisabledChanged() {
        this.updateDisabled();
    }

    @Override
    public void processControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__processingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
                    IAction1<MediaControlFrame[]> onProcessControlFrames = this._onProcessControlFrames;
                    if (onProcessControlFrames != null) {
                        onProcessControlFrames.invoke(controlFrames);
                    }
                    this.doProcessControlFrames(controlFrames);
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not process control frames.", this.getLabel()), exception);
            }
            finally {
                this.__processingControlFrames = false;
            }
        }
    }

    @Override
    public boolean processFrame(TFrame frame) {
        if (Global.equals((Object)this.getProcessFramePolicy(), (Object)ProcessFramePolicy.Synchronous)) {
            return this.processFrameSync(frame);
        }
        if (Global.equals((Object)this.getProcessFramePolicy(), (Object)ProcessFramePolicy.Asynchronous)) {
            for (MediaBuffer local : frame.getBuffers()) {
                local.keep();
            }
            this.__dispatchQueue.enqueue(frame);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFrameSync(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__processingFrame = true;
            try {
                Object buffer22;
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized) && (buffer22 = ((MediaFrame)frame).getBuffer(this.getInputFormat())) != null) {
                    IAction1<TFrame> onProcessFrame;
                    if (StringExtensions.isNullOrEmpty(((MediaBuffer)buffer22).getSourceId())) {
                        ((MediaBuffer)buffer22).setSourceId(this.getId());
                    }
                    if (this.getMuted()) {
                        ((MediaBuffer)buffer22).mute();
                    }
                    if ((onProcessFrame = this._onProcessFrame) != null) {
                        onProcessFrame.invoke(frame);
                    }
                    if (this.__diagnosticTimer != null) {
                        this.__diagnosticTimer.beginSample();
                    }
                    this.doProcessFrame(frame, buffer22);
                }
                boolean buffer22 = true;
                return buffer22;
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not process frame.", this.getLabel()), exception);
                IAction2<TFrame, Exception> onProcessFrameException = this._onProcessFrameException;
                if (onProcessFrameException != null) {
                    onProcessFrameException.invoke(frame, exception);
                }
            }
            finally {
                this.__processingFrame = false;
            }
        }
        return false;
    }

    @Override
    public boolean processGetMuteFromStream() {
        for (IMediaOutput local : this.getInputs()) {
            if (!local.processGetMuteFromStream()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Error processSdpMediaDescriptionFromInput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        Error error = this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        for (IMediaInput local : this.getOutputs()) {
            if (error != null) {
                return error;
            }
            error = local.processSdpMediaDescriptionFromInput(mediaDescription, isOffer, isLocalDescription);
        }
        return null;
    }

    @Override
    public Error processSdpMediaDescriptionFromOutput(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        Error error = this.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        for (IMediaOutput local : this.getInputs()) {
            if (error != null) {
                return error;
            }
            error = local.processSdpMediaDescriptionFromOutput(mediaDescription, isOffer, isLocalDescription);
        }
        return null;
    }

    @Override
    public void processSetMuteFromStream(boolean mute) {
        this.setMuted(mute);
        for (IMediaOutput local : this.getInputs()) {
            local.processSetMuteFromStream(mute);
        }
    }

    @Override
    public void processStatsFromInput(MediaTrackStats stats) {
        this.doProcessStatsFromInput(stats);
        for (IMediaInput local : this.getOutputs()) {
            local.processStatsFromInput(stats);
        }
    }

    @Override
    public void processStatsFromOutput(MediaTrackStats stats) {
        this.doProcessStatsFromOutput(stats);
        for (IMediaOutput local : this.getInputs()) {
            local.processStatsFromOutput(stats);
        }
    }

    protected void raiseControlFrame(MediaControlFrame controlFrame) {
        this.raiseControlFrames(new MediaControlFrame[]{controlFrame});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseControlFrames(MediaControlFrame[] controlFrames) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            this.__raisingControlFrames = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
                    IAction1<MediaControlFrame[]> onRaiseControlFrames = this._onRaiseControlFrames;
                    if (onRaiseControlFrames != null) {
                        onRaiseControlFrames.invoke(controlFrames);
                    }
                    for (IMediaOutput local : this.getInputs()) {
                        if (local.getDisabled()) continue;
                        local.processControlFrames(controlFrames);
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not raise control frames.", this.getLabel()), exception);
            }
            finally {
                this.__raisingControlFrames = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseFrame(TFrame frame) {
        if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
            if (this.__diagnosticTimer != null) {
                this.__diagnosticTimer.endSample();
            }
            this.__raisingFrame = true;
            try {
                if (Global.equals((Object)this.__state, (Object)MediaPipeState.Initialized)) {
                    Object[] outputs;
                    for (MediaBuffer local : frame.getBuffers()) {
                        if (StringExtensions.isNullOrEmpty(local.getSourceId())) {
                            local.setSourceId(this.getId());
                        }
                        if (!this.getMuted()) continue;
                        local.mute();
                    }
                    IAction1<TFrame> onRaiseFrame = this._onRaiseFrame;
                    if (onRaiseFrame != null) {
                        onRaiseFrame.invoke(frame);
                    }
                    if (ArrayExtensions.getLength(outputs = this.getOutputs()) > 0) {
                        TFrame local2 = frame;
                        for (int i = 0; i < ArrayExtensions.getLength(outputs); ++i) {
                            Object local3 = outputs[i];
                            Object outputFormat = this.getOutputFormat();
                            if (local3.getDisabled() || outputFormat == null || !((MediaFormat)this.getOutputFormat()).getIsInjected() && !((MediaFormat)outputFormat).isEquivalent(local3.getInputFormat())) continue;
                            if (ArrayExtensions.getLength(outputs) > 1) {
                                local3.processFrame(((MediaFrame)local2).clone());
                                continue;
                            }
                            local3.processFrame(frame);
                        }
                    }
                }
            }
            catch (Exception exception) {
                Log.error(StringExtensions.format("Media pipe ({0}) could not raise frame.", this.getLabel()), exception);
            }
            finally {
                this.__raisingFrame = false;
            }
        }
    }

    @Override
    public boolean removeInput(TIOutput input) {
        return ((Collection)this.__inputs).remove(input);
    }

    @Override
    public void removeInputs() {
        ((Collection)this.__inputs).removeAll();
    }

    @Override
    public boolean removeInputs(TIOutput[] inputs) {
        return ((Collection)this.__inputs).removeMany(inputs);
    }

    @Override
    public void removeOnDisabledChange(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onDisabledChange, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onDisabledChange.remove(value);
        if (this.__onDisabledChange.size() == 0) {
            this._onDisabledChange = null;
        }
    }

    @Override
    public void removeOnProcessControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessControlFrames.remove(value);
        if (this.__onProcessControlFrames.size() == 0) {
            this._onProcessControlFrames = null;
        }
    }

    @Override
    public void removeOnProcessFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onProcessFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrame.remove(value);
        if (this.__onProcessFrame.size() == 0) {
            this._onProcessFrame = null;
        }
    }

    public void removeOnProcessFrameException(IAction2<TFrame, Exception> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onProcessFrameException, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onProcessFrameException.remove(value);
        if (this.__onProcessFrameException.size() == 0) {
            this._onProcessFrameException = null;
        }
    }

    @Override
    public void removeOnRaiseControlFrames(IAction1<MediaControlFrame[]> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseControlFrames, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseControlFrames.remove(value);
        if (this.__onRaiseControlFrames.size() == 0) {
            this._onRaiseControlFrames = null;
        }
    }

    @Override
    public void removeOnRaiseFrame(IAction1<TFrame> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onRaiseFrame, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onRaiseFrame.remove(value);
        if (this.__onRaiseFrame.size() == 0) {
            this._onRaiseFrame = null;
        }
    }

    public void removeOnStateChange(IAction1<TPipe> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    @Override
    public boolean removeOutput(TIInput output) {
        if (output != null) {
            output.removeOnDisabledChange(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaPipe<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TPipe,TFrame,TBuffer,TBufferCollection,TFormat>.outputDisabledChanged";
                }

                @Override
                public void invoke() {
                    MediaPipe.this.outputDisabledChanged();
                }
            });
        }
        boolean flag = ((Collection)this.__outputs).remove(output);
        this.updateDisabled();
        return flag;
    }

    @Override
    public boolean removeOutputs(TIInput[] outputs) {
        for (TIInput local : outputs) {
            local.removeOnDisabledChange(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaPipe<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TPipe,TFrame,TBuffer,TBufferCollection,TFormat>.outputDisabledChanged";
                }

                @Override
                public void invoke() {
                    MediaPipe.this.outputDisabledChanged();
                }
            });
        }
        boolean flag = ((Collection)this.__outputs).removeMany(outputs);
        this.updateDisabled();
        return flag;
    }

    @Override
    public void removeOutputs() {
        for (IMediaInput local : (IMediaInput[])((Collection)this.__outputs).getValues()) {
            local.removeOnDisabledChange(new IActionDelegate0(){

                @Override
                public String getId() {
                    return "fm.icelink.MediaPipe<TIOutput,TIOutputCollection,TIInput,TIInputCollection,TPipe,TFrame,TBuffer,TBufferCollection,TFormat>.outputDisabledChanged";
                }

                @Override
                public void invoke() {
                    MediaPipe.this.outputDisabledChanged();
                }
            });
        }
        ((Collection)this.__outputs).removeAll();
        this.updateDisabled();
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    public void setInput(TIOutput value) {
        this.removeInputs();
        this.addInput(value);
    }

    private void setInputFormat(TFormat value) {
        this._inputFormat = value;
    }

    public void setInputs(TIOutput[] value) {
        this.removeInputs();
        this.addInputs((IMediaOutput[])value);
    }

    @Override
    public void setMuted(boolean value) {
        this._muted = value;
    }

    public void setOutput(TIInput value) {
        this.removeOutputs();
        this.addOutput(value);
    }

    private void setOutputFormat(TFormat value) {
        this._outputFormat = value;
    }

    public void setOutputs(TIInput[] value) {
        this.removeOutputs();
        this.addOutputs((IMediaInput[])value);
    }

    public void setPersistent(boolean value) {
        this._persistent = value;
    }

    @Override
    public void setProcessFramePolicy(ProcessFramePolicy value) {
        IAction1 action = null;
        if (Global.equals((Object)value, (Object)ProcessFramePolicy.Asynchronous) && this.__dispatchQueue == null) {
            if (action == null) {
                action = new IAction1<TFrame>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void invoke(TFrame frame) {
                        try {
                            MediaPipe.this.processFrameSync(frame);
                        }
                        finally {
                            for (MediaBuffer local : frame.getBuffers()) {
                                local.free();
                            }
                        }
                    }
                };
            }
            this.__dispatchQueue = new DispatchQueue(action);
        }
        this.__processPolicy = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(MediaPipeState value) {
        Object object = this.__stateLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                this.__state = value;
                IAction1<TPipe> onStateChange = this._onStateChange;
                if (onStateChange != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    public void setTag(String value) {
        this._tag = value;
    }

    public String toString() {
        return this.getLabel();
    }

    private boolean updateDisabled() {
        boolean flag = true;
        if (((MediaFormat)this.getOutputFormat()).getIsInjected()) {
            flag = false;
        } else {
            for (IMediaInput local : this.getOutputs()) {
                TFormat inputFormat = local.getInputFormat();
                if (local.getDisabled() || inputFormat == null || !((MediaFormat)inputFormat).isEquivalent(this.getOutputFormat())) continue;
                flag = false;
                break;
            }
        }
        if (!Global.equals(this.__disabled, flag)) {
            this.__disabled = flag;
            IAction0 onDisabledChange = this._onDisabledChange;
            if (onDisabledChange != null) {
                onDisabledChange.invoke();
            }
        }
        return flag;
    }

    private void validateInput(TIOutput input) {
        if (!(input instanceof Stream)) {
            if (this.getInputFormat() == null) {
                this.setInputFormat(((MediaFormat)input.getOutputFormat()).clone());
            }
            if (!((MediaFormat)input.getOutputFormat()).isEquivalent(this.getInputFormat())) {
                throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Output format [", ((MediaFormat)input.getOutputFormat()).toString(), "] of input (", input.getLabel(), ") does not match input format [", ((MediaFormat)this.getInputFormat()).toString(), "] of self (", this.getLabel(), ")."})));
            }
        }
    }

    private void validateOutput(TIInput output) {
        if (!(output instanceof Stream) && output.getInputFormat() != null && !((MediaFormat)output.getInputFormat()).isEquivalent(this.getOutputFormat())) {
            throw new RuntimeException(new Exception(StringExtensions.concat(new String[]{"Input format [", ((MediaFormat)output.getInputFormat()).toString(), "] of output (", output.getLabel(), ") does not match output format [", ((MediaFormat)this.getOutputFormat()).toString(), "] of self (", this.getLabel(), ")."})));
        }
    }
}

