/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Dynamic;
import fm.icelink.MediaFormat;
import fm.icelink.RtpPacketHeader;
import fm.icelink.Utility;

public abstract class MediaBuffer<TFormat extends MediaFormat<TFormat>, TBuffer extends MediaBuffer<TFormat, TBuffer>>
extends Dynamic {
    private DataBuffer[] _dataBuffers;
    private TFormat _format;
    private boolean _recoveredByFec;
    private RtpPacketHeader[] _rtpHeaders;
    private long[] _sequenceNumbers;
    private String _sourceId;

    public TBuffer clone() {
        TBuffer local = this.createInstance();
        ((MediaBuffer)local).setDataBuffers(this.getDataBuffers());
        ((MediaBuffer)local).setSequenceNumbers(this.getSequenceNumbers());
        if (this.getRtpHeaders() != null) {
            ((MediaBuffer)local).setRtpHeaders(new RtpPacketHeader[ArrayExtensions.getLength(this.getRtpHeaders())]);
            for (int i = 0; i < ArrayExtensions.getLength(((MediaBuffer)local).getRtpHeaders()); ++i) {
                if (this.getRtpHeaders()[i] == null) continue;
                ((MediaBuffer)local).getRtpHeaders()[i] = this.getRtpHeaders()[i].clone();
            }
        }
        ((MediaBuffer)local).setFormat((Object)((MediaFormat)this.getFormat()).clone());
        return local;
    }

    protected abstract TBuffer createInstance();

    public void free() {
        for (DataBuffer buffer : this.getDataBuffers()) {
            buffer.free();
        }
    }

    public DataBuffer getDataBuffer() {
        return Utility.firstOrDefault(this.getDataBuffers());
    }

    public DataBuffer[] getDataBuffers() {
        return this._dataBuffers;
    }

    public TFormat getFormat() {
        return this._format;
    }

    public abstract boolean getIsMuted();

    boolean getIsPacketized() {
        return false;
    }

    public long getLastSequenceNumber() {
        long[] sequenceNumbers = this.getSequenceNumbers();
        if (sequenceNumbers == null) {
            return 0L;
        }
        return sequenceNumbers[ArrayExtensions.getLength(sequenceNumbers) - 1];
    }

    public boolean getRecoveredByFec() {
        return this._recoveredByFec;
    }

    public RtpPacketHeader getRtpHeader() {
        return Utility.firstOrDefault(this.getRtpHeaders());
    }

    public RtpPacketHeader[] getRtpHeaders() {
        return this._rtpHeaders;
    }

    public int getRtpSequenceNumber() {
        int[] rtpSequenceNumbers = this.getRtpSequenceNumbers();
        if (rtpSequenceNumbers == null) {
            return 0;
        }
        return rtpSequenceNumbers[0];
    }

    public int[] getRtpSequenceNumbers() {
        int[] numArray = null;
        if (this.getIsPacketized()) {
            numArray = new int[ArrayExtensions.getLength(this.getRtpHeaders())];
            for (int i = 0; i < ArrayExtensions.getLength(numArray); ++i) {
                numArray[i] = this.getRtpHeaders()[i].getSequenceNumber();
            }
        }
        return numArray;
    }

    public long getSequenceNumber() {
        long[] sequenceNumbers = this.getSequenceNumbers();
        if (sequenceNumbers == null) {
            return 0L;
        }
        return sequenceNumbers[0];
    }

    public long[] getSequenceNumbers() {
        return this._sequenceNumbers;
    }

    public String getSourceId() {
        return this._sourceId;
    }

    public void keep() {
        for (DataBuffer buffer : this.getDataBuffers()) {
            buffer.keep();
        }
    }

    protected MediaBuffer() {
    }

    protected MediaBuffer(DataBuffer dataBuffer, TFormat format) {
        this(new DataBuffer[]{dataBuffer}, format);
    }

    protected MediaBuffer(DataBuffer[] dataBuffers, TFormat format) {
        this.setDataBuffers(dataBuffers);
        this.setFormat(format);
    }

    public abstract boolean mute();

    public void setDataBuffer(DataBuffer value) {
        DataBuffer[] dataBufferArray;
        if (value == null) {
            dataBufferArray = null;
        } else {
            DataBuffer[] dataBufferArray2 = new DataBuffer[1];
            dataBufferArray = dataBufferArray2;
            dataBufferArray2[0] = value;
        }
        this.setDataBuffers(dataBufferArray);
    }

    public void setDataBuffers(DataBuffer[] value) {
        this._dataBuffers = value;
    }

    public void setFormat(TFormat value) {
        this._format = value;
    }

    public void setRecoveredByFec(boolean value) {
        this._recoveredByFec = value;
    }

    public void setRtpHeader(RtpPacketHeader value) {
        RtpPacketHeader[] rtpPacketHeaderArray;
        if (value == null) {
            rtpPacketHeaderArray = null;
        } else {
            RtpPacketHeader[] rtpPacketHeaderArray2 = new RtpPacketHeader[1];
            rtpPacketHeaderArray = rtpPacketHeaderArray2;
            rtpPacketHeaderArray2[0] = value;
        }
        this.setRtpHeaders(rtpPacketHeaderArray);
    }

    public void setRtpHeaders(RtpPacketHeader[] value) {
        this._rtpHeaders = value;
    }

    public void setSequenceNumber(long value) {
        this.setSequenceNumbers(new long[]{value});
    }

    public void setSequenceNumbers(long[] value) {
        this._sequenceNumbers = value;
    }

    public void setSourceId(String value) {
        this._sourceId = value;
    }

    public String toString() {
        return ((MediaFormat)this.getFormat()).toString();
    }
}

