/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Dynamic;
import fm.icelink.Guid;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaInputCollection;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaOutputCollection;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFrame;
import fm.icelink.MediaPipe;
import fm.icelink.MediaSink;
import fm.icelink.MediaSource;
import fm.icelink.MediaTrack;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;
import java.util.ArrayList;

public abstract class MediaBranch<TIOutput extends IMediaOutput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIOutputCollection extends IMediaOutputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIOutputCollection>, TIInput extends IMediaInput<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat>, TIInputCollection extends IMediaInputCollection<TIOutput, TIInput, TFrame, TBuffer, TBufferCollection, TFormat, TIInputCollection>, TIElement extends IMediaElement, TSource extends MediaSource<TIOutput, TIInput, TIInputCollection, TSource, TFrame, TBuffer, TBufferCollection, TFormat>, TSink extends MediaSink<TIOutput, TIOutputCollection, TIInput, TSink, TFrame, TBuffer, TBufferCollection, TFormat>, TPipe extends MediaPipe<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TPipe, TFrame, TBuffer, TBufferCollection, TFormat>, TTrack extends MediaTrack<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TBranch extends MediaBranch<TIOutput, TIOutputCollection, TIInput, TIInputCollection, TIElement, TSource, TSink, TPipe, TTrack, TBranch, TFrame, TBuffer, TBufferCollection, TFormat>, TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>>
extends Dynamic
implements IMediaElement,
IElement {
    private ArrayList<TTrack> __tracks = new ArrayList();
    private boolean _destroyed = false;
    private Object _destroyLock = new Object();
    private String _id;
    private boolean _persistent;

    protected abstract TTrack[] arrayFromTracks(ArrayList<TTrack> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        MediaTrack[] mediaTrackArray = this._destroyLock;
        synchronized (this._destroyLock) {
            if (this._destroyed) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this._destroyed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (MediaTrack local : this.getTracks()) {
                if (local.getPersistent()) continue;
                local.destroy();
            }
            return true;
        }
    }

    public TTrack getActiveTrack() {
        return (TTrack)Utility.firstOrDefault(this.getActiveTracks());
    }

    public TTrack[] getActiveTracks() {
        ArrayList<MediaTrack> tracks = new ArrayList<MediaTrack>();
        for (MediaTrack local : this.getTracks()) {
            if (local.getDisabled()) continue;
            tracks.add(local);
        }
        return this.arrayFromTracks(tracks);
    }

    @Override
    public boolean getDisabled() {
        return this.getActiveTrack() == null;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public abstract String getLabel();

    @Override
    public boolean getMuted() {
        for (MediaTrack local : this.getTracks()) {
            if (!local.getMuted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getPersistent() {
        return this._persistent;
    }

    @Override
    public String getPipelineJson() {
        ArrayList<String> list = new ArrayList<String>();
        for (MediaTrack local : this.getTracks()) {
            list.add(local.getPipelineJson());
        }
        return StringExtensions.concat("[", StringExtensions.join(", ", list.toArray(new String[0])), "]");
    }

    public TTrack getTrack() {
        Object[] tracks = this.getTracks();
        if (tracks != null && ArrayExtensions.getLength(tracks) > 0) {
            return (TTrack)tracks[0];
        }
        return this.getTrack();
    }

    public TTrack[] getTracks() {
        return this.arrayFromTracks(this.__tracks);
    }

    public MediaBranch(TTrack[] tracks) {
        this.setId(Guid.newGuid().toString().replace("-", ""));
        ArrayListExtensions.addRange(this.__tracks, tracks);
    }

    @Override
    public void setId(String value) {
        this._id = value;
    }

    @Override
    public void setMuted(boolean value) {
        for (MediaTrack local : this.getTracks()) {
            local.setMuted(value);
        }
    }

    public void setPersistent(boolean value) {
        this._persistent = value;
    }

    public String toString() {
        return this.getLabel();
    }
}

