/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BigDecimalExtensions;
import fm.icelink.BooleanHolder;
import fm.icelink.CharacterExtensions;
import fm.icelink.Convert;
import fm.icelink.DoubleExtensions;
import fm.icelink.DoubleHolder;
import fm.icelink.FloatExtensions;
import fm.icelink.FloatHolder;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.JsonChecker;
import fm.icelink.LongExtensions;
import fm.icelink.LongHolder;
import fm.icelink.NullableBigDecimal;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableDouble;
import fm.icelink.NullableFloat;
import fm.icelink.NullableGuid;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import fm.icelink.ParseAssistant;
import fm.icelink.Serializable;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.StringType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class JsonSerializer {
    private static String charToUnicodeString(int value) {
        char ch = JsonSerializer.intToHex(value >> 12 & 0xF);
        char ch2 = JsonSerializer.intToHex(value >> 8 & 0xF);
        char ch3 = JsonSerializer.intToHex(value >> 4 & 0xF);
        char ch4 = JsonSerializer.intToHex(value & 0xF);
        return StringExtensions.concat(new String[]{"\\u", CharacterExtensions.toString(Character.valueOf(ch)), CharacterExtensions.toString(Character.valueOf(ch2)), CharacterExtensions.toString(Character.valueOf(ch3)), CharacterExtensions.toString(Character.valueOf(ch4))});
    }

    public static NullableBoolean deserializeBoolean(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableBoolean(null);
            }
            boolean boolResult = false;
            BooleanHolder _var0 = new BooleanHolder(boolResult);
            boolean _var1 = ParseAssistant.tryParseBooleanValue(valueJson, _var0);
            boolResult = _var0.getValue();
            if (_var1) {
                return new NullableBoolean(boolResult);
            }
        }
        return new NullableBoolean(null);
    }

    public static boolean[] deserializeBooleanArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        boolean[] flagArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                flagArray = new boolean[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                flagArray = new boolean[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    flagArray[i] = JsonSerializer.deserializeBoolean(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return flagArray;
    }

    public static NullableBigDecimal deserializeDecimal(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableBigDecimal(null);
            }
            BigDecimal decimalResult = new BigDecimal("0");
            Holder<BigDecimal> _var0 = new Holder<BigDecimal>(decimalResult);
            boolean _var1 = ParseAssistant.tryParseDecimalValue(valueJson, _var0);
            decimalResult = _var0.getValue();
            if (_var1) {
                return new NullableBigDecimal(decimalResult);
            }
        }
        return new NullableBigDecimal(null);
    }

    public static BigDecimal[] deserializeDecimalArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        BigDecimal[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new BigDecimal[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new BigDecimal[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = JsonSerializer.deserializeDecimal(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static <T> HashMap<String, T> deserializeDictionary(String dictionaryJson, IFunction0<HashMap<String, T>> createDictionaryCallback, final IFunction1<String, T> deserializeValueCallback) {
        return JsonSerializer.deserializeObject(dictionaryJson, createDictionaryCallback, new IAction3<HashMap<String, T>, String, String>(){

            @Override
            public void invoke(HashMap<String, T> dictionary, String key, String valueJson) {
                HashMapExtensions.set(HashMapExtensions.getItem(dictionary), key, deserializeValueCallback.invoke(valueJson));
            }
        });
    }

    public static NullableDouble deserializeDouble(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableDouble(null);
            }
            double doubleResult = 0.0;
            DoubleHolder _var0 = new DoubleHolder(doubleResult);
            boolean _var1 = ParseAssistant.tryParseDoubleValue(valueJson, _var0);
            doubleResult = _var0.getValue();
            if (_var1) {
                return new NullableDouble(doubleResult);
            }
        }
        return new NullableDouble(null);
    }

    public static double[] deserializeDoubleArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        double[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new double[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new double[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = JsonSerializer.deserializeDouble(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableFloat deserializeFloat(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableFloat(null);
            }
            float floatResult = 0.0f;
            FloatHolder _var0 = new FloatHolder(floatResult);
            boolean _var1 = ParseAssistant.tryParseFloatValue(valueJson, _var0);
            floatResult = _var0.getValue();
            if (_var1) {
                return new NullableFloat(floatResult);
            }
        }
        return new NullableFloat(null);
    }

    public static float[] deserializeFloatArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        float[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new float[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new float[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = JsonSerializer.deserializeFloat(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableGuid deserializeGuid(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableGuid(null);
            }
            Guid empty = Guid.empty;
            Holder<Guid> _var0 = new Holder<Guid>(empty);
            boolean _var1 = ParseAssistant.tryParseGuidValue(JsonSerializer.deserializeString(valueJson), _var0);
            empty = _var0.getValue();
            if (_var1) {
                return new NullableGuid(empty);
            }
        }
        return new NullableGuid(null);
    }

    public static Guid[] deserializeGuidArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        Guid[] guidArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                guidArray = new Guid[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                guidArray = new Guid[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    guidArray[i] = JsonSerializer.deserializeGuid(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return guidArray;
    }

    public static NullableInteger deserializeInteger(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableInteger(null);
            }
            int intResult = 0;
            IntegerHolder _var0 = new IntegerHolder(intResult);
            boolean _var1 = ParseAssistant.tryParseIntegerValue(valueJson, _var0);
            intResult = _var0.getValue();
            if (_var1) {
                return new NullableInteger(intResult);
            }
        }
        return new NullableInteger(null);
    }

    public static int[] deserializeIntegerArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        int[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new int[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new int[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = JsonSerializer.deserializeInteger(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableLong deserializeLong(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableLong(null);
            }
            long longResult = 0L;
            LongHolder _var0 = new LongHolder(longResult);
            boolean _var1 = ParseAssistant.tryParseLongValue(valueJson, _var0);
            longResult = _var0.getValue();
            if (_var1) {
                return new NullableLong(longResult);
            }
        }
        return new NullableLong(null);
    }

    public static long[] deserializeLongArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        long[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new long[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new long[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = JsonSerializer.deserializeLong(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static <T> T deserializeObject(String json, IFunction0<T> creator, IAction3<T, String, String> callback) {
        if (json == null) {
            return null;
        }
        if (Global.equals(json = json.trim(), "null") || StringExtensions.getLength(json) < 2) {
            return null;
        }
        T local = creator.invoke();
        if (json.charAt(0) == '{' && json.charAt(StringExtensions.getLength(json) - 1) == '}' && StringExtensions.getLength(json) > 2) {
            json = StringExtensions.concat(StringExtensions.substring(json, 1, StringExtensions.getLength(json) - 2), ",");
            int num = 0;
            int num2 = 0;
            boolean flag = false;
            int num3 = -2;
            StringType none = StringType.None;
            int startIndex = 0;
            int num5 = 0;
            String valueJson = StringExtensions.empty;
            String str2 = StringExtensions.empty;
            for (int i = 0; i < StringExtensions.getLength(json); ++i) {
                StringType type2;
                char ch = json.charAt(i);
                boolean flag2 = num3 == i - 1;
                boolean flag3 = false;
                if (!flag) {
                    char _var0 = ch;
                    if (_var0 == '[') {
                        ++num2;
                        flag3 = true;
                    } else if (_var0 == ']') {
                        --num2;
                        flag3 = true;
                    } else if (_var0 == '{') {
                        ++num;
                        flag3 = true;
                    } else if (_var0 == '}') {
                        --num;
                        flag3 = true;
                    }
                }
                if (flag3) continue;
                if (flag && ch == '\\' && !flag2) {
                    num3 = i;
                    flag3 = true;
                }
                if (flag3) continue;
                if (num == 0 && num2 == 0) {
                    char _var1 = ch;
                    if (_var1 == ',') {
                        if (!flag) {
                            str2 = StringExtensions.substring(json, num5, i - num5).trim();
                            callback.invoke(local, JsonSerializer.deserializeString(valueJson), str2);
                            startIndex = i + 1;
                        }
                        flag3 = true;
                    } else if (_var1 == ':') {
                        if (!flag) {
                            valueJson = StringExtensions.substring(json, startIndex, i - startIndex).trim();
                            num5 = i + 1;
                        }
                        flag3 = true;
                    }
                }
                if (flag3 || ch != '\'' && ch != '\"' || flag2) continue;
                StringType stringType = type2 = ch == '\"' ? StringType.Double : StringType.Single;
                if (!flag) {
                    flag = true;
                    none = type2;
                } else if (Global.equals((Object)none, (Object)type2)) {
                    flag = false;
                    none = StringType.None;
                }
                flag3 = true;
            }
        }
        return local;
    }

    public static <T> ArrayList<T> deserializeObjectArray(String json, IFunction1<String, T> deserializer) {
        ArrayList<String> list = JsonSerializer.deserializeRawArray(json);
        if (list == null) {
            return null;
        }
        ArrayList<T> list2 = new ArrayList<T>(ArrayListExtensions.getCount(list));
        for (String str : list) {
            T item = deserializer.invoke(str);
            list2.add(item);
        }
        return list2;
    }

    public static <T extends Serializable> T deserializeObjectFast(String json, IFunction0<T> creator, IAction3<T, String, String> callback) {
        Serializable local = (Serializable)JsonSerializer.deserializeObject(json, creator, callback);
        if (local != null) {
            local.setSerialized(json);
        }
        return (T)local;
    }

    public static String deserializeRaw(String dataJson) {
        if (StringExtensions.isNullOrEmpty(dataJson)) {
            return null;
        }
        return dataJson.trim();
    }

    public static ArrayList<String> deserializeRawArray(String json) {
        if (json == null) {
            return null;
        }
        if (Global.equals(json = json.trim(), "null") || StringExtensions.getLength(json) < 2) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (json.charAt(0) == '[' && json.charAt(StringExtensions.getLength(json) - 1) == ']' && StringExtensions.getLength(json) > 2) {
            int num = 0;
            int startIndex = 0;
            boolean flag = false;
            int num3 = -2;
            StringType none = StringType.None;
            for (int i = 1; i < StringExtensions.getLength(json) - 1; ++i) {
                StringType type2;
                boolean flag2;
                char ch = json.charAt(i);
                boolean bl = flag2 = num3 == i - 1;
                if (!flag) {
                    char _var0 = ch;
                    if (_var0 == '{') {
                        if (num == 0) {
                            startIndex = i;
                        }
                        ++num;
                    } else if (_var0 == '}' && --num == 0) {
                        list.add(StringExtensions.substring(json, startIndex, i - startIndex + 1));
                    }
                }
                if (flag && ch == '\\' && !flag2) {
                    num3 = i;
                    continue;
                }
                if (ch != '\'' && ch != '\"' || flag2) continue;
                StringType stringType = type2 = ch == '\"' ? StringType.Double : StringType.Single;
                if (!flag) {
                    flag = true;
                    none = type2;
                    continue;
                }
                if (!Global.equals((Object)none, (Object)type2)) continue;
                flag = false;
                none = StringType.None;
            }
        }
        return list;
    }

    public static String deserializeString(String valueJson) {
        boolean flag2;
        if (StringExtensions.isNullOrEmpty(valueJson)) {
            return null;
        }
        if (Global.equals(valueJson = valueJson.trim(), "null")) {
            return null;
        }
        boolean flag = valueJson.startsWith("\"") || valueJson.startsWith("'");
        boolean bl = flag2 = valueJson.endsWith("\"") || valueJson.endsWith("'");
        if (!flag || !flag2) {
            return null;
        }
        return JsonSerializer.unescapeString(JsonSerializer.trimQuotes(valueJson));
    }

    public static String[] deserializeStringArray(String arrayJson) {
        if (arrayJson == null) {
            return null;
        }
        String str = null;
        ArrayList<String> list = new ArrayList<String>();
        String str2 = "array-start";
        for (int i = 0; i < StringExtensions.getLength(arrayJson); ++i) {
            char ch = arrayJson.charAt(i);
            String _var0 = str2;
            if (_var0.equals("array-start")) {
                if (ch == '[') {
                    str2 = "value-start";
                    continue;
                }
                if (ch == ' ' || ch != '\t' || ch == '\n' || ch == '\r') continue;
                return null;
            }
            if (_var0.equals("value-start")) {
                if (ch == ']') {
                    str2 = "array-end";
                    continue;
                }
                if (ch == '\"') {
                    str = "";
                    str2 = "in-string";
                    continue;
                }
                if (ch == 'n') {
                    str = null;
                    str2 = "in-null-n";
                    continue;
                }
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
                return null;
            }
            if (_var0.equals("in-null-n")) {
                if (ch != 'u') {
                    return null;
                }
                str2 = "in-null-nu";
                continue;
            }
            if (_var0.equals("in-null-nu")) {
                if (ch == 'l') {
                    str2 = "in-null-nul";
                    continue;
                }
                return null;
            }
            if (_var0.equals("in-null-nul")) {
                if (ch == 'l') {
                    list.add(null);
                    str2 = "value-end";
                    continue;
                }
                return null;
            }
            if (_var0.equals("in-string")) {
                if (ch == '\"') {
                    list.add(JsonSerializer.unescapeString(JsonSerializer.trimQuotes(str.trim())));
                    str = null;
                    str2 = "value-end";
                    continue;
                }
                if (ch == '\\') {
                    str = StringExtensions.concat(str, "\\");
                    str2 = "in-string-escape";
                    continue;
                }
                str = StringExtensions.concat(str, CharacterExtensions.toString(Character.valueOf(ch)));
                continue;
            }
            if (_var0.equals("in-string-escape")) {
                str = StringExtensions.concat(str, CharacterExtensions.toString(Character.valueOf(ch)));
                str2 = "in-string";
                continue;
            }
            if (_var0.equals("value-end")) {
                if (ch == ',') {
                    str2 = "value-start";
                    continue;
                }
                if (ch == ']') {
                    str2 = "array-end";
                    continue;
                }
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
                return null;
            }
            if (!Global.equals(str2, "array-end") || ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') continue;
            return null;
        }
        if (!Global.equals(str2, "array-end")) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public static String escapeString(String text) {
        StringBuilder builder = new StringBuilder();
        int startIndex = -1;
        for (int i = 0; i < StringExtensions.getLength(text); ++i) {
            char ch = text.charAt(i);
            if (ch > '~') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, JsonSerializer.charToUnicodeString(ch));
                continue;
            }
            char _var0 = ch;
            if (_var0 == '\b') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\b");
                continue;
            }
            if (_var0 == '\f') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\f");
                continue;
            }
            if (_var0 == '\n') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\n");
                continue;
            }
            if (_var0 == '\r') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\r");
                continue;
            }
            if (_var0 == '\t') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\t");
                continue;
            }
            if (_var0 == '\"') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\\"");
                continue;
            }
            if (_var0 == '/') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\/");
                continue;
            }
            if (_var0 == '\\') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\\\");
                continue;
            }
            if (startIndex != -1) continue;
            startIndex = i;
        }
        if (startIndex != -1) {
            StringBuilderExtensions.append(builder, text, startIndex, StringExtensions.getLength(text) - startIndex);
        }
        return builder.toString();
    }

    private static char intToHex(int value) {
        if (value <= 9) {
            return (char)(value + 48);
        }
        return (char)(value - 10 + 97);
    }

    public static boolean isValidJson(String json) {
        return new JsonChecker().checkString(json);
    }

    public static String serializeBoolean(NullableBoolean value) {
        if (!value.getHasValue()) {
            return "null";
        }
        if (value.getValue()) {
            return "true";
        }
        return "false";
    }

    public static String serializeBooleanArray(boolean[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeBoolean(new NullableBoolean(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeDecimal(NullableBigDecimal value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return BigDecimalExtensions.toString(value.getValue());
    }

    public static String serializeDecimalArray(BigDecimal[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeDecimal(new NullableBigDecimal(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static <T> String serializeDictionary(HashMap<String, T> dictionary, final IFunction1<T, String> serializeValueCallback) {
        return JsonSerializer.serializeObject(dictionary, new IAction2<HashMap<String, T>, HashMap<String, String>>(){

            @Override
            public void invoke(HashMap<String, T> d, HashMap<String, String> jsonObject) {
                for (String str : HashMapExtensions.getKeys(d)) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), str, serializeValueCallback.invoke(HashMapExtensions.getItem(d).get(str)));
                }
            }
        });
    }

    public static String serializeDouble(NullableDouble value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return DoubleExtensions.toString(value.getValue());
    }

    public static String serializeDoubleArray(double[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeDouble(new NullableDouble(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeFloat(NullableFloat value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return FloatExtensions.toString(Float.valueOf(value.getValue()));
    }

    public static String serializeFloatArray(float[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeFloat(new NullableFloat(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeGuid(NullableGuid value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return StringExtensions.concat("\"", value.getValue().toString(), "\"");
    }

    public static String serializeGuidArray(Guid[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeGuid(new NullableGuid(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeInteger(NullableInteger value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return IntegerExtensions.toString(value.getValue());
    }

    public static String serializeIntegerArray(int[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeInteger(new NullableInteger(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeLong(NullableLong value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return LongExtensions.toString(value.getValue());
    }

    public static String serializeLongArray(long[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeLong(new NullableLong(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static <T> String serializeObject(T source, IAction2<T, HashMap<String, String>> callback) {
        if (source == null) {
            return "null";
        }
        HashMap dictionary = new HashMap();
        callback.invoke(source, dictionary);
        ArrayList<String> list = new ArrayList<String>(HashMapExtensions.getCount(dictionary));
        for (String str : HashMapExtensions.getKeys(dictionary)) {
            list.add(StringExtensions.concat(JsonSerializer.serializeString(str), ":", (String)HashMapExtensions.getItem(dictionary).get(str)));
        }
        return StringExtensions.concat("{", StringExtensions.join(",", list.toArray(new String[0])), "}");
    }

    public static <T> String serializeObjectArray(T[] objects, IFunction1<T, String> serializer) {
        if (objects == null) {
            return "null";
        }
        if (ArrayExtensions.getLength(objects) == 0) {
            return "[]";
        }
        String[] strArray = new String[ArrayExtensions.getLength(objects)];
        for (int i = 0; i < ArrayExtensions.getLength(objects); ++i) {
            strArray[i] = serializer.invoke(objects[i]);
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static <T extends Serializable> String serializeObjectFast(T source, IAction2<T, HashMap<String, String>> callback) {
        if (source == null) {
            return "null";
        }
        if (!source.getIsSerialized() || source.getIsDirty()) {
            source.setSerialized(JsonSerializer.serializeObject(source, callback));
        }
        return source.getSerialized();
    }

    public static String serializeRaw(String dataJson) {
        return dataJson;
    }

    public static String serializeRawArray(String[] jsons) {
        if (jsons == null) {
            return "null";
        }
        return StringExtensions.concat("[", StringExtensions.join(",", jsons), "]");
    }

    public static String serializeString(String value) {
        if (value == null) {
            return "null";
        }
        return StringExtensions.concat("\"", JsonSerializer.escapeString(value), "\"");
    }

    public static String serializeStringArray(String[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = JsonSerializer.serializeString(array[i]);
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String trimQuotes(String value) {
        char ch2;
        char ch;
        if (StringExtensions.getLength(value) > 1 && (ch = value.charAt(0)) == (ch2 = value.charAt(StringExtensions.getLength(value) - 1)) && (ch == '\'' || ch == '\"')) {
            value = StringExtensions.substring(value, 1, StringExtensions.getLength(value) - 2);
        }
        return value;
    }

    public static String unescapeString(String text) {
        StringBuilder builder = new StringBuilder();
        int startIndex = -1;
        for (int i = 0; i < StringExtensions.getLength(text); ++i) {
            char ch = text.charAt(i);
            if (ch == '\\') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                if (i == StringExtensions.getLength(text) - 1) continue;
                char ch2 = text.charAt(i + 1);
                char _var0 = ch2;
                if (_var0 == 'b') {
                    StringBuilderExtensions.append(builder, "\b");
                } else if (_var0 == 'f') {
                    StringBuilderExtensions.append(builder, "\f");
                } else if (_var0 == 'n') {
                    StringBuilderExtensions.append(builder, "\n");
                } else if (_var0 == 'r') {
                    StringBuilderExtensions.append(builder, "\r");
                } else if (_var0 == 't') {
                    StringBuilderExtensions.append(builder, "\t");
                } else if (_var0 == '/') {
                    StringBuilderExtensions.append(builder, "/");
                } else if (_var0 == 'u') {
                    if (i < StringExtensions.getLength(text) - 5) {
                        StringBuilderExtensions.append(builder, CharacterExtensions.toString(Character.valueOf(JsonSerializer.unicodeStringToChar(StringExtensions.substring(text, i, 6)))));
                        i += 4;
                    } else {
                        StringBuilderExtensions.append(builder, "u");
                    }
                } else if (_var0 == 'x') {
                    if (i < StringExtensions.getLength(text) - 3) {
                        StringBuilderExtensions.append(builder, CharacterExtensions.toString(Character.valueOf(JsonSerializer.unicodeStringToChar(StringExtensions.substring(text, i, 4)))));
                        i += 2;
                    } else {
                        StringBuilderExtensions.append(builder, "x");
                    }
                } else {
                    StringBuilderExtensions.append(builder, CharacterExtensions.toString(Character.valueOf(ch2)));
                }
                ++i;
                continue;
            }
            if (startIndex != -1) continue;
            startIndex = i;
        }
        if (startIndex != -1) {
            StringBuilderExtensions.append(builder, text, startIndex, StringExtensions.getLength(text) - startIndex);
        }
        return builder.toString();
    }

    private static char unicodeStringToChar(String value) {
        if (StringExtensions.getLength(value) < 2) {
            throw new RuntimeException(new Exception("Unicode string has invalid length."));
        }
        return (char)Convert.toInt32(value.substring(2), 16);
    }
}

