/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Base64;
import fm.icelink.DataBuffer;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IceSendMessageArgs;
import fm.icelink.IceSendRequestSuccessArgs;
import fm.icelink.IntegerExtensions;
import fm.icelink.ScheduledItem;
import fm.icelink.Scheduler;
import fm.icelink.stun.Message;
import fm.icelink.stun.TransactionTransmitCounterAttribute;
import java.util.ArrayList;
import java.util.HashMap;

class IceTransactionManager {
    private Object __lock;
    private static float __rttSmoothingFactor = 0.8f;
    private Scheduler __scheduler;
    private HashMap<String, Long> __stunDepartureTimesByTransactionIdAndSendAttempt;
    private HashMap<String, Long> __stunDepartureTimesByTransactionIdOnly;
    private HashMap<String, ArrayList<ScheduledItem>> __transactionsByCallerHash;
    private HashMap<String, ScheduledItem> __transactionsByTransactionKey = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTransaction(ScheduledItem item, Object caller) {
        String str = Base64.encodeBuffer(((IceSendMessageArgs)item.getState()).getMessage().getTransactionId());
        ArrayList list = null;
        Object object = this.__lock;
        synchronized (object) {
            String key = IntegerExtensions.toString(caller.hashCode());
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
            list = _var0.getValue();
            if (_var1) {
                list.add(item);
            } else {
                ArrayList<ScheduledItem> list2 = new ArrayList<ScheduledItem>();
                list2.add(item);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__transactionsByCallerHash), key, list2);
            }
            HashMapExtensions.set(HashMapExtensions.getItem(this.__transactionsByTransactionKey), str, item);
        }
        this.__scheduler.add(item);
    }

    int calculateInstantaneousRtt(IceSendRequestSuccessArgs args, boolean useRequestVersions) {
        long num4;
        ScheduledItem item = args.getItem();
        TransactionTransmitCounterAttribute transactionTransmitCounter = args.getResponse().getTransactionTransmitCounter();
        int attempt = -1;
        long invocationTime = -1L;
        boolean flag = false;
        if (transactionTransmitCounter != null && useRequestVersions) {
            attempt = transactionTransmitCounter.getNumRequests();
            if (item.getRecordDetailedInvocationTimes() && (invocationTime = item.getInvocationTime(attempt)) != -1L) {
                flag = true;
            }
        } else if (!useRequestVersions) {
            flag = true;
            invocationTime = item.getLastInvocationTime();
        }
        if (flag && (num4 = Scheduler.getCurrentTime() - invocationTime) > 0L) {
            return (int)num4;
        }
        return -1;
    }

    static int calculateSmoothedRtt(int instantaneousRtt, int currentSmoothedRtt) {
        if (currentSmoothedRtt == -1) {
            currentSmoothedRtt = instantaneousRtt;
        }
        return (int)((float)currentSmoothedRtt * __rttSmoothingFactor + (float)instantaneousRtt * (1.0f - __rttSmoothingFactor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveTransactions(Object caller) {
        Object object = this.__lock;
        synchronized (object) {
            String key = IntegerExtensions.toString(caller.hashCode());
            if (this.__transactionsByCallerHash.containsKey(key)) {
                ArrayList list = null;
                Holder<Object> _var0 = new Holder<Object>(list);
                boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
                list = _var0.getValue();
                if (_var1 && ArrayListExtensions.getCount(list) > 0) {
                    return true;
                }
            }
            return false;
        }
    }

    public IceTransactionManager(Object lockObject, Scheduler scheduler) {
        this.__transactionsByCallerHash = new HashMap();
        this.__stunDepartureTimesByTransactionIdOnly = new HashMap();
        this.__stunDepartureTimesByTransactionIdAndSendAttempt = new HashMap();
        this.__lock = lockObject;
        this.__scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object caller) {
        ArrayList list = null;
        Object object = this.__lock;
        synchronized (object) {
            String key = IntegerExtensions.toString(caller.hashCode());
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
            list = _var0.getValue();
            if (_var1) {
                if (list != null) {
                    for (ScheduledItem item : list) {
                        this.__scheduler.remove(item);
                        IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
                        String str2 = Base64.encodeBuffer(state.getMessage().getTransactionId());
                        HashMapExtensions.remove(this.__transactionsByTransactionKey, str2);
                    }
                }
                list.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String transactionId, Object caller) {
        Object object = this.__lock;
        synchronized (object) {
            ArrayList list = null;
            String key = IntegerExtensions.toString(caller.hashCode());
            Holder<Object> _var0 = new Holder<Object>(list);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByCallerHash, key, _var0);
            list = _var0.getValue();
            if (_var1) {
                if (list != null) {
                    ScheduledItem item = null;
                    Holder<Object> _var2 = new Holder<Object>(item);
                    boolean _var3 = HashMapExtensions.tryGetValue(this.__transactionsByTransactionKey, transactionId, _var2);
                    item = _var2.getValue();
                    if (_var3) {
                        list.remove(item);
                        this.__scheduler.remove(item);
                    }
                    if (ArrayListExtensions.getCount(list) < 1) {
                        HashMapExtensions.remove(this.__transactionsByCallerHash, key);
                    }
                } else {
                    HashMapExtensions.remove(this.__transactionsByCallerHash, key);
                }
            }
            HashMapExtensions.remove(this.__transactionsByTransactionKey, transactionId);
        }
    }

    public void remove(ScheduledItem item, Object caller) {
        if (item != null && caller != null) {
            DataBuffer buffer;
            IceSendMessageArgs state = (IceSendMessageArgs)item.getState();
            Message message = state == null ? null : state.getMessage();
            DataBuffer dataBuffer = buffer = message == null ? null : message.getTransactionId();
            if (buffer != null) {
                String transactionId = Base64.encodeBuffer(buffer);
                this.remove(transactionId, caller);
            }
        }
    }

    public void start() {
        this.__scheduler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledItem[] transactionsForCaller(Object caller) {
        Object object = this.__lock;
        synchronized (object) {
            String str = IntegerExtensions.toString(caller.hashCode());
            ArrayList<ScheduledItem> list = HashMapExtensions.getItem(this.__transactionsByCallerHash).get(str);
            if (list != null && ArrayListExtensions.getCount(list) > 0) {
                return list.toArray(new ScheduledItem[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryTriggerOnResponse(String key, IceSendRequestSuccessArgs successArgs) {
        boolean flag;
        ScheduledItem item = null;
        Object object = this.__lock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(item);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__transactionsByTransactionKey, key, _var0);
            item = _var0.getValue();
            flag = _var1;
        }
        ScheduledItem item2 = item;
        if (item2 != null) {
            IceSendMessageArgs state = (IceSendMessageArgs)item2.getState();
            IceSendMessageArgs args2 = state;
            if (args2 == null) {
                return flag;
            }
            IAction1<IceSendRequestSuccessArgs> onResponse = args2.getOnResponse();
            if (onResponse != null) {
                successArgs.setItem(item2);
                onResponse.invoke(successArgs);
            }
        }
        return flag;
    }
}

