/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Candidate;
import fm.icelink.Global;
import fm.icelink.ServerAddress;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.ice.CandidateAttribute;
import fm.icelink.sdp.ice.CandidateType;
import java.util.ArrayList;

public class IceServerTestResult {
    private Candidate[] _candidates;

    private Candidate[] getCandidates(String candidateType) {
        ArrayList<Candidate> list = new ArrayList<Candidate>();
        for (Candidate candidate : this.getCandidates()) {
            if (!Global.equals(candidate.getSdpCandidateAttribute().getCandidateType(), candidateType)) continue;
            list.add(candidate);
        }
        return list.toArray(new Candidate[0]);
    }

    public Candidate[] getCandidates() {
        return this._candidates;
    }

    public Candidate[] getHostCandidates() {
        return this.getCandidates(CandidateType.getHost());
    }

    public Candidate[] getPeerReflexiveCandidates() {
        return this.getCandidates(CandidateType.getPeerReflexive());
    }

    public Candidate[] getRelayedCandidates() {
        return this.getCandidates(CandidateType.getRelayed());
    }

    public ServerAddress[] getServerAddresses(int port) {
        return this.getServerAddresses(port, null);
    }

    public ServerAddress[] getServerAddresses(int port, String publicIPAddress) {
        ArrayList<ServerAddress> list;
        block3: {
            Candidate[] hostCandidates;
            block2: {
                list = new ArrayList<ServerAddress>();
                Object[] serverReflexiveCandidates = this.getServerReflexiveCandidates();
                if (ArrayExtensions.getLength(serverReflexiveCandidates) <= 0) break block2;
                for (Object candidate : serverReflexiveCandidates) {
                    CandidateAttribute sdpCandidateAttribute = ((Candidate)candidate).getSdpCandidateAttribute();
                    list.add(new ServerAddress(sdpCandidateAttribute.getRelatedAddress(), port, sdpCandidateAttribute.getConnectionAddress()));
                }
                break block3;
            }
            if (StringExtensions.isNullOrEmpty(publicIPAddress)) break block3;
            for (Candidate candidate2 : hostCandidates = this.getHostCandidates()) {
                CandidateAttribute sdpCandidateAttribute = candidate2.getSdpCandidateAttribute();
                list.add(new ServerAddress(sdpCandidateAttribute.getConnectionAddress(), port, publicIPAddress));
            }
        }
        return list.toArray(new ServerAddress[0]);
    }

    public Candidate[] getServerReflexiveCandidates() {
        return this.getCandidates(CandidateType.getServerReflexive());
    }

    public IceServerTestResult(Candidate[] candidates) {
        this.setCandidates(candidates);
    }

    private void setCandidates(Candidate[] value) {
        this._candidates = value;
    }
}

