/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IntegerHolder;
import fm.icelink.JsonSerializer;
import fm.icelink.ParseAssistant;
import fm.icelink.StringExtensions;
import java.util.ArrayList;
import java.util.HashMap;

public class IceServer {
    private String __ipAddress;
    private String[] __ipAddresses;
    private String _password;
    private String _url;
    private String _username;

    public static IceServer fromJson(String iceServerJson) {
        return JsonSerializer.deserializeObject(iceServerJson, new IFunction0<IceServer>(){

            @Override
            public IceServer invoke() {
                return new IceServer();
            }
        }, new IAction3<IceServer, String, String>(){

            @Override
            public void invoke(IceServer iceServer, String name, String valueJson) {
                String str = name;
                if (str != null) {
                    if (!Global.equals(str, "url")) {
                        if (Global.equals(str, "username")) {
                            iceServer.setUsername(JsonSerializer.deserializeString(valueJson));
                        } else if (Global.equals(str, "password")) {
                            iceServer.setPassword(JsonSerializer.deserializeString(valueJson));
                        }
                    } else {
                        iceServer.setUrl(JsonSerializer.deserializeString(valueJson));
                    }
                }
            }
        });
    }

    public static IceServer[] fromJsonArray(String iceServersJson) {
        ArrayList<IceServer> list = JsonSerializer.deserializeObjectArray(iceServersJson, new IFunctionDelegate1<String, IceServer>(){

            @Override
            public String getId() {
                return "fm.icelink.IceServer.fromJson";
            }

            @Override
            public IceServer invoke(String iceServerJson) {
                return IceServer.fromJson(iceServerJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new IceServer[0]);
    }

    public static int getDefaultPort() {
        return 3478;
    }

    public String getHost() {
        String host = null;
        int port = 0;
        Holder<Object> _var0 = new Holder<Object>(host);
        IntegerHolder _var1 = new IntegerHolder(port);
        boolean _var2 = IceServer.parseAddress(this.getUrl(), _var0, _var1);
        host = _var0.getValue();
        port = _var1.getValue();
        return host;
    }

    String getIPAddress() {
        if (this.__ipAddress == null && this.__ipAddresses != null && ArrayExtensions.getLength(this.__ipAddresses) > 0) {
            this.__ipAddress = this.__ipAddresses[0];
        }
        return this.__ipAddress;
    }

    String[] getIPAddresses() {
        if (this.__ipAddresses == null && this.__ipAddress != null) {
            this.__ipAddresses = new String[]{this.__ipAddress};
        }
        return this.__ipAddresses;
    }

    public boolean getIsSecure() {
        return this.getUrl().startsWith("stuns:") || this.getUrl().startsWith("turns:");
    }

    public boolean getIsStun() {
        return this.getUrl().startsWith("stun:") || this.getUrl().startsWith("stuns:");
    }

    public boolean getIsTcp() {
        return !this.getUrl().endsWith("?transport=udp");
    }

    public boolean getIsTurn() {
        return this.getUrl().startsWith("turn:") || this.getUrl().startsWith("turns:");
    }

    public boolean getIsUdp() {
        return !this.getUrl().endsWith("?transport=tcp");
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        String host = null;
        int port = 0;
        Holder<Object> _var0 = new Holder<Object>(host);
        IntegerHolder _var1 = new IntegerHolder(port);
        boolean _var2 = IceServer.parseAddress(this.getUrl(), _var0, _var1);
        host = _var0.getValue();
        port = _var1.getValue();
        return port;
    }

    public String getUrl() {
        return this._url;
    }

    public String getUsername() {
        return this._username;
    }

    public IceServer(String url, String username, String password) {
        if (url == null) {
            throw new RuntimeException(new Exception("URL cannot be null."));
        }
        if (username == null) {
            throw new RuntimeException(new Exception("Username cannot be null."));
        }
        if (password == null) {
            throw new RuntimeException(new Exception("Password cannot be null."));
        }
        if (url.startsWith("stun:") || url.startsWith("stuns:")) {
            throw new RuntimeException(new Exception("STUN servers do not have a username or password."));
        }
        if (!url.startsWith("turn:") && !url.startsWith("turns:")) {
            url = StringExtensions.format("turn:{0}", url);
        }
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    private IceServer() {
    }

    public IceServer(String url) {
        if (url == null) {
            throw new RuntimeException(new Exception("URL cannot be null."));
        }
        if (url.startsWith("turn:") || url.startsWith("turns:")) {
            throw new RuntimeException(new Exception("TURN servers require a username and password."));
        }
        if (!url.startsWith("stun:") && !url.startsWith("stuns:")) {
            url = StringExtensions.format("stun:{0}", url);
        }
        if (!url.contains("?transport=")) {
            url = StringExtensions.format("{0}?transport=udp", url);
        }
        this.setUrl(url);
    }

    private static boolean parseAddress(String address, Holder<String> host, IntegerHolder port) {
        Object[] strArray;
        host.setValue(null);
        port.setValue(3478);
        if (address == null) {
            return false;
        }
        if ((address = StringExtensions.split(address, new char[]{'?'})[0]).startsWith("stun:") || address.startsWith("stuns:") || address.startsWith("turn:") || address.startsWith("turns:")) {
            address = address.substring(StringExtensions.indexOf(address, ":") + 1);
        }
        if (address.startsWith("[")) {
            address = StringExtensions.substring(address, 1, StringExtensions.getLength(address) - 1);
            strArray = StringExtensions.split(address, new char[]{']'});
        } else {
            strArray = StringExtensions.split(address, new char[]{':'});
        }
        if (ArrayExtensions.getLength(strArray) > 0) {
            host.setValue((String)strArray[0]);
        }
        if (ArrayExtensions.getLength(strArray) > 1) {
            port.setValue(IceServer.parsePort((String)strArray[1]));
        }
        return true;
    }

    private static int parsePort(String portString) {
        int intResult = 0;
        IntegerHolder _var0 = new IntegerHolder(intResult);
        boolean _var1 = ParseAssistant.tryParseIntegerValue(portString, _var0);
        intResult = _var0.getValue();
        if (_var1) {
            return intResult;
        }
        return 3478;
    }

    void setIPAddress(String value) {
        this.__ipAddress = value;
    }

    void setIPAddresses(String[] value) {
        this.__ipAddresses = value;
    }

    private void setPassword(String value) {
        this._password = value;
    }

    private void setUrl(String value) {
        this._url = value;
    }

    private void setUsername(String value) {
        this._username = value;
    }

    public String toJson() {
        return IceServer.toJson(this);
    }

    public static String toJson(final IceServer iceServer) {
        return JsonSerializer.serializeObject(iceServer, new IAction2<IceServer, HashMap<String, String>>(){

            @Override
            public void invoke(IceServer i, HashMap<String, String> jsonObject) {
                if (iceServer.getUrl() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "url", JsonSerializer.serializeString(iceServer.getUrl()));
                }
                if (iceServer.getUsername() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "username", JsonSerializer.serializeString(iceServer.getUsername()));
                }
                if (iceServer.getPassword() != null) {
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "password", JsonSerializer.serializeString(iceServer.getPassword()));
                }
            }
        });
    }

    public static String toJsonArray(IceServer[] iceServers) {
        return JsonSerializer.serializeObjectArray(iceServers, new IFunctionDelegate1<IceServer, String>(){

            @Override
            public String getId() {
                return "fm.icelink.IceServer.toJson";
            }

            @Override
            public String invoke(IceServer iceServer) {
                return IceServer.toJson(iceServer);
            }
        });
    }
}

