/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IceConnectionState {
    New(1),
    Checking(2),
    Connected(3),
    Completed(4),
    Failed(5),
    Disconnected(6),
    Closed(7);

    private final int value;
    private static final Map<Integer, IceConnectionState> lookup;

    private IceConnectionState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static IceConnectionState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, IceConnectionState>();
        for (IceConnectionState s : EnumSet.allOf(IceConnectionState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

