/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.FecContext;
import fm.icelink.FecProtectionParameters;
import fm.icelink.FecRedPacket;
import fm.icelink.RtpPacketHeader;
import fm.icelink.RtpPacketPair;
import java.util.ArrayList;

class FecProducer {
    private FecContext __fec;
    private ArrayList<DataBuffer> __fecPackets;
    private boolean __incompleteFrame = false;
    private ArrayList<RtpPacketPair> __mediaPackets = new ArrayList();
    private int __minimumMediaPackets = 1;
    private FecProtectionParameters __newParameters;
    private int __numFirstPartition = 0;
    private int __numFrames = 0;
    private FecProtectionParameters __parameters;

    public boolean addRtpPacketAndGenerateFec(RtpPacketPair pair) {
        if (ArrayListExtensions.getCount(this.__fecPackets) > 0) {
            throw new RuntimeException(new Exception("FEC packets not empty."));
        }
        if (ArrayListExtensions.getCount(this.__mediaPackets) == 0) {
            this.__parameters = this.__newParameters;
        }
        this.__incompleteFrame = true;
        boolean marker = pair.getHeader().getMarker();
        if (ArrayListExtensions.getCount(this.__mediaPackets) < FecContext.getMaxMediaPackets()) {
            this.__mediaPackets.add(pair);
        }
        if (marker) {
            ++this.__numFrames;
            this.__incompleteFrame = false;
        }
        if (!this.__incompleteFrame && (this.__numFrames == this.__parameters.getMaxFecFrames() || this.getExcessOverheadBelowMax() && this.getMinimumMediaPacketsReached())) {
            if (this.__numFirstPartition > FecContext.getMaxMediaPackets()) {
                throw new RuntimeException(new Exception("Number of packets in the first partition exceeds the maximum allowed."));
            }
            boolean flag2 = this.__fec.generate(this.__mediaPackets, this.__parameters.getFecRate(), this.__numFirstPartition, this.__parameters.getUseUepProtection(), this.__parameters.getFecMaskType(), this.__fecPackets);
            if (ArrayListExtensions.getCount(this.__fecPackets) == 0) {
                this.__numFrames = 0;
                this.deletePackets();
            }
            return flag2;
        }
        return true;
    }

    public FecRedPacket buildRedPacket(RtpPacketHeader header, DataBuffer payload, int redPayloadType) {
        FecRedPacket packet = new FecRedPacket(header);
        packet.assignPayload(payload, redPayloadType);
        return packet;
    }

    private void deletePackets() {
        for (RtpPacketPair pair : this.__mediaPackets) {
            if (!pair.getPayload().getIsPooled()) continue;
            pair.getPayload().free();
        }
        this.__mediaPackets.clear();
    }

    public FecProducer(FecContext fec) {
        this.__fecPackets = new ArrayList();
        this.__parameters = new FecProtectionParameters();
        this.__newParameters = new FecProtectionParameters();
        this.__fec = fec;
    }

    public boolean getExcessOverheadBelowMax() {
        return this.getOverhead() - this.__parameters.getFecRate() < FecRedPacket.getMaxExcessOverhead();
    }

    public boolean getFecAvailable() {
        return ArrayListExtensions.getCount(this.__fecPackets) > 0;
    }

    public FecRedPacket getFecPacket(int redPayloadType, int fecPayloadType, int sequenceNumber) {
        if (ArrayListExtensions.getCount(this.__fecPackets) == 0) {
            return null;
        }
        DataBuffer payload = ArrayListExtensions.getItem(this.__fecPackets).get(0);
        RtpPacketPair pair = ArrayListExtensions.getItem(this.__mediaPackets).get(ArrayListExtensions.getCount(this.__mediaPackets) - 1);
        RtpPacketHeader header = pair.getHeader().clone();
        header.setPayloadType(fecPayloadType);
        FecRedPacket packet = new FecRedPacket(header);
        packet.setSequenceNumber(sequenceNumber);
        packet.clearMarkerBit();
        packet.assignPayload(payload, redPayloadType);
        ArrayListExtensions.removeAt(this.__fecPackets, 0);
        if (ArrayListExtensions.getCount(this.__fecPackets) == 0) {
            this.deletePackets();
            this.__numFrames = 0;
        }
        return packet;
    }

    public boolean getMinimumMediaPacketsReached() {
        float num = (float)ArrayListExtensions.getCount(this.__mediaPackets) / (float)this.__numFrames;
        if (num < 2.0f) {
            return ArrayListExtensions.getCount(this.__mediaPackets) >= this.__minimumMediaPackets;
        }
        return ArrayListExtensions.getCount(this.__mediaPackets) >= this.__minimumMediaPackets + 1;
    }

    private int getOverhead() {
        if (ArrayListExtensions.getCount(this.__mediaPackets) == 0) {
            return -1;
        }
        return (this.__fec.getNumberOfFecPackets(ArrayListExtensions.getCount(this.__mediaPackets), this.__parameters.getFecRate()) << 8) / ArrayListExtensions.getCount(this.__mediaPackets);
    }

    public void setFecParameters(FecProtectionParameters parameters, int numberFirstPartition) {
        if (numberFirstPartition > FecContext.getMaxMediaPackets()) {
            numberFirstPartition = FecContext.getMaxMediaPackets();
        }
        this.__newParameters = parameters;
        this.__numFirstPartition = numberFirstPartition;
        this.__minimumMediaPackets = parameters.getFecRate() > FecRedPacket.getHighProtectionThreshold() ? FecRedPacket.getMinimumMediaPackets() : 1;
    }
}

