/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.EcdsaKey;
import fm.icelink.EcdsaNamedCurve;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;

public class EcdsaCrypto {
    private static EcdsaNamedCurve _defaultNamedCurve = EcdsaNamedCurve.P256;

    public static EcdsaNamedCurve getDefaultNamedCurve() {
        return _defaultNamedCurve;
    }

    public static void setDefaultNamedCurve(EcdsaNamedCurve defaultNamedCurve) {
        _defaultNamedCurve = defaultNamedCurve;
    }

    private static String getCurveName(EcdsaNamedCurve namedCurve) {
        if (namedCurve == EcdsaNamedCurve.P256) {
            return "P-256";
        }
        if (namedCurve == EcdsaNamedCurve.P384) {
            return "P-384";
        }
        if (namedCurve == EcdsaNamedCurve.P521) {
            return "P-521";
        }
        throw new RuntimeException("Unsupported named curve.");
    }

    private static String getAlgorithm(EcdsaNamedCurve namedCurve) {
        if (namedCurve == EcdsaNamedCurve.P256) {
            return "SHA256WithECDSA";
        }
        if (namedCurve == EcdsaNamedCurve.P384) {
            return "SHA384WithECDSA";
        }
        if (namedCurve == EcdsaNamedCurve.P521) {
            return "SHA512WithECDSA";
        }
        throw new RuntimeException("Unsupported named curve.");
    }

    public static EcdsaKey createKey() {
        return EcdsaCrypto.createKey(_defaultNamedCurve);
    }

    public static EcdsaKey createKey(EcdsaNamedCurve namedCurve) {
        byte[] publicKeyYBytes;
        ECPublicKeyParameters publicKeyParameters;
        byte[] publicKeyXBytes;
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init(new ECKeyGenerationParameters(EcdsaCrypto.getDomainParameters(namedCurve), new SecureRandom()));
        AsymmetricCipherKeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        byte[] privateKeyBytes = privateKeyParameters.getD().toByteArray();
        if (privateKeyBytes.length % 2 == 1) {
            privateKeyBytes = BitAssistant.subArray(privateKeyBytes, 1);
        }
        if ((publicKeyXBytes = (publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic()).getQ().getAffineXCoord().toBigInteger().toByteArray()).length % 2 == 1) {
            publicKeyXBytes = BitAssistant.subArray(publicKeyXBytes, 1);
        }
        if ((publicKeyYBytes = publicKeyParameters.getQ().getAffineYCoord().toBigInteger().toByteArray()).length % 2 == 1) {
            publicKeyYBytes = BitAssistant.subArray(publicKeyYBytes, 1);
        }
        byte[] publicKeyBytes = new byte[publicKeyXBytes.length + publicKeyYBytes.length];
        BitAssistant.copy(publicKeyXBytes, 0, publicKeyBytes, 0, publicKeyXBytes.length);
        BitAssistant.copy(publicKeyYBytes, 0, publicKeyBytes, publicKeyXBytes.length, publicKeyYBytes.length);
        EcdsaKey key = new EcdsaKey();
        key.setPrivateKey(privateKeyBytes);
        key.setNamedCurve(namedCurve);
        key.setPublicKey(publicKeyBytes);
        return key;
    }

    public static byte[] sign(byte[] data, EcdsaKey privateKey) {
        try {
            AsymmetricKeyParameter privateKeyParameters = EcdsaCrypto.getPrivateKeyParameters(privateKey);
            DSADigestSigner signer = new DSADigestSigner(new ECDSASigner(), EcdsaCrypto.getDigest(privateKey.getNamedCurve()));
            signer.init(true, privateKeyParameters);
            signer.update(data, 0, data.length);
            return signer.generateSignature();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean verify(byte[] data, byte[] signature, EcdsaKey publicKey) {
        AsymmetricKeyParameter publicKeyParameters = EcdsaCrypto.getPublicKeyParameters(publicKey);
        DSADigestSigner signer = new DSADigestSigner(new ECDSASigner(), EcdsaCrypto.getDigest(publicKey.getNamedCurve()));
        signer.init(false, publicKeyParameters);
        signer.update(data, 0, data.length);
        return signer.verifySignature(signature);
    }

    static Digest getDigest(EcdsaNamedCurve namedCurve) {
        if (namedCurve == EcdsaNamedCurve.P256) {
            return new SHA256Digest();
        }
        if (namedCurve == EcdsaNamedCurve.P384) {
            return new SHA384Digest();
        }
        if (namedCurve == EcdsaNamedCurve.P521) {
            return new SHA512Digest();
        }
        throw new RuntimeException("Unsupported named curve.");
    }

    static ECDomainParameters getDomainParameters(EcdsaNamedCurve namedCurve) {
        X9ECParameters x9ecParameters = null;
        if (namedCurve == EcdsaNamedCurve.P256) {
            x9ecParameters = NISTNamedCurves.getByName("P-256");
        } else if (namedCurve == EcdsaNamedCurve.P384) {
            x9ecParameters = NISTNamedCurves.getByName("P-384");
        } else if (namedCurve == EcdsaNamedCurve.P521) {
            x9ecParameters = NISTNamedCurves.getByName("P-521");
        } else {
            throw new RuntimeException("Unsupported named curve.");
        }
        return new ECDomainParameters(x9ecParameters.getCurve(), x9ecParameters.getG(), x9ecParameters.getN(), x9ecParameters.getH());
    }

    static AsymmetricKeyParameter getPrivateKeyParameters(EcdsaKey privateKey) {
        return new ECPrivateKeyParameters(new BigInteger(1, privateKey.getPrivateKey()), EcdsaCrypto.getDomainParameters(privateKey.getNamedCurve()));
    }

    static AsymmetricKeyParameter getPublicKeyParameters(EcdsaKey publicKey) {
        BigInteger x = new BigInteger(1, BitAssistant.subArray(publicKey.getPublicKey(), 0, publicKey.getPublicKey().length / 2));
        BigInteger y = new BigInteger(1, BitAssistant.subArray(publicKey.getPublicKey(), publicKey.getPublicKey().length / 2));
        ECDomainParameters domainParameters = EcdsaCrypto.getDomainParameters(publicKey.getNamedCurve());
        return new ECPublicKeyParameters(domainParameters.getCurve().createPoint(x, y), domainParameters);
    }
}

