/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AsymmetricKey;
import fm.icelink.AsymmetricKeyType;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.EcdsaCrypto;
import fm.icelink.EcdsaKey;
import fm.icelink.RsaKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsUtils;

class DtlsUtility {
    DtlsUtility() {
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(Vector supportedSignatureAndHashAlgorithms, short signatureAlgorithm) {
        if (supportedSignatureAndHashAlgorithms != null) {
            for (SignatureAndHashAlgorithm supportedSignatureAndHashAlgorithm : supportedSignatureAndHashAlgorithms) {
                if (supportedSignatureAndHashAlgorithm.getSignature() != signatureAlgorithm) continue;
                return supportedSignatureAndHashAlgorithm;
            }
        }
        return null;
    }

    public static Certificate getCertificate(DtlsCertificate certificate) {
        try {
            byte[] certificateBytes = certificate.getBytes();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = certificateBytes.length;
            TlsUtils.writeUint24(length + 3, bos);
            TlsUtils.writeUint24(length, bos);
            bos.write(certificateBytes, 0, certificateBytes.length);
            return Certificate.parse(new ByteArrayInputStream(bos.toByteArray()));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static AsymmetricKeyParameter getRsaPrivateKey(DtlsCertificate certificate) {
        AsymmetricKey key = certificate.getKey();
        if (key.getType() == AsymmetricKeyType.Rsa) {
            RsaKey rsaKey = (RsaKey)key;
            return new RSAPrivateCrtKeyParameters(new BigInteger(1, rsaKey.getModulus()), new BigInteger(1, rsaKey.getPublicExponent()), new BigInteger(1, rsaKey.getPrivateExponent()), new BigInteger(1, rsaKey.getPrime1()), new BigInteger(1, rsaKey.getPrime2()), new BigInteger(1, rsaKey.getExponent1()), new BigInteger(1, rsaKey.getExponent2()), new BigInteger(1, rsaKey.getCoefficient()));
        }
        return null;
    }

    public static AsymmetricKeyParameter getEcdsaPrivateKey(DtlsCertificate certificate) {
        AsymmetricKey key = certificate.getKey();
        if (key.getType() == AsymmetricKeyType.Ecdsa) {
            return EcdsaCrypto.getPrivateKeyParameters((EcdsaKey)key);
        }
        return null;
    }

    public static int convertCipherSuite(DtlsCipherSuite cipherSuite) {
        if (cipherSuite == DtlsCipherSuite.RsaAes128Sha) {
            return 47;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheRsaAes128Sha) {
            return 49171;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheEcdsaAes128Sha) {
            return 49161;
        }
        if (cipherSuite == DtlsCipherSuite.RsaAes128GcmSha256) {
            return 156;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheRsaAes128GcmSha256) {
            return 49199;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheEcdsaAes128GcmSha256) {
            return 49195;
        }
        if (cipherSuite == DtlsCipherSuite.RsaAes128CbcSha256) {
            return 60;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheRsaAes128CbcSha256) {
            return 49191;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheEcdsaAes128CbcSha256) {
            return 49187;
        }
        return -1;
    }
}

