/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsUtility;
import fm.icelink.HashContextBase;
import fm.icelink.HashType;
import fm.icelink.IAction1;
import fm.icelink.Log;
import java.io.IOException;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;

class DtlsClientAuthentication
implements TlsAuthentication {
    private TlsContext context;
    public String remoteFingerprintAlgorithm;
    public String remoteFingerprint;
    private IAction1<DtlsCertificate> onRemoteCertificate;
    private DtlsCertificate certificate;

    public String getRemoteFingerprintAlgorithm() {
        return this.remoteFingerprintAlgorithm;
    }

    public String getRemoteFingerprint() {
        return this.remoteFingerprint;
    }

    public IAction1<DtlsCertificate> getOnRemoteCertificate() {
        return this.onRemoteCertificate;
    }

    public DtlsCertificate getCertificate() {
        return this.certificate;
    }

    public DtlsClientAuthentication(TlsContext context, DtlsCertificate certificate, String remoteFingerprintAlgorithm, String remoteFingerprint, IAction1<DtlsCertificate> onRemoteCertificate) {
        this.context = context;
        this.certificate = certificate;
        this.remoteFingerprintAlgorithm = remoteFingerprintAlgorithm;
        this.remoteFingerprint = remoteFingerprint;
        this.onRemoteCertificate = onRemoteCertificate;
    }

    @Override
    public void notifyServerCertificate(org.bouncycastle.crypto.tls.Certificate serverCertificate) throws IOException {
        if (serverCertificate == null) {
            throw new TlsFatalAlert(42);
        }
        Certificate[] certificates = serverCertificate.getCertificateList();
        if (certificates == null || certificates.length == 0) {
            throw new TlsFatalAlert(42);
        }
        Certificate cert = certificates[0];
        String fingerprint = null;
        if (this.remoteFingerprintAlgorithm.toLowerCase().equals("sha2") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha256") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha-256")) {
            fingerprint = HashContextBase.compute(HashType.Sha256, DataBuffer.wrap(cert.getEncoded())).toHexString();
        } else if (this.remoteFingerprintAlgorithm.toLowerCase().equals("sha") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha1") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha-1")) {
            fingerprint = HashContextBase.compute(HashType.Sha1, DataBuffer.wrap(cert.getEncoded())).toHexString();
        } else {
            throw new TlsFatalAlert(49);
        }
        if (!fingerprint.toLowerCase().equals(this.remoteFingerprint.replace(":", "").toLowerCase())) {
            throw new TlsFatalAlert(49);
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        AsymmetricKeyParameter rsaPrivateKey;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm;
        Log.debug("Generating DTLS 'client certificate' message.");
        short[] certificateTypes = certificateRequest.getCertificateTypes();
        if (certificateTypes == null) {
            return null;
        }
        AsymmetricKeyParameter ecdsaPrivateKey = DtlsUtility.getEcdsaPrivateKey(this.getCertificate());
        if (ecdsaPrivateKey != null) {
            if (certificateRequest.getSupportedSignatureAlgorithms() == null) {
                return new DefaultTlsSignerCredentials(this.context, DtlsUtility.getCertificate(this.getCertificate()), ecdsaPrivateKey);
            }
            signatureAndHashAlgorithm = DtlsUtility.getSignatureAndHashAlgorithm(certificateRequest.getSupportedSignatureAlgorithms(), (short)3);
            if (signatureAndHashAlgorithm != null) {
                return new DefaultTlsSignerCredentials(this.context, DtlsUtility.getCertificate(this.getCertificate()), ecdsaPrivateKey, signatureAndHashAlgorithm);
            }
        }
        if ((rsaPrivateKey = DtlsUtility.getRsaPrivateKey(this.getCertificate())) != null) {
            if (certificateRequest.getSupportedSignatureAlgorithms() == null) {
                return new DefaultTlsSignerCredentials(this.context, DtlsUtility.getCertificate(this.getCertificate()), rsaPrivateKey);
            }
            signatureAndHashAlgorithm = DtlsUtility.getSignatureAndHashAlgorithm(certificateRequest.getSupportedSignatureAlgorithms(), (short)1);
            if (signatureAndHashAlgorithm != null) {
                return new DefaultTlsSignerCredentials(this.context, DtlsUtility.getCertificate(this.getCertificate()), rsaPrivateKey, signatureAndHashAlgorithm);
            }
        }
        return null;
    }
}

