/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.IAction1;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DispatchQueue<T> {
    private ExecutorService _executor;
    private IAction1<T> _action;
    private AtomicLong _queueCount;

    public long getQueueCount() {
        return this._queueCount.getValue();
    }

    public DispatchQueue(IAction1<T> action) {
        this._action = action;
        this._queueCount = new AtomicLong();
        this._executor = Executors.newFixedThreadPool(1);
    }

    public void enqueue(final T item) {
        this._queueCount.increment();
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                DispatchQueue.this._queueCount.decrement();
                DispatchQueue.this._action.invoke(item);
            }
        });
    }
}

