/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.BooleanHolder;
import fm.icelink.DataBufferSubset;
import fm.icelink.Encoding;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IntegerHolder;
import fm.icelink.JsonSerializer;
import fm.icelink.LongHolder;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableInteger;
import java.util.ArrayList;
import java.util.HashMap;

public class DataBuffer {
    private int _index;
    private byte[] _innerData;
    private int _length;
    private boolean _littleEndian;

    public static DataBuffer allocate(int count, boolean littleEndian, boolean pooled) {
        return DataBuffer.wrap(new byte[count], littleEndian);
    }

    public static DataBuffer allocate(int count) {
        return DataBuffer.allocate(count, false);
    }

    public static DataBuffer allocate(int count, boolean littleEndian) {
        return DataBuffer.wrap(new byte[count], littleEndian);
    }

    public boolean and(int value, int offset) {
        return this.write8(this.read8(offset) & value, offset);
    }

    public DataBuffer append(DataBuffer[] buffers) {
        if (buffers != null && ArrayExtensions.getLength(buffers) > 0) {
            int length = this.getLength();
            for (DataBuffer buffer : buffers) {
                length += buffer.getLength();
            }
            if (length > this.getLength()) {
                int offset = this.getLength();
                this.resize(length);
                for (DataBuffer buffer : buffers) {
                    this.write(buffer, offset);
                    offset += buffer.getLength();
                }
            }
        }
        return this;
    }

    public DataBuffer append(DataBuffer buffer) {
        int newLength;
        if (buffer != null && buffer.getLength() > 0 && (newLength = this.getLength() + buffer.getLength()) > this.getLength()) {
            int length = this.getLength();
            this.resize(newLength);
            this.write(buffer, length);
            int n = length + buffer.getLength();
        }
        return this;
    }

    public static boolean areEqual(DataBuffer buffer1, DataBuffer buffer2) {
        if (buffer1.getLength() != buffer2.getLength()) {
            return false;
        }
        for (int i = 0; i < buffer1.getLength(); ++i) {
            if (buffer1.read8(i) == buffer2.read8(i)) continue;
            return false;
        }
        return true;
    }

    private static void check(boolean condition) {
        DataBuffer.check(condition, "Condition failed.");
    }

    private static void check(boolean condition, String message) {
        if (!condition) {
            throw new RuntimeException(new Exception(message));
        }
    }

    private static void checkSequenceEqual(byte[] test, byte[] actual) {
        if (ArrayExtensions.getLength(test) != ArrayExtensions.getLength(actual)) {
            throw new RuntimeException(new Exception("Sequence not equal."));
        }
        for (int i = 0; i < ArrayExtensions.getLength(test); ++i) {
            if (test[i] == actual[i]) continue;
            throw new RuntimeException(new Exception("Seqeunce not equal."));
        }
    }

    public DataBuffer clone(boolean littleEndian) {
        return this.subset(0);
    }

    public DataBuffer clone() {
        return this.clone(this.getLittleEndian());
    }

    DataBuffer(byte[] data, int index, int length, boolean littleEndian) {
        this.setInnerData(data);
        this.setIndex(index);
        this.setLength(length);
        this.setLittleEndian(littleEndian);
    }

    private DataBuffer() {
    }

    public void free() {
    }

    public static DataBuffer fromJson(String dataBufferJson) {
        return JsonSerializer.deserializeObject(dataBufferJson, new IFunction0<DataBuffer>(){

            @Override
            public DataBuffer invoke() {
                return new DataBuffer();
            }
        }, new IAction3<DataBuffer, String, String>(){

            @Override
            public void invoke(DataBuffer dataBuffer, String name, String valueJson) {
                String str = name;
                if (str != null) {
                    if (!Global.equals(str, "data")) {
                        if (Global.equals(str, "index")) {
                            dataBuffer.setIndex(JsonSerializer.deserializeInteger(valueJson).getValue());
                        } else if (Global.equals(str, "length")) {
                            dataBuffer.setLength(JsonSerializer.deserializeInteger(valueJson).getValue());
                        } else if (Global.equals(str, "littleEndian")) {
                            dataBuffer.setLittleEndian(JsonSerializer.deserializeBoolean(valueJson).getValue());
                        }
                    } else {
                        dataBuffer.setInnerData(Base64.decode(valueJson));
                    }
                }
            }
        });
    }

    public static DataBuffer[] fromJsonArray(String dataBuffersJson) {
        ArrayList<DataBuffer> list = JsonSerializer.deserializeObjectArray(dataBuffersJson, new IFunctionDelegate1<String, DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.DataBuffer.fromJson";
            }

            @Override
            public DataBuffer invoke(String dataBufferJson) {
                return DataBuffer.fromJson(dataBufferJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new DataBuffer[0]);
    }

    public byte[] getData() {
        if (this.getInnerData() == null) {
            throw new RuntimeException(new Exception("This data buffer has been invalidated."));
        }
        return this.getInnerData();
    }

    public static DataBuffer getEmpty() {
        return DataBuffer.allocate(0, false);
    }

    public int getIndex() {
        return this._index;
    }

    protected byte[] getInnerData() {
        return this._innerData;
    }

    public boolean getIsPooled() {
        return false;
    }

    public boolean getIsSubset() {
        return false;
    }

    public int getLength() {
        return this._length;
    }

    public boolean getLittleEndian() {
        return this._littleEndian;
    }

    public DataBuffer keep() {
        return this;
    }

    public boolean or(int value, int offset) {
        return this.write8(this.read8(offset) | value, offset);
    }

    public DataBuffer prepend(DataBuffer buffer) {
        int length = buffer.getLength();
        if (length <= this.getIndex()) {
            this.setIndex(this.getIndex() - length);
            this.setLength(this.getLength() + length);
        } else {
            this.resize(this.getLength() + length, 0);
        }
        int offset = 0;
        this.write(buffer, offset);
        offset += buffer.getLength();
        return this;
    }

    public void prepend(DataBuffer[] buffers) {
        if (buffers != null && ArrayExtensions.getLength(buffers) > 0) {
            int num = 0;
            for (DataBuffer buffer : buffers) {
                num += buffer.getLength();
            }
            if (num <= this.getIndex()) {
                this.setIndex(this.getIndex() - num);
                this.setLength(this.getLength() + num);
            } else {
                this.resize(this.getLength() + num, 0);
            }
            int offset = 0;
            for (DataBuffer buffer : buffers) {
                this.write(buffer, offset);
                offset += buffer.getLength();
            }
        }
    }

    public boolean read1(int offset, int bitOffset) {
        return Binary.fromBytes1(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public int read12(int offset, int bitOffset) {
        return Binary.fromBytes12(this.getData(), this.getIndex() + offset, bitOffset, this.getLittleEndian());
    }

    public int read13(int offset, int bitOffset) {
        return Binary.fromBytes13(this.getData(), this.getIndex() + offset, bitOffset, this.getLittleEndian());
    }

    public int read13Signed(int offset, int bitOffset) {
        int num = this.read13(offset, bitOffset);
        if (num > 4095) {
            num -= 8191;
        }
        return num;
    }

    public int read15(int offset, int bitOffset) {
        return Binary.fromBytes15(this.getData(), this.getIndex() + offset, bitOffset, this.getLittleEndian());
    }

    public int read16(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return this.read16(offset);
    }

    public int read16(int offset) {
        return Binary.fromBytes16(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public int read16Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return this.read16Signed(offset);
    }

    public int read16Signed(int offset) {
        int num = this.read16(offset);
        if (num > Short.MAX_VALUE) {
            num -= 65535;
        }
        return num;
    }

    public int read18(int offset, int bitOffset) {
        return Binary.fromBytes18(this.getData(), this.getIndex() + offset, bitOffset, this.getLittleEndian());
    }

    public int read2(int offset, int bitOffset) {
        return Binary.fromBytes2(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public int read24(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return this.read24(offset);
    }

    public int read24(int offset) {
        return Binary.fromBytes24(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public int read24Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return this.read24Signed(offset);
    }

    public int read24Signed(int offset) {
        int num = this.read24(offset);
        if (num > 0x7FFFFF) {
            num -= 0xFFFFFF;
        }
        return num;
    }

    public int read2Signed(int offset, int bitOffset) {
        int num = this.read4(offset, bitOffset);
        if (num > 1) {
            num -= 3;
        }
        return num;
    }

    public int read3(int offset, int bitOffset) {
        return Binary.fromBytes3(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public long read32(int offset) {
        return Binary.fromBytes32(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public long read32(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return this.read32(offset);
    }

    public long read32Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return this.read32Signed(offset);
    }

    public long read32Signed(int offset) {
        long num = this.read32(offset);
        if (num > Integer.MAX_VALUE) {
            num -= 0xFFFFFFFFL;
        }
        return num;
    }

    public int read3Signed(int offset, int bitOffset) {
        int num = this.read4(offset, bitOffset);
        if (num > 3) {
            num -= 7;
        }
        return num;
    }

    public int read4(int offset, int bitOffset) {
        return Binary.fromBytes4(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public long read40(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return this.read40(offset);
    }

    public long read40(int offset) {
        return Binary.fromBytes40(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public long read40Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return this.read40Signed(offset);
    }

    public long read40Signed(int offset) {
        long num = this.read40(offset);
        if (num > 0x7FFFFFFFFFL) {
            num -= 0xFFFFFFFFFFL;
        }
        return num;
    }

    public long read48(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return this.read48(offset);
    }

    public long read48(int offset) {
        return Binary.fromBytes48(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public long read48Signed(int offset) {
        long num = this.read48(offset);
        if (num > 0x7FFFFFFFFFFFL) {
            num -= 0xFFFFFFFFFFFFL;
        }
        return num;
    }

    public long read48Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return this.read48Signed(offset);
    }

    public int read4Signed(int offset, int bitOffset) {
        int num = this.read4(offset, bitOffset);
        if (num > 7) {
            num -= 15;
        }
        return num;
    }

    public int read5(int offset, int bitOffset) {
        return Binary.fromBytes5(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public long read56(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return this.read56(offset);
    }

    public long read56(int offset) {
        return Binary.fromBytes56(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public long read56Signed(int offset) {
        long num = this.read56(offset);
        if (num > 0x7FFFFFFFFFFFFFL) {
            num -= 0xFFFFFFFFFFFFFFL;
        }
        return num;
    }

    public long read56Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return this.read56Signed(offset);
    }

    public int read5Signed(int offset, int bitOffset) {
        int num = this.read5(offset, bitOffset);
        if (num > 15) {
            num -= 31;
        }
        return num;
    }

    public int read6(int offset, int bitOffset) {
        return Binary.fromBytes6(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public long read64(int offset) {
        return Binary.fromBytes64(this.getData(), this.getIndex() + offset, this.getLittleEndian());
    }

    public long read64(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return this.read64(offset);
    }

    public long read64Signed(int offset) {
        return this.read64(offset);
    }

    public long read64Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return this.read64Signed(offset);
    }

    public int read6Signed(int offset, int bitOffset) {
        int num = this.read6(offset, bitOffset);
        if (num > 31) {
            num -= 63;
        }
        return num;
    }

    public int read7(int offset, int bitOffset) {
        return Binary.fromBytes7(this.getData(), this.getIndex() + offset, bitOffset);
    }

    public int read7Signed(int offset, int bitOffset) {
        int num = this.read7(offset, bitOffset);
        if (num > 63) {
            num -= 127;
        }
        return num;
    }

    public int read8(int offset) {
        return Binary.fromBytes8(this.getData(), this.getIndex() + offset);
    }

    public int read8(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return this.read8(offset);
    }

    public int read8Signed(int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return this.read8Signed(offset);
    }

    public int read8Signed(int offset) {
        int num = this.read8(offset);
        if (num > 127) {
            num -= 255;
        }
        return num;
    }

    public String readUtf8String(int offset, int length) {
        return Encoding.getUtf8().getString(this.getData(), this.getIndex() + offset, length);
    }

    public String readUtf8String(int offset) {
        return Encoding.getUtf8().getString(this.getData(), this.getIndex() + offset, this.getLength() - this.getIndex() - offset);
    }

    public void resize(int newLength) {
        this.resize(newLength, -1);
    }

    public void resize(int newLength, int offset, boolean setZero) {
        int length = newLength - this.getLength();
        if (length < 0) {
            length = -length;
            if (offset < 0) {
                if (setZero) {
                    BitAssistant.set(this.getData(), newLength, length, 0);
                }
            } else if (offset <= this.getIndex()) {
                if (setZero) {
                    BitAssistant.set(this.getData(), this.getIndex(), length, 0);
                }
                this.setIndex(this.getIndex() + length);
            } else if (offset >= this.getIndex()) {
                int num3;
                int num2 = offset - this.getIndex();
                if (num2 < (num3 = this.getLength() - offset - length)) {
                    BitAssistant.copy(this.getData(), this.getIndex(), this.getData(), this.getIndex() + length, num2);
                    if (setZero) {
                        BitAssistant.set(this.getData(), this.getIndex(), length, 0);
                    }
                    this.setIndex(this.getIndex() + length);
                } else {
                    BitAssistant.copy(this.getData(), this.getLength() - num3, this.getData(), this.getIndex() + num2, num3);
                    if (setZero) {
                        BitAssistant.set(this.getData(), newLength, length, 0);
                    }
                }
            }
        } else if (length > 0) {
            if (offset >= this.getIndex()) {
                if (this.getIndex() + newLength < ArrayExtensions.getLength(this.getData())) {
                    int index = this.getIndex() + offset;
                    int num5 = this.getIndex() + offset + length;
                    int num6 = this.getLength() - offset;
                    BitAssistant.copy(this.getData(), index, this.getData(), num5, num6);
                    if (setZero) {
                        BitAssistant.set(this.getData(), index, length, 0);
                    }
                } else {
                    if (this.getIsPooled()) {
                        throw new RuntimeException(new Exception("Cannot resize pooled data buffer."));
                    }
                    byte[] buffer = new byte[this.getIndex() + newLength];
                    BitAssistant.copy(this.getData(), this.getIndex(), buffer, this.getIndex(), offset);
                    int index = this.getIndex() + offset;
                    int num5 = this.getIndex() + offset + length;
                    int num7 = this.getLength() - offset;
                    BitAssistant.copy(this.getData(), index, buffer, num5, num7);
                    this.setInnerData(buffer);
                }
            } else if (offset < 0) {
                if (this.getIndex() + newLength <= ArrayExtensions.getLength(this.getData())) {
                    if (setZero) {
                        BitAssistant.set(this.getData(), this.getLength(), length, 0);
                    }
                } else {
                    if (this.getIsPooled()) {
                        throw new RuntimeException(new Exception("Cannot resize pooled data buffer."));
                    }
                    byte[] buffer = new byte[this.getIndex() + newLength];
                    BitAssistant.copy(this.getData(), this.getIndex(), buffer, this.getIndex(), this.getLength());
                    this.setInnerData(buffer);
                }
            } else if (this.getIndex() - offset + newLength < ArrayExtensions.getLength(this.getData())) {
                this.setIndex(offset);
            } else {
                if (this.getIsPooled()) {
                    throw new RuntimeException(new Exception("Cannot resize pooled data buffer."));
                }
                byte[] buffer = new byte[newLength];
                int index = this.getIndex();
                int num5 = length;
                BitAssistant.copy(this.getData(), index, buffer, num5, this.getLength());
                this.setInnerData(buffer);
                this.setIndex(0);
            }
        }
        this.setLength(newLength);
    }

    public void resize(int newLength, int offset) {
        this.resize(newLength, offset, false);
    }

    public boolean sequenceEquals(DataBuffer buffer) {
        return BitAssistant.sequencesAreEqual(this.getData(), this.getIndex(), buffer.getData(), buffer.getIndex(), this.getLength());
    }

    public boolean sequenceEqualsConstantTime(DataBuffer buffer) {
        return BitAssistant.sequencesAreEqualConstantTime(this.getData(), this.getIndex(), buffer.getData(), buffer.getIndex(), this.getLength());
    }

    public void set(byte value) {
        this.set(value, 0, this.getLength());
    }

    public void set(byte value, int offset) {
        BitAssistant.set(this.getData(), this.getIndex() + offset, this.getLength() - offset, value);
    }

    public void set(byte value, int offset, int length) {
        BitAssistant.set(this.getData(), this.getIndex() + offset, length, value);
    }

    protected void setIndex(int value) {
        this._index = value;
    }

    protected void setInnerData(byte[] value) {
        this._innerData = value;
    }

    protected void setLength(int value) {
        this._length = value;
    }

    public void setLittleEndian(boolean value) {
        this._littleEndian = value;
    }

    public DataBuffer subset(int offset) {
        return this.subset(offset, this.getLength() - offset);
    }

    public DataBuffer subset(int offset, int length) {
        if (offset + length > this.getLength() || length < 0) {
            return null;
        }
        if (this.getIsPooled()) {
            return new DataBufferSubset(this, this.getIndex() + offset, length);
        }
        return new DataBuffer(this.getData(), this.getIndex() + offset, length, this.getLittleEndian());
    }

    public byte[] toArray() {
        byte[] destination = new byte[this.getLength()];
        BitAssistant.copy(this.getData(), this.getIndex(), destination, 0, this.getLength());
        return destination;
    }

    public String toHexString() {
        return BitAssistant.getHexString(this.getData(), this.getIndex(), this.getLength());
    }

    public String toJson() {
        return DataBuffer.toJson(this);
    }

    public static String toJson(final DataBuffer dataBuffer) {
        return JsonSerializer.serializeObject(dataBuffer, new IAction2<DataBuffer, HashMap<String, String>>(){

            @Override
            public void invoke(DataBuffer obj, HashMap<String, String> jsonObject) {
                byte[] b = dataBuffer.toArray();
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "data", Base64.encode(b));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "index", JsonSerializer.serializeInteger(new NullableInteger(0)));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "length", JsonSerializer.serializeInteger(new NullableInteger(ArrayExtensions.getLength(b))));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "littleEndian", JsonSerializer.serializeBoolean(new NullableBoolean(dataBuffer.getLittleEndian())));
            }
        });
    }

    public static String toJsonArray(DataBuffer[] dataBuffers) {
        return JsonSerializer.serializeObjectArray(dataBuffers, new IFunctionDelegate1<DataBuffer, String>(){

            @Override
            public String getId() {
                return "fm.icelink.DataBuffer.toJson";
            }

            @Override
            public String invoke(DataBuffer dataBuffer) {
                return DataBuffer.toJson(dataBuffer);
            }
        });
    }

    public boolean tryRead1(int offset, int bitOffset, BooleanHolder value) {
        boolean _var0 = Binary.tryFromBytes1(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead13(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes13(this.getData(), this.getIndex() + offset, bitOffset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead16(int offset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes16(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead2(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes2(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead24(int offset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes24(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead3(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes3(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead32(int offset, LongHolder value) {
        boolean _var0 = Binary.tryFromBytes32(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead4(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes4(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead40(int offset, LongHolder value) {
        boolean _var0 = Binary.tryFromBytes40(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead48(int offset, LongHolder value) {
        boolean _var0 = Binary.tryFromBytes48(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead5(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes5(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead56(int offset, LongHolder value) {
        boolean _var0 = Binary.tryFromBytes56(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead6(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes6(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead64(int offset, LongHolder value) {
        boolean _var0 = Binary.tryFromBytes64(this.getData(), this.getIndex() + offset, this.getLittleEndian(), value);
        return _var0;
    }

    public boolean tryRead7(int offset, int bitOffset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes7(this.getData(), this.getIndex() + offset, bitOffset, value);
        return _var0;
    }

    public boolean tryRead8(int offset, IntegerHolder value) {
        boolean _var0 = Binary.tryFromBytes8(this.getData(), this.getIndex() + offset, value);
        return _var0;
    }

    public static DataBuffer wrap(byte[] data, int index) {
        return DataBuffer.wrap(data, index, -1, false);
    }

    public static DataBuffer wrap(byte[] data, int index, boolean littleEndian) {
        return DataBuffer.wrap(data, index, -1, littleEndian);
    }

    public static DataBuffer wrap(byte[] data, int index, int length) {
        return DataBuffer.wrap(data, index, length, false);
    }

    public static DataBuffer wrap(byte[] data, boolean littleEndian) {
        return DataBuffer.wrap(data, 0, -1, littleEndian);
    }

    public static DataBuffer wrap(byte[] data, int index, int length, boolean littleEndian) {
        if (data == null) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (length < 0) {
            length = ArrayExtensions.getLength(data) - index;
        }
        return new DataBuffer(data, index, length, littleEndian);
    }

    public static DataBuffer wrap(byte[] data) {
        return DataBuffer.wrap(data, 0, -1, false);
    }

    public void write(DataBuffer buffer) {
        this.write(buffer, 0);
    }

    public void write(DataBuffer buffer, int offset) {
        BitAssistant.copy(buffer.getData(), buffer.getIndex(), this.getData(), this.getIndex() + offset, buffer.getLength());
    }

    public void write(DataBuffer buffer, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + buffer.getLength());
        this.write(buffer, offset);
    }

    public boolean write1(boolean value, int offset, int bitOffset) {
        return Binary.toBytes1(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write13(int value, int offset, int bitOffset) {
        return Binary.toBytes13(value, bitOffset, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write16(int value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 2);
        return this.write16(value, offset);
    }

    public boolean write16(int value, int offset) {
        return Binary.toBytes16(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write18(int value, int offset, int bitOffset) {
        return Binary.toBytes18(value, bitOffset, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write2(int value, int offset, int bitOffset) {
        return Binary.toBytes2(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write24(int value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 3);
        return this.write24(value, offset);
    }

    public boolean write24(int value, int offset) {
        return Binary.toBytes24(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write3(int value, int offset, int bitOffset) {
        return Binary.toBytes3(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write32(long value, int offset) {
        return Binary.toBytes32(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write32(long value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 4);
        return this.write32(value, offset);
    }

    public boolean write4(int value, int offset, int bitOffset) {
        return Binary.toBytes4(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write40(long value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 5);
        return this.write40(value, offset);
    }

    public boolean write40(long value, int offset) {
        return Binary.toBytes40(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write48(long value, int offset) {
        return Binary.toBytes48(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write48(long value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 6);
        return this.write48(value, offset);
    }

    public boolean write5(int value, int offset, int bitOffset) {
        return Binary.toBytes5(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write56(long value, int offset) {
        return Binary.toBytes56(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write56(long value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 7);
        return this.write56(value, offset);
    }

    public boolean write6(int value, int offset, int bitOffset) {
        return Binary.toBytes6(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write64(long value, int offset) {
        return Binary.toBytes64(value, this.getLittleEndian(), this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write64(long value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 8);
        return this.write64(value, offset);
    }

    public boolean write7(int value, int offset, int bitOffset) {
        return Binary.toBytes7(value, bitOffset, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write8(int value, int offset) {
        return Binary.toBytes8(value, this.getData(), this.getIndex() + offset) != null;
    }

    public boolean write8(int value, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + 1);
        return this.write8(value, offset);
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, ArrayExtensions.getLength(bytes), 0);
    }

    public void writeBytes(byte[] bytes, int offset) {
        this.writeBytes(bytes, 0, ArrayExtensions.getLength(bytes), offset);
    }

    public void writeBytes(byte[] bytes, int bytesIndex, int bytesLength, int offset) {
        if (offset + bytesLength > this.getLength()) {
            throw new RuntimeException(new Exception("Would write out of the allowed bounds for this data buffer."));
        }
        BitAssistant.copy(bytes, bytesIndex, this.getData(), this.getIndex() + offset, bytesLength);
    }

    public void writeBytes(byte[] bytes, int bytesIndex, int bytesLength, int offset, IntegerHolder offsetPlus) {
        offsetPlus.setValue(offset + bytesLength);
        this.writeBytes(bytes, bytesIndex, bytesLength, offset);
    }

    public void writeBytes(byte[] bytes, int bytesIndex, int offset) {
        this.writeBytes(bytes, bytesIndex, ArrayExtensions.getLength(bytes) - bytesIndex, offset);
    }

    public boolean xor(int value, int offset) {
        return this.write8(this.read8(offset) ^ value, offset);
    }
}

