/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BaseStats;
import fm.icelink.DataStreamStats;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.MediaStreamStats;
import fm.icelink.StreamStats;
import fm.icelink.StreamType;
import fm.icelink.Utility;
import java.util.ArrayList;
import java.util.HashMap;

public class ConnectionStats
extends BaseStats {
    private DataStreamStats _dataStream;
    private MediaStreamStats[] _mediaStreams;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String str = key;
        if (str != null) {
            if (!Global.equals(str, "mediaStreams")) {
                if (Global.equals(str, "dataStream")) {
                    this.setDataStream(DataStreamStats.fromJson(valueJson));
                }
            } else {
                this.setMediaStreams(MediaStreamStats.fromJsonArray(valueJson));
            }
        }
    }

    public static ConnectionStats fromJson(String connectionJson) {
        return JsonSerializer.deserializeObject(connectionJson, new IFunction0<ConnectionStats>(){

            @Override
            public ConnectionStats invoke() {
                return new ConnectionStats();
            }
        }, new IAction3<ConnectionStats, String, String>(){

            @Override
            public void invoke(ConnectionStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public MediaStreamStats getAudioStream() {
        return Utility.firstOrDefault(this.getAudioStreams());
    }

    public MediaStreamStats[] getAudioStreams() {
        ArrayList<MediaStreamStats> list = new ArrayList<MediaStreamStats>();
        MediaStreamStats[] mediaStreams = this.getMediaStreams();
        if (mediaStreams != null) {
            for (MediaStreamStats stats : mediaStreams) {
                if (!Global.equals((Object)stats.getType(), (Object)StreamType.Audio)) continue;
                list.add(stats);
            }
        }
        return list.toArray(new MediaStreamStats[0]);
    }

    public DataStreamStats getDataStream() {
        return this._dataStream;
    }

    public boolean getIsHost() {
        StreamStats[] streams = this.getStreams();
        if (streams != null) {
            for (StreamStats stats : streams) {
                if (!stats.getIsHost()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getIsReflexive() {
        StreamStats[] streams = this.getStreams();
        if (streams != null) {
            for (StreamStats stats : streams) {
                if (!stats.getIsReflexive()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getIsRelayed() {
        StreamStats[] streams = this.getStreams();
        if (streams != null) {
            for (StreamStats stats : streams) {
                if (!stats.getIsRelayed()) continue;
                return true;
            }
        }
        return false;
    }

    public MediaStreamStats getMediaStream(String mediaStreamId) {
        for (MediaStreamStats stats : this.getMediaStreams()) {
            if (!Global.equals(stats.getId(), mediaStreamId)) continue;
            return stats;
        }
        return null;
    }

    public MediaStreamStats getMediaStream() {
        return Utility.firstOrDefault(this.getMediaStreams());
    }

    public MediaStreamStats[] getMediaStreams() {
        return this._mediaStreams;
    }

    public StreamStats[] getStreams() {
        DataStreamStats dataStream;
        ArrayList<StreamStats> list = new ArrayList<StreamStats>();
        MediaStreamStats[] mediaStreams = this.getMediaStreams();
        if (mediaStreams != null) {
            for (MediaStreamStats stats : mediaStreams) {
                list.add(stats);
            }
        }
        if ((dataStream = this.getDataStream()) != null) {
            list.add(dataStream);
        }
        return list.toArray(new StreamStats[0]);
    }

    public MediaStreamStats getVideoStream() {
        return Utility.firstOrDefault(this.getVideoStreams());
    }

    public MediaStreamStats[] getVideoStreams() {
        ArrayList<MediaStreamStats> list = new ArrayList<MediaStreamStats>();
        MediaStreamStats[] mediaStreams = this.getMediaStreams();
        if (mediaStreams != null) {
            for (MediaStreamStats stats : mediaStreams) {
                if (!Global.equals((Object)stats.getType(), (Object)StreamType.Video)) continue;
                list.add(stats);
            }
        }
        return list.toArray(new MediaStreamStats[0]);
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        if (this.getMediaStreams() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "mediaStreams", MediaStreamStats.toJsonArray(this.getMediaStreams()));
        }
        if (this.getDataStream() != null) {
            HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "dataStream", DataStreamStats.toJson(this.getDataStream()));
        }
    }

    void setDataStream(DataStreamStats value) {
        this._dataStream = value;
    }

    void setMediaStreams(MediaStreamStats[] value) {
        this._mediaStreams = value;
    }

    public String toJson() {
        return ConnectionStats.toJson(this);
    }

    public static String toJson(ConnectionStats connection) {
        return JsonSerializer.serializeObject(connection, new IAction2<ConnectionStats, HashMap<String, String>>(){

            @Override
            public void invoke(ConnectionStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }
}

