/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.AsymmetricKey;
import fm.icelink.Binary;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Fingerprint;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashContextBase;
import fm.icelink.HashType;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.X501Attribute;
import fm.icelink.X501AttributeType;
import fm.icelink.X501DirectoryString;
import fm.icelink.X501Name;
import fm.icelink.X501RelativeDistinguishedName;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509Certificate;
import fm.icelink.X509Extensions;
import fm.icelink.X509SubjectPublicKeyInfo;
import fm.icelink.X509TbsCertificate;
import fm.icelink.X509Time;
import fm.icelink.X509TimeType;
import fm.icelink.X509Validity;
import java.util.Date;

public abstract class Certificate<TCertificate extends Certificate<TCertificate, TFingerprint>, TFingerprint extends Fingerprint> {
    Asn1Sequence __asn1;
    private boolean __autoRegenerate = true;
    DataBuffer __buffer;
    DataBuffer __md5Fingerprint;
    DataBuffer __sha1Fingerprint;
    DataBuffer __sha256Fingerprint;
    X509Certificate __x509;
    private Date _effectiveDate = new Date();
    private Date _expirationDate = new Date();
    private X509Extensions _extensions;
    private String _id;
    private String _issuerName;
    private byte[] _issuerUniqueId;
    private AsymmetricKey _key;
    private byte[] _serialNumber;
    private X509AlgorithmIdentifier _signatureAlgorithm;
    private String _subjectName;
    private byte[] _subjectUniqueId;

    public TFingerprint calculateFingerprint(String algorithm) {
        byte[] bytes = this.getBytes();
        DataBuffer buffer2 = null;
        if (Global.equals(algorithm, Fingerprint.getSha256Algorithm())) {
            if (this.__sha256Fingerprint == null) {
                this.__sha256Fingerprint = HashContextBase.compute(HashType.Sha256, DataBuffer.wrap(bytes));
            }
            buffer2 = this.__sha256Fingerprint;
        } else if (Global.equals(algorithm, Fingerprint.getSha1Algorithm())) {
            if (this.__sha1Fingerprint == null) {
                this.__sha1Fingerprint = HashContextBase.compute(HashType.Sha1, DataBuffer.wrap(bytes));
            }
            buffer2 = this.__sha1Fingerprint;
        } else if (Global.equals(algorithm, Fingerprint.getMd5Algorithm())) {
            if (this.__md5Fingerprint == null) {
                this.__md5Fingerprint = HashContextBase.compute(HashType.Md5, DataBuffer.wrap(bytes));
            }
            buffer2 = this.__md5Fingerprint;
        } else {
            Log.error(StringExtensions.format("Unsupported fingerprint algorithm: {0}.", algorithm));
            return null;
        }
        String str = buffer2.toHexString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < StringExtensions.getLength(str); i += 2) {
            if (i > 0) {
                StringBuilderExtensions.append(builder, ":");
            }
            StringBuilderExtensions.append(builder, StringExtensions.toUpper(StringExtensions.substring(str, i, 2)));
        }
        return this.createFingerprint(algorithm, builder.toString());
    }

    public Certificate() {
        this.setId(Guid.newGuid().toString().replace("-", ""));
    }

    public TCertificate clone() {
        TCertificate local = this.createCertificate();
        ((Certificate)local).setId(this.getId());
        ((Certificate)local).setIssuerName(this.getIssuerName());
        ((Certificate)local).setSubjectName(this.getSubjectName());
        ((Certificate)local).setEffectiveDate(this.getEffectiveDate());
        ((Certificate)local).setExpirationDate(this.getExpirationDate());
        ((Certificate)local).setIssuerUniqueId(this.getIssuerUniqueId());
        ((Certificate)local).setSubjectUniqueId(this.getSubjectUniqueId());
        ((Certificate)local).setExtensions(this.getExtensions());
        ((Certificate)local).setSerialNumber(this.getSerialNumber());
        ((Certificate)local).setSignatureAlgorithm(this.getSignatureAlgorithm());
        ((Certificate)local).setKey(this.getKey());
        ((Certificate)local).__buffer = this.__buffer;
        ((Certificate)local).__asn1 = this.__asn1;
        ((Certificate)local).__x509 = this.__x509;
        ((Certificate)local).__md5Fingerprint = this.__md5Fingerprint;
        ((Certificate)local).__sha1Fingerprint = this.__sha1Fingerprint;
        ((Certificate)local).__sha256Fingerprint = this.__sha256Fingerprint;
        return local;
    }

    protected abstract TCertificate createCertificate();

    protected abstract TFingerprint createFingerprint(String var1, String var2);

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC fromAsn1(Asn1Any any, TC certificate) {
        X509Certificate certificate2 = X509Certificate.fromAsn1(any);
        if (certificate2 == null) {
            return null;
        }
        return Certificate.fromX509(certificate2, certificate);
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC fromX509(X509Certificate x509Certificate, TC certificate) {
        if (x509Certificate == null) {
            return null;
        }
        byte[] signature = x509Certificate.getSignature();
        X509TbsCertificate tbsCertificate = x509Certificate.getTbsCertificate();
        if (tbsCertificate == null) {
            return null;
        }
        if (!X509AlgorithmIdentifier.areEqual(x509Certificate.getSignatureAlgorithm(), tbsCertificate.getSignatureAlgorithm())) {
            return null;
        }
        X509SubjectPublicKeyInfo subjectPublicKeyInfo = tbsCertificate.getSubjectPublicKeyInfo();
        if (subjectPublicKeyInfo == null || subjectPublicKeyInfo.getSubjectPublicKey() == null) {
            return null;
        }
        AsymmetricKey key = null;
        if (signature != null) {
            key = AsymmetricKey.fromSubjectPublicKeyInfo(subjectPublicKeyInfo);
            if (tbsCertificate.getSourceAsn() == null) {
                if (!key.verify(tbsCertificate.toAsn1().getBytes(), signature, x509Certificate.getSignatureAlgorithm())) {
                    // empty if block
                }
            } else {
                DataBuffer buffer;
                DataBuffer sourceData = tbsCertificate.getSourceAsn().getSourceData();
                if (!sourceData.sequenceEquals(buffer = tbsCertificate.toAsn1().getBuffer())) {
                    Log.warn(StringExtensions.format("Certificate ASN.1 input does not match certificate ASN.1 output.\nINPUT: {0}\nOUTPUT: {1}", sourceData.toHexString(), buffer.toHexString()));
                }
                if (!key.verify(sourceData.toArray(), signature, x509Certificate.getSignatureAlgorithm())) {
                    // empty if block
                }
            }
        }
        if (tbsCertificate.getValidity() == null) {
            return null;
        }
        certificate.setSignatureAlgorithm(x509Certificate.getSignatureAlgorithm());
        certificate.setSerialNumber(tbsCertificate.getSerialNumber());
        certificate.setEffectiveDate(tbsCertificate.getValidity().getNotBefore().getValue());
        certificate.setExpirationDate(tbsCertificate.getValidity().getNotAfter().getValue());
        certificate.setIssuerName(Certificate.getCommonName(tbsCertificate.getIssuer()));
        certificate.setSubjectName(Certificate.getCommonName(tbsCertificate.getSubject()));
        certificate.setIssuerUniqueId(tbsCertificate.getIssuerUniqueId());
        certificate.setSubjectUniqueId(tbsCertificate.getSubjectUniqueId());
        certificate.setExtensions(tbsCertificate.getExtensions());
        certificate.setKey(key);
        return certificate;
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC generateCertificate(String issuerName, String subjectName, Date expirationDate, AsymmetricKey key, TC certificate) {
        Date utcNow = DateExtensions.getUtcNow();
        if (key == null) {
            throw new RuntimeException(new Exception("Key cannot be null."));
        }
        if (!key.hasPublic()) {
            throw new RuntimeException(new Exception("Key is missing public details."));
        }
        if (!key.hasPrivate()) {
            throw new RuntimeException(new Exception("Key is missing private details."));
        }
        certificate.setIssuerName(issuerName != null ? issuerName : "IceLink");
        certificate.setSubjectName(subjectName != null ? subjectName : "IceLink");
        certificate.setEffectiveDate(DateExtensions.addSeconds(utcNow, -864000.0));
        certificate.setExpirationDate(expirationDate);
        certificate.setSerialNumber(Binary.toBytes32(LockedRandomizer.next(), false));
        certificate.setSignatureAlgorithm(key.getPreferredSignatureAlgorithm());
        certificate.setKey(key);
        return certificate;
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC generateCertificate(String name, AsymmetricKey key, TC certificate) {
        return Certificate.generateCertificate(name, name, key, certificate);
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC generateCertificate(String issuerName, String subjectName, AsymmetricKey key, TC certificate) {
        Date expirationDate = DateExtensions.addSeconds(DateExtensions.getUtcNow(), 864000.0);
        return Certificate.generateCertificate(issuerName, subjectName, expirationDate, key, certificate);
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC generateCertificate(AsymmetricKey key, TC certificate) {
        return Certificate.generateCertificate("IceLink", key, certificate);
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC generateCertificateFromOldCertificate(TC oldCertificate, Date expirationDate, TC certificate) {
        return Certificate.generateCertificate(oldCertificate.getIssuerName(), oldCertificate.getSubjectName(), expirationDate, AsymmetricKey.createKey(oldCertificate.getKey().getType()), certificate);
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC generateCertificateFromOldCertificate(TC oldCertificate, TC certificate) {
        return Certificate.generateCertificate(oldCertificate.getIssuerName(), oldCertificate.getSubjectName(), AsymmetricKey.createKey(oldCertificate.getKey().getType()), certificate);
    }

    public boolean getAutoRegenerate() {
        return this.__autoRegenerate;
    }

    public DataBuffer getBuffer() {
        Asn1Sequence sequence;
        if (this.__buffer == null && (sequence = this.toAsn1()) != null) {
            this.__buffer = sequence.getBuffer();
        }
        return this.__buffer;
    }

    public byte[] getBytes() {
        return this.getBuffer().toArray();
    }

    private static String getCommonName(X501Name name) {
        if (name == null) {
            return null;
        }
        X501Attribute attribute = name.getAttribute(X501AttributeType.getCommonName());
        if (attribute == null) {
            return null;
        }
        return attribute.attributeValueAsString();
    }

    public Date getEffectiveDate() {
        return this._effectiveDate;
    }

    public Date getExpirationDate() {
        return this._expirationDate;
    }

    X509Extensions getExtensions() {
        return this._extensions;
    }

    public String getId() {
        return this._id;
    }

    public boolean getIsExpired() {
        long num2;
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        return ticks > (num2 = DateExtensions.getTicks(this.getExpirationDate()));
    }

    public boolean getIsExpiring() {
        long ticks = DateExtensions.getTicks(DateExtensions.getUtcNow());
        return DateExtensions.getTicks(this.getExpirationDate()) - ticks < 86400L;
    }

    public String getIssuerName() {
        return this._issuerName;
    }

    byte[] getIssuerUniqueId() {
        return this._issuerUniqueId;
    }

    public AsymmetricKey getKey() {
        return this._key;
    }

    byte[] getSerialNumber() {
        return this._serialNumber;
    }

    X509AlgorithmIdentifier getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public String getSubjectName() {
        return this._subjectName;
    }

    byte[] getSubjectUniqueId() {
        return this._subjectUniqueId;
    }

    static <TC extends Certificate<TC, TF>, TF extends Fingerprint> TC parseBytes(byte[] bytes, TC certificate) {
        Asn1Any any = Asn1Any.parseBytes(bytes);
        if (any == null) {
            return null;
        }
        return Certificate.fromAsn1(any, certificate);
    }

    public void regenerate(Date expirationDate) {
        this.setExpirationDate(expirationDate);
        this.setSerialNumber(Binary.toBytes32(LockedRandomizer.next(), false));
        AsymmetricKey key = this.getKey();
        if (key != null) {
            this.setKey(key.regenerate());
        }
        this.__buffer = null;
        this.__asn1 = null;
        this.__x509 = null;
        this.__sha1Fingerprint = null;
        this.__sha256Fingerprint = null;
    }

    public void regenerate() {
        Date expirationDate = DateExtensions.addSeconds(DateExtensions.getUtcNow(), 864000.0);
        this.regenerate(expirationDate);
    }

    public void setAutoRegenerate(boolean value) {
        this.__autoRegenerate = value;
    }

    void setEffectiveDate(Date value) {
        this._effectiveDate = value;
    }

    void setExpirationDate(Date value) {
        this._expirationDate = value;
    }

    void setExtensions(X509Extensions value) {
        this._extensions = value;
    }

    public void setId(String value) {
        this._id = value;
    }

    void setIssuerName(String value) {
        this._issuerName = value;
    }

    void setIssuerUniqueId(byte[] value) {
        this._issuerUniqueId = value;
    }

    public void setKey(AsymmetricKey value) {
        this._key = value;
    }

    void setSerialNumber(byte[] value) {
        this._serialNumber = value;
    }

    void setSignatureAlgorithm(X509AlgorithmIdentifier value) {
        this._signatureAlgorithm = value;
    }

    void setSubjectName(String value) {
        this._subjectName = value;
    }

    void setSubjectUniqueId(byte[] value) {
        this._subjectUniqueId = value;
    }

    Asn1Sequence toAsn1() {
        X509Certificate certificate;
        if (this.__asn1 == null && (certificate = this.toX509()) != null) {
            this.__asn1 = certificate.toAsn1();
        }
        return this.__asn1;
    }

    X509Certificate toX509() {
        if (this.__x509 == null) {
            AsymmetricKey key = this.getKey();
            if (key == null || !key.hasPrivate()) {
                throw new RuntimeException(new Exception("Key is missing private information."));
            }
            X509TbsCertificate certificate2 = new X509TbsCertificate();
            certificate2.setVersion(X509TbsCertificate.getVersion3());
            certificate2.setSerialNumber(this.getSerialNumber());
            certificate2.setSignatureAlgorithm(this.getSignatureAlgorithm());
            certificate2.setIssuer(new X501Name(new X501RelativeDistinguishedName[]{new X501RelativeDistinguishedName(new X501Attribute[]{new X501Attribute(X501AttributeType.getCommonName(), new X501DirectoryString(this.getIssuerName()).toAsn1Printable().getBytes())})}));
            X509Validity validity = new X509Validity();
            validity.setNotBefore(new X509Time(this.getEffectiveDate(), X509TimeType.Utc));
            validity.setNotAfter(new X509Time(this.getExpirationDate(), X509TimeType.Utc));
            certificate2.setValidity(validity);
            certificate2.setSubject(new X501Name(new X501RelativeDistinguishedName[]{new X501RelativeDistinguishedName(new X501Attribute[]{new X501Attribute(X501AttributeType.getCommonName(), new X501DirectoryString(this.getSubjectName()).toAsn1Printable().getBytes())})}));
            certificate2.setSubjectPublicKeyInfo(key.toSubjectPublicKeyInfo());
            certificate2.setIssuerUniqueId(this.getIssuerUniqueId());
            certificate2.setSubjectUniqueId(this.getSubjectUniqueId());
            certificate2.setExtensions(this.getExtensions());
            X509TbsCertificate certificate = certificate2;
            X509Certificate certificate3 = new X509Certificate();
            certificate3.setTbsCertificate(certificate);
            certificate3.setSignatureAlgorithm(this.getSignatureAlgorithm());
            certificate3.setSignature(key.sign(certificate.toAsn1().getBytes(), this.getSignatureAlgorithm()));
            this.__x509 = certificate3;
        }
        return this.__x509;
    }
}

