/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFormatCollection;
import fm.icelink.AudioFrame;
import fm.icelink.AudioTrack;
import fm.icelink.BandwidthAdaptationPolicy;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioInputCollection;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioOutputCollection;
import fm.icelink.IAudioStream;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaOutput;
import fm.icelink.IMediaStream;
import fm.icelink.IOutput;
import fm.icelink.IStream;
import fm.icelink.IntegerHolder;
import fm.icelink.JitterConfig;
import fm.icelink.LocalMedia;
import fm.icelink.MathAssistant;
import fm.icelink.MediaHeaderExtensionPolicy;
import fm.icelink.MediaStream;
import fm.icelink.NackPolicy;
import fm.icelink.ParseAssistant;
import fm.icelink.RedFecPolicy;
import fm.icelink.RemoteMedia;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.dtmf.Receiver;
import fm.icelink.dtmf.Sender;
import fm.icelink.dtmf.Tone;
import fm.icelink.sdp.rtp.MapAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AudioStream
extends MediaStream<IAudioOutput, IAudioOutputCollection, IAudioInput, IAudioInputCollection, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat, AudioFormatCollection>
implements IAudioStream,
IMediaStream,
IStream,
IAudioInput,
IMediaInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioOutput,
IMediaOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    private double __gain;
    private List<IAction1<Tone>> __onReceiveDtmfTone;
    private List<IAction1<Tone>> __onReceiveDtmfToneChange;
    private List<IAction1<Tone>> __onSendDtmfTone;
    private List<IAction1<Tone>> __onSendDtmfToneChange;
    private double __volume;
    private HashMap<Integer, Receiver> _dtmfReceivers;
    private HashMap<Integer, Sender> _dtmfSenders;
    private AudioTrack _localTrack;
    private IAction1<Tone> _onReceiveDtmfTone;
    private IAction1<Tone> _onReceiveDtmfToneChange;
    private IAction1<Tone> _onSendDtmfTone;
    private IAction1<Tone> _onSendDtmfToneChange;
    private AudioTrack _remoteTrack;

    @Override
    public void addOnReceiveDtmfTone(IAction1<Tone> value) {
        if (value != null) {
            if (this._onReceiveDtmfTone == null) {
                this._onReceiveDtmfTone = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(AudioStream.this.__onReceiveDtmfTone)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceiveDtmfTone.add(value);
        }
    }

    @Override
    public void addOnReceiveDtmfToneChange(IAction1<Tone> value) {
        if (value != null) {
            if (this._onReceiveDtmfToneChange == null) {
                this._onReceiveDtmfToneChange = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(AudioStream.this.__onReceiveDtmfToneChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceiveDtmfToneChange.add(value);
        }
    }

    @Override
    public void addOnSendDtmfTone(IAction1<Tone> value) {
        if (value != null) {
            if (this._onSendDtmfTone == null) {
                this._onSendDtmfTone = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(AudioStream.this.__onSendDtmfTone)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onSendDtmfTone.add(value);
        }
    }

    @Override
    public void addOnSendDtmfToneChange(IAction1<Tone> value) {
        if (value != null) {
            if (this._onSendDtmfToneChange == null) {
                this._onSendDtmfToneChange = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(AudioStream.this.__onSendDtmfToneChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onSendDtmfToneChange.add(value);
        }
    }

    public AudioStream(IAudioOutput input, IAudioInput output) {
        IAudioInput[] iAudioInputArray;
        IAudioOutput[] iAudioOutputArray;
        if (input == null) {
            iAudioOutputArray = null;
        } else {
            IAudioOutput[] iAudioOutputArray2 = new IAudioOutput[1];
            iAudioOutputArray = iAudioOutputArray2;
            iAudioOutputArray2[0] = input;
        }
        if (output == null) {
            iAudioInputArray = null;
        } else {
            IAudioInput[] iAudioInputArray2 = new IAudioInput[1];
            iAudioInputArray = iAudioInputArray2;
            iAudioInputArray2[0] = output;
        }
        this(iAudioOutputArray, iAudioInputArray);
    }

    public AudioStream(IAudioInput[] outputs) {
        this(null, outputs);
    }

    public AudioStream(IAudioOutput[] inputs) {
        this(inputs, null);
    }

    public AudioStream(IAudioInput output) {
        IAudioInput[] iAudioInputArray;
        if (output == null) {
            iAudioInputArray = null;
        } else {
            IAudioInput[] iAudioInputArray2 = new IAudioInput[1];
            iAudioInputArray = iAudioInputArray2;
            iAudioInputArray2[0] = output;
        }
        this(iAudioInputArray);
    }

    public AudioStream(AudioTrack localTrack) {
        this(localTrack, null);
    }

    public AudioStream(LocalMedia localMedia, RemoteMedia remoteMedia) {
        this(localMedia == null ? null : (AudioTrack)localMedia.getAudioTrack(), remoteMedia == null ? null : (AudioTrack)remoteMedia.getAudioTrack());
        super.setLocalMedia(localMedia);
        super.setRemoteMedia(remoteMedia);
    }

    public AudioStream(IAudioOutput[] inputs, IAudioInput[] outputs) {
        super(StreamType.Audio, new JitterConfig());
        this.__onReceiveDtmfTone = new ArrayList<IAction1<Tone>>();
        this.__onReceiveDtmfToneChange = new ArrayList<IAction1<Tone>>();
        this.__onSendDtmfTone = new ArrayList<IAction1<Tone>>();
        this.__onSendDtmfToneChange = new ArrayList<IAction1<Tone>>();
        this._onReceiveDtmfTone = null;
        this._onReceiveDtmfToneChange = null;
        this._onSendDtmfTone = null;
        this._onSendDtmfToneChange = null;
        this.__gain = 1.0;
        this.__volume = 1.0;
        this._dtmfSenders = new HashMap();
        this._dtmfReceivers = new HashMap();
        if (inputs == null && outputs == null) {
            throw new RuntimeException(new Exception("Cannot initialize audio stream if no inputs and no outputs are provided."));
        }
        super.setRedFecPolicy(RedFecPolicy.Disabled);
        super.setNackPolicy(NackPolicy.Disabled);
        if (inputs != null) {
            super.addInputs((IMediaOutput[])inputs);
        }
        if (outputs != null) {
            super.addOutputs((IMediaInput[])outputs);
        }
        this.initializeDtmf();
        super.setAbsoluteSenderTimePolicy(MediaHeaderExtensionPolicy.Disabled);
    }

    public AudioStream(RemoteMedia remoteMedia) {
        this(null, remoteMedia);
    }

    public AudioStream(AudioTrack localTrack, AudioTrack remoteTrack) {
        this(localTrack == null ? null : (IAudioOutput[])localTrack.getOutputs(), remoteTrack == null ? null : (IAudioInput[])remoteTrack.getInputs());
        this.setLocalTrack(localTrack);
        this.setRemoteTrack(remoteTrack);
    }

    public AudioStream(LocalMedia localMedia) {
        this(localMedia, null);
    }

    public AudioStream() {
        this(new IAudioOutput[0]);
    }

    public AudioStream(IAudioOutput input) {
        IAudioOutput[] iAudioOutputArray;
        if (input == null) {
            iAudioOutputArray = null;
        } else {
            IAudioOutput[] iAudioOutputArray2 = new IAudioOutput[1];
            iAudioOutputArray = iAudioOutputArray2;
            iAudioOutputArray2[0] = input;
        }
        this(iAudioOutputArray);
    }

    private void audioStream_OnProcessFrame(AudioFrame frame) {
        Sender dtmfSender;
        if (!((AudioFormat)((AudioBuffer)frame.getLastBuffer()).getFormat()).getIsInjected() && (dtmfSender = this.getDtmfSender(frame)) != null && dtmfSender.hasTone()) {
            dtmfSender.raiseTone(frame.getDuration(), frame.getTimestamp(), frame.getSynchronizationSource());
        }
    }

    @Override
    protected AudioFormat createFormat(MapAttribute attribute) {
        return this.createFormat(attribute.getFormatName(), attribute.getClockRate(), attribute.getFormatParameters(), attribute.getPayloadType());
    }

    @Override
    protected AudioFormat createFormat(String name, int clockRate, String parameters, int payloadType) {
        int intResult = 1;
        IntegerHolder _var0 = new IntegerHolder(intResult);
        boolean _var1 = ParseAssistant.tryParseIntegerValue(parameters, _var0);
        intResult = _var0.getValue();
        if (!StringExtensions.isNullOrEmpty(parameters) && !_var1) {
            return null;
        }
        AudioFormat format = new AudioFormat(name, clockRate, intResult);
        format.setRegisteredPayloadType(payloadType);
        format.setIsPacketized(true);
        for (IAudioOutput iAudioOutput : (IAudioOutput[])super.getInputs()) {
            AudioFormat outputFormat = (AudioFormat)iAudioOutput.getOutputFormat();
            if (!outputFormat.isEquivalent(format)) continue;
            format.setIsInjected(outputFormat.getIsInjected());
        }
        for (IAudioElement iAudioElement : (IAudioInput[])super.getOutputs()) {
            AudioFormat inputFormat = (AudioFormat)iAudioElement.getInputFormat();
            if (!inputFormat.isEquivalent(format)) continue;
            format.setIsInjected(inputFormat.getIsInjected());
        }
        return format;
    }

    @Override
    protected IAudioInputCollection createInputCollection(IAudioOutput output) {
        return new IAudioInputCollection(output);
    }

    @Override
    protected AudioFormatCollection createMediaFormatCollection() {
        return new AudioFormatCollection();
    }

    @Override
    protected IAudioOutputCollection createOutputCollection(IAudioInput input) {
        return new IAudioOutputCollection(input);
    }

    private void dtmfReceiver_OnTone(Tone tone) {
        IAction1<Tone> onReceiveDtmfTone = this._onReceiveDtmfTone;
        if (onReceiveDtmfTone != null) {
            onReceiveDtmfTone.invoke(tone);
        }
    }

    private void dtmfReceiver_OnToneChange(Tone tone) {
        IAction1<Tone> onReceiveDtmfToneChange = this._onReceiveDtmfToneChange;
        if (onReceiveDtmfToneChange != null) {
            onReceiveDtmfToneChange.invoke(tone);
        }
    }

    private void dtmfSender_OnTone(Tone tone) {
        IAction1<Tone> onSendDtmfTone = this._onSendDtmfTone;
        if (onSendDtmfTone != null) {
            onSendDtmfTone.invoke(tone);
        }
    }

    private void dtmfSender_OnToneChange(Tone tone) {
        IAction1<Tone> onSendDtmfToneChange = this._onSendDtmfToneChange;
        if (onSendDtmfToneChange != null) {
            onSendDtmfToneChange.invoke(tone);
        }
    }

    protected AudioFormat[] formatArrayFromList(ArrayList<AudioFormat> formatList) {
        return formatList.toArray(new AudioFormat[0]);
    }

    @Override
    public AudioConfig getConfig() {
        return this.getOutputConfig();
    }

    private Sender getCurrentDtmfSender() {
        return this.getDtmfSender((AudioFormat)super.getInputFormat());
    }

    private Sender getDtmfSender(AudioFrame frame) {
        if (frame == null) {
            return null;
        }
        return this.getDtmfSender((AudioBuffer)frame.getBuffer(true));
    }

    private Sender getDtmfSender(AudioFormat format) {
        if (format == null) {
            return null;
        }
        return this.getDtmfSender(format.getClockRate());
    }

    private Sender getDtmfSender(AudioBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return this.getDtmfSender((AudioFormat)buffer.getFormat());
    }

    private Sender getDtmfSender(int clockRate) {
        Sender sender = null;
        Holder<Object> _var0 = new Holder<Object>(sender);
        boolean _var1 = HashMapExtensions.tryGetValue(this._dtmfSenders, Integer.valueOf(clockRate), _var0);
        sender = _var0.getValue();
        return sender;
    }

    @Override
    public double getGain() {
        return this.__gain;
    }

    public AudioConfig getInputConfig() {
        AudioFormat inputFormat = (AudioFormat)super.getInputFormat();
        if (inputFormat != null) {
            return inputFormat.getConfig();
        }
        return null;
    }

    public AudioTrack getLocalTrack() {
        return this._localTrack;
    }

    public AudioConfig getOutputConfig() {
        AudioFormat outputFormat = (AudioFormat)super.getOutputFormat();
        if (outputFormat != null) {
            return outputFormat.getConfig();
        }
        return null;
    }

    public AudioTrack getRemoteTrack() {
        return this._remoteTrack;
    }

    @Override
    public double getVolume() {
        return this.__volume;
    }

    private void initializeDtmf() {
        AudioFormat outputFormat;
        for (IAudioOutput iAudioOutput : (IAudioOutput[])super.getInputs()) {
            outputFormat = (AudioFormat)iAudioOutput.getOutputFormat();
            if (outputFormat == null || outputFormat.getIsInjected()) continue;
            this.initializeDtmfSender(outputFormat.getClockRate());
        }
        for (IAudioElement iAudioElement : (IAudioInput[])super.getOutputs()) {
            outputFormat = (AudioFormat)iAudioElement.getInputFormat();
            if (outputFormat == null || outputFormat.getIsInjected()) continue;
            this.initializeDtmfReceiver(outputFormat.getClockRate());
        }
        super.addOnProcessFrame(new IActionDelegate1<AudioFrame>(){

            @Override
            public String getId() {
                return "fm.icelink.AudioStream.audioStream_OnProcessFrame";
            }

            @Override
            public void invoke(AudioFrame frame) {
                AudioStream.this.audioStream_OnProcessFrame(frame);
            }
        });
    }

    private void initializeDtmfReceiver(int clockRate) {
        if (!this._dtmfReceivers.containsKey(clockRate)) {
            Receiver output = new Receiver(clockRate);
            output.addOnTone((IAction1<Tone>)new IActionDelegate1<Tone>(){

                @Override
                public String getId() {
                    return "fm.icelink.AudioStream.dtmfReceiver_OnTone";
                }

                @Override
                public void invoke(Tone tone) {
                    AudioStream.this.dtmfReceiver_OnTone(tone);
                }
            });
            output.addOnToneChange((IAction1<Tone>)new IActionDelegate1<Tone>(){

                @Override
                public String getId() {
                    return "fm.icelink.AudioStream.dtmfReceiver_OnToneChange";
                }

                @Override
                public void invoke(Tone tone) {
                    AudioStream.this.dtmfReceiver_OnToneChange(tone);
                }
            });
            super.addOutput(output);
            HashMapExtensions.set(HashMapExtensions.getItem(this._dtmfReceivers), clockRate, output);
        }
    }

    private void initializeDtmfSender(int clockRate) {
        if (!this._dtmfSenders.containsKey(clockRate)) {
            Sender input = new Sender(clockRate);
            input.addOnTone((IAction1<Tone>)new IActionDelegate1<Tone>(){

                @Override
                public String getId() {
                    return "fm.icelink.AudioStream.dtmfSender_OnTone";
                }

                @Override
                public void invoke(Tone tone) {
                    AudioStream.this.dtmfSender_OnTone(tone);
                }
            });
            input.addOnToneChange((IAction1<Tone>)new IActionDelegate1<Tone>(){

                @Override
                public String getId() {
                    return "fm.icelink.AudioStream.dtmfSender_OnToneChange";
                }

                @Override
                public void invoke(Tone tone) {
                    AudioStream.this.dtmfSender_OnToneChange(tone);
                }
            });
            super.addInput(input);
            HashMapExtensions.set(HashMapExtensions.getItem(this._dtmfSenders), clockRate, input);
        }
    }

    @Override
    public boolean insertDtmfTone(Tone dtmfTone) {
        return this.insertDtmfTones(new Tone[]{dtmfTone});
    }

    @Override
    public boolean insertDtmfTones(Tone[] dtmfTones) {
        Sender currentDtmfSender = this.getCurrentDtmfSender();
        if (currentDtmfSender == null) {
            return false;
        }
        currentDtmfSender.insertTones(dtmfTones);
        return true;
    }

    @Override
    protected void processBandwidthAdapatationPolicyChange(BandwidthAdaptationPolicy policy) {
        super.processBandwidthAdapatationPolicyChange(policy);
    }

    @Override
    public void removeOnReceiveDtmfTone(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveDtmfTone, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveDtmfTone.remove(value);
        if (this.__onReceiveDtmfTone.size() == 0) {
            this._onReceiveDtmfTone = null;
        }
    }

    @Override
    public void removeOnReceiveDtmfToneChange(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceiveDtmfToneChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceiveDtmfToneChange.remove(value);
        if (this.__onReceiveDtmfToneChange.size() == 0) {
            this._onReceiveDtmfToneChange = null;
        }
    }

    @Override
    public void removeOnSendDtmfTone(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSendDtmfTone, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSendDtmfTone.remove(value);
        if (this.__onSendDtmfTone.size() == 0) {
            this._onSendDtmfTone = null;
        }
    }

    @Override
    public void removeOnSendDtmfToneChange(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSendDtmfToneChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSendDtmfToneChange.remove(value);
        if (this.__onSendDtmfToneChange.size() == 0) {
            this._onSendDtmfToneChange = null;
        }
    }

    @Override
    public void setGain(double value) {
        this.__gain = MathAssistant.max(value, 0.0);
    }

    private void setLocalTrack(AudioTrack value) {
        this._localTrack = value;
    }

    private void setRemoteTrack(AudioTrack value) {
        this._remoteTrack = value;
    }

    @Override
    public void setVolume(double value) {
        this.__volume = MathAssistant.min(MathAssistant.max(value, 0.0), 1.0);
    }
}

