/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioInputCollection;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioReframer;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaOutput;
import fm.icelink.IOutput;
import fm.icelink.MathAssistant;
import fm.icelink.MediaSource;
import fm.icelink.SoundReframerContext;
import fm.icelink.SoundUtility;

public abstract class AudioSource
extends MediaSource<IAudioOutput, IAudioInput, IAudioInputCollection, AudioSource, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioOutput,
IMediaOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement,
IAudioReframer {
    private SoundReframerContext __reframerContext;
    private double __volume = 1.0;

    public AudioSource(AudioFormat outputFormat, int frameDuration) {
        super(outputFormat);
        if (frameDuration <= 0) {
            frameDuration = 20;
        }
        this.__reframerContext = new SoundReframerContext(frameDuration, outputFormat.getConfig());
    }

    public AudioSource(AudioFormat outputFormat) {
        this(outputFormat, 20);
    }

    public static int calculateDuration(int dataLength, AudioConfig config) {
        return SoundUtility.calculateDuration(dataLength, config);
    }

    public static int calculateDuration(int dataLength, int clockRate, int channelCount) {
        return SoundUtility.calculateDuration(dataLength, clockRate, channelCount);
    }

    public int calculateDuration(int dataLength) {
        return SoundUtility.calculateDuration(dataLength, ((AudioFormat)super.getOutputFormat()).getConfig());
    }

    public static int calculateDurationFloat(int dataLength, int clockRate, int channelCount) {
        return SoundUtility.calculateDurationFloat(dataLength, clockRate, channelCount);
    }

    public int calculateDurationFloat(int dataLength) {
        return SoundUtility.calculateDurationFloat(dataLength, ((AudioFormat)super.getOutputFormat()).getConfig());
    }

    @Override
    protected IAudioInputCollection createInputCollection(IAudioOutput output) {
        return new IAudioInputCollection(output);
    }

    private void doRaiseFrame(AudioFrame frame) {
        AudioBuffer buffer;
        if (((AudioFormat)super.getOutputFormat()).getIsPcm() && (buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName())) != null && this.getVolume() != 1.0) {
            buffer.applyGain(this.getVolume());
        }
        super.raiseFrame(frame);
    }

    @Override
    public int getClockRate() {
        return this.__reframerContext.getClockRate();
    }

    @Override
    public AudioConfig getConfig() {
        AudioFormat outputFormat = (AudioFormat)super.getOutputFormat();
        if (outputFormat != null) {
            return outputFormat.getConfig();
        }
        return null;
    }

    @Override
    public boolean getDisableTimestampReset() {
        return this.__reframerContext.getDisableTimestampReset();
    }

    @Override
    public boolean getForceTimestampReset() {
        return this.__reframerContext.getForceTimestampReset();
    }

    @Override
    public int getFrameDuration() {
        return this.__reframerContext.getFrameDuration();
    }

    @Override
    public int getTimestampResetInterval() {
        return this.__reframerContext.getTimestampResetInterval();
    }

    @Override
    public double getVolume() {
        return this.__volume;
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        AudioBuffer buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName());
        if (buffer == null) {
            this.doRaiseFrame(frame);
        } else {
            if (this.__reframerContext.getOnFrame() == null) {
                this.__reframerContext.setOnFrame((IAction1<AudioFrame>)new IActionDelegate1<AudioFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.AudioSource.doRaiseFrame";
                    }

                    @Override
                    public void invoke(AudioFrame frame) {
                        AudioSource.this.doRaiseFrame(frame);
                    }
                });
            }
            this.__reframerContext.processFrame(frame, buffer);
        }
    }

    @Override
    public void setDisableTimestampReset(boolean value) {
        this.__reframerContext.setDisableTimestampReset(value);
    }

    @Override
    public void setForceTimestampReset(boolean value) {
        this.__reframerContext.setForceTimestampReset(value);
    }

    @Override
    public void setTimestampResetInterval(int value) {
        this.__reframerContext.setTimestampResetInterval(value);
    }

    @Override
    public void setVolume(double value) {
        this.__volume = MathAssistant.min(MathAssistant.max(value, 0.0), 1.0);
    }
}

