/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioOutputCollection;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.MathAssistant;
import fm.icelink.MediaSink;

public abstract class AudioSink
extends MediaSink<IAudioOutput, IAudioOutputCollection, IAudioInput, AudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioInput,
IMediaInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    private double __gain = 1.0;

    public AudioSink(AudioFormat inputFormat) {
        super(inputFormat);
    }

    public AudioSink() {
    }

    @Override
    protected IAudioOutputCollection createOutputCollection(IAudioInput input) {
        return new IAudioOutputCollection(input);
    }

    @Override
    public AudioConfig getConfig() {
        AudioFormat inputFormat = (AudioFormat)super.getInputFormat();
        if (inputFormat != null) {
            return inputFormat.getConfig();
        }
        return null;
    }

    @Override
    public double getGain() {
        return this.__gain;
    }

    @Override
    public boolean processFrame(AudioFrame frame) {
        AudioBuffer buffer;
        if (((AudioFormat)super.getInputFormat()).getIsPcm() && (buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName())) != null && this.getGain() != 1.0) {
            buffer.applyGain(this.getGain());
        }
        return super.processFrame(frame);
    }

    @Override
    public void setGain(double value) {
        this.__gain = MathAssistant.max(value, 0.0);
    }
}

