/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioInputCollection;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioOutputCollection;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.IMediaOutput;
import fm.icelink.IOutput;
import fm.icelink.MathAssistant;
import fm.icelink.MediaPipe;

public abstract class AudioPipe
extends MediaPipe<IAudioOutput, IAudioOutputCollection, IAudioInput, IAudioInputCollection, AudioPipe, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioInput,
IMediaInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioOutput,
IMediaOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    private double __gain = 1.0;
    private double __volume = 1.0;

    public AudioPipe(AudioFormat outputFormat) {
        this(null, outputFormat);
    }

    public AudioPipe(AudioFormat inputFormat, AudioFormat outputFormat) {
        super(inputFormat, outputFormat);
    }

    @Override
    protected IAudioInputCollection createInputCollection(IAudioOutput output) {
        return new IAudioInputCollection(output);
    }

    @Override
    protected IAudioOutputCollection createOutputCollection(IAudioInput input) {
        return new IAudioOutputCollection(input);
    }

    @Override
    public AudioConfig getConfig() {
        return this.getOutputConfig();
    }

    @Override
    public double getGain() {
        return this.__gain;
    }

    public AudioConfig getInputConfig() {
        AudioFormat inputFormat = (AudioFormat)super.getInputFormat();
        if (inputFormat != null) {
            return inputFormat.getConfig();
        }
        return null;
    }

    public AudioConfig getOutputConfig() {
        AudioFormat outputFormat = (AudioFormat)super.getOutputFormat();
        if (outputFormat != null) {
            return outputFormat.getConfig();
        }
        return null;
    }

    @Override
    public double getVolume() {
        return this.__volume;
    }

    @Override
    public boolean processFrame(AudioFrame frame) {
        AudioBuffer buffer;
        if (((AudioFormat)super.getInputFormat()).getIsPcm() && (buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName())) != null && this.getGain() != 1.0) {
            buffer.applyGain(this.getGain());
        }
        return super.processFrame(frame);
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        AudioBuffer buffer;
        if (((AudioFormat)super.getOutputFormat()).getIsPcm() && (buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName())) != null && this.getVolume() != 1.0) {
            buffer.applyGain(this.getVolume());
        }
        super.raiseFrame(frame);
    }

    @Override
    public void setGain(double value) {
        this.__gain = MathAssistant.max(value, 0.0);
    }

    @Override
    public void setVolume(double value) {
        this.__volume = MathAssistant.min(MathAssistant.max(value, 0.0), 1.0);
    }
}

