/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.Binary;
import fm.icelink.CircularBuffer;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioReframer;
import fm.icelink.IMediaOutput;
import fm.icelink.LockedRandomizer;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;
import fm.icelink.SoundTimestampContext;
import fm.icelink.pcm.Format;
import java.util.ArrayList;
import java.util.HashMap;

public class AudioMixer
extends AudioPipe
implements IAudioReframer {
    private HashMap<Long, CircularBuffer> __buffers = new HashMap();
    private Object __buffersLock = new Object();
    private ManagedThread __thread;
    private volatile boolean __threadActive = false;
    private SoundTimestampContext __timestampContext;
    private int _latency;
    private long _synchronizationSource;

    public AudioMixer(IAudioOutput[] inputs, int latency) {
        this(inputs, latency, 0);
    }

    public AudioMixer(AudioConfig config) {
        this(config, 0);
    }

    public AudioMixer(AudioFormat format, int latency) {
        this(format, latency, 0);
    }

    public AudioMixer(AudioConfig config, int latency, int frameDuration) {
        this(new Format(config), latency, frameDuration);
    }

    public AudioMixer(IAudioOutput[] inputs) {
        this(inputs, 0);
    }

    public AudioMixer(AudioConfig config, int latency) {
        this(config, latency, 0);
    }

    public AudioMixer(IAudioOutput input, int latency) {
        this(input, latency, 0);
    }

    public AudioMixer(IAudioOutput input) {
        this(input, 0);
    }

    public AudioMixer(AudioFormat format, int latency, int frameDuration) {
        super(format.clone(), format.clone());
        byte[] buffer = new byte[4];
        LockedRandomizer.nextBytes(buffer);
        this.setSynchronizationSource(Binary.fromBytes32(buffer, 0, false));
        if (!format.getIsPcm()) {
            throw new RuntimeException(new Exception("Cannot mix non-PCM audio."));
        }
        if (latency <= 0) {
            latency = 200;
        }
        if (frameDuration <= 0) {
            frameDuration = 20;
        }
        if (latency <= 0) {
            latency = 200;
        }
        this.setLatency(latency);
        this.__timestampContext = new SoundTimestampContext(frameDuration, format.getClockRate());
        this.__threadActive = true;
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.AudioMixer.loop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                AudioMixer.this.loop(thread);
            }
        });
        this.__thread.start();
    }

    public AudioMixer(IAudioOutput[] inputs, int latency, int frameDuration) {
        this((AudioFormat)inputs[0].getOutputFormat(), latency, frameDuration);
        super.addInputs((IMediaOutput[])inputs);
    }

    public AudioMixer(AudioFormat format) {
        this(format, 0);
    }

    public AudioMixer(IAudioOutput input, int latency, int frameDuration) {
        this((AudioFormat)input.getOutputFormat(), latency, frameDuration);
        super.addInput(input);
    }

    @Override
    protected void doDestroy() {
        this.__threadActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        CircularBuffer buffer = null;
        Object object = this.__buffersLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(buffer);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__buffers, Long.valueOf(frame.getSynchronizationSource()), _var0);
            buffer = _var0.getValue();
            if (!_var1) {
                buffer = new CircularBuffer(this.getCircularBufferLength(), this.getLatency() * super.getConfig().getClockRate() * super.getConfig().getChannelCount() * 2 / 1000, ((AudioFormat)super.getOutputFormat()).getLittleEndian());
                HashMapExtensions.set(HashMapExtensions.getItem(this.__buffers), frame.getSynchronizationSource(), buffer);
            }
        }
        buffer.write(inputBuffer.getDataBuffer());
    }

    private int getCircularBufferLength() {
        return super.getConfig().getClockRate() * super.getConfig().getChannelCount() * 2 * (this.getLatency() * 2) / 1000;
    }

    @Override
    public int getClockRate() {
        return this.__timestampContext.getClockRate();
    }

    @Override
    public boolean getDisableTimestampReset() {
        return this.__timestampContext.getDisableTimestampReset();
    }

    @Override
    public boolean getForceTimestampReset() {
        return this.__timestampContext.getForceTimestampReset();
    }

    @Override
    public int getFrameDuration() {
        return this.__timestampContext.getFrameDuration();
    }

    @Override
    public String getLabel() {
        return "Audio Mixer";
    }

    public int getLatency() {
        return this._latency;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    @Override
    public int getTimestampResetInterval() {
        return this.__timestampContext.getTimestampResetInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void loop(ManagedThread thread) {
        int size = super.getConfig().getClockRate() * super.getConfig().getChannelCount() * 2 * this.getFrameDuration() / 1000;
        ArrayList<CircularBuffer> list = new ArrayList<CircularBuffer>();
        ManagedStopwatch stopwatch = new ManagedStopwatch();
        stopwatch.start();
        double num2 = 0.0;
        while (this.__threadActive) {
            thread.loopBegin();
            long elapsedMilliseconds = stopwatch.getElapsedMilliseconds();
            while (num2 < (double)elapsedMilliseconds) {
                list.clear();
                Object object = this.__buffersLock;
                synchronized (object) {
                    for (CircularBuffer circularBuffer : HashMapExtensions.getValues(this.__buffers)) {
                        list.add(circularBuffer);
                    }
                }
                DataBuffer dataBuffer = DataBufferPool.getInstance().take(size, ((AudioFormat)super.getOutputFormat()).getLittleEndian());
                ArrayList<DataBuffer> list2 = new ArrayList<DataBuffer>();
                for (CircularBuffer buffer3 : list) {
                    DataBuffer item = buffer3.read(dataBuffer.getLength());
                    if (item == null) continue;
                    list2.add(item);
                }
                dataBuffer.set((byte)0);
                if (ArrayListExtensions.getCount(list2) > 0) {
                    void var11_15;
                    boolean bl = false;
                    while (var11_15 < size) {
                        int num5 = 0;
                        for (int j = 0; j < ArrayListExtensions.getCount(list2); ++j) {
                            num5 += ((DataBuffer)ArrayListExtensions.getItem(list2).get(j)).read16((int)var11_15);
                        }
                        dataBuffer.write16(num5, (int)var11_15);
                        var11_15 += 2;
                    }
                }
                AudioFrame audioFrame = new AudioFrame(this.getFrameDuration(), new AudioBuffer(dataBuffer, (AudioFormat)super.getOutputFormat()));
                audioFrame.setSynchronizationSource(this.getSynchronizationSource());
                this.raiseFrame(audioFrame);
                dataBuffer.free();
                num2 += (double)this.getFrameDuration();
            }
            int num7 = (int)elapsedMilliseconds % this.getFrameDuration();
            ManagedThread.sleep(num7 == 0 ? this.getFrameDuration() : num7);
            thread.loopEnd();
        }
        stopwatch.stop();
    }

    @Override
    public void setDisableTimestampReset(boolean value) {
        this.__timestampContext.setDisableTimestampReset(value);
    }

    @Override
    public void setForceTimestampReset(boolean value) {
        this.__timestampContext.setForceTimestampReset(value);
    }

    private void setLatency(int value) {
        this._latency = value;
    }

    public void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    @Override
    public void setTimestampResetInterval(int value) {
        this.__timestampContext.setTimestampResetInterval(value);
    }
}

