/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.IAudioOutput;
import fm.icelink.MediaTrackStats;

public abstract class AudioDepacketizer
extends AudioPipe {
    private AtomicLong __framesReceived = new AtomicLong();

    public AudioDepacketizer(AudioFormat format) {
        super(AudioDepacketizer.cloneFormat(format, true, false), AudioDepacketizer.cloneFormat(format, false, format.getLittleEndian()));
    }

    public AudioDepacketizer(IAudioOutput input) {
        this((AudioFormat)input.getOutputFormat());
        super.addInput(input);
    }

    private static AudioFormat cloneFormat(AudioFormat format, boolean isPacketized, boolean littleEndian) {
        AudioFormat format2 = format.clone();
        format2.setIsPacketized(isPacketized);
        format2.setLittleEndian(littleEndian);
        return format2;
    }

    @Override
    protected void doProcessStatsFromInput(MediaTrackStats stats) {
        super.doProcessStatsFromInput(stats);
        stats.setFramesReceived(this.getFramesReceived());
    }

    @Override
    protected boolean getAllowDiagnosticTimer() {
        return false;
    }

    public long getFramesReceived() {
        return this.__framesReceived.getValue();
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        this.__framesReceived.increment();
        super.raiseFrame(frame);
    }
}

