/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1OctetString;
import fm.icelink.AsymmetricKeyType;
import fm.icelink.EcdsaCrypto;
import fm.icelink.EcdsaKey;
import fm.icelink.RsaCrypto;
import fm.icelink.RsaKey;
import fm.icelink.X509AlgorithmIdentifier;
import fm.icelink.X509ECNamedCurve;
import fm.icelink.X509ECParameters;
import fm.icelink.X509ECPoint;
import fm.icelink.X509PublicKeyAlgorithm;
import fm.icelink.X509RsaPublicKey;
import fm.icelink.X509SubjectPublicKeyInfo;

public abstract class AsymmetricKey {
    protected AsymmetricKey() {
    }

    public static AsymmetricKey createKey(AsymmetricKeyType keyType) {
        AsymmetricKeyType _var0 = keyType;
        if (_var0 == AsymmetricKeyType.Ecdsa) {
            return EcdsaCrypto.createKey();
        }
        return RsaCrypto.createKey();
    }

    static AsymmetricKey fromSubjectPublicKeyInfo(X509SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (Asn1ObjectIdentifier.areEqual(subjectPublicKeyInfo.getAlgorithm().getAlgorithm(), X509PublicKeyAlgorithm.getRsaEncryption())) {
            X509RsaPublicKey key = X509RsaPublicKey.fromAsn1(Asn1Any.parseBytes(subjectPublicKeyInfo.getSubjectPublicKey()));
            if (key == null) {
                return null;
            }
            RsaKey key2 = new RsaKey();
            key2.setModulus(key.getModulus());
            key2.setPublicExponent(key.getExponent());
            return key2;
        }
        if (!Asn1ObjectIdentifier.areEqual(subjectPublicKeyInfo.getAlgorithm().getAlgorithm(), X509PublicKeyAlgorithm.getEcPublicKey())) {
            throw new RuntimeException(new Exception("Public key algorithm is not supported."));
        }
        X509ECPoint point = X509ECPoint.fromAsn1(new Asn1OctetString(subjectPublicKeyInfo.getSubjectPublicKey()));
        if (point == null) {
            return null;
        }
        X509ECParameters parameters = X509ECParameters.fromAsn1(Asn1Any.parseBytes(subjectPublicKeyInfo.getAlgorithm().getParameters()));
        if (parameters == null || parameters.getNamedCurve() == null) {
            return null;
        }
        EcdsaKey key3 = new EcdsaKey();
        key3.setNamedCurve(X509ECNamedCurve.toEnum(parameters.getNamedCurve()));
        key3.setPublicKey(point.getValue());
        return key3;
    }

    abstract X509AlgorithmIdentifier getPreferredSignatureAlgorithm();

    public abstract AsymmetricKeyType getType();

    public abstract boolean hasPrivate();

    public abstract boolean hasPublic();

    abstract AsymmetricKey regenerate();

    abstract byte[] sign(byte[] var1, X509AlgorithmIdentifier var2);

    abstract X509SubjectPublicKeyInfo toSubjectPublicKeyInfo();

    abstract boolean verify(byte[] var1, byte[] var2, X509AlgorithmIdentifier var3);
}

