/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.Architecture;
import fm.icelink.FileStream;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.Holder;
import fm.icelink.HttpFileTransfer;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IFunction0;
import fm.icelink.Log;
import fm.icelink.ManagedConcurrentDictionary;
import fm.icelink.ManagedThread;
import fm.icelink.MediaFrame;
import fm.icelink.OperatingSystem;
import fm.icelink.PathUtility;
import fm.icelink.Platform;
import fm.icelink.Promise;
import fm.icelink.PromiseBase;
import fm.icelink.SourceLanguage;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.openh264.Decoder;
import fm.icelink.openh264.Encoder;
import fm.icelink.openh264.NativeLibraryInfo;

public class Utility {
    private static ManagedConcurrentDictionary<String, NativeLibraryInfo> __libraryInfo = new ManagedConcurrentDictionary();

    private static void addPlatformInfo(OperatingSystem os, Architecture arch, String downloadUrl, String libraryName, String loadLibraryName, String[] oldLibraryNames) {
        NativeLibraryInfo info2 = new NativeLibraryInfo();
        info2.setDownloadURL(downloadUrl);
        info2.setLibraryName(libraryName);
        info2.setLoadLibraryName(loadLibraryName);
        info2.setOldLibraryNames(oldLibraryNames);
        NativeLibraryInfo info = info2;
        __libraryInfo.tryAdd((Object)StringExtensions.format((String)"{0}-{1}", (Object)os.toString(), (Object)arch.toString()), (Object)info);
    }

    private static void doInitialize(final Encoder encoder, final Decoder decoder, final Promise<Object> promise) {
        decoder.addOnRaiseFrame((IAction1)new IAction1<VideoFrame>(){

            public void invoke(VideoFrame frame) {
                promise.resolve(null);
                ManagedThread.dispatch((IAction0)new IAction0(){

                    public void invoke() {
                        encoder.destroy();
                        decoder.destroy();
                    }
                });
            }
        });
        encoder.addOnRaiseFrame((IAction1)new IAction1<VideoFrame>(){

            public void invoke(VideoFrame encodedFrame) {
                try {
                    decoder.processFrame((MediaFrame)new VideoFrame((VideoBuffer)encodedFrame.getLastBuffer()));
                }
                catch (Exception exception) {
                    promise.reject(exception);
                }
            }
        });
        encoder.processFrame(new VideoFrame(VideoBuffer.createBlack((int)160, (int)120, (String)VideoFormat.getI420Name())));
    }

    public static Future<Object> downloadOpenH264(final String downloadPath, final boolean removeOld) {
        return PromiseBase.wrapPromise((IFunction0)new IFunction0<Future<Object>>(){

            public Future<Object> invoke() {
                OperatingSystem os = Platform.getInstance().getOperatingSystem();
                Architecture architecture = Platform.getInstance().getArchitecture();
                NativeLibraryInfo platformInfo = Utility.getPlatformInfo(os, architecture);
                String absolutePath = StringExtensions.empty;
                if (Global.equals((Object)downloadPath, (Object)StringExtensions.empty) || downloadPath == null) {
                    if (Global.equals((Object)Platform.getInstance().getSourceLanguage(), (Object)SourceLanguage.CSharp) && Global.equals((Object)os, (Object)OperatingSystem.Windows)) {
                        absolutePath = Global.equals((Object)architecture, (Object)Architecture.X86) ? "lib/win_x86" : "lib/win_x64";
                    } else if (Global.equals((Object)Platform.getInstance().getSourceLanguage(), (Object)SourceLanguage.Java) && (Global.equals((Object)os, (Object)OperatingSystem.MacOS) || Global.equals((Object)os, (Object)OperatingSystem.Linux))) {
                        absolutePath = PathUtility.getAbsolutePath((String)PathUtility.getTempPath());
                    }
                } else {
                    absolutePath = downloadPath;
                }
                String path = PathUtility.combinePaths((String)absolutePath, (String)platformInfo.getLibraryName());
                if (!new FileStream(path).exists()) {
                    Exception exception;
                    if (removeOld) {
                        for (String str3 : platformInfo.getOldLibraryNames()) {
                            String str4 = PathUtility.combinePaths((String)absolutePath, (String)str3);
                            if (!new FileStream(str4).exists()) continue;
                            Log.debug((String)StringExtensions.format((String)"Removing old OpenH264 library from: {0}.", (Object)str4));
                            try {
                                PathUtility.delete((String)str4);
                            }
                            catch (Exception exception1) {
                                exception = exception1;
                                Log.info((String)StringExtensions.format((String)"Failed to remove old OpenH264 library from: {0}, Error: {1}", (Object)str4, (Object)exception.getMessage()));
                            }
                        }
                    }
                    Log.info((String)StringExtensions.format((String)"OpenH264 v1.7 library missing. Downloading now from: {0}.", (Object)platformInfo.getDownloadURL()));
                    HttpFileTransfer.downloadFile((String)platformInfo.getDownloadURL(), (String)path).waitForResult();
                    OperatingSystem _var0 = os;
                    if (_var0 == OperatingSystem.Android || _var0 == OperatingSystem.Linux) {
                        String destinationPath = PathUtility.combinePaths((String)absolutePath, (String)platformInfo.getLibraryName());
                        String str6 = PathUtility.combinePaths((String)absolutePath, (String)platformInfo.getLoadLibraryName());
                        try {
                            PathUtility.delete((String)str6);
                        }
                        catch (Exception str3) {
                            // empty catch block
                        }
                        try {
                            PathUtility.createSymlink((String)destinationPath, (String)str6);
                        }
                        catch (Exception exception3) {
                            exception = exception3;
                            Log.error((String)"Unable to create symlink for OpenH264 binary.", (Exception)exception);
                        }
                    }
                    Log.info((String)"OpenH264 library downloaded.");
                }
                return PromiseBase.resolveNow();
            }
        });
    }

    public static Future<Object> downloadOpenH264() {
        return Utility.downloadOpenH264(null, true);
    }

    public static Future<Object> downloadOpenH264(String downloadPath) {
        return Utility.downloadOpenH264(downloadPath, true);
    }

    public static String getDownloadUrl() {
        return Utility.getPlatformInfo().getDownloadURL();
    }

    public static String getLibraryName() {
        return Utility.getPlatformInfo().getLibraryName();
    }

    public static String getLoadLibraryName() {
        return Utility.getPlatformInfo().getLoadLibraryName();
    }

    private static NativeLibraryInfo getPlatformInfo(OperatingSystem os, Architecture arch) {
        NativeLibraryInfo info = null;
        Holder _var0 = new Holder(info);
        boolean _var1 = __libraryInfo.tryGetValue((Object)StringExtensions.format((String)"{0}-{1}", (Object)os.toString(), (Object)arch.toString()), _var0);
        info = (NativeLibraryInfo)_var0.getValue();
        if (!_var1) {
            return null;
        }
        return info;
    }

    private static NativeLibraryInfo getPlatformInfo() {
        Architecture arch;
        OperatingSystem operatingSystem = Platform.getInstance().getOperatingSystem();
        NativeLibraryInfo platformInfo = Utility.getPlatformInfo(operatingSystem, arch = Platform.getInstance().getArchitecture());
        if (platformInfo == null) {
            throw new RuntimeException(new Exception(StringExtensions.format((String)"Cisco does not distribute {0} OpenH264 binaries for {1}.", (Object)arch, (Object)operatingSystem)));
        }
        return platformInfo;
    }

    public static Future<Object> initialize() {
        if (Utility.isSupported()) {
            return Utility.initialize(new Encoder(), new Decoder());
        }
        return PromiseBase.resolveNow();
    }

    private static Future<Object> initialize(Encoder encoder, Decoder decoder) {
        Promise promise = new Promise();
        try {
            Utility.doInitialize(encoder, decoder, (Promise<Object>)promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public static boolean isSupported() {
        Architecture arch;
        OperatingSystem operatingSystem = Platform.getInstance().getOperatingSystem();
        return Utility.getPlatformInfo(operatingSystem, arch = Platform.getInstance().getArchitecture()) != null;
    }

    static {
        Utility.addPlatformInfo(OperatingSystem.Windows, Architecture.X86, "http://ciscobinary.openh264.org/openh264-1.7.0-win32.dll.bz2", "openh264-1.7.0.dll", "openh264-1.7.0.dll", new String[]{"openh264.dll"});
        Utility.addPlatformInfo(OperatingSystem.Windows, Architecture.X64, "http://ciscobinary.openh264.org/openh264-1.7.0-win64.dll.bz2", "openh264-1.7.0.dll", "openh264-1.7.0.dll", new String[]{"openh264.dll"});
        Utility.addPlatformInfo(OperatingSystem.MacOS, Architecture.X86, "http://ciscobinary.openh264.org/libopenh264-1.7.0-osx32.4.dylib.bz2", "openh264-1.7.0.dylib", "openh264-1.7.0.dylib", new String[]{"openh264.dylib"});
        Utility.addPlatformInfo(OperatingSystem.MacOS, Architecture.X64, "http://ciscobinary.openh264.org/libopenh264-1.7.0-osx64.4.dylib.bz2", "openh264-1.7.0.dylib", "openh264-1.7.0.dylib", new String[]{"openh264.dylib"});
        Utility.addPlatformInfo(OperatingSystem.Linux, Architecture.X86, "http://ciscobinary.openh264.org/libopenh264-1.7.0-linux32.4.so.bz2", "libopenh264-1.7.0.so", "libopenh264.so.4", new String[]{"libopenh264.so"});
        Utility.addPlatformInfo(OperatingSystem.Linux, Architecture.X64, "http://ciscobinary.openh264.org/libopenh264-1.7.0-linux64.4.so.bz2", "libopenh264-1.7.0.so", "libopenh264.so.4", new String[]{"libopenh264.so"});
        Utility.addPlatformInfo(OperatingSystem.Android, Architecture.Armv7, "http://ciscobinary.openh264.org/libopenh264-1.7.0-android19.so.bz2", "libopenh264-1.7.0.so", "libopenh264.so", new String[]{"libopenh264.so"});
        Utility.addPlatformInfo(OperatingSystem.Android, Architecture.Armv8, "http://ciscobinary.openh264.org/libopenh264-1.7.0-android19.so.bz2", "libopenh264-1.7.0.so", "libopenh264.so", new String[]{"libopenh264.so"});
        Utility.addPlatformInfo(OperatingSystem.Linux, Architecture.X64, "http://ciscobinary.openh264.org/libopenh264-1.7.0-linux64.4.so.bz2", "libopenh264-1.7.0.so", "libopenh264.so", new String[]{"libopenh264.so"});
    }
}

