/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.Holder;
import fm.icelink.IMediaOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.MediaBuffer;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.h264.Format;
import fm.icelink.h264.ProfileLevelId;
import fm.icelink.h264.Utility;
import fm.icelink.openh264.DecoderConfig;
import fm.icelink.openh264.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MediaDescription;

public class Decoder
extends VideoDecoder {
    private DecoderConfig __codecConfig;
    private Native __decoder = new Native(false);

    public Decoder() {
        super((VideoFormat)new Format(), VideoFormat.getI420());
        DecoderConfig config = new DecoderConfig();
        this.setCodecConfig(config);
    }

    public Decoder(IVideoOutput input) {
        this();
        super.addInput((IMediaOutput)input);
    }

    protected void doDestroy() {
        this.__decoder.destroy();
        this.__decoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        super.doProcessFrame(frame, inputBuffer);
        if (!super.getDelayDecode()) {
            VideoBuffer buffer = this.__decoder.decode(inputBuffer, (VideoFormat)super.getOutputFormat());
            if (buffer != null) {
                frame.addBuffer((MediaBuffer)buffer);
                this.raiseFrame(frame);
                buffer.getDataBuffer().free();
            }
            if (this.getNeedsKeyFrame()) {
                super.sendKeyFrameRequest("H.264 decoder needs a keyframe.");
            }
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        Object[] attributeArray;
        super.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        if (isLocalDescription && (attributeArray = mediaDescription.getRtpMapAttributes(((VideoFormat)super.getInputFormat()).getName(), ((VideoFormat)super.getInputFormat()).getClockRate(), ((VideoFormat)super.getInputFormat()).getParameters())) != null) {
            for (int i = 0; i < ArrayExtensions.getLength((Object[])attributeArray); ++i) {
                Object attribute = attributeArray[i];
                FormatParametersAttribute relatedFormatParametersAttribute = attribute.getRelatedFormatParametersAttribute();
                if (relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(attribute.getPayloadType());
                    attribute.setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                String str = null;
                Holder _var0 = new Holder(str);
                boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("profile-level-id", _var0);
                str = (String)_var0.getValue();
                if (str != null) continue;
                relatedFormatParametersAttribute.setFormatSpecificParameter("profile-level-id", new ProfileLevelId(66, 224, 31).toString());
            }
        }
        return null;
    }

    public DecoderConfig getCodecConfig() {
        return this.__codecConfig.deepCopy();
    }

    public String getLabel() {
        return "OpenH264 Decoder";
    }

    public boolean getNeedsKeyFrame() {
        return this.__decoder.getNeedsKeyFrame();
    }

    protected boolean isKeyFrame(DataBuffer dataBuffer) {
        return Utility.isKeyFrame((DataBuffer)dataBuffer);
    }

    public int setCodecConfig(DecoderConfig config) {
        int num = this.__decoder.setDecoderConfig(config.getNativeConfig());
        if (num == 0) {
            this.__codecConfig = config.deepCopy();
        }
        return num;
    }

    private void setNeedsKeyFrame(boolean value) {
        this.__decoder.setNeedsKeyFrame(value);
    }
}

