/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.yuv;

import fm.icelink.IMediaOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.yuv.Native;

public class ImageScaler
extends VideoPipe {
    private double __scale;
    private Native __yuvx = new Native();
    private int _filterMode;

    protected void doDestroy() {
        this.__yuvx.destroy();
        this.__yuvx = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer;
        double scale = this.getScale();
        int toWidth = (int)((double)inputBuffer.getWidth() * scale);
        int toHeight = (int)((double)inputBuffer.getHeight() * scale);
        if ((buffer = this.__yuvx.scale(inputBuffer, toWidth -= toWidth % 2, toHeight -= toHeight % 2, this.getFilterMode())) != null) {
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame((MediaFrame)frame);
            buffer.getDataBuffer().free();
        }
    }

    public int getFilterMode() {
        return this._filterMode;
    }

    public String getLabel() {
        return "Image Scaler";
    }

    public double getScale() {
        return this.__scale;
    }

    public ImageScaler(double scale, IVideoOutput[] inputs) {
        this(scale);
        super.addInputs((IMediaOutput[])inputs);
    }

    public ImageScaler(double scale, IVideoOutput input) {
        this(scale);
        super.addInput((IMediaOutput)input);
    }

    public ImageScaler(double scale) {
        super(VideoFormat.getI420(), VideoFormat.getI420());
        this.setScale(scale);
        this.setFilterMode(0);
    }

    public void setFilterMode(int value) {
        this._filterMode = value;
    }

    public void setScale(double value) {
        if (value <= 0.0) {
            throw new RuntimeException(new Exception("Scale must be greater than 0.0."));
        }
        this.__scale = value;
    }
}

