/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.callstats;

import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableLong;
import fm.icelink.callstats.Utility;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class DataStatsCSTransportStats {
    private long _bytesReceived;
    private long _bytesSent;
    private String _csId;
    private Date _csTimestamp = new Date();
    private String _localCertificateId;
    private String _remoteCertificateId;
    private String _selectedCandidatePairId;

    void deserializeProperties(String key, String valueJson) {
        String _var0 = key;
        if (_var0.equals("id")) {
            this.setCsId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("timestamp")) {
            this.setCsTimestamp(Utility.callStatsMillisToDateTime(valueJson));
        } else if (_var0.equals("bytesSent")) {
            this.setBytesSent(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("bytesReceived")) {
            this.setBytesReceived(JsonSerializer.deserializeLong((String)valueJson).getValue());
        } else if (_var0.equals("selectedCandidatePairId")) {
            this.setSelectedCandidatePairId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("localCertificateId")) {
            this.setLocalCertificateId(JsonSerializer.deserializeString((String)valueJson));
        } else if (_var0.equals("remoteCertificateId")) {
            this.setRemoteCertificateId(JsonSerializer.deserializeString((String)valueJson));
        }
    }

    static DataStatsCSTransportStats fromJson(String iceTransportStatsJson) {
        return (DataStatsCSTransportStats)JsonSerializer.deserializeObject((String)iceTransportStatsJson, (IFunction0)new IFunction0<DataStatsCSTransportStats>(){

            public DataStatsCSTransportStats invoke() {
                return new DataStatsCSTransportStats();
            }
        }, (IAction3)new IAction3<DataStatsCSTransportStats, String, String>(){

            public void invoke(DataStatsCSTransportStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    static DataStatsCSTransportStats[] fromJsonArray(String iceTransportStats) {
        ArrayList list = JsonSerializer.deserializeObjectArray((String)iceTransportStats, (IFunction1)new IFunctionDelegate1<String, DataStatsCSTransportStats>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSTransportStats.fromJson";
            }

            public DataStatsCSTransportStats invoke(String iceTransportStatsJson) {
                return DataStatsCSTransportStats.fromJson(iceTransportStatsJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new DataStatsCSTransportStats[0]);
    }

    public long getBytesReceived() {
        return this._bytesReceived;
    }

    public long getBytesSent() {
        return this._bytesSent;
    }

    public String getCsId() {
        return this._csId;
    }

    public Date getCsTimestamp() {
        return this._csTimestamp;
    }

    public String getLocalCertificateId() {
        return this._localCertificateId;
    }

    public String getRemoteCertificateId() {
        return this._remoteCertificateId;
    }

    public String getSelectedCandidatePairId() {
        return this._selectedCandidatePairId;
    }

    void serializeProperties(HashMap<String, String> jsonObject) {
        if (this.getCsId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"id", (Object)JsonSerializer.serializeString((String)this.getCsId()));
        }
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"timestamp", (Object)Utility.dateTimeToCallStatsMillis(this.getCsTimestamp()));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"bytesSent", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getBytesSent())));
        HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"bytesReceived", (Object)JsonSerializer.serializeLong((NullableLong)new NullableLong(this.getBytesReceived())));
        if (this.getSelectedCandidatePairId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"selectedCandidatePairId", (Object)JsonSerializer.serializeString((String)this.getSelectedCandidatePairId()));
        }
        if (this.getLocalCertificateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"localCertificateId", (Object)JsonSerializer.serializeString((String)this.getLocalCertificateId()));
        }
        if (this.getRemoteCertificateId() != null) {
            HashMapExtensions.set((HashMap)HashMapExtensions.getItem(jsonObject), (Object)"remoteCertificateId", (Object)JsonSerializer.serializeString((String)this.getRemoteCertificateId()));
        }
    }

    public void setBytesReceived(long value) {
        this._bytesReceived = value;
    }

    public void setBytesSent(long value) {
        this._bytesSent = value;
    }

    public void setCsId(String value) {
        this._csId = value;
    }

    public void setCsTimestamp(Date value) {
        this._csTimestamp = value;
    }

    public void setLocalCertificateId(String value) {
        this._localCertificateId = value;
    }

    public void setRemoteCertificateId(String value) {
        this._remoteCertificateId = value;
    }

    public void setSelectedCandidatePairId(String value) {
        this._selectedCandidatePairId = value;
    }

    static String toJson(DataStatsCSTransportStats iceTransportStats) {
        return JsonSerializer.serializeObject((Object)iceTransportStats, (IAction2)new IAction2<DataStatsCSTransportStats, HashMap<String, String>>(){

            public void invoke(DataStatsCSTransportStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    String toJson() {
        return DataStatsCSTransportStats.toJson(this);
    }

    static String toJsonArray(DataStatsCSTransportStats[] iceTransportStats) {
        return JsonSerializer.serializeObjectArray((Object[])iceTransportStats, (IFunction1)new IFunctionDelegate1<DataStatsCSTransportStats, String>(){

            public String getId() {
                return "fm.icelink.callstats.DataStatsCSTransportStats.toJson";
            }

            public String invoke(DataStatsCSTransportStats iceTransportStats) {
                return DataStatsCSTransportStats.toJson(iceTransportStats);
            }
        });
    }
}

